/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.MonotonicClock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.tez.client.TezApiVersionInfo;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.common.security.TokenCache;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.NamedEntityDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezConstants;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.DAGAppMaster;
import org.apache.tez.dag.app.DAGAppMasterReadinessService;
import org.apache.tez.dag.app.DAGAppMasterState;
import org.apache.tez.dag.app.TezDagVersionInfo;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.impl.DAGImpl;
import org.apache.tez.dag.app.rm.TaskSchedulerManager;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezVertexID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestDAGAppMaster {
    private static final String TEST_KEY = "TEST_KEY";
    private static final String TEST_VAL = "TEST_VAL";
    private static final String TS_NAME = "TS";
    private static final String CL_NAME = "CL";
    private static final String TC_NAME = "TC";
    private static final String CLASS_SUFFIX = "_CLASS";
    private static final File TEST_DIR = new File(System.getProperty("test.build.data"), TestDAGAppMaster.class.getName()).getAbsoluteFile();

    @Before
    public void setup() {
        FileUtil.fullyDelete((File)TEST_DIR);
        TEST_DIR.mkdirs();
    }

    @After
    public void teardown() {
        FileUtil.fullyDelete((File)TEST_DIR);
    }

    @Test(timeout=20000L)
    public void testInvalidSession() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)2);
        DAGAppMasterForTest dam = new DAGAppMasterForTest(attemptId, true);
        TezConfiguration conf = new TezConfiguration(false);
        conf.setBoolean("tez.dag.recovery.enabled", false);
        dam.init((Configuration)conf);
        dam.start();
        ((TaskSchedulerManager)Mockito.verify((Object)dam.mockScheduler)).setShouldUnregisterFlag();
        ((DAGAppMaster.DAGAppMasterShutdownHandler)Mockito.verify((Object)dam.mockShutdown)).shutdown();
        List diags = dam.getDiagnostics();
        boolean found = false;
        for (String diag : diags) {
            if (!diag.contains("Initial application attempt in session mode failed. Application cannot recover and continue properly as DAG recovery has been disabled")) continue;
            found = true;
            break;
        }
        Assert.assertTrue((String)"Missing invalid session diagnostics", (boolean)found);
        dam.stop();
    }

    @Test(timeout=5000L)
    public void testPluginParsing() throws IOException {
        HashBiMap pluginMap = HashBiMap.create();
        Configuration conf = new Configuration(false);
        conf.set("testkey", "testval");
        UserPayload defaultPayload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        LinkedList<DAGProtos.TezNamedEntityDescriptorProto> entityDescriptors = new LinkedList<DAGProtos.TezNamedEntityDescriptorProto>();
        pluginMap.clear();
        LinkedList entities = new LinkedList();
        DAGAppMaster.parsePlugin(entities, (BiMap)pluginMap, null, (boolean)true, (boolean)false, (UserPayload)defaultPayload);
        Assert.assertEquals((long)1L, (long)pluginMap.size());
        Assert.assertEquals((long)1L, (long)entities.size());
        Assert.assertTrue((boolean)pluginMap.containsKey((Object)TezConstants.getTezYarnServicePluginName()));
        Assert.assertTrue((0 == (Integer)pluginMap.get((Object)TezConstants.getTezYarnServicePluginName()) ? 1 : 0) != 0);
        Assert.assertEquals((Object)"testval", (Object)TezUtils.createConfFromUserPayload((UserPayload)((NamedEntityDescriptor)entities.get(0)).getUserPayload()).get("testkey"));
        pluginMap.clear();
        entities = new LinkedList();
        DAGAppMaster.parsePlugin(entities, (BiMap)pluginMap, null, (boolean)false, (boolean)true, (UserPayload)defaultPayload);
        Assert.assertEquals((long)1L, (long)pluginMap.size());
        Assert.assertEquals((long)1L, (long)entities.size());
        Assert.assertTrue((boolean)pluginMap.containsKey((Object)TezConstants.getTezUberServicePluginName()));
        Assert.assertTrue((0 == (Integer)pluginMap.get((Object)TezConstants.getTezUberServicePluginName()) ? 1 : 0) != 0);
        Assert.assertEquals((Object)"testval", (Object)TezUtils.createConfFromUserPayload((UserPayload)((NamedEntityDescriptor)entities.get(0)).getUserPayload()).get("testkey"));
        pluginMap.clear();
        entities = new LinkedList();
        DAGAppMaster.parsePlugin(entities, (BiMap)pluginMap, null, (boolean)true, (boolean)true, (UserPayload)defaultPayload);
        Assert.assertEquals((long)2L, (long)pluginMap.size());
        Assert.assertEquals((long)2L, (long)entities.size());
        Assert.assertTrue((boolean)pluginMap.containsKey((Object)TezConstants.getTezYarnServicePluginName()));
        Assert.assertTrue((0 == (Integer)pluginMap.get((Object)TezConstants.getTezYarnServicePluginName()) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pluginMap.containsKey((Object)TezConstants.getTezUberServicePluginName()));
        Assert.assertTrue((1 == (Integer)pluginMap.get((Object)TezConstants.getTezUberServicePluginName()) ? 1 : 0) != 0);
        String pluginName = "d1";
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(0, 3);
        DAGProtos.TezNamedEntityDescriptorProto d1 = DAGProtos.TezNamedEntityDescriptorProto.newBuilder().setName(pluginName).setEntityDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("d1Class").setTezUserPayload(DAGProtos.TezUserPayloadProto.newBuilder().setUserPayload(ByteString.copyFrom((ByteBuffer)bb)))).build();
        entityDescriptors.add(d1);
        pluginMap.clear();
        entities = new LinkedList();
        DAGAppMaster.parsePlugin(entities, (BiMap)pluginMap, entityDescriptors, (boolean)false, (boolean)false, (UserPayload)defaultPayload);
        Assert.assertEquals((long)1L, (long)pluginMap.size());
        Assert.assertEquals((long)1L, (long)entities.size());
        Assert.assertTrue((boolean)pluginMap.containsKey((Object)pluginName));
        Assert.assertTrue((0 == (Integer)pluginMap.get((Object)pluginName) ? 1 : 0) != 0);
        pluginMap.clear();
        entities = new LinkedList();
        DAGAppMaster.parsePlugin(entities, (BiMap)pluginMap, entityDescriptors, (boolean)true, (boolean)true, (UserPayload)defaultPayload);
        Assert.assertEquals((long)3L, (long)pluginMap.size());
        Assert.assertEquals((long)3L, (long)entities.size());
        Assert.assertTrue((boolean)pluginMap.containsKey((Object)TezConstants.getTezYarnServicePluginName()));
        Assert.assertTrue((0 == (Integer)pluginMap.get((Object)TezConstants.getTezYarnServicePluginName()) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pluginMap.containsKey((Object)TezConstants.getTezUberServicePluginName()));
        Assert.assertTrue((1 == (Integer)pluginMap.get((Object)TezConstants.getTezUberServicePluginName()) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pluginMap.containsKey((Object)pluginName));
        Assert.assertTrue((2 == (Integer)pluginMap.get((Object)pluginName) ? 1 : 0) != 0);
        entityDescriptors.clear();
    }

    @Test(timeout=5000L)
    public void testParseAllPluginsNoneSpecified() throws IOException {
        Configuration conf = new Configuration(false);
        conf.set(TEST_KEY, TEST_VAL);
        UserPayload defaultPayload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        LinkedList tsDescriptors = Lists.newLinkedList();
        HashBiMap tsMap = HashBiMap.create();
        LinkedList clDescriptors = Lists.newLinkedList();
        HashBiMap clMap = HashBiMap.create();
        LinkedList tcDescriptors = Lists.newLinkedList();
        HashBiMap tcMap = HashBiMap.create();
        DAGAppMaster.parseAllPlugins((List)tsDescriptors, (BiMap)tsMap, (List)clDescriptors, (BiMap)clMap, (List)tcDescriptors, (BiMap)tcMap, null, (boolean)false, (UserPayload)defaultPayload);
        this.verifyDescAndMap(tsDescriptors, (BiMap<String, Integer>)tsMap, 1, true, TezConstants.getTezYarnServicePluginName());
        this.verifyDescAndMap(clDescriptors, (BiMap<String, Integer>)clMap, 1, true, TezConstants.getTezYarnServicePluginName());
        this.verifyDescAndMap(tcDescriptors, (BiMap<String, Integer>)tcMap, 1, true, TezConstants.getTezYarnServicePluginName());
        tsDescriptors = Lists.newLinkedList();
        tsMap = HashBiMap.create();
        clDescriptors = Lists.newLinkedList();
        clMap = HashBiMap.create();
        tcDescriptors = Lists.newLinkedList();
        tcMap = HashBiMap.create();
        DAGAppMaster.parseAllPlugins((List)tsDescriptors, (BiMap)tsMap, (List)clDescriptors, (BiMap)clMap, (List)tcDescriptors, (BiMap)tcMap, null, (boolean)true, (UserPayload)defaultPayload);
        this.verifyDescAndMap(tsDescriptors, (BiMap<String, Integer>)tsMap, 1, true, TezConstants.getTezUberServicePluginName());
        this.verifyDescAndMap(clDescriptors, (BiMap<String, Integer>)clMap, 1, true, TezConstants.getTezUberServicePluginName());
        this.verifyDescAndMap(tcDescriptors, (BiMap<String, Integer>)tcMap, 1, true, TezConstants.getTezUberServicePluginName());
    }

    @Test(timeout=5000L)
    public void testParseAllPluginsOnlyCustomSpecified() throws IOException {
        Configuration conf = new Configuration(false);
        conf.set(TEST_KEY, TEST_VAL);
        UserPayload defaultPayload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        DAGProtos.TezUserPayloadProto payloadProto = DAGProtos.TezUserPayloadProto.newBuilder().setUserPayload(ByteString.copyFrom((ByteBuffer)defaultPayload.getPayload())).build();
        DAGProtos.AMPluginDescriptorProto proto = this.createAmPluginDescriptor(false, false, true, payloadProto);
        LinkedList tsDescriptors = Lists.newLinkedList();
        HashBiMap tsMap = HashBiMap.create();
        LinkedList clDescriptors = Lists.newLinkedList();
        HashBiMap clMap = HashBiMap.create();
        LinkedList tcDescriptors = Lists.newLinkedList();
        HashBiMap tcMap = HashBiMap.create();
        DAGAppMaster.parseAllPlugins((List)tsDescriptors, (BiMap)tsMap, (List)clDescriptors, (BiMap)clMap, (List)tcDescriptors, (BiMap)tcMap, (DAGProtos.AMPluginDescriptorProto)proto, (boolean)false, (UserPayload)defaultPayload);
        this.verifyDescAndMap(tsDescriptors, (BiMap<String, Integer>)tsMap, 2, true, TS_NAME, TezConstants.getTezYarnServicePluginName());
        this.verifyDescAndMap(clDescriptors, (BiMap<String, Integer>)clMap, 1, true, CL_NAME);
        this.verifyDescAndMap(tcDescriptors, (BiMap<String, Integer>)tcMap, 1, true, TC_NAME);
        Assert.assertEquals((Object)"TS_CLASS", (Object)((NamedEntityDescriptor)tsDescriptors.get(0)).getClassName());
        Assert.assertEquals((Object)"CL_CLASS", (Object)((NamedEntityDescriptor)clDescriptors.get(0)).getClassName());
        Assert.assertEquals((Object)"TC_CLASS", (Object)((NamedEntityDescriptor)tcDescriptors.get(0)).getClassName());
    }

    @Test(timeout=5000L)
    public void testParseAllPluginsCustomAndYarnSpecified() throws IOException {
        Configuration conf = new Configuration(false);
        conf.set(TEST_KEY, TEST_VAL);
        UserPayload defaultPayload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        DAGProtos.TezUserPayloadProto payloadProto = DAGProtos.TezUserPayloadProto.newBuilder().setUserPayload(ByteString.copyFrom((ByteBuffer)defaultPayload.getPayload())).build();
        DAGProtos.AMPluginDescriptorProto proto = this.createAmPluginDescriptor(true, false, true, payloadProto);
        LinkedList tsDescriptors = Lists.newLinkedList();
        HashBiMap tsMap = HashBiMap.create();
        LinkedList clDescriptors = Lists.newLinkedList();
        HashBiMap clMap = HashBiMap.create();
        LinkedList tcDescriptors = Lists.newLinkedList();
        HashBiMap tcMap = HashBiMap.create();
        DAGAppMaster.parseAllPlugins((List)tsDescriptors, (BiMap)tsMap, (List)clDescriptors, (BiMap)clMap, (List)tcDescriptors, (BiMap)tcMap, (DAGProtos.AMPluginDescriptorProto)proto, (boolean)false, (UserPayload)defaultPayload);
        this.verifyDescAndMap(tsDescriptors, (BiMap<String, Integer>)tsMap, 2, true, TezConstants.getTezYarnServicePluginName(), TS_NAME);
        this.verifyDescAndMap(clDescriptors, (BiMap<String, Integer>)clMap, 2, true, TezConstants.getTezYarnServicePluginName(), CL_NAME);
        this.verifyDescAndMap(tcDescriptors, (BiMap<String, Integer>)tcMap, 2, true, TezConstants.getTezYarnServicePluginName(), TC_NAME);
        Assert.assertNull((Object)((NamedEntityDescriptor)tsDescriptors.get(0)).getClassName());
        Assert.assertNull((Object)((NamedEntityDescriptor)clDescriptors.get(0)).getClassName());
        Assert.assertNull((Object)((NamedEntityDescriptor)tcDescriptors.get(0)).getClassName());
        Assert.assertEquals((Object)"TS_CLASS", (Object)((NamedEntityDescriptor)tsDescriptors.get(1)).getClassName());
        Assert.assertEquals((Object)"CL_CLASS", (Object)((NamedEntityDescriptor)clDescriptors.get(1)).getClassName());
        Assert.assertEquals((Object)"TC_CLASS", (Object)((NamedEntityDescriptor)tcDescriptors.get(1)).getClassName());
    }

    @Test(timeout=60000L)
    public void testShutdownTezAMWithMissingRecoveryAndFailureOnMissingData() throws Exception {
        TezConfiguration conf = new TezConfiguration();
        conf.setBoolean("tez.am.credentials-merge", true);
        conf.setBoolean("tez.local.mode", true);
        conf.set("tez.staging-dir", TEST_DIR.toString());
        conf.setBoolean("tez.am.failure.on.missing.recovery.data", true);
        conf.setBoolean("tez.dag.recovery.enabled", true);
        conf.setInt("tez.session.am.dag.submit.timeout.secs", 1000000000);
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)2);
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)mockFs.exists((Path)ArgumentMatchers.any())).thenReturn((Object)false);
        DAGAppMasterForTest dam = new DAGAppMasterForTest(attemptId, true);
        dam.init((Configuration)conf);
        Field field = DAGAppMasterForTest.class.getSuperclass().getDeclaredField("recoveryFS");
        field.setAccessible(true);
        field.set((Object)dam, mockFs);
        dam.start();
        ArgumentCaptor captor = ArgumentCaptor.forClass(Path.class);
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.times((int)2))).exists((Path)captor.capture());
        Assert.assertTrue((boolean)((Path)captor.getAllValues().get(1)).toString().contains("/recovery/1/summary"));
        Assert.assertTrue((boolean)((Path)captor.getAllValues().get(0)).toString().contains("/recovery/1/RecoveryFatalErrorOccurred"));
        ((TaskSchedulerManager)Mockito.verify((Object)dam.mockScheduler)).setShouldUnregisterFlag();
        ((DAGAppMaster.DAGAppMasterShutdownHandler)Mockito.verify((Object)dam.mockShutdown)).shutdown();
        Assert.assertEquals((Object)DAGAppMasterState.ERROR, (Object)dam.getState());
    }

    @Test
    public void testShutdownTezAMWithMissingRecoveryAndNoFailureOnMissingData() throws Exception {
        TezConfiguration conf = new TezConfiguration();
        conf.setBoolean("tez.am.credentials-merge", true);
        conf.setBoolean("tez.local.mode", true);
        conf.set("tez.staging-dir", TEST_DIR.toString());
        conf.setBoolean("tez.am.failure.on.missing.recovery.data", false);
        conf.setBoolean("tez.dag.recovery.enabled", true);
        conf.setInt("tez.session.am.dag.submit.timeout.secs", 1);
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)2);
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)mockFs.exists((Path)ArgumentMatchers.any())).thenReturn((Object)false);
        DAGAppMasterForTest dam = new DAGAppMasterForTest(attemptId, true);
        dam.init((Configuration)conf);
        Field field = DAGAppMasterForTest.class.getSuperclass().getDeclaredField("recoveryFS");
        field.setAccessible(true);
        field.set((Object)dam, mockFs);
        dam.start();
        Thread.sleep(2000L);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Path.class);
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.times((int)2))).exists((Path)captor.capture());
        Assert.assertTrue((boolean)((Path)captor.getAllValues().get(1)).toString().contains("/recovery/1/summary"));
        Assert.assertTrue((boolean)((Path)captor.getAllValues().get(0)).toString().contains("/recovery/1/RecoveryFatalErrorOccurred"));
        ((TaskSchedulerManager)Mockito.verify((Object)dam.mockScheduler)).setShouldUnregisterFlag();
        ((DAGAppMaster.DAGAppMasterShutdownHandler)Mockito.verify((Object)dam.mockShutdown)).shutdown();
        Assert.assertEquals((Object)DAGAppMasterState.SUCCEEDED, (Object)dam.getState());
    }

    private void verifyDescAndMap(List<NamedEntityDescriptor> descriptors, BiMap<String, Integer> map, int numExpected, boolean verifyPayload, String ... expectedNames) throws IOException {
        Preconditions.checkArgument((expectedNames.length == numExpected ? 1 : 0) != 0);
        Assert.assertEquals((long)numExpected, (long)descriptors.size());
        Assert.assertEquals((long)numExpected, (long)map.size());
        for (int i = 0; i < numExpected; ++i) {
            Assert.assertEquals((Object)expectedNames[i], (Object)descriptors.get(i).getEntityName());
            if (verifyPayload) {
                Assert.assertEquals((Object)TEST_VAL, (Object)TezUtils.createConfFromUserPayload((UserPayload)descriptors.get(0).getUserPayload()).get(TEST_KEY));
            }
            Assert.assertTrue(((Integer)map.get((Object)expectedNames[i]) == i ? 1 : 0) != 0);
            Assert.assertTrue((map.inverse().get((Object)i) == expectedNames[i] ? 1 : 0) != 0);
        }
    }

    private DAGProtos.AMPluginDescriptorProto createAmPluginDescriptor(boolean enableYarn, boolean enableUber, boolean addCustom, DAGProtos.TezUserPayloadProto payloadProto) {
        DAGProtos.AMPluginDescriptorProto.Builder builder = DAGProtos.AMPluginDescriptorProto.newBuilder().setUberEnabled(enableUber).setContainersEnabled(enableYarn);
        if (addCustom) {
            builder.addTaskSchedulers(DAGProtos.TezNamedEntityDescriptorProto.newBuilder().setName(TS_NAME).setEntityDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("TS_CLASS").setTezUserPayload(payloadProto))).addContainerLaunchers(DAGProtos.TezNamedEntityDescriptorProto.newBuilder().setName(CL_NAME).setEntityDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("CL_CLASS").setTezUserPayload(payloadProto))).addTaskCommunicators(DAGProtos.TezNamedEntityDescriptorProto.newBuilder().setName(TC_NAME).setEntityDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("TC_CLASS").setTezUserPayload(payloadProto)));
        }
        return builder.build();
    }

    @Test
    public void testDagCredentialsWithoutMerge() throws Exception {
        this.testDagCredentials(false);
    }

    @Test
    public void testDagCredentialsWithMerge() throws Exception {
        this.testDagCredentials(true);
    }

    @Test
    public void testGetACLFailure() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)2);
        DAGAppMasterForTest dam = new DAGAppMasterForTest(attemptId, true);
        TezConfiguration conf = new TezConfiguration(false);
        conf.setBoolean("tez.dag.recovery.enabled", false);
        dam.init((Configuration)conf);
        LambdaTestUtils.intercept(TezUncheckedException.class, (String)"Cannot get ApplicationACLs before all services have started, The current service state is INITED", () -> dam.getContext().getApplicationACLs());
        dam.start();
        dam.stop();
        Mockito.when((Object)dam.mockShutdown.getShutdownTime()).thenReturn((Object)Date.from(Instant.ofEpochMilli(Time.now())));
        LambdaTestUtils.intercept(TezUncheckedException.class, (String)(" Cannot get ApplicationACLs before all services have started, The current service state is STOPPED. The shutdown hook started at " + dam.mockShutdown.getShutdownTime()), () -> dam.getContext().getApplicationACLs());
    }

    @Test
    public void testBadProgress() throws Exception {
        TezConfiguration conf = new TezConfiguration();
        conf.setBoolean("tez.am.credentials-merge", true);
        conf.setBoolean("tez.local.mode", true);
        conf.set("tez.staging-dir", TEST_DIR.toString());
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        Credentials amCreds = new Credentials();
        JobTokenSecretManager jtsm = new JobTokenSecretManager();
        JobTokenIdentifier identifier = new JobTokenIdentifier(new Text(appId.toString()));
        Token sessionToken = new Token((TokenIdentifier)identifier, (SecretManager)jtsm);
        sessionToken.setService(identifier.getJobId());
        TokenCache.setSessionToken((Token)sessionToken, (Credentials)amCreds);
        TestTokenSecretManager ttsm = new TestTokenSecretManager();
        Text tokenAlias1 = new Text("alias1");
        Token amToken1 = new Token((TokenIdentifier)new TestTokenIdentifier(new Text("amtoken1")), (SecretManager)ttsm);
        amCreds.addToken(tokenAlias1, amToken1);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        FSDataOutputStream sessionJarsPBOutStream = TezCommonUtils.createFileForAM((FileSystem)fs, (Path)new Path(TEST_DIR.toString(), "tez.session.local-resources.pb"));
        DAGProtos.PlanLocalResourcesProto.getDefaultInstance().writeDelimitedTo((OutputStream)sessionJarsPBOutStream);
        sessionJarsPBOutStream.close();
        DAGAppMaster am = (DAGAppMaster)Mockito.spy((Object)new DAGAppMaster(attemptId, ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L), "127.0.0.1", 0, 0, (Clock)new MonotonicClock(), 1L, true, TEST_DIR.toString(), new String[]{TEST_DIR.toString()}, new String[]{TEST_DIR.toString()}, new TezApiVersionInfo().getVersion(), amCreds, "someuser", null));
        Mockito.when((Object)am.getState()).thenReturn((Object)DAGAppMasterState.RUNNING);
        am.init((Configuration)conf);
        am.start();
        Credentials dagCreds = new Credentials();
        Token dagToken1 = new Token((TokenIdentifier)new TestTokenIdentifier(new Text("dagtoken1")), (SecretManager)ttsm);
        dagCreds.addToken(tokenAlias1, dagToken1);
        Text tokenAlias3 = new Text("alias3");
        Token dagToken2 = new Token((TokenIdentifier)new TestTokenIdentifier(new Text("dagtoken2")), (SecretManager)ttsm);
        dagCreds.addToken(tokenAlias3, dagToken2);
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        DAGProtos.DAGPlan dagPlan = DAGProtos.DAGPlan.newBuilder().setName("somedag").setCredentialsBinary(DagTypeConverters.convertCredentialsToProto((Credentials)dagCreds)).build();
        DAGImpl dag = (DAGImpl)Mockito.spy((Object)am.createDAG(dagPlan, dagId));
        am.setCurrentDAG((DAG)dag);
        Mockito.when((Object)dag.getState()).thenReturn((Object)DAGState.RUNNING);
        HashMap<TezVertexID, Vertex> map = new HashMap<TezVertexID, Vertex>();
        TezVertexID mockVertexID = (TezVertexID)Mockito.mock(TezVertexID.class);
        Vertex mockVertex = (Vertex)Mockito.mock(Vertex.class);
        Mockito.when((Object)Float.valueOf(mockVertex.getProgress())).thenReturn((Object)Float.valueOf(Float.NaN));
        map.put(mockVertexID, mockVertex);
        Mockito.when((Object)dag.getVertices()).thenReturn(map);
        Mockito.when((Object)dag.getTotalVertices()).thenReturn((Object)1);
        Assert.assertEquals((String)"Progress was NaN and should be reported as 0", (float)0.0f, (float)am.getProgress(), (float)0.0f);
        Mockito.when((Object)Float.valueOf(mockVertex.getProgress())).thenReturn((Object)Float.valueOf(-10.0f));
        Assert.assertEquals((String)"Progress was negative and should be reported as 0", (float)0.0f, (float)am.getProgress(), (float)0.0f);
        Mockito.when((Object)Float.valueOf(mockVertex.getProgress())).thenReturn((Object)Float.valueOf(1.0000567f));
        Assert.assertEquals((String)"Progress was greater than 1 by a small float precision 1.0000567 and should be reported as 1", (float)1.0f, (float)am.getProgress(), (float)0.0f);
        Mockito.when((Object)Float.valueOf(mockVertex.getProgress())).thenReturn((Object)Float.valueOf(10.0f));
        Assert.assertEquals((String)"Progress was greater than 1 and should be reported as 1", (float)1.0f, (float)am.getProgress(), (float)0.0f);
    }

    private void testDagCredentials(boolean doMerge) throws IOException {
        TezConfiguration conf = new TezConfiguration();
        conf.setBoolean("tez.am.credentials-merge", doMerge);
        conf.setBoolean("tez.local.mode", true);
        conf.set("tez.staging-dir", TEST_DIR.toString());
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        Credentials amCreds = new Credentials();
        JobTokenSecretManager jtsm = new JobTokenSecretManager();
        JobTokenIdentifier identifier = new JobTokenIdentifier(new Text(appId.toString()));
        Token sessionToken = new Token((TokenIdentifier)identifier, (SecretManager)jtsm);
        sessionToken.setService(identifier.getJobId());
        TokenCache.setSessionToken((Token)sessionToken, (Credentials)amCreds);
        TestTokenSecretManager ttsm = new TestTokenSecretManager();
        Text tokenAlias1 = new Text("alias1");
        Token amToken1 = new Token((TokenIdentifier)new TestTokenIdentifier(new Text("amtoken1")), (SecretManager)ttsm);
        amCreds.addToken(tokenAlias1, amToken1);
        Text tokenAlias2 = new Text("alias2");
        Token amToken2 = new Token((TokenIdentifier)new TestTokenIdentifier(new Text("amtoken2")), (SecretManager)ttsm);
        amCreds.addToken(tokenAlias2, amToken2);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        FSDataOutputStream sessionJarsPBOutStream = TezCommonUtils.createFileForAM((FileSystem)fs, (Path)new Path(TEST_DIR.toString(), "tez.session.local-resources.pb"));
        DAGProtos.PlanLocalResourcesProto.getDefaultInstance().writeDelimitedTo((OutputStream)sessionJarsPBOutStream);
        sessionJarsPBOutStream.close();
        DAGAppMaster am = new DAGAppMaster(attemptId, ContainerId.newInstance((ApplicationAttemptId)attemptId, (int)1), "127.0.0.1", 0, 0, (Clock)new SystemClock(), 1L, true, TEST_DIR.toString(), new String[]{TEST_DIR.toString()}, new String[]{TEST_DIR.toString()}, new TezApiVersionInfo().getVersion(), amCreds, "someuser", null);
        am.init((Configuration)conf);
        am.start();
        Credentials dagCreds = new Credentials();
        Token dagToken1 = new Token((TokenIdentifier)new TestTokenIdentifier(new Text("dagtoken1")), (SecretManager)ttsm);
        dagCreds.addToken(tokenAlias2, dagToken1);
        Text tokenAlias3 = new Text("alias3");
        Token dagToken2 = new Token((TokenIdentifier)new TestTokenIdentifier(new Text("dagtoken2")), (SecretManager)ttsm);
        dagCreds.addToken(tokenAlias3, dagToken2);
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        DAGProtos.DAGPlan dagPlan = DAGProtos.DAGPlan.newBuilder().setName("somedag").setCredentialsBinary(DagTypeConverters.convertCredentialsToProto((Credentials)dagCreds)).build();
        DAGImpl dag = am.createDAG(dagPlan, dagId);
        Credentials fetchedDagCreds = dag.getCredentials();
        am.stop();
        Token fetchedToken1 = fetchedDagCreds.getToken(tokenAlias1);
        if (doMerge) {
            Assert.assertNotNull((String)"AM creds missing from DAG creds", (Object)fetchedToken1);
            TestDAGAppMaster.compareTestTokens((Token<? extends TokenIdentifier>)amToken1, (Token<? extends TokenIdentifier>)fetchedDagCreds.getToken(tokenAlias1));
        } else {
            Assert.assertNull((String)"AM creds leaked to DAG creds", (Object)fetchedToken1);
        }
        TestDAGAppMaster.compareTestTokens((Token<? extends TokenIdentifier>)dagToken1, (Token<? extends TokenIdentifier>)fetchedDagCreds.getToken(tokenAlias2));
        TestDAGAppMaster.compareTestTokens((Token<? extends TokenIdentifier>)dagToken2, (Token<? extends TokenIdentifier>)fetchedDagCreds.getToken(tokenAlias3));
    }

    private static void compareTestTokens(Token<? extends TokenIdentifier> expected, Token<? extends TokenIdentifier> actual) throws IOException {
        TestTokenIdentifier expectedId = TestDAGAppMaster.getTestTokenIdentifier(expected);
        TestTokenIdentifier actualId = TestDAGAppMaster.getTestTokenIdentifier(actual);
        Assert.assertEquals((String)"Token id not preserved", (Object)expectedId.getTestId(), (Object)actualId.getTestId());
    }

    private static TestTokenIdentifier getTestTokenIdentifier(Token<? extends TokenIdentifier> token) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream in = new DataInputStream(buf);
        TestTokenIdentifier tokenId = new TestTokenIdentifier();
        tokenId.readFields(in);
        in.close();
        return tokenId;
    }

    public static class DAGAppMasterForTest
    extends DAGAppMaster {
        private DAGAppMaster.DAGAppMasterShutdownHandler mockShutdown;
        private TaskSchedulerManager mockScheduler = (TaskSchedulerManager)Mockito.mock(TaskSchedulerManager.class);
        private DAGAppMasterReadinessService mockAppMasterReadinessService = (DAGAppMasterReadinessService)Mockito.mock(DAGAppMasterReadinessService.class);

        public DAGAppMasterForTest(ApplicationAttemptId attemptId, boolean isSession) {
            super(attemptId, ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L), "hostname", 12345, 12346, (Clock)new SystemClock(), 0L, isSession, TEST_DIR.getAbsolutePath(), new String[]{TEST_DIR.getAbsolutePath()}, new String[]{TEST_DIR.getAbsolutePath()}, new TezDagVersionInfo().getVersion(), DAGAppMasterForTest.createCredentials(), "jobname", null);
        }

        public static Credentials createCredentials() {
            Credentials creds = new Credentials();
            JobTokenSecretManager jtsm = new JobTokenSecretManager();
            JobTokenIdentifier jtid = new JobTokenIdentifier(new Text());
            Token token = new Token((TokenIdentifier)jtid, (SecretManager)jtsm);
            TokenCache.setSessionToken((Token)token, (Credentials)creds);
            return creds;
        }

        private static void stubSessionResources(Configuration conf) throws IOException {
            File file = new File(TEST_DIR, "tez.session.local-resources.pb");
            conf.set("tez.staging-dir", TEST_DIR.getAbsolutePath());
            FileOutputStream out = new FileOutputStream(file);
            DAGProtos.PlanLocalResourcesProto planProto = DAGProtos.PlanLocalResourcesProto.getDefaultInstance();
            planProto.writeDelimitedTo((OutputStream)out);
            out.close();
        }

        public synchronized void serviceInit(Configuration conf) throws Exception {
            DAGAppMasterForTest.stubSessionResources(conf);
            conf.setBoolean("tez.am.tez-ui.webservice.enable", false);
            super.serviceInit(conf);
        }

        protected DAGAppMaster.DAGAppMasterShutdownHandler createShutdownHandler() {
            this.mockShutdown = (DAGAppMaster.DAGAppMasterShutdownHandler)Mockito.mock(DAGAppMaster.DAGAppMasterShutdownHandler.class);
            return this.mockShutdown;
        }

        protected TaskSchedulerManager createTaskSchedulerManager(List<NamedEntityDescriptor> taskSchedulerDescriptors) {
            return this.mockScheduler;
        }

        protected DAGAppMasterReadinessService createAppMasterReadinessService() {
            return this.mockAppMasterReadinessService;
        }
    }

    private static class TestTokenSecretManager
    extends SecretManager<TestTokenIdentifier> {
        private TestTokenSecretManager() {
        }

        public byte[] createPassword(TestTokenIdentifier id) {
            return id.getBytes();
        }

        public byte[] retrievePassword(TestTokenIdentifier id) throws SecretManager.InvalidToken {
            return id.getBytes();
        }

        public TestTokenIdentifier createIdentifier() {
            return new TestTokenIdentifier();
        }
    }

    private static class TestTokenIdentifier
    extends TokenIdentifier {
        private static Text KIND_NAME = new Text("test-token");
        private Text testId;

        public TestTokenIdentifier() {
            this(new Text());
        }

        public TestTokenIdentifier(Text id) {
            this.testId = id;
        }

        public void readFields(DataInput in) throws IOException {
            this.testId.readFields(in);
        }

        public void write(DataOutput out) throws IOException {
            this.testId.write(out);
        }

        public Text getKind() {
            return KIND_NAME;
        }

        public UserGroupInformation getUser() {
            return UserGroupInformation.createRemoteUser((String)"token-user");
        }

        public Text getTestId() {
            return this.testId;
        }
    }
}

