/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import org.junit.Assert;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginWrapperTestHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(PluginWrapperTestHelpers.class);

    private PluginWrapperTestHelpers() {
    }

    public static void testDelegation(Class<?> delegateClass, Class<?> rawClass, Set<String> skipMethods) throws Exception {
        Method[] methods;
        TrackingAnswer answer = new TrackingAnswer();
        Object mock = Mockito.mock(rawClass, (Answer)answer);
        Constructor<?> ctor = delegateClass.getConstructor(rawClass);
        Object wrapper = ctor.newInstance(mock);
        for (Method method : methods = delegateClass.getMethods()) {
            if (!method.getDeclaringClass().equals(delegateClass) || skipMethods.contains(method.getName())) continue;
            Assert.assertEquals((long)1L, (long)method.getExceptionTypes().length);
            Assert.assertEquals(Exception.class, method.getExceptionTypes()[0]);
            LOG.info("Checking method [{}] with parameterTypes [{}]", (Object)method.getName(), (Object)Arrays.toString(method.getParameterTypes()));
            Object[] params = PluginWrapperTestHelpers.constructMethodArgs(method);
            Object result = method.invoke(wrapper, params);
            Assert.assertEquals((Object)method.getName(), (Object)answer.lastMethodName);
            Assert.assertArrayEquals((Object[])params, (Object[])answer.lastArgs);
            if (answer.compareAsPrimitive) {
                Assert.assertEquals((Object)answer.lastRetValue, (Object)result);
                continue;
            }
            Assert.assertSame((String)("Expected: " + System.identityHashCode(answer.lastRetValue) + ", actual=" + System.identityHashCode(result)), (Object)answer.lastRetValue, (Object)result);
        }
    }

    public static Object[] constructMethodArgs(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        Object[] params = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            params[i] = PluginWrapperTestHelpers.constructSingleArg(paramTypes[i]);
        }
        return params;
    }

    private static Object constructSingleArg(Class<?> clazz) {
        if (clazz.isPrimitive() || clazz.equals(String.class)) {
            return PluginWrapperTestHelpers.getValueForPrimitiveOrString(clazz);
        }
        if (clazz.isEnum()) {
            if (clazz.getEnumConstants().length == 0) {
                return null;
            }
            return clazz.getEnumConstants()[0];
        }
        if (clazz.isArray() && (clazz.getComponentType().isPrimitive() || clazz.getComponentType().equals(String.class))) {
            return null;
        }
        return Mockito.mock(clazz);
    }

    private static Object getValueForPrimitiveOrString(Class<?> clazz) {
        if (clazz.equals(String.class)) {
            return "teststring";
        }
        if (clazz.equals(Byte.TYPE)) {
            return Character.valueOf('b');
        }
        if (clazz.equals(Short.TYPE)) {
            return 2;
        }
        if (clazz.equals(Integer.TYPE)) {
            return 224;
        }
        if (clazz.equals(Long.TYPE)) {
            return 445L;
        }
        if (clazz.equals(Float.TYPE)) {
            return Float.valueOf(2.24f);
        }
        if (clazz.equals(Double.TYPE)) {
            return 4.57;
        }
        if (clazz.equals(Boolean.TYPE)) {
            return true;
        }
        if (clazz.equals(Character.TYPE)) {
            return Character.valueOf('c');
        }
        if (clazz.equals(Void.TYPE)) {
            return null;
        }
        throw new RuntimeException("Unrecognized type: " + clazz.getName());
    }

    public static class TrackingAnswer
    implements Answer {
        public String lastMethodName;
        public Object[] lastArgs;
        public Object lastRetValue;
        boolean compareAsPrimitive;

        public Object answer(InvocationOnMock invocation) throws Throwable {
            this.lastArgs = invocation.getArguments();
            this.lastMethodName = invocation.getMethod().getName();
            Class<?> retType = invocation.getMethod().getReturnType();
            this.lastRetValue = PluginWrapperTestHelpers.constructSingleArg(retType);
            this.compareAsPrimitive = retType.isPrimitive() || retType.isEnum() || retType.equals(String.class);
            return this.lastRetValue;
        }
    }
}

