/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.TezSharedExecutor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTezSharedExecutor {
    private TezSharedExecutor sharedExecutor;

    @Before
    public void setup() {
        this.sharedExecutor = new TezSharedExecutor(new Configuration());
    }

    @After
    public void cleanup() {
        this.sharedExecutor.shutdownNow();
        this.sharedExecutor = null;
    }

    @Test(timeout=10000L)
    public void testSimpleExecution() throws Exception {
        ConcurrentHashMap<String, AtomicInteger> map = new ConcurrentHashMap<String, AtomicInteger>();
        ExecutorService service = this.sharedExecutor.createExecutorService(1, "simple-test");
        service.submit(new Counter(map, "test")).get();
        Assert.assertEquals((long)1L, (long)map.get("test").get());
        final Object expected = new Object();
        Object val = service.submit(new Counter(map, "test"), expected).get();
        Assert.assertEquals((Object)expected, (Object)val);
        Assert.assertEquals((long)2L, (long)map.get("test").get());
        val = service.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return expected;
            }
        }).get();
        Assert.assertEquals((Object)expected, (Object)val);
        service.shutdown();
        try {
            service.submit(new Counter(map, "test"));
            Assert.fail((String)"Expected rejected execution exception.");
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Test(timeout=10000L)
    public void testAwaitTermination() throws Exception {
        ExecutorService service = this.sharedExecutor.createExecutorService(1, "await-termination");
        CountDownLatch latch = new CountDownLatch(1);
        Wait runnable = new Wait(latch);
        service.submit(runnable);
        service.shutdown();
        Assert.assertFalse((boolean)service.awaitTermination(100L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)service.isTerminated());
        Assert.assertTrue((boolean)service.isShutdown());
        latch.countDown();
        Assert.assertTrue((boolean)service.awaitTermination(5L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)service.isTerminated());
        Assert.assertTrue((boolean)service.isShutdown());
    }

    @Test(timeout=10000L)
    public void testSerialExecution() throws Exception {
        ExecutorService service = this.sharedExecutor.createExecutorService(1, "serial-test");
        CountDownLatch latch = new CountDownLatch(1);
        Future<?> f1 = service.submit(new Wait(latch));
        ArrayList list = new ArrayList();
        ArrayList futures = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            futures.add(service.submit(new Appender<Integer>(list, i)));
        }
        service.shutdown();
        Assert.assertEquals((long)0L, (long)list.size());
        latch.countDown();
        f1.get();
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)10L, (long)list.size());
        Assert.assertEquals(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9), list);
    }

    @Test(timeout=10000L)
    public void testParallelExecution() throws Exception {
        ConcurrentHashMap<String, AtomicInteger> map = new ConcurrentHashMap<String, AtomicInteger>();
        ArrayList futures = new ArrayList();
        ExecutorService[] services = new ExecutorService[]{this.sharedExecutor.createExecutorService(2, "parallel-1"), this.sharedExecutor.createExecutorService(2, "parallel-2")};
        int[] expectedCounts = new int[]{0, 0};
        Random random = new Random();
        for (int i = 0; i < 200; ++i) {
            int n;
            int n2 = n = random.nextInt(2);
            expectedCounts[n2] = expectedCounts[n2] + 1;
            futures.add(services[n].submit(new Runner(new Sleep(10L), new Counter(map, "test" + n))));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)expectedCounts[0], (long)((AtomicInteger)map.get("test0")).get());
        Assert.assertEquals((long)expectedCounts[1], (long)((AtomicInteger)map.get("test1")).get());
        services[0].shutdown();
        services[1].submit(new Counter(map, "test1")).get();
        Assert.assertEquals((long)(expectedCounts[1] + 1), (long)map.get("test1").get());
    }

    private static class Counter
    implements Runnable {
        private final AtomicInteger counter;

        Counter(ConcurrentHashMap<String, AtomicInteger> map, String tag) {
            if (!map.contains(tag)) {
                map.putIfAbsent(tag, new AtomicInteger(0));
            }
            this.counter = map.get(tag);
        }

        @Override
        public void run() {
            this.counter.getAndIncrement();
        }
    }

    private static class Wait
    implements Runnable {
        private final CountDownLatch latch;

        Wait(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void run() {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static class Appender<T>
    implements Runnable {
        private final Collection<T> collection;
        private final T obj;

        Appender(Collection<T> collection, T obj) {
            this.collection = collection;
            this.obj = obj;
        }

        @Override
        public void run() {
            this.collection.add(this.obj);
        }
    }

    private static class Runner
    implements Runnable {
        private Runnable[] runnables;

        Runner(Runnable ... runnables) {
            this.runnables = runnables;
        }

        @Override
        public void run() {
            for (Runnable runnable : this.runnables) {
                runnable.run();
            }
        }
    }

    private static class Sleep
    implements Runnable {
        private final long sleepTime;

        Sleep(long sleepTime) {
            this.sleepTime = sleepTime;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

