/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.common.AsyncDispatcher;
import org.apache.tez.common.AsyncDispatcherConcurrent;
import org.apache.tez.common.TezAbstractEvent;
import org.junit.Assert;
import org.junit.Test;

public class TestAsyncDispatcherConcurrent {
    @Test(timeout=5000L)
    public void testBasic() throws Exception {
        CountDownLatch latch = new CountDownLatch(4);
        CountDownEventHandler.init(latch);
        AsyncDispatcher central = new AsyncDispatcher("Type1");
        central.register(TestEventType1.class, (EventHandler)new TestEventHandler1());
        central.registerAndCreateDispatcher(TestEventType2.class, (EventHandler)new TestEventHandler2(), "Type2", 1);
        central.registerAndCreateDispatcher(TestEventType3.class, (EventHandler)new TestEventHandler3(), "Type3", 1);
        central.init(new Configuration());
        central.start();
        central.getEventHandler().handle((Event)new TestEvent1(TestEventType1.TYPE1, 0));
        central.getEventHandler().handle((Event)new TestEvent2(TestEventType2.TYPE2));
        central.getEventHandler().handle((Event)new TestEvent3(TestEventType3.TYPE3));
        CountDownEventHandler.checkParallelCountersDoneAndFinish();
        central.close();
    }

    @Test(timeout=5000L)
    public void testMultiThreads() throws Exception {
        CountDownLatch latch = new CountDownLatch(4);
        CountDownEventHandler.init(latch);
        AsyncDispatcherConcurrent central = new AsyncDispatcherConcurrent("Type1", 1);
        central.registerAndCreateDispatcher(TestEventType1.class, (EventHandler)new TestEventHandler1(), "Type1", 3);
        central.init(new Configuration());
        central.start();
        central.getEventHandler().handle((Event)new TestEvent1(TestEventType1.TYPE1, 0));
        central.getEventHandler().handle((Event)new TestEvent1(TestEventType1.TYPE1, 1));
        central.getEventHandler().handle((Event)new TestEvent1(TestEventType1.TYPE1, 2));
        CountDownEventHandler.checkParallelCountersDoneAndFinish();
        central.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testMultipleRegisterFail() throws Exception {
        try (AsyncDispatcher central = new AsyncDispatcher("Type1");){
            central.register(TestEventType1.class, (EventHandler)new TestEventHandler1());
            central.registerAndCreateDispatcher(TestEventType1.class, (EventHandler)new TestEventHandler2(), "Type2", 1);
            Assert.fail();
        }
        central = new AsyncDispatcher("Type1");
        try {
            central.registerAndCreateDispatcher(TestEventType1.class, (EventHandler)new TestEventHandler2(), "Type2", 1);
            central.register(TestEventType1.class, (EventHandler)new TestEventHandler1());
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Multiple concurrent dispatchers cannot be registered"));
        }
        finally {
            central.close();
        }
        central = new AsyncDispatcher("Type1");
        try {
            central.registerAndCreateDispatcher(TestEventType1.class, (EventHandler)new TestEventHandler2(), "Type2", 1);
            central.registerAndCreateDispatcher(TestEventType1.class, (EventHandler)new TestEventHandler2(), "Type2", 1);
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Multiple concurrent dispatchers cannot be registered"));
        }
        finally {
            central.close();
        }
        central = new AsyncDispatcher("Type1");
        try {
            central.registerAndCreateDispatcher(TestEventType1.class, (EventHandler)new TestEventHandler2(), "Type2");
            central.registerAndCreateDispatcher(TestEventType1.class, (EventHandler)new TestEventHandler2(), "Type2");
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Multiple dispatchers cannot be registered for"));
        }
        finally {
            central.close();
        }
        central = new AsyncDispatcher("Type1");
        try {
            AsyncDispatcherConcurrent concDispatcher = central.registerAndCreateDispatcher(TestEventType1.class, (EventHandler)new TestEventHandler2(), "Type2", 1);
            central.registerWithExistingDispatcher(TestEventType1.class, (EventHandler)new TestEventHandler1(), concDispatcher);
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Multiple concurrent dispatchers cannot be registered"));
        }
        finally {
            central.close();
        }
    }

    static class CountDownEventHandler {
        static CountDownLatch latch;

        CountDownEventHandler() {
        }

        static void init(CountDownLatch latch) {
            CountDownEventHandler.latch = latch;
        }

        static void checkParallelCountersDoneAndFinish() throws Exception {
            latch.countDown();
            latch.await();
        }

        public void handle() {
            latch.countDown();
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static enum TestEventType1 {
        TYPE1;

    }

    class TestEventHandler1
    extends CountDownEventHandler
    implements EventHandler<TestEvent1> {
        TestEventHandler1() {
        }

        public void handle(TestEvent1 event) {
            this.handle();
        }
    }

    public static enum TestEventType2 {
        TYPE2;

    }

    class TestEventHandler2
    extends CountDownEventHandler
    implements EventHandler<TestEvent2> {
        TestEventHandler2() {
        }

        public void handle(TestEvent2 event) {
            this.handle();
        }
    }

    public static enum TestEventType3 {
        TYPE3;

    }

    class TestEventHandler3
    extends CountDownEventHandler
    implements EventHandler<TestEvent3> {
        TestEventHandler3() {
        }

        public void handle(TestEvent3 event) {
            this.handle();
        }
    }

    public class TestEvent1
    extends TezAbstractEvent<TestEventType1> {
        final int hash;

        public TestEvent1(TestEventType1 type, int hash) {
            super((Enum)type);
            this.hash = hash;
        }

        public int getSerializingHash() {
            return this.hash;
        }
    }

    public class TestEvent2
    extends TezAbstractEvent<TestEventType2> {
        public TestEvent2(TestEventType2 type) {
            super((Enum)type);
        }
    }

    public class TestEvent3
    extends TezAbstractEvent<TestEventType3> {
        public TestEvent3(TestEventType3 type) {
            super((Enum)type);
        }
    }
}

