/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.TezExecutors;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TezSharedExecutor
implements TezExecutors {
    private final ThreadPoolExecutor service;
    private final DelayedExecutionPoller poller;

    public TezSharedExecutor(Configuration conf) {
        int minThreads = conf.getInt("tez.shared-executor.min-threads", 0);
        int maxThreads = conf.getInt("tez.shared-executor.max-threads", -1);
        if (maxThreads < 0) {
            maxThreads = Integer.MAX_VALUE;
        }
        this.service = new ThreadPoolExecutor(minThreads, maxThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("TezSharedExecutor: %d").build());
        this.poller = new DelayedExecutionPoller(this.service);
        this.poller.start();
    }

    @Override
    public ExecutorService createExecutorService(int poolSize, String threadName) {
        return new ExecutorServiceInternal(poolSize, threadName);
    }

    @Override
    public void shutdown() {
        this.service.shutdown();
        this.poller.interrupt();
    }

    @Override
    public void shutdownNow() {
        this.service.shutdownNow();
        this.poller.interrupt();
    }

    protected void finalize() {
        this.shutdown();
    }

    private static class DelayedExecutionPoller
    extends Thread {
        private final ThreadPoolExecutor service;
        private final LinkedBlockingQueue<ExecutorServiceInternal> executeQueue = new LinkedBlockingQueue();

        DelayedExecutionPoller(ThreadPoolExecutor service) {
            super("DelayedExecutionPoller");
            this.setDaemon(true);
            this.service = service;
        }

        void add(ExecutorServiceInternal es) {
            this.executeQueue.add(es);
        }

        @Override
        public void run() {
            while (!this.service.isShutdown()) {
                try {
                    this.executeQueue.take().tryExecute();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class ExecutorServiceInternal
    extends AbstractExecutorService {
        private final ConcurrentHashMap<ManagedFutureTask<?>, Boolean> futures = new ConcurrentHashMap();
        private final AtomicInteger numTasksSubmitted = new AtomicInteger();
        private final LinkedBlockingQueue<ManagedFutureTask<?>> pendingTasks = new LinkedBlockingQueue();
        private final CountDownLatch shutdownLatch = new CountDownLatch(1);
        private final String threadName;
        private final int poolSize;

        ExecutorServiceInternal(int poolSize, String threadName) {
            Preconditions.checkArgument(poolSize > 0, "Expected poolSize > 0");
            this.threadName = threadName;
            this.poolSize = poolSize;
        }

        private void addFuture(ManagedFutureTask<?> future) {
            this.futures.put(future, Boolean.TRUE);
            if (this.isShutdown()) {
                TezSharedExecutor.this.service.getRejectedExecutionHandler().rejectedExecution(future, TezSharedExecutor.this.service);
            }
        }

        private void removeFuture(ManagedFutureTask<?> future) {
            this.futures.remove(future);
        }

        protected <T> ManagedFutureTask<T> newTaskFor(Runnable runnable, T value) {
            if (runnable instanceof ManagedFutureTask) {
                return (ManagedFutureTask)runnable;
            }
            return new ManagedFutureTask<T>(runnable, value);
        }

        protected <T> ManagedFutureTask<T> newTaskFor(Callable<T> callable) {
            return new ManagedFutureTask<T>(callable);
        }

        @Override
        public void shutdown() {
            this.shutdownLatch.countDown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            this.shutdownLatch.countDown();
            ArrayList<Runnable> pending = new ArrayList<Runnable>(this.pendingTasks.size());
            this.pendingTasks.drainTo(pending);
            for (ManagedFutureTask future : this.futures.keySet()) {
                future.cancel(true);
            }
            return pending;
        }

        @Override
        public boolean isShutdown() {
            return this.shutdownLatch.getCount() == 0L || TezSharedExecutor.this.service.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            if (!this.isShutdown()) {
                return false;
            }
            for (ManagedFutureTask future : this.futures.keySet()) {
                if (future.isDone()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            long deadline = System.nanoTime() + unit.toNanos(timeout);
            if (!this.shutdownLatch.await(timeout, unit)) {
                return false;
            }
            for (ManagedFutureTask future : this.futures.keySet()) {
                long nanosLeft = deadline - System.nanoTime();
                if (nanosLeft <= 0L) {
                    return false;
                }
                try {
                    future.get(nanosLeft, TimeUnit.NANOSECONDS);
                }
                catch (CancellationException | ExecutionException exception) {
                }
                catch (TimeoutException e) {
                    return false;
                }
            }
            return true;
        }

        private void tryExecute() {
            while (!this.pendingTasks.isEmpty()) {
                int numTasks = this.numTasksSubmitted.get();
                if (numTasks >= this.poolSize) {
                    return;
                }
                if (!this.numTasksSubmitted.compareAndSet(numTasks, numTasks + 1)) continue;
                ManagedFutureTask<?> task = this.pendingTasks.poll();
                if (task == null || task.isCancelled() || TezSharedExecutor.this.service.isShutdown()) {
                    this.numTasksSubmitted.decrementAndGet();
                    continue;
                }
                task.submit();
            }
        }

        @Override
        public void execute(Runnable command) {
            this.pendingTasks.add((ManagedFutureTask<?>)this.newTaskFor(command, (Object)null));
            this.tryExecute();
        }

        protected void finalize() {
            this.shutdown();
        }

        private class ManagedFutureTask<V>
        extends FutureTask<V> {
            private boolean submitted;

            ManagedFutureTask(Runnable runnable, V value) {
                super(runnable, value);
                this.submitted = false;
                ExecutorServiceInternal.this.addFuture(this);
            }

            ManagedFutureTask(Callable<V> callable) {
                super(callable);
                this.submitted = false;
                ExecutorServiceInternal.this.addFuture(this);
            }

            @Override
            public void run() {
                Thread thisThread = Thread.currentThread();
                String savedThreadName = null;
                if (ExecutorServiceInternal.this.threadName != null) {
                    savedThreadName = thisThread.getName();
                    thisThread.setName(String.format(ExecutorServiceInternal.this.threadName, thisThread.getId()));
                }
                try {
                    super.run();
                }
                finally {
                    if (ExecutorServiceInternal.this.threadName != null) {
                        thisThread.setName(savedThreadName);
                    }
                }
            }

            synchronized void submit() {
                this.submitted = true;
                TezSharedExecutor.this.service.execute(this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void done() {
                ExecutorServiceInternal.this.removeFuture(this);
                ManagedFutureTask managedFutureTask = this;
                synchronized (managedFutureTask) {
                    if (this.submitted) {
                        ExecutorServiceInternal.this.numTasksSubmitted.decrementAndGet();
                    }
                }
                TezSharedExecutor.this.poller.add(ExecutorServiceInternal.this);
            }
        }
    }
}

