/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.apache.tez.runtime.library.common.sort.impl.IFileInputStream;
import org.apache.tez.shaded.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodecUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CodecUtils.class);
    @VisibleForTesting
    static final int DEFAULT_BUFFER_SIZE = 262144;

    private CodecUtils() {
    }

    public static CompressionCodec getCodec(Configuration conf) throws IOException {
        if (ConfigUtils.shouldCompressIntermediateOutput(conf)) {
            Class<? extends CompressionCodec> codecClass = ConfigUtils.getIntermediateOutputCompressorClass(conf, DefaultCodec.class);
            CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, (Configuration)conf);
            if (codec != null) {
                Class compressorType = null;
                RuntimeException cause = null;
                try {
                    compressorType = codec.getCompressorType();
                }
                catch (RuntimeException e) {
                    cause = e;
                }
                if (compressorType == null) {
                    String errMsg = String.format("Unable to get CompressorType for codec (%s). This is most likely due to missing native libraries for the codec.", conf.get("tez.runtime.compress.codec"));
                    throw new IOException(errMsg, cause);
                }
            }
            return codec;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getDecompressedInputStreamWithBufferSize(CompressionCodec codec, IFileInputStream checksumIn, Decompressor decompressor, int compressedLength) throws IOException {
        String bufferSizeProp = CodecUtils.getBufferSizeProperty(codec);
        CompressionInputStream in = null;
        if (bufferSizeProp != null) {
            Configuration conf;
            Configurable configurableCodec = (Configurable)codec;
            Configuration configuration = conf = configurableCodec.getConf();
            synchronized (configuration) {
                int defaultBufferSize = CodecUtils.getDefaultBufferSize(conf, codec);
                int originalSize = conf.getInt(bufferSizeProp, defaultBufferSize);
                int newBufSize = Math.min(compressedLength, defaultBufferSize);
                LOG.debug("buffer size was set according to min({}, {}) => {}={}", new Object[]{compressedLength, defaultBufferSize, bufferSizeProp, newBufSize});
                conf.setInt(bufferSizeProp, newBufSize);
                in = codec.createInputStream((InputStream)checksumIn, decompressor);
                conf.setInt(bufferSizeProp, originalSize);
            }
        } else {
            in = codec.createInputStream((InputStream)checksumIn, decompressor);
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Compressor getCompressor(CompressionCodec codec) {
        Configuration configuration = ((Configurable)codec).getConf();
        synchronized (configuration) {
            return CodecPool.getCompressor((CompressionCodec)codec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Decompressor getDecompressor(CompressionCodec codec) {
        Configuration configuration = ((Configurable)codec).getConf();
        synchronized (configuration) {
            return CodecPool.getDecompressor((CompressionCodec)codec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompressionInputStream createInputStream(CompressionCodec codec, InputStream checksumIn, Decompressor decompressor) throws IOException {
        Configuration configuration = ((Configurable)codec).getConf();
        synchronized (configuration) {
            return codec.createInputStream(checksumIn, decompressor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompressionOutputStream createOutputStream(CompressionCodec codec, OutputStream checksumOut, Compressor compressor) throws IOException {
        Configuration configuration = ((Configurable)codec).getConf();
        synchronized (configuration) {
            return codec.createOutputStream(checksumOut, compressor);
        }
    }

    public static String getBufferSizeProperty(CompressionCodec codec) {
        return CodecUtils.getBufferSizeProperty(codec.getClass().getName());
    }

    public static String getBufferSizeProperty(String codecClassName) {
        switch (codecClassName) {
            case "org.apache.hadoop.io.compress.DefaultCodec": 
            case "org.apache.hadoop.io.compress.BZip2Codec": 
            case "org.apache.hadoop.io.compress.GzipCodec": {
                return "io.file.buffer.size";
            }
            case "org.apache.hadoop.io.compress.SnappyCodec": {
                return "io.compression.codec.snappy.buffersize";
            }
            case "org.apache.hadoop.io.compress.ZStandardCodec": {
                return "io.compression.codec.zstd.buffersize";
            }
            case "org.apache.hadoop.io.compress.LzoCodec": 
            case "com.hadoop.compression.lzo.LzoCodec": {
                return "io.compression.codec.lzo.buffersize";
            }
            case "org.apache.hadoop.io.compress.Lz4Codec": {
                return "io.compression.codec.lz4.buffersize";
            }
        }
        return null;
    }

    public static int getDefaultBufferSize(Configuration conf, CompressionCodec codec) {
        return CodecUtils.getDefaultBufferSize(conf, codec.getClass().getName());
    }

    public static int getDefaultBufferSize(Configuration conf, String codecClassName) {
        switch (codecClassName) {
            case "org.apache.hadoop.io.compress.DefaultCodec": 
            case "org.apache.hadoop.io.compress.BZip2Codec": 
            case "org.apache.hadoop.io.compress.GzipCodec": {
                return 4096;
            }
            case "org.apache.hadoop.io.compress.SnappyCodec": {
                return 262144;
            }
            case "org.apache.hadoop.io.compress.ZStandardCodec": {
                return 0;
            }
            case "org.apache.hadoop.io.compress.LzoCodec": 
            case "com.hadoop.compression.lzo.LzoCodec": {
                return 65536;
            }
            case "org.apache.hadoop.io.compress.Lz4Codec": {
                return 262144;
            }
        }
        return 262144;
    }
}

