/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.auxservices;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.hadoop.io.ReadaheadPool;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.tez.shaded.io.netty.buffer.ByteBuf;
import org.apache.tez.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.tez.shaded.io.netty.handler.stream.ChunkedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FadvisedChunkedFile
extends ChunkedFile {
    private static final Logger LOG = LoggerFactory.getLogger(FadvisedChunkedFile.class);
    private final boolean manageOsCache;
    private final int readaheadLength;
    private final ReadaheadPool readaheadPool;
    private final FileDescriptor fd;
    private final String identifier;
    private ReadaheadPool.ReadaheadRequest readaheadRequest;

    public FadvisedChunkedFile(RandomAccessFile file, long position, long count, int chunkSize, boolean manageOsCache, int readaheadLength, ReadaheadPool readaheadPool, String identifier) throws IOException {
        super(file, position, count, chunkSize);
        this.manageOsCache = manageOsCache;
        this.readaheadLength = readaheadLength;
        this.readaheadPool = readaheadPool;
        this.fd = file.getFD();
        this.identifier = identifier;
    }

    @Override
    public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
        if (this.manageOsCache && this.readaheadPool != null) {
            this.readaheadRequest = this.readaheadPool.readaheadStream(this.identifier, this.fd, this.currentOffset(), (long)this.readaheadLength, this.endOffset(), this.readaheadRequest);
        }
        return super.readChunk(ctx);
    }

    @Override
    public void close() throws Exception {
        if (this.readaheadRequest != null) {
            this.readaheadRequest.cancel();
        }
        if (this.manageOsCache && this.endOffset() - this.startOffset() > 0L) {
            try {
                NativeIO.POSIX.getCacheManipulator().posixFadviseIfPossible(this.identifier, this.fd, this.startOffset(), this.endOffset() - this.startOffset(), NativeIO.POSIX.POSIX_FADV_DONTNEED);
            }
            catch (Throwable t) {
                LOG.warn("Failed to manage OS cache for " + this.identifier, t);
            }
        }
        super.close();
    }
}

