/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client;

import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import com.sun.jersey.json.impl.provider.entity.JSONRootElementProvider;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.tez.common.ReflectionUtils;
import org.apache.tez.dag.api.TezException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class TimelineReaderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineReaderFactory.class);
    private static final String KERBEROS_DELEGATION_TOKEN_AUTHENTICATOR_CLAZZ_NAME = "org.apache.hadoop.security.token.delegation.web.KerberosDelegationTokenAuthenticator";
    private static final String PSEUDO_DELEGATION_TOKEN_AUTHENTICATOR_CLAZZ_NAME = "org.apache.hadoop.security.token.delegation.web.PseudoDelegationTokenAuthenticator";
    private static final String DELEGATION_TOKEN_AUTHENTICATED_URL_CLAZZ_NAME = "org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL";
    private static final String DELEGATION_TOKEN_AUTHENTICATOR_CLAZZ_NAME = "org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticator";
    private static final String DELEGATION_TOKEN_AUTHENTICATED_URL_TOKEN_CLASS_NAME = "org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL$Token";
    private static Class<?> delegationTokenAuthenticatorClazz = null;
    private static Method delegationTokenAuthenticateURLOpenConnectionMethod = null;
    private static boolean isTokenDelegationSupportChecksDone = false;
    private static boolean isTokenDelegationClassesPresent = false;

    private TimelineReaderFactory() {
    }

    public static TimelineReaderStrategy getTimelineReaderStrategy(Configuration conf, boolean useHttps, int connTimeout) throws TezException {
        if (!TimelineReaderFactory.isTimelineClientSupported()) {
            throw new TezException("Reading from timeline is not supported. token delegation support: " + TimelineReaderFactory.tokenDelegationSupported() + ", is secure timeline: " + UserGroupInformation.isSecurityEnabled());
        }
        TimelineReaderStrategy timelineReaderStrategy = TimelineReaderFactory.getTimelineReaderStrategy(TimelineReaderFactory.tokenDelegationSupported(), conf, useHttps, connTimeout);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using " + timelineReaderStrategy.getClass().getName() + " to read timeline data");
        }
        return timelineReaderStrategy;
    }

    private static TimelineReaderStrategy getTimelineReaderStrategy(boolean isTokenDelegationSupported, Configuration conf, boolean useHttps, int connTimeout) {
        TimelineReaderStrategy timelineReaderStrategy = isTokenDelegationSupported ? new TimelineReaderTokenAuthenticatedStrategy(conf, useHttps, connTimeout) : new TimelineReaderPseudoAuthenticatedStrategy(conf, useHttps, connTimeout);
        return timelineReaderStrategy;
    }

    public static boolean isTimelineClientSupported() {
        return !UserGroupInformation.isSecurityEnabled() || TimelineReaderFactory.tokenDelegationSupported();
    }

    private static ConnectionConfigurator getNewConnectionConf(boolean useHttps, final int connTimeout, SSLFactory sslFactory) {
        ConnectionConfigurator connectionConf = null;
        if (useHttps) {
            try {
                connectionConf = TimelineReaderFactory.getNewSSLConnectionConf(connTimeout, sslFactory);
            }
            catch (IOException e) {
                LOG.debug("Cannot load customized ssl related configuration. Falling back to system-generic settings.", (Throwable)e);
            }
        }
        if (connectionConf == null) {
            connectionConf = new ConnectionConfigurator(){

                public HttpURLConnection configure(HttpURLConnection httpURLConnection) {
                    TimelineReaderFactory.setTimeouts(httpURLConnection, connTimeout);
                    return httpURLConnection;
                }
            };
        }
        return connectionConf;
    }

    private static ConnectionConfigurator getNewSSLConnectionConf(final int connTimeout, SSLFactory sslFactory) throws IOException {
        SSLSocketFactory sslSocketFactory;
        try {
            sslFactory.init();
            sslSocketFactory = sslFactory.createSSLSocketFactory();
        }
        catch (GeneralSecurityException e) {
            sslFactory.destroy();
            throw new IOException("Failed to initialize ssl factory");
        }
        final HostnameVerifier hostnameVerifier = sslFactory.getHostnameVerifier();
        return new ConnectionConfigurator(){

            public HttpURLConnection configure(HttpURLConnection httpURLConnection) throws IOException {
                if (!(httpURLConnection instanceof HttpsURLConnection)) {
                    throw new IOException("Expected https connection");
                }
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
                httpsURLConnection.setSSLSocketFactory(sslSocketFactory);
                httpsURLConnection.setHostnameVerifier(hostnameVerifier);
                TimelineReaderFactory.setTimeouts(httpsURLConnection, connTimeout);
                return httpsURLConnection;
            }
        };
    }

    private static void setTimeouts(HttpURLConnection httpURLConnection, int connTimeout) {
        httpURLConnection.setConnectTimeout(connTimeout);
        httpURLConnection.setReadTimeout(connTimeout);
    }

    private static synchronized boolean tokenDelegationSupported() {
        if (!isTokenDelegationSupportChecksDone) {
            isTokenDelegationSupportChecksDone = true;
            try {
                ReflectionUtils.getClazz(KERBEROS_DELEGATION_TOKEN_AUTHENTICATOR_CLAZZ_NAME);
                ReflectionUtils.getClazz(PSEUDO_DELEGATION_TOKEN_AUTHENTICATOR_CLAZZ_NAME);
                delegationTokenAuthenticatorClazz = ReflectionUtils.getClazz(DELEGATION_TOKEN_AUTHENTICATOR_CLAZZ_NAME);
                Class<?> delegationTokenAuthenticatedURLClazz = ReflectionUtils.getClazz(DELEGATION_TOKEN_AUTHENTICATED_URL_CLAZZ_NAME);
                Class<?> delegationTokenAuthenticatedURLTokenClazz = ReflectionUtils.getClazz(DELEGATION_TOKEN_AUTHENTICATED_URL_TOKEN_CLASS_NAME);
                delegationTokenAuthenticateURLOpenConnectionMethod = ReflectionUtils.getMethod(delegationTokenAuthenticatedURLClazz, "openConnection", URL.class, delegationTokenAuthenticatedURLTokenClazz, String.class);
                isTokenDelegationClassesPresent = true;
            }
            catch (TezException e) {
                LOG.info("Could not find class required for token delegation, will fallback to pseudo auth");
            }
        }
        return isTokenDelegationClassesPresent;
    }

    public static interface TimelineReaderStrategy {
        public Client getHttpClient() throws IOException;

        public void close();
    }

    private static class TimelineReaderTokenAuthenticatedStrategy
    implements TimelineReaderStrategy {
        private final boolean useHttps;
        private final int connTimeout;
        private final SSLFactory sslFactory;

        public TimelineReaderTokenAuthenticatedStrategy(Configuration conf, boolean useHttps, int connTimeout) {
            this.useHttps = useHttps;
            this.connTimeout = connTimeout;
            this.sslFactory = useHttps ? new SSLFactory(SSLFactory.Mode.CLIENT, conf) : null;
        }

        @Override
        public Client getHttpClient() throws IOException {
            TokenAuthenticatedURLConnectionFactory connectionFactory;
            Authenticator authenticator;
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            UserGroupInformation realUgi = ugi.getRealUser();
            DefaultClientConfig clientConfig = new DefaultClientConfig(new Class[]{JSONRootElementProvider.App.class});
            ConnectionConfigurator connectionConfigurator = TimelineReaderFactory.getNewConnectionConf(this.useHttps, this.connTimeout, this.sslFactory);
            try {
                authenticator = TimelineReaderTokenAuthenticatedStrategy.getTokenAuthenticator();
                authenticator.setConnectionConfigurator(connectionConfigurator);
            }
            catch (TezException e) {
                throw new IOException("Failed to get authenticator", e);
            }
            String doAsUser = realUgi != null ? ugi.getShortUserName() : null;
            try {
                connectionFactory = new TokenAuthenticatedURLConnectionFactory(connectionConfigurator, authenticator, doAsUser);
            }
            catch (TezException e) {
                throw new IOException("Fail to create TokenAuthenticatedURLConnectionFactory", e);
            }
            return new Client((ClientHandler)new URLConnectionClientHandler((HttpURLConnectionFactory)connectionFactory), (ClientConfig)clientConfig);
        }

        private static Authenticator getTokenAuthenticator() throws TezException {
            String authenticatorClazzName = UserGroupInformation.isSecurityEnabled() ? TimelineReaderFactory.KERBEROS_DELEGATION_TOKEN_AUTHENTICATOR_CLAZZ_NAME : TimelineReaderFactory.PSEUDO_DELEGATION_TOKEN_AUTHENTICATOR_CLAZZ_NAME;
            return (Authenticator)ReflectionUtils.createClazzInstance(authenticatorClazzName);
        }

        @Override
        public void close() {
            if (this.sslFactory != null) {
                this.sslFactory.destroy();
            }
        }

        private static class TokenAuthenticatedURLConnectionFactory
        implements HttpURLConnectionFactory {
            private final Authenticator authenticator;
            private final ConnectionConfigurator connConfigurator;
            private final String doAsUser;
            private final AuthenticatedURL.Token token;

            public TokenAuthenticatedURLConnectionFactory(ConnectionConfigurator connConfigurator, Authenticator authenticator, String doAsUser) throws TezException {
                this.connConfigurator = connConfigurator;
                this.authenticator = authenticator;
                this.doAsUser = doAsUser;
                this.token = (AuthenticatedURL.Token)ReflectionUtils.createClazzInstance(TimelineReaderFactory.DELEGATION_TOKEN_AUTHENTICATED_URL_TOKEN_CLASS_NAME, null, null);
            }

            public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
                try {
                    AuthenticatedURL authenticatedURL = (AuthenticatedURL)ReflectionUtils.createClazzInstance(TimelineReaderFactory.DELEGATION_TOKEN_AUTHENTICATED_URL_CLAZZ_NAME, new Class[]{delegationTokenAuthenticatorClazz, ConnectionConfigurator.class}, new Object[]{this.authenticator, this.connConfigurator});
                    return (HttpURLConnection)ReflectionUtils.invokeMethod(authenticatedURL, delegationTokenAuthenticateURLOpenConnectionMethod, url, this.token, this.doAsUser);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        }
    }

    @VisibleForTesting
    protected static class TimelineReaderPseudoAuthenticatedStrategy
    implements TimelineReaderStrategy {
        private final ConnectionConfigurator connectionConf;
        private final SSLFactory sslFactory;

        public TimelineReaderPseudoAuthenticatedStrategy(Configuration conf, boolean useHttps, int connTimeout) {
            this.sslFactory = useHttps ? new SSLFactory(SSLFactory.Mode.CLIENT, conf) : null;
            this.connectionConf = TimelineReaderFactory.getNewConnectionConf(useHttps, connTimeout, this.sslFactory);
        }

        @Override
        public Client getHttpClient() {
            DefaultClientConfig config = new DefaultClientConfig(new Class[]{JSONRootElementProvider.App.class});
            PseudoAuthenticatedURLConnectionFactory urlFactory = new PseudoAuthenticatedURLConnectionFactory(this.connectionConf);
            return new Client((ClientHandler)new URLConnectionClientHandler((HttpURLConnectionFactory)urlFactory), (ClientConfig)config);
        }

        @Override
        public void close() {
            if (this.sslFactory != null) {
                this.sslFactory.destroy();
            }
        }

        @VisibleForTesting
        protected static class PseudoAuthenticatedURLConnectionFactory
        implements HttpURLConnectionFactory {
            private final ConnectionConfigurator connectionConf;

            public PseudoAuthenticatedURLConnectionFactory(ConnectionConfigurator connectionConf) {
                this.connectionConf = connectionConf;
            }

            public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
                String tokenString = (url.getQuery() == null ? "?" : "&") + "user.name=" + URLEncoder.encode(UserGroupInformation.getCurrentUser().getShortUserName(), "UTF8");
                HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(url + tokenString).openConnection();
                this.connectionConf.configure(httpURLConnection);
                return httpURLConnection;
            }
        }
    }
}

