/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
public final class UserPayload {
    private ByteBuffer payload;
    private int version;
    private static final ByteBuffer EMPTY_BYTE = ByteBuffer.wrap(new byte[0]);

    public UserPayload() {
    }

    private UserPayload(@Nullable ByteBuffer payload) {
        this(payload, 0);
    }

    private UserPayload(@Nullable ByteBuffer payload, int version) {
        this.payload = payload == null ? EMPTY_BYTE : payload;
        this.version = version;
    }

    public static UserPayload create(@Nullable ByteBuffer payload) {
        return new UserPayload(payload);
    }

    public static UserPayload create(@Nullable ByteBuffer payload, int version) {
        return new UserPayload(payload, version);
    }

    @Nullable
    public ByteBuffer getRawPayload() {
        return this.payload == EMPTY_BYTE ? null : this.payload.duplicate();
    }

    @Nullable
    public ByteBuffer getPayload() {
        return this.payload == EMPTY_BYTE ? null : this.payload.asReadOnlyBuffer();
    }

    public int getVersion() {
        return this.version;
    }

    public boolean hasPayload() {
        return this.payload != null && this.payload != EMPTY_BYTE;
    }

    @InterfaceStability.Unstable
    @VisibleForTesting
    public byte[] deepCopyAsArray() {
        ByteBuffer src = this.getPayload();
        if (src != null) {
            byte[] dst = new byte[src.limit() - src.position()];
            src.get(dst);
            return dst;
        }
        return new byte[0];
    }
}

