/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.common.Preconditions;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;

@InterfaceAudience.Public
public class EdgeProperty {
    final DataMovementType dataMovementType;
    final DataSourceType dataSourceType;
    final SchedulingType schedulingType;
    final InputDescriptor inputDescriptor;
    final OutputDescriptor outputDescriptor;
    final EdgeManagerPluginDescriptor edgeManagerDescriptor;

    public static EdgeProperty create(DataMovementType dataMovementType, DataSourceType dataSourceType, SchedulingType schedulingType, OutputDescriptor edgeSource, InputDescriptor edgeDestination) {
        return new EdgeProperty(dataMovementType, dataSourceType, schedulingType, edgeSource, edgeDestination);
    }

    public static EdgeProperty create(EdgeManagerPluginDescriptor edgeManagerDescriptor, DataSourceType dataSourceType, SchedulingType schedulingType, OutputDescriptor edgeSource, InputDescriptor edgeDestination) {
        return new EdgeProperty(edgeManagerDescriptor, dataSourceType, schedulingType, edgeSource, edgeDestination);
    }

    @InterfaceAudience.Private
    public static EdgeProperty create(EdgeManagerPluginDescriptor edgeManagerDescriptor, DataMovementType dataMovementType, DataSourceType dataSourceType, SchedulingType schedulingType, OutputDescriptor edgeSource, InputDescriptor edgeDestination) {
        return new EdgeProperty(edgeManagerDescriptor, dataMovementType, dataSourceType, schedulingType, edgeSource, edgeDestination);
    }

    private EdgeProperty(DataMovementType dataMovementType, DataSourceType dataSourceType, SchedulingType schedulingType, OutputDescriptor edgeSource, InputDescriptor edgeDestination) {
        this(null, dataMovementType, dataSourceType, schedulingType, edgeSource, edgeDestination);
        Preconditions.checkArgument(dataMovementType != DataMovementType.CUSTOM, DataMovementType.CUSTOM + " cannot be used with this constructor");
    }

    private EdgeProperty(EdgeManagerPluginDescriptor edgeManagerDescriptor, DataSourceType dataSourceType, SchedulingType schedulingType, OutputDescriptor edgeSource, InputDescriptor edgeDestination) {
        this(edgeManagerDescriptor, DataMovementType.CUSTOM, dataSourceType, schedulingType, edgeSource, edgeDestination);
    }

    private EdgeProperty(EdgeManagerPluginDescriptor edgeManagerDescriptor, DataMovementType dataMovementType, DataSourceType dataSourceType, SchedulingType schedulingType, OutputDescriptor edgeSource, InputDescriptor edgeDestination) {
        this.dataMovementType = dataMovementType;
        this.edgeManagerDescriptor = edgeManagerDescriptor;
        this.dataSourceType = dataSourceType;
        this.schedulingType = schedulingType;
        this.inputDescriptor = edgeDestination;
        this.outputDescriptor = edgeSource;
    }

    public DataMovementType getDataMovementType() {
        return this.dataMovementType;
    }

    public DataSourceType getDataSourceType() {
        return this.dataSourceType;
    }

    public SchedulingType getSchedulingType() {
        return this.schedulingType;
    }

    public InputDescriptor getEdgeDestination() {
        return this.inputDescriptor;
    }

    public OutputDescriptor getEdgeSource() {
        return this.outputDescriptor;
    }

    @InterfaceAudience.Private
    public EdgeManagerPluginDescriptor getEdgeManagerDescriptor() {
        return this.edgeManagerDescriptor;
    }

    public String toString() {
        return "{ " + this.dataMovementType + " : " + this.inputDescriptor.getClassName() + " >> " + this.dataSourceType + " >> " + this.outputDescriptor.getClassName() + " >> " + (this.edgeManagerDescriptor == null ? "NullEdgeManager" : this.edgeManagerDescriptor.getClassName()) + " }";
    }

    public static enum DataMovementType {
        ONE_TO_ONE,
        BROADCAST,
        SCATTER_GATHER,
        CUSTOM;

    }

    public static enum DataSourceType {
        PERSISTED,
        PERSISTED_RELIABLE,
        EPHEMERAL;

    }

    public static enum SchedulingType {
        SEQUENTIAL,
        CONCURRENT;

    }

    public static enum ConcurrentEdgeTriggerType {
        SOURCE_VERTEX_CONFIGURED,
        SOURCE_TASK_STARTED;

    }
}

