/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.io.File;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class TezYARNUtils {
    private static Logger LOG = LoggerFactory.getLogger(TezYARNUtils.class);
    public static final String ENV_NAME_REGEX = "[A-Za-z_][A-Za-z0-9_]*";
    private static final Pattern VAR_SUBBER = Pattern.compile(Shell.getEnvironmentVariableRegex());
    private static final Pattern VARVAL_SPLITTER = Pattern.compile("(?<=^|,)([A-Za-z_][A-Za-z0-9_]*)=([^,]*)");

    private TezYARNUtils() {
    }

    public static String getFrameworkClasspath(Configuration conf, boolean usingArchive) {
        StringBuilder classpathBuilder = new StringBuilder();
        boolean userClassesTakesPrecedence = conf.getBoolean("tez.user.classpath.first", true);
        if (userClassesTakesPrecedence) {
            TezYARNUtils.addUserSpecifiedClasspath(classpathBuilder, conf);
        }
        String[] tezLibUrisClassPath = conf.getStrings("tez.lib.uris.classpath");
        if (!conf.getBoolean("tez.ignore.lib.uris", false) && tezLibUrisClassPath != null && tezLibUrisClassPath.length != 0) {
            for (String c : tezLibUrisClassPath) {
                classpathBuilder.append(c.trim()).append(File.pathSeparator);
            }
        } else {
            if (conf.getBoolean("tez.ignore.lib.uris", false)) {
                LOG.info("Ignoring 'tez.lib.uris' since  'tez.ignore.lib.uris' is set to true ");
            }
            if (usingArchive) {
                classpathBuilder.append(ApplicationConstants.Environment.PWD.$()).append(File.separator).append("tezlib").append(File.separator).append("*").append(File.pathSeparator);
                classpathBuilder.append(ApplicationConstants.Environment.PWD.$()).append(File.separator).append("tezlib").append(File.separator).append("lib").append(File.separator).append("*").append(File.pathSeparator);
            }
        }
        if (conf.getBoolean("tez.use.cluster.hadoop-libs", false)) {
            for (String c : conf.getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH)) {
                classpathBuilder.append(c.trim()).append(File.pathSeparator);
            }
        } else if (conf.getBoolean("tez.classpath.add-hadoop-conf", false)) {
            classpathBuilder.append(ApplicationConstants.Environment.HADOOP_CONF_DIR.$()).append(File.pathSeparator);
        }
        if (!userClassesTakesPrecedence) {
            TezYARNUtils.addUserSpecifiedClasspath(classpathBuilder, conf);
        }
        String classpath = classpathBuilder.toString();
        return StringInterner.weakIntern((String)classpath);
    }

    private static void addUserSpecifiedClasspath(StringBuilder classpathBuilder, Configuration conf) {
        String additionalClasspath = conf.get("tez.cluster.additional.classpath.prefix");
        if (additionalClasspath != null && !additionalClasspath.trim().isEmpty()) {
            classpathBuilder.append(additionalClasspath).append(File.pathSeparator);
        }
        classpathBuilder.append(ApplicationConstants.Environment.PWD.$()).append(File.pathSeparator).append(ApplicationConstants.Environment.PWD.$()).append(File.separator).append("*").append(File.pathSeparator);
    }

    public static void appendToEnvFromInputString(Map<String, String> env, String envString, String classPathSeparator) {
        if (envString != null && envString.length() > 0) {
            Matcher varValMatcher = VARVAL_SPLITTER.matcher(envString);
            while (varValMatcher.find()) {
                String envVar = varValMatcher.group(1);
                Matcher m = VAR_SUBBER.matcher(varValMatcher.group(2));
                StringBuffer sb = new StringBuffer();
                while (m.find()) {
                    String var = m.group(1);
                    String replace = env.get(var);
                    if (replace == null) {
                        replace = System.getenv(var);
                    }
                    if (replace == null) continue;
                    m.appendReplacement(sb, Matcher.quoteReplacement(replace));
                }
                m.appendTail(sb);
                TezYARNUtils.addToEnvironment(env, envVar, sb.toString(), classPathSeparator);
            }
        }
    }

    public static void setEnvIfAbsentFromInputString(Map<String, String> env, String envString) {
        if (envString != null && envString.length() > 0) {
            String[] childEnvs;
            for (String cEnv : childEnvs = envString.split(",")) {
                String[] parts = cEnv.split("=");
                Matcher m = VAR_SUBBER.matcher(parts[1]);
                StringBuffer sb = new StringBuffer();
                while (m.find()) {
                    String var = m.group(1);
                    String replace = env.get(var);
                    if (replace == null) {
                        replace = System.getenv(var);
                    }
                    if (replace == null) continue;
                    m.appendReplacement(sb, Matcher.quoteReplacement(replace));
                }
                m.appendTail(sb);
                TezYARNUtils.putIfAbsent(env, parts[0], sb.toString());
            }
        }
    }

    public static void addToEnvironment(Map<String, String> environment, String variable, String value, String classPathSeparator) {
        Object val = environment.get(variable);
        val = val == null ? value : (String)val + classPathSeparator + value;
        environment.put(StringInterner.weakIntern((String)variable), StringInterner.weakIntern((String)val));
    }

    private static void putIfAbsent(Map<String, String> env, String key, String value) {
        if (!env.containsKey(key)) {
            env.put(StringInterner.weakIntern((String)key), StringInterner.weakIntern((String)value));
        }
    }

    public static void setupDefaultEnv(Map<String, String> env, Configuration conf, String userEnvKey, String userEnvDefault, String clusterDefaultEnvKey, String clusterDefaultEnvDefault, boolean usingArchive) {
        String classpath = TezYARNUtils.getFrameworkClasspath(conf, usingArchive);
        TezYARNUtils.addToEnvironment(env, ApplicationConstants.Environment.CLASSPATH.name(), classpath, File.pathSeparator);
        TezYARNUtils.addToEnvironment(env, ApplicationConstants.Environment.LD_LIBRARY_PATH.name(), ApplicationConstants.Environment.PWD.$(), File.pathSeparator);
        TezYARNUtils.appendToEnvFromInputString(env, conf.get(userEnvKey, userEnvDefault), File.pathSeparator);
        TezYARNUtils.appendToEnvFromInputString(env, conf.get(clusterDefaultEnvKey, clusterDefaultEnvDefault), File.pathSeparator);
    }

    public static void replaceInEnv(Map<String, String> env, String key, String value) {
        env.put(StringInterner.weakIntern((String)key), StringInterner.weakIntern((String)value));
    }
}

