/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client.registry;

import java.util.Objects;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.yarn.api.records.ApplicationId;

@InterfaceAudience.Public
public class AMRecord {
    private static final String APP_ID_RECORD_KEY = "appId";
    private static final String HOST_RECORD_KEY = "host";
    private static final String PORT_RECORD_KEY = "port";
    private static final String OPAQUE_ID_KEY = "id";
    private final ApplicationId appId;
    private final String host;
    private final int port;
    private final String id;

    public AMRecord(ApplicationId appId, String host, int port, String id) {
        this.appId = appId;
        this.host = host;
        this.port = port;
        this.id = id == null ? "" : id;
    }

    public AMRecord(AMRecord other) {
        this.appId = other.getApplicationId();
        this.host = other.getHost();
        this.port = other.getPort();
        this.id = other.getId();
    }

    public AMRecord(ServiceRecord serviceRecord) {
        this.appId = ApplicationId.fromString((String)serviceRecord.get(APP_ID_RECORD_KEY));
        this.host = serviceRecord.get(HOST_RECORD_KEY);
        this.port = Integer.parseInt(serviceRecord.get(PORT_RECORD_KEY));
        this.id = serviceRecord.get(OPAQUE_ID_KEY);
    }

    public ApplicationId getApplicationId() {
        return this.appId;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof AMRecord) {
            AMRecord otherRecord = (AMRecord)other;
            return this.appId.equals((Object)otherRecord.appId) && this.host.equals(otherRecord.host) && this.port == otherRecord.port && this.id.equals(otherRecord.id);
        }
        return false;
    }

    public ServiceRecord toServiceRecord() {
        ServiceRecord serviceRecord = new ServiceRecord();
        serviceRecord.set(APP_ID_RECORD_KEY, (Object)this.appId);
        serviceRecord.set(HOST_RECORD_KEY, (Object)this.host);
        serviceRecord.set(PORT_RECORD_KEY, (Object)this.port);
        serviceRecord.set(OPAQUE_ID_KEY, (Object)this.id);
        return serviceRecord;
    }

    public int hashCode() {
        return Objects.hash(this.appId, this.host, this.port, this.id);
    }
}

