/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.tez.client.TestTezClientUtils;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezUncheckedException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTezCommonUtils {
    private static final String STAGE_DIR = "/tmp/mystage";
    private static final File LOCAL_STAGING_DIR = new File(System.getProperty("test.build.data"), TestTezCommonUtils.class.getSimpleName()).getAbsoluteFile();
    private static String RESOLVED_STAGE_DIR;
    private static Configuration conf;
    private static String TEST_ROOT_DIR;
    private static MiniDFSCluster dfsCluster;
    private static FileSystem remoteFs;
    private static final Logger LOG;

    @BeforeClass
    public static void setup() throws Exception {
        conf.set("tez.staging-dir", STAGE_DIR);
        LOG.info("Starting mini clusters");
        try {
            conf.set("hdfs.minidfs.basedir", TEST_ROOT_DIR);
            dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).format(true).racks(null).build();
            remoteFs = dfsCluster.getFileSystem();
            RESOLVED_STAGE_DIR = remoteFs.getUri() + STAGE_DIR;
            conf.set("fs.defaultFS", remoteFs.getUri().toString());
        }
        catch (IOException io) {
            throw new RuntimeException("problem starting mini dfs cluster", io);
        }
    }

    @AfterClass
    public static void afterClass() throws InterruptedException {
        if (dfsCluster != null) {
            try {
                LOG.info("Stopping DFSCluster");
                dfsCluster.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Test(timeout=5000L)
    public void testTezBaseStagingPath() throws Exception {
        Configuration localConf = new Configuration();
        localConf.set("tez.staging-dir", LOCAL_STAGING_DIR.getAbsolutePath());
        localConf.set("fs.defaultFS", "file:///");
        Path stageDir = TezCommonUtils.getTezBaseStagingPath((Configuration)localConf);
        Assert.assertEquals((Object)("file:" + LOCAL_STAGING_DIR), (Object)stageDir.toString());
        conf.set("tez.staging-dir", STAGE_DIR);
        stageDir = TezCommonUtils.getTezBaseStagingPath((Configuration)conf);
        Assert.assertEquals((Object)stageDir.toString(), (Object)RESOLVED_STAGE_DIR);
    }

    @Test(timeout=5000L)
    public void testCreateTezSysStagingPath() throws Exception {
        String strAppId = "testAppId";
        String expectedStageDir = RESOLVED_STAGE_DIR + "/.tez/" + strAppId;
        String unResolvedStageDir = "/tmp/mystage/.tez/" + strAppId;
        Path stagePath = new Path(unResolvedStageDir);
        FileSystem fs = stagePath.getFileSystem(conf);
        if (fs.exists(stagePath)) {
            fs.delete(stagePath, true);
        }
        Assert.assertFalse((boolean)fs.exists(stagePath));
        Path stageDir = TezCommonUtils.createTezSystemStagingPath((Configuration)conf, (String)strAppId);
        Assert.assertEquals((Object)stageDir.toString(), (Object)expectedStageDir);
        Assert.assertTrue((boolean)fs.exists(stagePath));
    }

    @Test(timeout=5000L)
    public void testTezSysStagingPath() throws Exception {
        String strAppId = "testAppId";
        Path stageDir = TezCommonUtils.getTezSystemStagingPath((Configuration)conf, (String)strAppId);
        String expectedStageDir = RESOLVED_STAGE_DIR + "/.tez/" + strAppId;
        Assert.assertEquals((Object)stageDir.toString(), (Object)expectedStageDir);
    }

    @Test(timeout=5000L)
    public void testTezConfStagingPath() throws Exception {
        String strAppId = "testAppId";
        Path stageDir = TezCommonUtils.getTezSystemStagingPath((Configuration)conf, (String)strAppId);
        Path confStageDir = TezCommonUtils.getTezConfStagingPath((Path)stageDir);
        String expectedDir = RESOLVED_STAGE_DIR + "/.tez/" + strAppId + "/tez-conf.pb";
        Assert.assertEquals((Object)confStageDir.toString(), (Object)expectedDir);
    }

    @Test(timeout=5000L)
    public void testTezSessionJarStagingPath() throws Exception {
        String strAppId = "testAppId";
        Path stageDir = TezCommonUtils.getTezSystemStagingPath((Configuration)conf, (String)strAppId);
        Path confStageDir = TezCommonUtils.getTezAMJarStagingPath((Path)stageDir);
        String expectedDir = RESOLVED_STAGE_DIR + "/.tez/" + strAppId + "/tez.session.local-resources.pb";
        Assert.assertEquals((Object)confStageDir.toString(), (Object)expectedDir);
    }

    @Test(timeout=5000L)
    public void testTezBinPlanStagingPath() throws Exception {
        String strAppId = "testAppId";
        Path stageDir = TezCommonUtils.getTezSystemStagingPath((Configuration)conf, (String)strAppId);
        Path confStageDir = TezCommonUtils.getTezBinPlanStagingPath((Path)stageDir);
        String expectedDir = RESOLVED_STAGE_DIR + "/.tez/" + strAppId + "/tez-dag.pb";
        Assert.assertEquals((Object)confStageDir.toString(), (Object)expectedDir);
    }

    @Test(timeout=5000L)
    public void testTezTextPlanStagingPath() throws Exception {
        String strAppId = "testAppId";
        String dagPBName = "testDagPBName";
        Path tezSysStagingPath = TezCommonUtils.getTezSystemStagingPath((Configuration)conf, (String)strAppId);
        Path confStageDir = TezCommonUtils.getTezTextPlanStagingPath((Path)tezSysStagingPath, (String)strAppId, (String)dagPBName);
        String expectedDir = RESOLVED_STAGE_DIR + "/.tez/" + strAppId + "/" + strAppId + "-" + dagPBName + "-tez-dag.pb.txt";
        Assert.assertEquals((Object)confStageDir.toString(), (Object)expectedDir);
    }

    @Test(timeout=5000L)
    public void testTezRecoveryStagingPath() throws Exception {
        String strAppId = "testAppId";
        Path stageDir = TezCommonUtils.getTezSystemStagingPath((Configuration)conf, (String)strAppId);
        Path confStageDir = TezCommonUtils.getRecoveryPath((Path)stageDir, (Configuration)conf);
        String expectedDir = RESOLVED_STAGE_DIR + "/.tez/" + strAppId + "/recovery";
        Assert.assertEquals((Object)confStageDir.toString(), (Object)expectedDir);
    }

    @Test(timeout=5000L)
    public void testTezAttemptRecoveryStagingPath() throws Exception {
        String strAppId = "testAppId";
        Path stageDir = TezCommonUtils.getTezSystemStagingPath((Configuration)conf, (String)strAppId);
        Path recoveryPath = TezCommonUtils.getRecoveryPath((Path)stageDir, (Configuration)conf);
        Path recoveryStageDir = TezCommonUtils.getAttemptRecoveryPath((Path)recoveryPath, (int)2);
        String expectedDir = RESOLVED_STAGE_DIR + "/.tez/" + strAppId + "/recovery/2";
        Assert.assertEquals((Object)recoveryStageDir.toString(), (Object)expectedDir);
    }

    @Test(timeout=5000L)
    public void testTezDAGRecoveryStagingPath() throws Exception {
        String strAppId = "testAppId";
        Path stageDir = TezCommonUtils.getTezSystemStagingPath((Configuration)conf, (String)strAppId);
        Path recoveryPath = TezCommonUtils.getRecoveryPath((Path)stageDir, (Configuration)conf);
        Path recoveryStageDir = TezCommonUtils.getAttemptRecoveryPath((Path)recoveryPath, (int)2);
        Path dagRecoveryPathj = TezCommonUtils.getDAGRecoveryPath((Path)recoveryStageDir, (String)"dag_123");
        String expectedDir = RESOLVED_STAGE_DIR + "/.tez/" + strAppId + "/recovery/2/dag_123.recovery";
        Assert.assertEquals((Object)expectedDir, (Object)dagRecoveryPathj.toString());
    }

    @Test(timeout=5000L)
    public void testTezSummaryRecoveryStagingPath() throws Exception {
        String strAppId = "testAppId";
        Path stageDir = TezCommonUtils.getTezSystemStagingPath((Configuration)conf, (String)strAppId);
        Path recoveryPath = TezCommonUtils.getRecoveryPath((Path)stageDir, (Configuration)conf);
        Path recoveryStageDir = TezCommonUtils.getAttemptRecoveryPath((Path)recoveryPath, (int)2);
        Path summaryRecoveryPathj = TezCommonUtils.getSummaryRecoveryPath((Path)recoveryStageDir);
        String expectedDir = RESOLVED_STAGE_DIR + "/.tez/" + strAppId + "/recovery/2/summary";
        Assert.assertEquals((Object)expectedDir, (Object)summaryRecoveryPathj.toString());
    }

    @Test(timeout=5000L)
    public void testLocalResourceVisibility() throws Exception {
        TestTezClientUtils.testLocalResourceVisibility(dfsCluster.getFileSystem(), conf);
    }

    @Test(timeout=5000L)
    public void testStringTokenize() {
        String s = "foo:bar:xyz::too";
        Object[] expectedTokens = new String[]{"foo", "bar", "xyz", "too"};
        Object[] tokens = new String[4];
        TezCommonUtils.tokenizeString((String)s, (String)":").toArray(tokens);
        Assert.assertArrayEquals((Object[])expectedTokens, (Object[])tokens);
    }

    @Test(timeout=5000L)
    public void testAddAdditionalLocalResources() {
        String lrName = "LR";
        HashMap originalLrs = Maps.newHashMap();
        originalLrs.put(lrName, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        originalLrs = Maps.newHashMap();
        originalLrs.put(lrName, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        HashMap additionalLrs = Maps.newHashMap();
        additionalLrs.put(lrName, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        TezCommonUtils.addAdditionalLocalResources((Map)additionalLrs, (Map)originalLrs, (String)"");
        originalLrs = Maps.newHashMap();
        originalLrs.put(lrName, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        additionalLrs = Maps.newHashMap();
        additionalLrs.put(lrName, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)100L, (long)1L));
        try {
            TezCommonUtils.addAdditionalLocalResources((Map)additionalLrs, (Map)originalLrs, (String)"");
            Assert.fail((String)"Duplicate LRs with different sizes expected to fail");
        }
        catch (TezUncheckedException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Duplicate Resources found with different size"));
        }
        originalLrs = Maps.newHashMap();
        originalLrs.put(lrName, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        additionalLrs = Maps.newHashMap();
        additionalLrs.put(lrName, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test2"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)100L));
        TezCommonUtils.addAdditionalLocalResources((Map)additionalLrs, (Map)originalLrs, (String)"");
        originalLrs = Maps.newHashMap();
        originalLrs.put(lrName, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        additionalLrs = Maps.newHashMap();
        additionalLrs.put(lrName, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test2"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)100L, (long)1L));
        try {
            TezCommonUtils.addAdditionalLocalResources((Map)additionalLrs, (Map)originalLrs, (String)"");
            Assert.fail((String)"Duplicate LRs with different sizes expected to fail");
        }
        catch (TezUncheckedException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Duplicate Resources found with different size"));
        }
    }

    @Test(timeout=5000L)
    public void testAMClientHeartBeatTimeout() {
        TezConfiguration conf = new TezConfiguration(false);
        Assert.assertEquals((long)-1L, (long)TezCommonUtils.getAMClientHeartBeatTimeoutMillis((Configuration)conf));
        conf.setInt("tez.am.client.heartbeat.timeout.secs", -2);
        Assert.assertEquals((long)-1L, (long)TezCommonUtils.getAMClientHeartBeatTimeoutMillis((Configuration)conf));
        conf.setInt("tez.am.client.heartbeat.timeout.secs", 9);
        Assert.assertEquals((long)10000L, (long)TezCommonUtils.getAMClientHeartBeatTimeoutMillis((Configuration)conf));
        conf.setInt("tez.am.client.heartbeat.timeout.secs", 20);
        Assert.assertEquals((long)20000L, (long)TezCommonUtils.getAMClientHeartBeatTimeoutMillis((Configuration)conf));
        conf = new TezConfiguration(false);
        Assert.assertEquals((long)-1L, (long)TezCommonUtils.getAMClientHeartBeatPollIntervalMillis((Configuration)conf, (long)-1L, (int)10));
        Assert.assertEquals((long)-1L, (long)TezCommonUtils.getAMClientHeartBeatPollIntervalMillis((Configuration)conf, (long)-123L, (int)10));
        Assert.assertEquals((long)-1L, (long)TezCommonUtils.getAMClientHeartBeatPollIntervalMillis((Configuration)conf, (long)0L, (int)10));
        Assert.assertEquals((long)1000L, (long)TezCommonUtils.getAMClientHeartBeatPollIntervalMillis((Configuration)conf, (long)600L, (int)10));
        Assert.assertEquals((long)2000L, (long)TezCommonUtils.getAMClientHeartBeatPollIntervalMillis((Configuration)conf, (long)20000L, (int)10));
        conf.setInt("tez.am.client.heartbeat.poll.interval.millis", -1);
        Assert.assertEquals((long)4000L, (long)TezCommonUtils.getAMClientHeartBeatPollIntervalMillis((Configuration)conf, (long)20000L, (int)5));
        conf.setInt("tez.am.client.heartbeat.poll.interval.millis", 2000);
        Assert.assertEquals((long)2000L, (long)TezCommonUtils.getAMClientHeartBeatPollIntervalMillis((Configuration)conf, (long)20000L, (int)5));
    }

    @Test
    public void testLogSystemProperties() throws Exception {
        Configuration conf = new Configuration();
        conf.set("tez.tez.jvm.system-properties-to-log", " ");
        String value = TezCommonUtils.getSystemPropertiesToLog((Configuration)conf);
        for (String key : TezConfiguration.TEZ_JVM_SYSTEM_PROPERTIES_TO_LOG_DEFAULT) {
            Assert.assertTrue((boolean)value.contains(key));
        }
        String classpath = "java.class.path";
        String os = "os.name";
        String version = "java.version";
        conf.set("tez.tez.jvm.system-properties-to-log", classpath + ", " + os);
        value = TezCommonUtils.getSystemPropertiesToLog((Configuration)conf);
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)value.contains(classpath));
        Assert.assertTrue((boolean)value.contains(os));
        Assert.assertFalse((boolean)value.contains(version));
    }

    @Test(timeout=5000L)
    public void testGetDAGSessionTimeout() {
        Configuration conf = new Configuration(false);
        Assert.assertEquals((long)300000L, (long)TezCommonUtils.getDAGSessionTimeout((Configuration)conf));
        conf.setInt("tez.session.am.dag.submit.timeout.secs", 2592000);
        Assert.assertEquals((long)2592000000L, (long)TezCommonUtils.getDAGSessionTimeout((Configuration)conf));
        conf.setInt("tez.session.am.dag.submit.timeout.secs", -2592000);
        Assert.assertEquals((long)-1L, (long)TezCommonUtils.getDAGSessionTimeout((Configuration)conf));
        conf.setInt("tez.session.am.dag.submit.timeout.secs", 0);
        Assert.assertEquals((long)1000L, (long)TezCommonUtils.getDAGSessionTimeout((Configuration)conf));
    }

    @Test
    public void testMkDirForAM() throws IOException {
        Configuration remoteConf = new Configuration();
        remoteConf.set("hdfs.minidfs.basedir", TEST_ROOT_DIR);
        remoteConf.set("fs.permissions.umask-mode", "777");
        MiniDFSCluster miniDFS = new MiniDFSCluster.Builder(remoteConf).numDataNodes(3).format(true).racks(null).build();
        DistributedFileSystem remoteFileSystem = miniDFS.getFileSystem();
        Path path = new Path(TEST_ROOT_DIR + "/testMkDirForAM");
        TezCommonUtils.mkDirForAM((FileSystem)remoteFileSystem, (Path)path);
        Assert.assertEquals((Object)TezCommonUtils.TEZ_AM_DIR_PERMISSION, (Object)remoteFileSystem.getFileStatus(path).getPermission());
        miniDFS.shutdown();
    }

    static {
        conf = new Configuration();
        TEST_ROOT_DIR = "target/" + TestTezCommonUtils.class.getName() + "-tmpDir";
        dfsCluster = null;
        remoteFs = null;
        LOG = LoggerFactory.getLogger(TestTezCommonUtils.class);
    }
}

