/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client.registry.zookeeper;

import com.fasterxml.jackson.core.JsonParseException;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.tez.client.registry.AMRecord;
import org.apache.tez.client.registry.AMRegistryClient;
import org.apache.tez.client.registry.AMRegistryClientListener;
import org.apache.tez.client.registry.zookeeper.ZkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class ZkAMRegistryClient
extends AMRegistryClient {
    private static final Logger LOG = LoggerFactory.getLogger(ZkAMRegistryClient.class);
    private final Configuration conf;
    private ConcurrentHashMap<String, AMRecord> amRecordCache = new ConcurrentHashMap();
    private CuratorFramework client;
    private static Map<String, ZkAMRegistryClient> INSTANCES = new HashMap<String, ZkAMRegistryClient>();

    public static synchronized ZkAMRegistryClient getClient(Configuration conf) throws Exception {
        String namespace = conf.get("tez.am.registry.namespace");
        ZkAMRegistryClient registry = INSTANCES.get(namespace);
        if (registry == null) {
            registry = new ZkAMRegistryClient(conf);
            registry.start();
            INSTANCES.put(namespace, registry);
        }
        LOG.info("Returning tez AM registry ({}) for namespace '{}'", (Object)System.identityHashCode(registry), (Object)namespace);
        return registry;
    }

    private ZkAMRegistryClient(Configuration conf) {
        this.conf = conf;
    }

    private void start() throws Exception {
        ZkConfig zkConf = new ZkConfig(this.conf);
        this.client = zkConf.createCuratorFramework();
        TreeCache cache = new TreeCache(this.client, zkConf.getZkNamespace());
        this.client.start();
        cache.start();
        cache.getListenable().addListener((Object)new ZkRegistryListener());
    }

    public static AMRecord getAMRecord(ChildData childData) throws IOException {
        if (!childData.getPath().contains("application")) {
            return null;
        }
        byte[] data = childData.getData();
        if (data.length == 0) {
            return null;
        }
        String value = new String(data);
        try {
            RegistryUtils.ServiceRecordMarshal marshal = new RegistryUtils.ServiceRecordMarshal();
            ServiceRecord serviceRecord = (ServiceRecord)marshal.fromJson(value);
            return new AMRecord(serviceRecord);
        }
        catch (JsonParseException e) {
            LOG.warn("Non-json data received while de-serializing AMRecord: {}. Ignoring..", (Object)value);
            return null;
        }
    }

    @Override
    public AMRecord getRecord(String appId) {
        if (this.amRecordCache.get(appId) == null) {
            return null;
        }
        return new AMRecord(this.amRecordCache.get(appId));
    }

    @Override
    public List<AMRecord> getAllRecords() {
        return this.amRecordCache.values().stream().map(record -> new AMRecord((AMRecord)record)).collect(Collectors.toList());
    }

    @Override
    public synchronized void addListener(AMRegistryClientListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void close() {
        this.client.close();
    }

    private class ZkRegistryListener
    implements TreeCacheListener {
        private ZkRegistryListener() {
        }

        public void childEvent(CuratorFramework client, TreeCacheEvent event) throws Exception {
            Preconditions.checkArgument((client != null && client.getState() == CuratorFrameworkState.STARTED ? 1 : 0) != 0, (Object)"Curator client is not started");
            ChildData childData = event.getData();
            switch (event.getType()) {
                case NODE_ADDED: {
                    if (this.isEmpty(childData)) {
                        LOG.info("AppId allocated: {}", (Object)childData.getPath());
                        break;
                    }
                    AMRecord amRecord = ZkAMRegistryClient.getAMRecord(childData);
                    if (amRecord == null) break;
                    LOG.info("AM registered with data: {}. Notifying {} listeners.", (Object)amRecord, (Object)ZkAMRegistryClient.this.listeners.size());
                    ZkAMRegistryClient.this.amRecordCache.put(amRecord.getApplicationId().toString(), amRecord);
                    ZkAMRegistryClient.this.notifyOnAdded(amRecord);
                    break;
                }
                case NODE_UPDATED: {
                    if (this.isEmpty(childData)) {
                        throw new RuntimeException("AM updated with empty data");
                    }
                    AMRecord amRecord = ZkAMRegistryClient.getAMRecord(childData);
                    if (amRecord == null) break;
                    LOG.info("AM updated data: {}. Notifying {} listeners.", (Object)amRecord, (Object)ZkAMRegistryClient.this.listeners.size());
                    ZkAMRegistryClient.this.amRecordCache.put(amRecord.getApplicationId().toString(), amRecord);
                    ZkAMRegistryClient.this.notifyOnAdded(amRecord);
                    break;
                }
                case NODE_REMOVED: {
                    if (this.isEmpty(childData)) {
                        LOG.info("Unused AppId unregistered: {}", (Object)childData.getPath());
                        break;
                    }
                    AMRecord amRecord = ZkAMRegistryClient.getAMRecord(childData);
                    if (amRecord == null) break;
                    LOG.info("AM removed: {}. Notifying {} listeners.", (Object)amRecord, (Object)ZkAMRegistryClient.this.listeners.size());
                    ZkAMRegistryClient.this.amRecordCache.remove(amRecord.getApplicationId().toString(), amRecord);
                    ZkAMRegistryClient.this.notifyOnRemoved(amRecord);
                    break;
                }
                default: {
                    if (childData == null) {
                        LOG.info("Ignored event {}", (Object)event.getType());
                        break;
                    }
                    LOG.info("Ignored event {} for {}", (Object)event.getType(), (Object)childData.getPath());
                }
            }
        }

        private boolean isEmpty(ChildData childData) {
            return childData == null || childData.getData() == null || childData.getData().length == 0;
        }
    }
}

