/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.tez.common.security.DAGAccessControls;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.GroupInputEdge;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.VertexGroup;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.VertexManagerPluginDescriptor;
import org.apache.tez.dag.api.records.DAGProtos;
import org.junit.Assert;
import org.junit.Test;

public class TestDAGVerify {
    private final String dummyProcessorClassName = TestDAGVerify.class.getName();
    private final String dummyInputClassName = TestDAGVerify.class.getName();
    private final String dummyInputInitClassName = TestDAGVerify.class.getName();
    private final String dummyOutputClassName = TestDAGVerify.class.getName();
    private final String dummyVMPluginClassName = TestDAGVerify.class.getName();
    private final int dummyTaskCount = 2;
    private final Resource dummyTaskResource = Resource.newInstance((int)1, (int)1);

    @Test(timeout=5000L)
    public void testVerifyScatterGather() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName), (int)2, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        Edge e1 = Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)this.dummyOutputClassName), (InputDescriptor)InputDescriptor.create((String)this.dummyInputClassName)));
        DAG dag = DAG.create((String)"DAG-testVerifyScatterGather");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addEdge(e1);
        dag.verify();
    }

    @Test(timeout=5000L)
    public void testVerifyCustomEdge() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName), (int)2, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        Edge e1 = Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeManagerPluginDescriptor)EdgeManagerPluginDescriptor.create((String)"emClass"), (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)this.dummyOutputClassName), (InputDescriptor)InputDescriptor.create((String)this.dummyInputClassName)));
        DAG dag = DAG.create((String)"DAG-testVerifyCustomEdge");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addEdge(e1);
        dag.verify();
    }

    @Test(timeout=5000L)
    public void testVerifyOneToOne() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName), (int)2, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        Edge e1 = Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)this.dummyOutputClassName), (InputDescriptor)InputDescriptor.create((String)this.dummyInputClassName)));
        DAG dag = DAG.create((String)"DAG-testVerifyOneToOne");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addEdge(e1);
        dag.verify();
    }

    @Test(timeout=5000L)
    public void testVerifyOneToOneInferParallelism() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName), (int)2, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)-1, (Resource)this.dummyTaskResource);
        Vertex v3 = Vertex.create((String)"v3", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)-1, (Resource)this.dummyTaskResource);
        Edge e1 = Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)this.dummyOutputClassName), (InputDescriptor)InputDescriptor.create((String)this.dummyInputClassName)));
        Edge e2 = Edge.create((Vertex)v2, (Vertex)v3, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)this.dummyOutputClassName), (InputDescriptor)InputDescriptor.create((String)this.dummyInputClassName)));
        DAG dag = DAG.create((String)"DAG-testVerifyOneToOneInferParallelism");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addVertex(v3);
        dag.addEdge(e1);
        dag.addEdge(e2);
        dag.verify();
        Assert.assertEquals((long)2L, (long)v2.getParallelism());
        Assert.assertEquals((long)2L, (long)v3.getParallelism());
    }

    @Test(timeout=5000L)
    public void testVerifyOneToOneInferParallelismReverseOrder() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName), (int)2, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)-1, (Resource)this.dummyTaskResource);
        Vertex v3 = Vertex.create((String)"v3", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)-1, (Resource)this.dummyTaskResource);
        Edge e1 = Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)this.dummyOutputClassName), (InputDescriptor)InputDescriptor.create((String)this.dummyInputClassName)));
        Edge e2 = Edge.create((Vertex)v2, (Vertex)v3, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)this.dummyOutputClassName), (InputDescriptor)InputDescriptor.create((String)this.dummyInputClassName)));
        DAG dag = DAG.create((String)"DAG-testVerifyOneToOneInferParallelismReverseOrder");
        dag.addVertex(v3);
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addEdge(e2);
        dag.addEdge(e1);
        dag.verify();
        Assert.assertEquals((long)2L, (long)v2.getParallelism());
        Assert.assertEquals((long)2L, (long)v3.getParallelism());
    }

    @Test(timeout=5000L)
    public void testVerifyOneToOneNoInferParallelism() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName), (int)-1, (Resource)this.dummyTaskResource);
        DataSourceDescriptor dsDesc = DataSourceDescriptor.create((InputDescriptor)InputDescriptor.create((String)this.dummyInputClassName), (InputInitializerDescriptor)InputInitializerDescriptor.create((String)this.dummyInputInitClassName), null);
        v1.addDataSource("input_1", dsDesc);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)-1, (Resource)this.dummyTaskResource);
        Edge e1 = Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)this.dummyOutputClassName), (InputDescriptor)InputDescriptor.create((String)this.dummyInputClassName)));
        DAG dag = DAG.create((String)"DAG-testVerifyOneToOneNoInferParallelism");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addEdge(e1);
        dag.verify();
        Assert.assertEquals((long)-1L, (long)v2.getParallelism());
    }

    @Test(timeout=5000L)
    public void testVerifyOneToOneIncorrectParallelism1() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName), (int)-1, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName), (int)2, (Resource)this.dummyTaskResource);
        Vertex v3 = Vertex.create((String)"v3", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)-1, (Resource)this.dummyTaskResource);
        Edge e1 = Edge.create((Vertex)v1, (Vertex)v3, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)this.dummyOutputClassName), (InputDescriptor)InputDescriptor.create((String)this.dummyInputClassName)));
        Edge e2 = Edge.create((Vertex)v2, (Vertex)v3, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)this.dummyOutputClassName), (InputDescriptor)InputDescriptor.create((String)this.dummyInputClassName)));
        DAG dag = DAG.create((String)"DAG-testVerifyOneToOneIncorrectParallelism1");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addVertex(v3);
        dag.addEdge(e1);
        dag.addEdge(e2);
        try {
            dag.verify();
            Assert.assertTrue((boolean)false);
        }
        catch (TezUncheckedException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("1-1 Edge. Destination vertex parallelism must match source vertex"));
        }
    }

    @Test(timeout=5000L)
    public void testVerifyOneToOneIncorrectParallelism2() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName), (int)-1, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName), (int)2, (Resource)this.dummyTaskResource);
        Vertex v3 = Vertex.create((String)"v3", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName), (int)-1, (Resource)this.dummyTaskResource);
        Vertex v4 = Vertex.create((String)"v4", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName), (int)-1, (Resource)this.dummyTaskResource);
        Edge e1 = Edge.create((Vertex)v1, (Vertex)v4, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)this.dummyOutputClassName), (InputDescriptor)InputDescriptor.create((String)this.dummyInputClassName)));
        Edge e2 = Edge.create((Vertex)v2, (Vertex)v4, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)this.dummyOutputClassName), (InputDescriptor)InputDescriptor.create((String)this.dummyInputClassName)));
        Edge e3 = Edge.create((Vertex)v3, (Vertex)v4, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)this.dummyOutputClassName), (InputDescriptor)InputDescriptor.create((String)this.dummyInputClassName)));
        DAG dag = DAG.create((String)"DAG-testVerifyOneToOneIncorrectParallelism2");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addVertex(v3);
        dag.addVertex(v4);
        dag.addEdge(e1);
        dag.addEdge(e2);
        dag.addEdge(e3);
        try {
            dag.verify();
            Assert.fail();
        }
        catch (TezUncheckedException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("1-1 Edge. Destination vertex parallelism must match source vertex"));
        }
    }

    @Test(timeout=5000L)
    public void testVerifyBroadcast() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName), (int)2, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        Edge e1 = Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.BROADCAST, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)this.dummyOutputClassName), (InputDescriptor)InputDescriptor.create((String)this.dummyInputClassName)));
        DAG dag = DAG.create((String)"DAG-testVerifyBroadcast");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addEdge(e1);
        dag.verify();
    }

    @Test(timeout=5000L)
    public void testVerify3() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName), (int)2, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        Edge e1 = Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.EPHEMERAL, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)this.dummyOutputClassName), (InputDescriptor)InputDescriptor.create((String)this.dummyInputClassName)));
        DAG dag = DAG.create((String)"DAG-testVerify3");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addEdge(e1);
        dag.verify();
    }

    @Test(timeout=5000L)
    public void testVerify4() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName), (int)2, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        Edge e1 = Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.EPHEMERAL, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.CONCURRENT, (OutputDescriptor)OutputDescriptor.create((String)this.dummyOutputClassName), (InputDescriptor)InputDescriptor.create((String)this.dummyInputClassName)));
        DAG dag = DAG.create((String)"DAG-testVerify4");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addEdge(e1);
        dag.verify();
    }

    @Test(timeout=5000L)
    public void testCycle1() {
        IllegalStateException ex = null;
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v3 = Vertex.create((String)"v3", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v4 = Vertex.create((String)"v4", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        Edge e1 = Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"dummy output class"), (InputDescriptor)InputDescriptor.create((String)"dummy input class")));
        Edge e2 = Edge.create((Vertex)v2, (Vertex)v3, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"dummy output class"), (InputDescriptor)InputDescriptor.create((String)"dummy input class")));
        Edge e3 = Edge.create((Vertex)v2, (Vertex)v4, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"dummy output class"), (InputDescriptor)InputDescriptor.create((String)"dummy input class")));
        Edge e4 = Edge.create((Vertex)v4, (Vertex)v1, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"dummy output class"), (InputDescriptor)InputDescriptor.create((String)"dummy input class")));
        DAG dag = DAG.create((String)"DAG-testCycle1");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addVertex(v3);
        dag.addVertex(v4);
        dag.addEdge(e1);
        dag.addEdge(e2);
        dag.addEdge(e3);
        dag.addEdge(e4);
        try {
            dag.verify();
        }
        catch (IllegalStateException e) {
            ex = e;
        }
        Assert.assertNotNull((Object)ex);
        System.out.println(ex.getMessage());
        Assert.assertTrue((boolean)ex.getMessage().startsWith("DAG contains a cycle"));
    }

    @Test(timeout=5000L)
    public void testCycle2() {
        IllegalStateException ex = null;
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v3 = Vertex.create((String)"v3", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v4 = Vertex.create((String)"v4", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        Edge e1 = Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"dummy output class"), (InputDescriptor)InputDescriptor.create((String)"dummy input class")));
        Edge e2 = Edge.create((Vertex)v2, (Vertex)v3, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"dummy output class"), (InputDescriptor)InputDescriptor.create((String)"dummy input class")));
        Edge e3 = Edge.create((Vertex)v2, (Vertex)v4, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"dummy output class"), (InputDescriptor)InputDescriptor.create((String)"dummy input class")));
        Edge e4 = Edge.create((Vertex)v3, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"dummy output class"), (InputDescriptor)InputDescriptor.create((String)"dummy input class")));
        DAG dag = DAG.create((String)"DAG-testCycle2");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addVertex(v3);
        dag.addVertex(v4);
        dag.addEdge(e1);
        dag.addEdge(e2);
        dag.addEdge(e3);
        dag.addEdge(e4);
        try {
            dag.verify();
        }
        catch (IllegalStateException e) {
            ex = e;
        }
        Assert.assertNotNull((Object)ex);
        System.out.println(ex.getMessage());
        Assert.assertTrue((boolean)ex.getMessage().startsWith("DAG contains a cycle"));
    }

    @Test(timeout=5000L)
    public void testSelfCycle() {
        IllegalStateException ex = null;
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        Edge e1 = Edge.create((Vertex)v1, (Vertex)v1, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"dummy output class"), (InputDescriptor)InputDescriptor.create((String)"dummy input class")));
        DAG dag = DAG.create((String)"DAG-testSelfCycle");
        dag.addVertex(v1);
        dag.addEdge(e1);
        try {
            dag.verify();
        }
        catch (IllegalStateException e) {
            ex = e;
        }
        Assert.assertNotNull((Object)ex);
        System.out.println(ex.getMessage());
        Assert.assertTrue((boolean)ex.getMessage().startsWith("DAG contains a self-cycle"));
    }

    @Test(timeout=5000L)
    public void repeatedVertexName() {
        IllegalStateException ex = null;
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v1repeat = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        try {
            DAG dag = DAG.create((String)"DAG-repeatedVertexName");
            dag.addVertex(v1);
            dag.addVertex(v1repeat);
            dag.verify();
        }
        catch (IllegalStateException e) {
            ex = e;
        }
        Assert.assertNotNull((Object)ex);
        System.out.println(ex.getMessage());
        Assert.assertTrue((boolean)ex.getMessage().startsWith("Vertex v1 already defined"));
    }

    @Test(expected=IllegalStateException.class, timeout=5000L)
    public void testInputAndInputVertexNameCollision() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        v2.addDataSource("v1", DataSourceDescriptor.create(null, null, null));
        Edge e1 = Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"dummy output class"), (InputDescriptor)InputDescriptor.create((String)"dummy input class")));
        DAG dag = DAG.create((String)"DAG-testInputAndInputVertexNameCollision");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addEdge(e1);
        dag.verify();
    }

    @Test(expected=IllegalStateException.class, timeout=5000L)
    public void testOutputAndOutputVertexNameCollision() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        v1.addDataSink("v2", DataSinkDescriptor.create(null, null, null));
        Edge e1 = Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"dummy output class"), (InputDescriptor)InputDescriptor.create((String)"dummy input class")));
        DAG dag = DAG.create((String)"DAG-testOutputAndOutputVertexNameCollision");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addEdge(e1);
        dag.verify();
    }

    @Test(expected=IllegalStateException.class, timeout=5000L)
    public void testOutputAndVertexNameCollision() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        v1.addDataSink("v2", DataSinkDescriptor.create(null, null, null));
        DAG dag = DAG.create((String)"DAG-testOutputAndVertexNameCollision");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.verify();
    }

    @Test(expected=IllegalStateException.class, timeout=5000L)
    public void testInputAndVertexNameCollision() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        v1.addDataSource("v2", DataSourceDescriptor.create(null, null, null));
        DAG dag = DAG.create((String)"DAG-testInputAndVertexNameCollision");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.verify();
    }

    @Test(timeout=5000L)
    public void BinaryInputAllowed() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v3 = Vertex.create((String)"v3", (ProcessorDescriptor)ProcessorDescriptor.create((String)"ReduceProcessor"), (int)2, (Resource)this.dummyTaskResource);
        Edge e1 = Edge.create((Vertex)v1, (Vertex)v3, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"dummy output class"), (InputDescriptor)InputDescriptor.create((String)"dummy input class")));
        Edge e2 = Edge.create((Vertex)v2, (Vertex)v3, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"dummy output class"), (InputDescriptor)InputDescriptor.create((String)"dummy input class")));
        DAG dag = DAG.create((String)"DAG-BinaryInputAllowed");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addVertex(v3);
        dag.addEdge(e1);
        dag.addEdge(e2);
        dag.verify();
    }

    @Test(timeout=5000L)
    public void testVertexGroupWithMultipleOutputEdges() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v3 = Vertex.create((String)"v3", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v4 = Vertex.create((String)"v4", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)2, (Resource)this.dummyTaskResource);
        DAG dag = DAG.create((String)"DAG-testVertexGroupWithMultipleOutputEdges");
        VertexGroup uv12 = dag.createVertexGroup("uv12", new Vertex[]{v1, v2});
        OutputDescriptor outDesc = new OutputDescriptor();
        uv12.addDataSink("uvOut", DataSinkDescriptor.create((OutputDescriptor)outDesc, null, null));
        GroupInputEdge e1 = GroupInputEdge.create((VertexGroup)uv12, (Vertex)v3, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"dummy output class"), (InputDescriptor)InputDescriptor.create((String)"dummy input class")), (InputDescriptor)InputDescriptor.create((String)"dummy input class"));
        GroupInputEdge e2 = GroupInputEdge.create((VertexGroup)uv12, (Vertex)v4, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"dummy output class"), (InputDescriptor)InputDescriptor.create((String)"dummy input class")), (InputDescriptor)InputDescriptor.create((String)"dummy input class"));
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addVertex(v3);
        dag.addVertex(v4);
        dag.addEdge(e1);
        dag.addEdge(e2);
        dag.verify();
        for (int i = 0; i < 10; ++i) {
            dag.verify();
        }
        Assert.assertEquals((long)2L, (long)v1.getOutputVertices().size());
        Assert.assertEquals((long)2L, (long)v2.getOutputVertices().size());
        Assert.assertTrue((boolean)v1.getOutputVertices().contains(v3));
        Assert.assertTrue((boolean)v1.getOutputVertices().contains(v4));
        Assert.assertTrue((boolean)v2.getOutputVertices().contains(v3));
        Assert.assertTrue((boolean)v2.getOutputVertices().contains(v4));
    }

    @Test(timeout=5000L)
    public void testVertexGroup() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v3 = Vertex.create((String)"v3", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v4 = Vertex.create((String)"v4", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v5 = Vertex.create((String)"v5", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)2, (Resource)this.dummyTaskResource);
        DAG dag = DAG.create((String)"DAG-testVertexGroup");
        String groupName1 = "uv12";
        VertexGroup uv12 = dag.createVertexGroup(groupName1, new Vertex[]{v1, v2});
        OutputDescriptor outDesc = new OutputDescriptor();
        uv12.addDataSink("uvOut", DataSinkDescriptor.create((OutputDescriptor)outDesc, null, null));
        String groupName2 = "uv23";
        VertexGroup uv23 = dag.createVertexGroup(groupName2, new Vertex[]{v2, v3});
        GroupInputEdge e1 = GroupInputEdge.create((VertexGroup)uv12, (Vertex)v4, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"dummy output class"), (InputDescriptor)InputDescriptor.create((String)"dummy input class")), (InputDescriptor)InputDescriptor.create((String)"dummy input class"));
        GroupInputEdge e2 = GroupInputEdge.create((VertexGroup)uv23, (Vertex)v5, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"dummy output class"), (InputDescriptor)InputDescriptor.create((String)"dummy input class")), (InputDescriptor)InputDescriptor.create((String)"dummy input class"));
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addVertex(v3);
        dag.addVertex(v4);
        dag.addVertex(v5);
        dag.addEdge(e1);
        dag.addEdge(e2);
        for (int i = 0; i < 10; ++i) {
            dag.verify();
        }
        Assert.assertNull((Object)dag.getVertex(uv12.getGroupName()));
        Assert.assertNull((Object)dag.getVertex(uv23.getGroupName()));
        Assert.assertFalse((boolean)dag.edges.contains(e1));
        Assert.assertFalse((boolean)dag.edges.contains(e2));
        Assert.assertEquals((long)1L, (long)v1.getOutputs().size());
        Assert.assertEquals((long)1L, (long)v2.getOutputs().size());
        Assert.assertEquals((Object)outDesc, (Object)((RootInputLeafOutput)v1.getOutputs().get(0)).getIODescriptor());
        Assert.assertEquals((Object)outDesc, (Object)((RootInputLeafOutput)v2.getOutputs().get(0)).getIODescriptor());
        Assert.assertEquals((long)1L, (long)v1.getOutputVertices().size());
        Assert.assertEquals((long)1L, (long)v3.getOutputVertices().size());
        Assert.assertEquals((long)2L, (long)v2.getOutputVertices().size());
        Assert.assertTrue((boolean)v1.getOutputVertices().contains(v4));
        Assert.assertTrue((boolean)v3.getOutputVertices().contains(v5));
        Assert.assertTrue((boolean)v2.getOutputVertices().contains(v4));
        Assert.assertTrue((boolean)v2.getOutputVertices().contains(v5));
        Assert.assertEquals((long)2L, (long)v4.getInputVertices().size());
        Assert.assertTrue((boolean)v4.getInputVertices().contains(v1));
        Assert.assertTrue((boolean)v4.getInputVertices().contains(v2));
        Assert.assertEquals((long)2L, (long)v5.getInputVertices().size());
        Assert.assertTrue((boolean)v5.getInputVertices().contains(v2));
        Assert.assertTrue((boolean)v5.getInputVertices().contains(v3));
        Assert.assertEquals((long)1L, (long)v4.getGroupInputs().size());
        Assert.assertTrue((boolean)v4.getGroupInputs().containsKey(groupName1));
        Assert.assertEquals((long)1L, (long)v5.getGroupInputs().size());
        Assert.assertTrue((boolean)v5.getGroupInputs().containsKey(groupName2));
        Assert.assertEquals((long)2L, (long)dag.vertexGroups.size());
    }

    @Test(timeout=5000L)
    public void testVertexGroupOneToOne() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v3 = Vertex.create((String)"v3", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v4 = Vertex.create((String)"v4", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v5 = Vertex.create((String)"v5", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)-1, (Resource)this.dummyTaskResource);
        DAG dag = DAG.create((String)"DAG-testVertexGroupOneToOne");
        String groupName1 = "uv12";
        VertexGroup uv12 = dag.createVertexGroup(groupName1, new Vertex[]{v1, v2});
        OutputDescriptor outDesc = new OutputDescriptor();
        uv12.addDataSink("uvOut", DataSinkDescriptor.create((OutputDescriptor)outDesc, null, null));
        String groupName2 = "uv23";
        VertexGroup uv23 = dag.createVertexGroup(groupName2, new Vertex[]{v2, v3});
        GroupInputEdge e1 = GroupInputEdge.create((VertexGroup)uv12, (Vertex)v4, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"dummy output class"), (InputDescriptor)InputDescriptor.create((String)"dummy input class")), (InputDescriptor)InputDescriptor.create((String)"dummy input class"));
        GroupInputEdge e2 = GroupInputEdge.create((VertexGroup)uv23, (Vertex)v5, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"dummy output class"), (InputDescriptor)InputDescriptor.create((String)"dummy input class")), (InputDescriptor)InputDescriptor.create((String)"dummy input class"));
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addVertex(v3);
        dag.addVertex(v4);
        dag.addVertex(v5);
        dag.addEdge(e1);
        dag.addEdge(e2);
        for (int i = 0; i < 10; ++i) {
            dag.verify();
        }
        Assert.assertEquals((long)2L, (long)v5.getParallelism());
    }

    @Test(timeout=5000L)
    public void BinaryOutput() {
        IllegalStateException ex = null;
        try {
            Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
            Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
            Vertex v3 = Vertex.create((String)"v3", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)2, (Resource)this.dummyTaskResource);
            Edge e1 = Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"dummy output class"), (InputDescriptor)InputDescriptor.create((String)"dummy input class")));
            Edge e2 = Edge.create((Vertex)v1, (Vertex)v3, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"dummy output class"), (InputDescriptor)InputDescriptor.create((String)"dummy input class")));
            DAG dag = DAG.create((String)"DAG-BinaryOutput");
            dag.addVertex(v1);
            dag.addVertex(v2);
            dag.addVertex(v3);
            dag.addEdge(e1);
            dag.addEdge(e2);
            dag.verify();
        }
        catch (IllegalStateException e) {
            ex = e;
        }
        Assert.assertNull((Object)ex);
    }

    @Test(timeout=5000L)
    public void testDagWithNoVertices() {
        IllegalStateException ex = null;
        try {
            DAG dag = DAG.create((String)"DAG-testDagWithNoVertices");
            dag.verify();
        }
        catch (IllegalStateException e) {
            ex = e;
        }
        Assert.assertNotNull((Object)ex);
        System.out.println(ex.getMessage());
        Assert.assertTrue((boolean)ex.getMessage().startsWith("Invalid dag containing 0 vertices"));
    }

    @Test(timeout=5000L)
    public void testInvalidVertexConstruction() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)0, (Resource)this.dummyTaskResource);
        Vertex vertex = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)-1, (Resource)this.dummyTaskResource);
        try {
            v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)-2, (Resource)this.dummyTaskResource);
            Assert.fail((String)"Expected exception for 0 parallelism");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Parallelism should be -1 if determined by the AM, otherwise should be >= 0"));
        }
        try {
            v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"MapProcessor"), (int)1, null);
            Assert.fail((String)"Expected exception for 0 parallelism");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Resource cannot be null"));
        }
    }

    @Test(timeout=5000L)
    public void testMultipleRootInputsAllowed() {
        DAG dag = DAG.create((String)"DAG-testMultipleRootInputsAllowed");
        ProcessorDescriptor pd1 = (ProcessorDescriptor)ProcessorDescriptor.create((String)"processor1").setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap("processor1Bytes".getBytes())));
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)pd1, (int)10, (Resource)Resource.newInstance((int)1024, (int)1));
        VertexManagerPluginDescriptor vertexManagerPluginDescriptor = VertexManagerPluginDescriptor.create((String)"TestVertexManager");
        v1.setVertexManagerPlugin(vertexManagerPluginDescriptor);
        InputDescriptor inputDescriptor1 = (InputDescriptor)InputDescriptor.create((String)"input1").setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap("inputBytes".getBytes())));
        InputDescriptor inputDescriptor2 = (InputDescriptor)InputDescriptor.create((String)"input2").setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap("inputBytes".getBytes())));
        v1.addDataSource("input1", DataSourceDescriptor.create((InputDescriptor)inputDescriptor1, null, null));
        v1.addDataSource("input2", DataSourceDescriptor.create((InputDescriptor)inputDescriptor2, null, null));
        dag.addVertex(v1);
        dag.createDag((Configuration)new TezConfiguration(), null, null, null, true);
    }

    @Test(timeout=5000L)
    public void testDAGCreateDataInference() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName));
        HashMap lrs1 = Maps.newHashMap();
        String lrName1 = "LR1";
        lrs1.put(lrName1, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        HashMap lrs2 = Maps.newHashMap();
        String lrName2 = "LR2";
        lrs2.put(lrName2, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test1"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        HashSet hosts = Sets.newHashSet();
        hosts.add("h1");
        hosts.add("h2");
        LinkedList taskLocationHints = Lists.newLinkedList();
        taskLocationHints.add(TaskLocationHint.createTaskLocationHint((Set)hosts, null));
        taskLocationHints.add(TaskLocationHint.createTaskLocationHint((Set)hosts, null));
        VertexLocationHint vLoc = VertexLocationHint.create((List)taskLocationHints);
        DataSourceDescriptor ds = DataSourceDescriptor.create((InputDescriptor)InputDescriptor.create((String)"I.class"), (InputInitializerDescriptor)InputInitializerDescriptor.create((String)this.dummyInputInitClassName), (int)2, null, (VertexLocationHint)vLoc, (Map)lrs2);
        v1.addDataSource("i1", ds);
        DAG dag = DAG.create((String)"DAG-testDAGCreateDataInference");
        dag.addVertex(v1);
        dag.addTaskLocalFiles((Map)lrs1);
        DAGProtos.DAGPlan dagPlan = dag.createDag((Configuration)new TezConfiguration(), null, null, null, true);
        Assert.assertEquals((Object)lrName1, (Object)dagPlan.getLocalResource(0).getName());
        DAGProtos.VertexPlan vPlan = dagPlan.getVertex(0);
        DAGProtos.PlanTaskConfiguration taskPlan = vPlan.getTaskConfig();
        Assert.assertEquals((long)2L, (long)taskPlan.getNumTasks());
        Assert.assertEquals((long)1024L, (long)taskPlan.getMemoryMb());
        Assert.assertEquals((Object)lrName2, (Object)taskPlan.getLocalResource(0).getName());
        Assert.assertEquals((long)2L, (long)vPlan.getTaskLocationHintCount());
    }

    @Test(timeout=5000L)
    public void testInferredFilesFail() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName), (int)2, (Resource)this.dummyTaskResource);
        HashMap lrs = Maps.newHashMap();
        String lrName1 = "LR1";
        lrs.put(lrName1, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        HashMap lrs2 = Maps.newHashMap();
        lrs2.put(lrName1, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test2"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)100L, (long)1L));
        v1.addTaskLocalFiles((Map)lrs);
        try {
            v1.addTaskLocalFiles((Map)lrs2);
            Assert.fail();
        }
        catch (TezUncheckedException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Duplicate Resources found with different size"));
        }
        DataSourceDescriptor ds = DataSourceDescriptor.create((InputDescriptor)InputDescriptor.create((String)"I.class"), null, (int)-1, null, null, (Map)lrs2);
        v1.addDataSource("i1", ds);
        DAG dag = DAG.create((String)"DAG-testInferredFilesFail");
        dag.addVertex(v1);
        dag.addTaskLocalFiles((Map)lrs);
        try {
            dag.addTaskLocalFiles((Map)lrs2);
            Assert.fail();
        }
        catch (TezUncheckedException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Duplicate Resources found with different size"));
        }
        try {
            dag.createDag((Configuration)new TezConfiguration(), null, null, null, true);
            Assert.fail();
        }
        catch (TezUncheckedException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Duplicate Resources found with different size"));
        }
    }

    @Test(timeout=5000L)
    public void testDAGAccessControls() {
        DAG dag = DAG.create((String)"DAG-testDAGAccessControls");
        ProcessorDescriptor pd1 = (ProcessorDescriptor)ProcessorDescriptor.create((String)"processor1").setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap("processor1Bytes".getBytes())));
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)pd1, (int)10, (Resource)Resource.newInstance((int)1024, (int)1));
        dag.addVertex(v1);
        DAGAccessControls dagAccessControls = new DAGAccessControls();
        dagAccessControls.setUsersWithViewACLs(Arrays.asList("u1")).setUsersWithModifyACLs(Arrays.asList("*")).setGroupsWithViewACLs(Arrays.asList("g1")).setGroupsWithModifyACLs(Arrays.asList("g2"));
        dag.setAccessControls(dagAccessControls);
        Configuration conf = new Configuration(false);
        DAGProtos.DAGPlan dagPlan = dag.createDag(conf, null, null, null, true);
        Assert.assertNull((Object)conf.get("tez.am.dag.view-acls"));
        Assert.assertNull((Object)conf.get("tez.am.dag.modify-acls"));
        DAGProtos.ACLInfo aclInfo = dagPlan.getAclInfo();
        Assert.assertEquals(Collections.singletonList("u1"), (Object)aclInfo.getUsersWithViewAccessList());
        Assert.assertEquals(Collections.singletonList("g1"), (Object)aclInfo.getGroupsWithViewAccessList());
        Assert.assertEquals(Collections.singletonList("*"), (Object)aclInfo.getUsersWithModifyAccessList());
        Assert.assertEquals(Collections.singletonList("g2"), (Object)aclInfo.getGroupsWithModifyAccessList());
    }

    @Test(timeout=5000L)
    public void testDAGInvalidParallelism1() {
        DAG dag = DAG.create((String)"DAG-testDAGInvalidParallelism1");
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName));
        dag.addVertex(v1);
        try {
            dag.verify();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"v1 has -1 tasks but does not have input initializers, 1-1 uninited sources or custom vertex manager to set it at runtime", (Object)e.getMessage());
        }
        DataSourceDescriptor dsDesc = DataSourceDescriptor.create((InputDescriptor)InputDescriptor.create((String)this.dummyInputClassName), (InputInitializerDescriptor)InputInitializerDescriptor.create((String)this.dummyInputInitClassName), null);
        v1.addDataSource("input_1", dsDesc);
        dag.verify();
    }

    @Test(timeout=5000L)
    public void testDAGInvalidParallelism2() {
        DAG dag = DAG.create((String)"DAG-testDAGInvalidParallelism2");
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName));
        dag.addVertex(v1);
        try {
            dag.verify();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"v1 has -1 tasks but does not have input initializers, 1-1 uninited sources or custom vertex manager to set it at runtime", (Object)e.getMessage());
        }
        v1.setVertexManagerPlugin(VertexManagerPluginDescriptor.create((String)this.dummyVMPluginClassName));
        dag.verify();
    }

    @Test(timeout=5000L)
    public void testDAGInvalidParallelism3() {
        DAG dag = DAG.create((String)"DAG-testDAGInvalidParallelism3");
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName));
        dag.addVertex(v1);
        try {
            dag.verify();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"v1 has -1 tasks but does not have input initializers, 1-1 uninited sources or custom vertex manager to set it at runtime", (Object)e.getMessage());
        }
        Vertex v0 = Vertex.create((String)"v0", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName));
        DataSourceDescriptor dsDesc = DataSourceDescriptor.create((InputDescriptor)InputDescriptor.create((String)this.dummyInputClassName), (InputInitializerDescriptor)InputInitializerDescriptor.create((String)this.dummyInputInitClassName), null);
        v0.addDataSource("input", dsDesc);
        dag.addVertex(v0);
        dag.addEdge(Edge.create((Vertex)v0, (Vertex)v1, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)this.dummyOutputClassName), (InputDescriptor)InputDescriptor.create((String)this.dummyInputClassName))));
        dag.verify();
    }

    @Test
    public void testDAGInvalidParallelism4() {
        DAG dag = DAG.create((String)"DAG-testDAGInvalidParallelism4");
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName));
        dag.addVertex(v1);
        try {
            dag.verify();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"v1 has -1 tasks but does not have input initializers, 1-1 uninited sources or custom vertex manager to set it at runtime", (Object)e.getMessage());
        }
        Vertex v0 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName));
        v0.setVertexManagerPlugin(VertexManagerPluginDescriptor.create((String)this.dummyVMPluginClassName));
        dag.addVertex(v0);
        dag.addEdge(Edge.create((Vertex)v0, (Vertex)v1, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)this.dummyOutputClassName), (InputDescriptor)InputDescriptor.create((String)this.dummyInputClassName))));
        dag.verify();
    }

    @Test
    public void testDAGWithSplitsOnClient() {
        DAG dag = DAG.create((String)"DAG-testDAGWithSplitsOnClient");
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName));
        v1.addDataSource("input", DataSourceDescriptor.create((InputDescriptor)InputDescriptor.create((String)this.dummyInputClassName), null, (int)10, null, null, null));
        dag.addVertex(v1);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName));
        dag.addVertex(v2);
        dag.addEdge(Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)this.dummyOutputClassName), (InputDescriptor)InputDescriptor.create((String)this.dummyInputClassName))));
        dag.verify();
    }

    @Test(timeout=5000L)
    public void testDAGWithConflictingResource() {
        DAG dag = DAG.create((String)"DAG-testDAGWithConflictingResource");
        HashMap<String, LocalResource> localResourceMap = new HashMap<String, LocalResource>();
        String commonResourceKey = "local resource";
        localResourceMap.put("lr", LocalResource.newInstance(null, (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)0L, (long)0L));
        dag.addTaskLocalFiles(localResourceMap);
        Vertex v1 = Vertex.create((String)"v", (ProcessorDescriptor)ProcessorDescriptor.create((String)this.dummyProcessorClassName), (int)1);
        localResourceMap.put("lr", LocalResource.newInstance(null, (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)10L, (long)0L));
        v1.addTaskLocalFiles(localResourceMap);
        dag.addVertex(v1);
        try {
            dag.verifyLocalResources((Configuration)new TezConfiguration());
            Assert.fail((String)"should report failure on conflict resources");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("There is conflicting local resource"));
        }
    }
}

