/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.tez.client.CallerContext;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.GroupInputEdge;
import org.apache.tez.dag.api.HistoryLogLevel;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.VertexGroup;
import org.apache.tez.dag.api.records.DAGProtos;
import org.junit.Assert;
import org.junit.Test;

public class TestDAG {
    private final int dummyTaskCount = 2;
    private final Resource dummyTaskResource = Resource.newInstance((int)1, (int)1);

    @Test(timeout=5000L)
    public void testDuplicatedVertices() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)2, (Resource)this.dummyTaskResource);
        DAG dag = DAG.create((String)"DAG-testDuplicatedVertices");
        dag.addVertex(v1);
        try {
            dag.addVertex(v2);
            Assert.fail((String)"should fail it due to duplicated vertices");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.assertEquals((Object)"Vertex v1 already defined!", (Object)e.getMessage());
        }
    }

    @Test(timeout=5000L)
    public void testDuplicatedEdges() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)2, (Resource)this.dummyTaskResource);
        Edge edge1 = Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.CONCURRENT, (OutputDescriptor)OutputDescriptor.create((String)"output"), (InputDescriptor)InputDescriptor.create((String)"input")));
        Edge edge2 = Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.CONCURRENT, (OutputDescriptor)OutputDescriptor.create((String)"output"), (InputDescriptor)InputDescriptor.create((String)"input")));
        DAG dag = DAG.create((String)"DAG-testDuplicatedEdges");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addEdge(edge1);
        try {
            dag.addEdge(edge2);
            Assert.fail((String)"should fail it due to duplicated edges");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)e.getMessage().contains("already defined!"));
        }
    }

    @Test(timeout=5000L)
    public void testDuplicatedVertexGroup() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v3 = Vertex.create((String)"v3", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)2, (Resource)this.dummyTaskResource);
        DAG dag = DAG.create((String)"DAG-testDuplicatedVertexGroup");
        dag.createVertexGroup("group_1", new Vertex[]{v1, v2});
        try {
            dag.createVertexGroup("group_1", new Vertex[]{v2, v3});
            Assert.fail((String)"should fail it due to duplicated VertexGroups");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.assertEquals((Object)"VertexGroup group_1 already defined!", (Object)e.getMessage());
        }
        dag.createVertexGroup("group_2", new Vertex[]{v1, v2});
    }

    @Test(timeout=5000L)
    public void testDuplicatedGroupInputEdge() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)2, (Resource)this.dummyTaskResource);
        Vertex v3 = Vertex.create((String)"v3", (ProcessorDescriptor)ProcessorDescriptor.create((String)"Processor"), (int)2, (Resource)this.dummyTaskResource);
        DAG dag = DAG.create((String)"DAG-testDuplicatedGroupInputEdge");
        String groupName1 = "uv12";
        VertexGroup uv12 = dag.createVertexGroup(groupName1, new Vertex[]{v1, v2});
        GroupInputEdge e1 = GroupInputEdge.create((VertexGroup)uv12, (Vertex)v3, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"dummy output class"), (InputDescriptor)InputDescriptor.create((String)"dummy input class")), (InputDescriptor)InputDescriptor.create((String)"dummy input class"));
        GroupInputEdge e2 = GroupInputEdge.create((VertexGroup)uv12, (Vertex)v3, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"dummy output class"), (InputDescriptor)InputDescriptor.create((String)"dummy input class")), (InputDescriptor)InputDescriptor.create((String)"dummy input class"));
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addVertex(v3);
        dag.addEdge(e1);
        try {
            dag.addEdge(e2);
            Assert.fail((String)"should fail it due to duplicated GroupInputEdge");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)e.getMessage().contains("already defined"));
        }
    }

    @Test(timeout=5000L)
    public void testDAGConf() {
        DAG dag = DAG.create((String)"DAG-testDAGConf");
        dag.setConf("unknown_conf", "value");
        try {
            dag.setConf("tez.am.mode.session", "true");
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"tez.am.mode.session is set at the scope of DAG, but it is only valid in the scope of AM", (Object)e.getMessage());
        }
        dag.setConf("tez.am.commit-all-outputs-on-dag-success", "false");
        dag.setConf("tez.am.task.max.failed.attempts", "3");
    }

    @Test(timeout=5000L)
    public void testVertexConf() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"dummyProcessor"));
        v1.setConf("unknown_conf", "value");
        try {
            v1.setConf("tez.am.mode.session", "true");
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"tez.am.mode.session is set at the scope of VERTEX, but it is only valid in the scope of AM", (Object)e.getMessage());
        }
        try {
            v1.setConf("tez.am.commit-all-outputs-on-dag-success", "false");
            Assert.fail((String)"should fail due to invalid configuration set");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"tez.am.commit-all-outputs-on-dag-success is set at the scope of VERTEX, but it is only valid in the scope of DAG", (Object)e.getMessage());
        }
        v1.setConf("tez.am.task.max.failed.attempts", "3");
    }

    @Test(timeout=5000L)
    public void testDuplicatedInput() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"dummyProcessor"));
        DataSourceDescriptor dataSource = DataSourceDescriptor.create((InputDescriptor)InputDescriptor.create((String)"dummyInput"), null, null);
        try {
            v1.addDataSource(null, dataSource);
            Assert.fail((String)"Should fail due to invalid inputName");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("InputName should not be null, empty or white space only,"));
        }
        try {
            v1.addDataSource("", dataSource);
            Assert.fail((String)"Should fail due to invalid inputName");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("InputName should not be null, empty or white space only,"));
        }
        try {
            v1.addDataSource(" ", dataSource);
            Assert.fail((String)"Should fail due to invalid inputName");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("InputName should not be null, empty or white space only,"));
        }
        v1.addDataSource("input_1", dataSource);
        try {
            v1.addDataSource("input_1", DataSourceDescriptor.create((InputDescriptor)InputDescriptor.create((String)"dummyInput"), null, null));
            Assert.fail((String)"Should fail due to duplicated input");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Duplicated input:input_1, vertexName=v1", (Object)e.getMessage());
        }
    }

    @Test(timeout=5000L)
    public void testDuplicatedOutput_1() {
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"dummyProcessor"));
        DataSinkDescriptor dataSink = DataSinkDescriptor.create((OutputDescriptor)OutputDescriptor.create((String)"dummyOutput"), null, null);
        try {
            v1.addDataSink(null, dataSink);
            Assert.fail((String)"Should fail due to invalid outputName");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("OutputName should not be null, empty or white space only,"));
        }
        try {
            v1.addDataSink("", dataSink);
            Assert.fail((String)"Should fail due to invalid outputName");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("OutputName should not be null, empty or white space only,"));
        }
        try {
            v1.addDataSink(" ", dataSink);
            Assert.fail((String)"Should fail due to invalid outputName");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("OutputName should not be null, empty or white space only,"));
        }
        v1.addDataSink("output_1", DataSinkDescriptor.create((OutputDescriptor)OutputDescriptor.create((String)"dummyOutput"), null, null));
        try {
            v1.addDataSink("output_1", DataSinkDescriptor.create((OutputDescriptor)OutputDescriptor.create((String)"dummyOutput"), null, null));
            Assert.fail((String)"Should fail due to duplicated output");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Duplicated output:output_1, vertexName=v1", (Object)e.getMessage());
        }
    }

    @Test(timeout=5000L)
    public void testDuplicatedOutput_2() {
        DAG dag = DAG.create((String)"DAG-testDuplicatedOutput_2");
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"dummyProcessor"));
        DataSinkDescriptor dataSink = DataSinkDescriptor.create((OutputDescriptor)OutputDescriptor.create((String)"dummyOutput"), null, null);
        try {
            v1.addDataSink(null, dataSink);
            Assert.fail((String)"Should fail due to invalid outputName");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("OutputName should not be null, empty or white space only,"));
        }
        try {
            v1.addDataSink("", dataSink);
            Assert.fail((String)"Should fail due to invalid outputName");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("OutputName should not be null, empty or white space only,"));
        }
        try {
            v1.addDataSink(" ", dataSink);
            Assert.fail((String)"Should fail due to invalid outputName");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("OutputName should not be null, empty or white space only,"));
        }
        v1.addDataSink("output_1", dataSink);
        Vertex v2 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"dummyProcessor"));
        VertexGroup vGroup = dag.createVertexGroup("group_1", new Vertex[]{v1, v2});
        try {
            vGroup.addDataSink("output_1", DataSinkDescriptor.create((OutputDescriptor)OutputDescriptor.create((String)"dummyOutput"), null, null));
            Assert.fail((String)"Should fail due to duplicated output");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Duplicated output:output_1, vertexName=v1", (Object)e.getMessage());
        }
    }

    @Test
    public void testCallerContext() {
        try {
            CallerContext.create((String)"ctxt", (String)"", (String)"", (String)"desc");
            Assert.fail((String)"Expected failure for invalid args");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            CallerContext.create((String)"", (String)"desc");
            Assert.fail((String)"Expected failure for invalid args");
        }
        catch (Exception exception) {
            // empty catch block
        }
        CallerContext.create((String)"ctxt", (String)"a", (String)"a", (String)"desc");
        CallerContext.create((String)"ctxt", null);
        CallerContext callerContext = CallerContext.create((String)"ctxt", (String)"desc");
        Assert.assertTrue((boolean)callerContext.toString().contains("desc"));
        Assert.assertFalse((boolean)callerContext.contextAsSimpleString().contains("desc"));
    }

    @Test
    public void testRecreateDAG() {
        Map<String, LocalResource> lrDAG = Collections.singletonMap("LR1", LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test1"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"dummyProcessor1"), (int)1, (Resource)Resource.newInstance((int)1, (int)1));
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"dummyProcessor2"), (int)1, (Resource)Resource.newInstance((int)1, (int)1));
        DAG dag = DAG.create((String)"DAG-testRecreateDAG").addVertex(v1).addVertex(v2).addTaskLocalFiles(lrDAG);
        TezConfiguration tezConf = new TezConfiguration();
        DAGProtos.DAGPlan firstPlan = dag.createDag((Configuration)tezConf, null, null, null, false);
        for (int i = 0; i < 3; ++i) {
            DAGProtos.DAGPlan dagPlan = dag.createDag((Configuration)tezConf, null, null, null, false);
            Assert.assertEquals((Object)dagPlan, (Object)firstPlan);
        }
    }

    @Test
    public void testCreateDAGForHistoryLogLevel() {
        Map<String, LocalResource> lrDAG = Collections.singletonMap("LR1", LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test1"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"dummyProcessor1"), (int)1, (Resource)Resource.newInstance((int)1, (int)1));
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"dummyProcessor2"), (int)1, (Resource)Resource.newInstance((int)1, (int)1));
        DAG dag = DAG.create((String)"DAG-testCreateDAGForHistoryLogLevel").addVertex(v1).addVertex(v2).addTaskLocalFiles(lrDAG);
        TezConfiguration tezConf = new TezConfiguration();
        DAGProtos.DAGPlan dagPlan = dag.createDag((Configuration)tezConf, null, null, null, false);
        DAGProtos.DAGPlan.Builder builder = DAGProtos.DAGPlan.newBuilder((DAGProtos.DAGPlan)dagPlan);
        Assert.assertNull((Object)this.findKVP(builder.getDagConf(), "tez.history.logging.log.level"));
        tezConf.set("tez.history.logging.log.level", "TASK");
        dagPlan = dag.createDag((Configuration)tezConf, null, null, null, false);
        Assert.assertEquals((Object)"TASK", (Object)this.findKVP(DAGProtos.DAGPlan.newBuilder((DAGProtos.DAGPlan)dagPlan).getDagConf(), "tez.history.logging.log.level"));
        tezConf.set("tez.history.logging.log.level", "invalid");
        try {
            dagPlan = dag.createDag((Configuration)tezConf, null, null, null, false);
            Assert.fail((String)"Expected illegal argument exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Config: tez.history.logging.log.level is set to invalid value: invalid", (Object)e.getMessage());
        }
        dag.setHistoryLogLevel(HistoryLogLevel.VERTEX);
        dagPlan = dag.createDag((Configuration)tezConf, null, null, null, false);
        Assert.assertEquals((Object)"VERTEX", (Object)this.findKVP(DAGProtos.DAGPlan.newBuilder((DAGProtos.DAGPlan)dagPlan).getDagConf(), "tez.history.logging.log.level"));
        dag.setConf("tez.history.logging.log.level", HistoryLogLevel.DAG.name());
        dagPlan = dag.createDag((Configuration)tezConf, null, null, null, false);
        Assert.assertEquals((Object)"DAG", (Object)this.findKVP(DAGProtos.DAGPlan.newBuilder((DAGProtos.DAGPlan)dagPlan).getDagConf(), "tez.history.logging.log.level"));
        dag.setConf("tez.history.logging.log.level", "invalid");
        try {
            dagPlan = dag.createDag((Configuration)tezConf, null, null, null, false);
            Assert.fail((String)"Expected illegal argument exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Config: tez.history.logging.log.level is set to invalid value: invalid", (Object)e.getMessage());
        }
    }

    private String findKVP(DAGProtos.ConfigurationProto conf, String key) {
        String foundValue = null;
        for (int i = 0; i < conf.getConfKeyValuesCount(); ++i) {
            if (!conf.getConfKeyValues(i).getKey().equals(key)) continue;
            if (foundValue == null) {
                foundValue = conf.getConfKeyValues(i).getValue();
                continue;
            }
            Assert.fail((String)("Multiple values found: " + foundValue + ", " + conf.getConfKeyValues(i).getValue()));
        }
        return foundValue;
    }
}

