/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import org.apache.tez.common.JavaOptsChecker;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.junit.Assert;
import org.junit.Test;

public class TestJavaOptsChecker {
    private final JavaOptsChecker javaOptsChecker = new JavaOptsChecker();

    @Test(timeout=5000L)
    public void testBasicChecker() throws TezException {
        this.javaOptsChecker.checkOpts(TezConfiguration.TEZ_TASK_LAUNCH_CMD_OPTS_DEFAULT);
    }

    @Test(timeout=5000L)
    public void testMultipleGC() {
        String opts = "-XX:+UseConcMarkSweepGC -XX:+UseG1GC -XX:+UseParallelGC ";
        try {
            this.javaOptsChecker.checkOpts(opts);
            Assert.fail((String)("Expected check to fail with opts=" + opts));
        }
        catch (TezException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Invalid/conflicting GC options found"));
        }
    }

    @Test(timeout=5000L)
    public void testPositiveNegativeOpts() throws TezException {
        String opts = "-XX:+UseConcMarkSweepGC -XX:+UseG1GC -XX:+UseParallelGC -XX:-UseG1GC ";
        try {
            this.javaOptsChecker.checkOpts(opts);
            Assert.fail((String)("Expected check to fail with opts=" + opts));
        }
        catch (TezException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Invalid/conflicting GC options found"));
        }
        opts = " -XX:-UseG1GC -XX:+UseParallelGC -XX:-UseG1GC  -XX:+UseG1GC";
        try {
            this.javaOptsChecker.checkOpts(opts);
            Assert.fail((String)("Expected check to fail with opts=" + opts));
        }
        catch (TezException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Invalid/conflicting GC options found"));
        }
        opts = " -XX:+UseG1GC -XX:-UseG1GC -XX:+UseParallelGC -XX:-UseG1GC  -XX:+UseG1GC";
        try {
            this.javaOptsChecker.checkOpts(opts);
            Assert.fail((String)("Expected check to fail with opts=" + opts));
        }
        catch (TezException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Invalid/conflicting GC options found"));
        }
        opts = " -XX:+UseG1GC -XX:+UseParallelGC -XX:-UseG1GC ";
        this.javaOptsChecker.checkOpts(opts);
        opts = " -XX:+UseG1GC -XX:+UseParallelGC -XX:-UseG1GC -XX:-UseConcMarkSweepGC ";
        this.javaOptsChecker.checkOpts(opts);
    }

    @Test(timeout=5000L)
    public void testSpecialCaseNonConflictingGCOptions() throws TezException {
        String opts = " -XX:+UseParNewGC -XX:+UseConcMarkSweepGC ";
        this.javaOptsChecker.checkOpts(opts);
        opts = opts + " -XX:+DisableExplicitGC ";
        this.javaOptsChecker.checkOpts(opts);
        opts = opts + " -XX:-UseG1GC ";
        this.javaOptsChecker.checkOpts(opts);
        opts = opts + " -XX:+UseG1GC ";
        try {
            this.javaOptsChecker.checkOpts(opts);
            Assert.fail((String)("Expected check to fail with opts=" + opts));
        }
        catch (TezException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Invalid/conflicting GC options found"));
        }
    }
}

