/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.usergroupsync;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.plugin.util.RangerMetricsUtil;
import org.apache.ranger.unixusersync.config.UserGroupSyncConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSyncMetricsProducer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(UserSyncMetricsProducer.class);
    private boolean shutdownFlag;

    public static void main(String[] args) {
        UserSyncMetricsProducer userSyncMetrics = new UserSyncMetricsProducer();
        userSyncMetrics.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block11: {
            try {
                UserGroupSyncConfig config = UserGroupSyncConfig.getInstance();
                long sleepTimeBetweenCycleInMillis = config.getUserSyncMetricsFrequency();
                String logFileNameWithPath = config.getUserSyncMetricsFileName();
                LOG.info("User Sync metrics frequency :  {} and metrics file : {}", (Object)sleepTimeBetweenCycleInMillis, (Object)logFileNameWithPath);
                if (logFileNameWithPath != null) {
                    while (!this.shutdownFlag) {
                        try {
                            LOG.debug("Sleeping metrics for {} milliSeconds", (Object)sleepTimeBetweenCycleInMillis);
                            Thread.sleep(sleepTimeBetweenCycleInMillis);
                        }
                        catch (InterruptedException e) {
                            LOG.error("Failed to wait for [{}] milliseconds before attempting to fetch userSync metrics information", (Object)sleepTimeBetweenCycleInMillis, (Object)e);
                        }
                        try {
                            this.writeJVMMetrics(logFileNameWithPath);
                        }
                        catch (Throwable t) {
                            LOG.error("Failed to write user sync metrics into file. Error details: ", t);
                        }
                    }
                    break block11;
                }
                LOG.info("No file directory found for usersync metrics log ");
            }
            catch (Throwable t) {
                LOG.error("Failed to start user sync metrics. Error details: ", t);
            }
            finally {
                LOG.info("Shutting down the User Sync metrics producer thread");
            }
        }
    }

    private void writeJVMMetrics(String logFileNameWithPath) throws Throwable {
        try {
            File userMetricFile = new File(logFileNameWithPath);
            UserGroupSyncConfig userConfig = UserGroupSyncConfig.getInstance();
            Configuration config = userConfig.getUserGroupConfig();
            if (!userMetricFile.exists()) {
                userMetricFile.createNewFile();
            }
            RangerMetricsUtil rangerMetricsUtil = new RangerMetricsUtil();
            if (config.getBoolean("ranger-ugsync.server.ha.enabled", false)) {
                if (UserGroupSyncConfig.isUgsyncServiceActive()) {
                    RangerMetricsUtil.setIsRoleActive((int)1);
                } else {
                    RangerMetricsUtil.setIsRoleActive((int)0);
                }
            }
            rangerMetricsUtil.writeMetricsToFile(userMetricFile);
        }
        catch (Throwable t) {
            LOG.error("UserSyncMetricsProducer.writeJVMMetrics() failed to write metrics into file. Error details: ", t);
            throw t;
        }
    }
}

