/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.unixusersync.process;

import com.sun.jersey.api.client.ClientResponse;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.SecureClientLogin;
import org.apache.ranger.authorization.utils.JsonUtils;
import org.apache.ranger.ugsyncutil.model.GroupUserInfo;
import org.apache.ranger.ugsyncutil.model.UgsyncAuditInfo;
import org.apache.ranger.ugsyncutil.model.UsersGroupRoleAssignments;
import org.apache.ranger.ugsyncutil.model.XGroupInfo;
import org.apache.ranger.ugsyncutil.model.XUserInfo;
import org.apache.ranger.unixusersync.config.UserGroupSyncConfig;
import org.apache.ranger.unixusersync.model.GetXGroupListResponse;
import org.apache.ranger.unixusersync.model.GetXUserListResponse;
import org.apache.ranger.unixusersync.process.RangerUgSyncRESTClient;
import org.apache.ranger.usergroupsync.AbstractUserGroupSource;
import org.apache.ranger.usergroupsync.UserGroupSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyMgrUserGroupBuilder
extends AbstractUserGroupSource
implements UserGroupSink {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyMgrUserGroupBuilder.class);
    private static final String PM_ADD_USERS_URI = "/service/xusers/ugsync/users";
    private static final String PM_ADD_GROUPS_URI = "/service/xusers/ugsync/groups/";
    private static final String PM_ADD_GROUP_USER_LIST_URI = "/service/xusers/ugsync/groupusers";
    private static final String PM_AUDIT_INFO_URI = "/service/xusers/ugsync/auditinfo/";
    private static final String PM_UPDATE_DELETED_USERS_URI = "/service/xusers/ugsync/users/visibility";
    private static final String PM_UPDATE_DELETED_GROUPS_URI = "/service/xusers/ugsync/groups/visibility";
    public static final String PM_USER_LIST_URI = "/service/xusers/users/";
    public static final String PM_GROUP_LIST_URI = "/service/xusers/groups/";
    public static final String PM_GET_ALL_GROUP_USER_MAP_LIST_URI = "/service/xusers/ugsync/groupusers";
    public static final String PM_UPDATE_USERS_ROLES_URI = "/service/xusers/users/roleassignments";
    private static final String AUTHENTICATION_TYPE = "hadoop.security.authentication";
    private static final String AUTH_KERBEROS = "kerberos";
    private static final String KERBEROS_PRINCIPAL = "ranger.usersync.kerberos.principal";
    private static final String KERBEROS_KEYTAB = "ranger.usersync.kerberos.keytab";
    private static final String NAME_RULE = "hadoop.security.auth_to_local";
    private static final String SOURCE_EXTERNAL = "1";
    private static final String STATUS_ENABLED = "1";
    private static final String ISVISIBLE = "1";
    private static final String ISHIDDEN = "0";
    private static final Pattern USER_OR_GROUP_NAME_VALIDATION_REGEX = Pattern.compile("^([A-Za-z0-9_]|[\u00c0-\u017f])([a-zA-Z0-9\\s,._\\-+/@= ]|[\u00c0-\u017f])+$", 2);
    private static final String ERR_MSG_FOR_INACTIVE_SERVER = "This userGroupSync server is not in active state. Cannot commit transaction!";
    private static String localHostname;
    private final boolean userNameCaseConversionFlag;
    private final boolean groupNameCaseConversionFlag;
    private volatile RangerUgSyncRESTClient ldapUgSyncClient;
    private Map<String, XUserInfo> userCache;
    private Map<String, XGroupInfo> groupCache;
    private Map<String, Set<String>> groupUsersCache;
    private Map<String, String> groupNameMap;
    private Map<String, String> userNameMap;
    private Set<String> computeRolesForUsers;
    private Map<String, XGroupInfo> deltaGroups;
    private Map<String, XUserInfo> deltaUsers;
    private Map<String, Set<String>> deltaGroupUsers;
    private Map<String, XGroupInfo> deletedGroups;
    private Map<String, XUserInfo> deletedUsers;
    private int noOfNewUsers;
    private int noOfNewGroups;
    private int noOfModifiedUsers;
    private int noOfModifiedGroups;
    private int noOfDeletedUsers;
    private int noOfDeletedGroups;
    private boolean isStartupFlag;
    private boolean isValidRangerCookie;
    private boolean isMockRun;
    private boolean userNameLowerCaseFlag;
    private boolean groupNameLowerCaseFlag;
    private boolean isRangerCookieEnabled;
    private boolean isUserSyncNameValidationEnabled;
    private boolean isSyncSourceValidationEnabled;
    private String recordsToPullPerCall = "10";
    private String currentSyncSource;
    private String ldapUrl;
    private String authenticationType;
    private String rangerCookieName;
    private String policyMgrBaseUrl;
    private Cookie sessionId;
    String principal;
    String keytab;
    String policyMgrUserName;
    String nameRules;
    List<NewCookie> cookieList = new ArrayList<NewCookie>();
    Map<String, String> userMap = new LinkedHashMap<String, String>();
    Map<String, String> groupMap = new LinkedHashMap<String, String>();
    Map<String, String> whiteListUserMap = new LinkedHashMap<String, String>();
    Map<String, String> whiteListGroupMap = new LinkedHashMap<String, String>();

    public PolicyMgrUserGroupBuilder() {
        String userNameCaseConversion = this.config.getUserNameCaseConversion();
        if ("none".equalsIgnoreCase(userNameCaseConversion)) {
            this.userNameCaseConversionFlag = false;
        } else {
            this.userNameCaseConversionFlag = true;
            this.userNameLowerCaseFlag = "lower".equalsIgnoreCase(userNameCaseConversion);
        }
        String groupNameCaseConversion = this.config.getGroupNameCaseConversion();
        if ("none".equalsIgnoreCase(groupNameCaseConversion)) {
            this.groupNameCaseConversionFlag = false;
        } else {
            this.groupNameCaseConversionFlag = true;
            this.groupNameLowerCaseFlag = "lower".equalsIgnoreCase(groupNameCaseConversion);
        }
    }

    public static void main(String[] args) throws Throwable {
        PolicyMgrUserGroupBuilder ugbuilder = new PolicyMgrUserGroupBuilder();
        ugbuilder.init();
    }

    @Override
    public synchronized void init() throws Throwable {
        String policyMgrUserRole;
        String whiteListUserRoles;
        this.isUserSyncNameValidationEnabled = this.config.isUserSyncNameValidationEnabled();
        this.isSyncSourceValidationEnabled = this.config.isSyncSourceValidationEnabled();
        this.recordsToPullPerCall = this.config.getMaxRecordsPerAPICall();
        this.policyMgrBaseUrl = this.config.getPolicyManagerBaseURL();
        this.isMockRun = this.config.isMockRunEnabled();
        this.isRangerCookieEnabled = this.config.isUserSyncRangerCookieEnabled();
        this.rangerCookieName = this.config.getRangerAdminCookieName();
        this.groupNameMap = new HashMap<String, String>();
        this.userNameMap = new HashMap<String, String>();
        this.userCache = new HashMap<String, XUserInfo>();
        this.groupCache = new HashMap<String, XGroupInfo>();
        this.groupUsersCache = new HashMap<String, Set<String>>();
        this.isStartupFlag = true;
        this.ldapUrl = null;
        this.currentSyncSource = this.config.getCurrentSyncSource();
        if (StringUtils.equalsIgnoreCase((String)this.currentSyncSource, (String)"LDAP/AD")) {
            this.ldapUrl = this.config.getLdapUrl();
        }
        this.sessionId = null;
        String keyStoreFile = this.config.getSSLKeyStorePath();
        String trustStoreFile = this.config.getSSLTrustStorePath();
        String keyStoreFilepwd = this.config.getSSLKeyStorePathPassword();
        String trustStoreFilepwd = this.config.getSSLTrustStorePathPassword();
        String keyStoreType = this.config.getSSLKeyStoreType();
        String trustStoreType = this.config.getSSLTrustStoreType();
        this.authenticationType = this.config.getProperty(AUTHENTICATION_TYPE, "simple");
        try {
            this.principal = SecureClientLogin.getPrincipal((String)this.config.getProperty(KERBEROS_PRINCIPAL, ""), (String)localHostname);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.keytab = this.config.getProperty(KERBEROS_KEYTAB, "");
        this.policyMgrUserName = this.config.getPolicyMgrUserName();
        this.nameRules = this.config.getProperty(NAME_RULE, "DEFAULT");
        this.ldapUgSyncClient = new RangerUgSyncRESTClient(this.policyMgrBaseUrl, keyStoreFile, keyStoreFilepwd, keyStoreType, trustStoreFile, trustStoreFilepwd, trustStoreType, this.authenticationType, this.principal, this.keytab, this.policyMgrUserName, this.config.getPolicyMgrPassword());
        String userGroupRoles = this.config.getGroupRoleRules();
        if (userGroupRoles != null && !userGroupRoles.isEmpty()) {
            this.getRoleForUserGroups(userGroupRoles, this.userMap, this.groupMap);
        }
        if ((whiteListUserRoles = this.config.getWhileListUserRoleRules()) != null && !whiteListUserRoles.isEmpty()) {
            this.getRoleForUserGroups(whiteListUserRoles, this.whiteListUserMap, this.whiteListGroupMap);
        }
        if (!StringUtils.equalsIgnoreCase((String)(policyMgrUserRole = this.whiteListUserMap.get(this.policyMgrUserName)), (String)"ROLE_SYS_ADMIN")) {
            this.whiteListUserMap.put(this.policyMgrUserName, "ROLE_SYS_ADMIN");
        }
        LOG.debug("Entries in group role assignments: {}", this.groupMap);
        LOG.debug("Entries in whitelist group role assignments: {}", this.whiteListGroupMap);
        this.buildUserGroupInfo();
        LOG.debug("PolicyMgrUserGroupBuilderOld.init()==> policyMgrBaseUrl: {}, KeyStore File: {}, TrustStore File: {}, Authentication Type: {}", new Object[]{this.policyMgrBaseUrl, keyStoreFile, trustStoreFile, this.authenticationType});
    }

    @Override
    public void postUserGroupAuditInfo(UgsyncAuditInfo ugsyncAuditInfo) {
        ugsyncAuditInfo.setNoOfNewUsers(Long.valueOf(Integer.toUnsignedLong(this.noOfNewUsers)));
        ugsyncAuditInfo.setNoOfNewGroups(Long.valueOf(Integer.toUnsignedLong(this.noOfNewGroups)));
        ugsyncAuditInfo.setNoOfModifiedUsers(Long.valueOf(Integer.toUnsignedLong(this.noOfModifiedUsers)));
        ugsyncAuditInfo.setNoOfModifiedGroups(Long.valueOf(Integer.toUnsignedLong(this.noOfModifiedGroups)));
        int noOfCachedUsers = this.userCache.size();
        int noOfCachedGroups = this.groupCache.size();
        switch (ugsyncAuditInfo.getSyncSource()) {
            case "LDAP/AD": {
                ugsyncAuditInfo.getLdapSyncSourceInfo().setTotalUsersSynced((long)noOfCachedUsers);
                ugsyncAuditInfo.getLdapSyncSourceInfo().setTotalGroupsSynced((long)noOfCachedGroups);
                ugsyncAuditInfo.getLdapSyncSourceInfo().setTotalUsersDeleted((long)this.noOfDeletedUsers);
                ugsyncAuditInfo.getLdapSyncSourceInfo().setTotalGroupsDeleted((long)this.noOfDeletedGroups);
                break;
            }
            case "Unix": {
                ugsyncAuditInfo.getUnixSyncSourceInfo().setTotalUsersSynced((long)noOfCachedUsers);
                ugsyncAuditInfo.getUnixSyncSourceInfo().setTotalGroupsSynced((long)noOfCachedGroups);
                ugsyncAuditInfo.getUnixSyncSourceInfo().setTotalUsersDeleted((long)this.noOfDeletedUsers);
                ugsyncAuditInfo.getUnixSyncSourceInfo().setTotalGroupsDeleted((long)this.noOfDeletedGroups);
                break;
            }
            case "File": {
                ugsyncAuditInfo.getFileSyncSourceInfo().setTotalUsersSynced((long)noOfCachedUsers);
                ugsyncAuditInfo.getFileSyncSourceInfo().setTotalGroupsSynced((long)noOfCachedGroups);
                ugsyncAuditInfo.getFileSyncSourceInfo().setTotalUsersDeleted((long)this.noOfDeletedUsers);
                ugsyncAuditInfo.getFileSyncSourceInfo().setTotalGroupsDeleted((long)this.noOfDeletedGroups);
                break;
            }
        }
        if (!this.isMockRun) {
            this.checkStatus();
            this.addUserGroupAuditInfo(ugsyncAuditInfo);
        }
    }

    @Override
    public void addOrUpdateUsersGroups(Map<String, Map<String, String>> sourceGroups, Map<String, Map<String, String>> sourceUsers, Map<String, Set<String>> sourceGroupUsers, boolean computeDeletes) throws Throwable {
        this.checkStatus();
        this.noOfNewUsers = 0;
        this.noOfNewGroups = 0;
        this.noOfModifiedUsers = 0;
        this.noOfModifiedGroups = 0;
        this.computeRolesForUsers = new HashSet<String>();
        if (!this.isStartupFlag && computeDeletes) {
            LOG.info("Computing deleted users/groups");
            if (MapUtils.isNotEmpty(sourceGroups)) {
                this.updateDeletedGroups(sourceGroups);
            }
            if (MapUtils.isNotEmpty(sourceUsers)) {
                this.updateDeletedUsers(sourceUsers);
            }
            if (MapUtils.isNotEmpty(this.deletedGroups)) {
                this.groupCache.putAll(this.deletedGroups);
            }
            if (MapUtils.isNotEmpty(this.deletedUsers)) {
                this.userCache.putAll(this.deletedUsers);
            }
        }
        if (MapUtils.isNotEmpty(sourceGroups)) {
            this.addOrUpdateGroups(sourceGroups);
        }
        if (MapUtils.isNotEmpty(sourceUsers)) {
            this.addOrUpdateUsers(sourceUsers);
        }
        if (MapUtils.isNotEmpty(sourceGroupUsers)) {
            this.addOrUpdateGroupUsers(sourceGroupUsers);
        }
        if (this.isStartupFlag) {
            HashSet groupUsers;
            if (MapUtils.isNotEmpty(this.whiteListUserMap)) {
                LOG.debug("adding {} for computing roles during startup", this.whiteListUserMap.keySet());
                this.computeRolesForUsers.addAll(this.whiteListUserMap.keySet());
            }
            if (MapUtils.isNotEmpty(this.whiteListGroupMap)) {
                for (String groupName : this.whiteListGroupMap.keySet()) {
                    groupUsers = null;
                    if (CollectionUtils.isNotEmpty((Collection)this.groupUsersCache.get(groupName))) {
                        groupUsers = new HashSet(this.groupUsersCache.get(groupName));
                    } else if (CollectionUtils.isNotEmpty((Collection)this.deltaGroupUsers.get(groupName))) {
                        groupUsers = new HashSet(this.deltaGroupUsers.get(groupName));
                    }
                    if (groupUsers == null) continue;
                    LOG.debug("adding {} from {} for computing roles during startup", groupUsers, (Object)groupName);
                    this.computeRolesForUsers.addAll(groupUsers);
                }
            }
            if (MapUtils.isNotEmpty(this.userMap)) {
                LOG.debug("adding {} for computing roles during startup", this.userMap.keySet());
                this.computeRolesForUsers.addAll(this.userMap.keySet());
            }
            if (MapUtils.isNotEmpty(this.groupMap)) {
                for (String groupName : this.groupMap.keySet()) {
                    groupUsers = null;
                    if (CollectionUtils.isNotEmpty((Collection)this.groupUsersCache.get(groupName))) {
                        groupUsers = new HashSet(this.groupUsersCache.get(groupName));
                    } else if (CollectionUtils.isNotEmpty((Collection)this.deltaGroupUsers.get(groupName))) {
                        groupUsers = new HashSet(this.deltaGroupUsers.get(groupName));
                    }
                    if (groupUsers == null) continue;
                    LOG.debug("adding {} from {} for computing roles during startup", groupUsers, (Object)groupName);
                    this.computeRolesForUsers.addAll(groupUsers);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(this.computeRolesForUsers)) {
            this.updateUserRoles();
        }
        this.isStartupFlag = false;
        LOG.debug("Update cache");
        if (MapUtils.isNotEmpty(this.deltaGroups)) {
            this.groupCache.putAll(this.deltaGroups);
        }
        if (MapUtils.isNotEmpty(this.deltaUsers)) {
            this.userCache.putAll(this.deltaUsers);
        }
        if (MapUtils.isNotEmpty(this.deltaGroupUsers)) {
            this.groupUsersCache.putAll(this.deltaGroupUsers);
        }
    }

    protected String userNameTransform(String userName) {
        if (this.userNameCaseConversionFlag) {
            userName = this.userNameLowerCaseFlag ? userName.toLowerCase() : userName.toUpperCase();
        }
        if (this.userNameRegExInst != null) {
            userName = this.userNameRegExInst.transform(userName);
        }
        return userName;
    }

    protected String groupNameTransform(String groupName) {
        if (this.groupNameCaseConversionFlag) {
            groupName = this.groupNameLowerCaseFlag ? groupName.toLowerCase() : groupName.toUpperCase();
        }
        if (this.groupNameRegExInst != null) {
            groupName = this.groupNameRegExInst.transform(groupName);
        }
        return groupName;
    }

    protected boolean isValidString(String name) {
        if (StringUtils.isBlank((String)name)) {
            return false;
        }
        if (this.isUserSyncNameValidationEnabled) {
            return USER_OR_GROUP_NAME_VALIDATION_REGEX.matcher(name).matches();
        }
        return true;
    }

    protected void setUserSyncNameValidationEnabled(String isNameValidationEnabled) {
        this.config.setProperty("ranger.usersync.name.validation.enabled", isNameValidationEnabled);
        this.isUserSyncNameValidationEnabled = this.config.isUserSyncNameValidationEnabled();
    }

    private void buildUserGroupInfo() throws Throwable {
        if (AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab)) {
            LOG.info("Using principal: {} and keytab: {}", (Object)this.principal, (Object)this.keytab);
            Subject sub = SecureClientLogin.loginUserFromKeytab((String)this.principal, (String)this.keytab, (String)this.nameRules);
            Boolean isInitDone = Subject.doAs(sub, () -> {
                try {
                    this.buildGroupList();
                    this.buildUserList();
                    this.buildGroupUserLinkList();
                }
                catch (Throwable e) {
                    LOG.error("Failed to build Users and Groups from Ranger admin : ", e);
                    return false;
                }
                return true;
            });
            if (!isInitDone.booleanValue()) {
                String msg = "Failed to build Users and Groups from Ranger admin";
                LOG.error(msg);
                throw new Exception(msg);
            }
        } else {
            this.buildGroupList();
            this.buildUserList();
            this.buildGroupUserLinkList();
        }
    }

    private void buildGroupList() throws Throwable {
        LOG.debug("==> PolicyMgrUserGroupBuilder.buildGroupList()");
        int totalCount = 100;
        int retrievedCount = 0;
        while (retrievedCount < totalCount) {
            String response = null;
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("pageSize", this.recordsToPullPerCall);
            queryParams.put("startIndex", String.valueOf(retrievedCount));
            if (this.isRangerCookieEnabled) {
                response = this.cookieBasedGetEntity(PM_GROUP_LIST_URI, retrievedCount);
            } else {
                try {
                    ClientResponse clientResp = this.ldapUgSyncClient.get(PM_GROUP_LIST_URI, queryParams);
                    if (clientResp != null) {
                        response = (String)clientResp.getEntity(String.class);
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to get groups from Ranger, Error is : {}", (Object)e.getMessage());
                    throw e;
                }
            }
            LOG.debug("REST response from {} : {}", (Object)PM_GROUP_LIST_URI, (Object)response);
            GetXGroupListResponse groupList = (GetXGroupListResponse)JsonUtils.jsonToObject((String)response, GetXGroupListResponse.class);
            totalCount = groupList.getTotalCount();
            if (groupList.getXgroupInfoList() != null) {
                for (XGroupInfo g : groupList.getXgroupInfoList()) {
                    LOG.debug("GROUP:  Id: {}, Name: {}, Description: {}", new Object[]{g.getId(), g.getName(), g.getDescription()});
                    if (null != g.getOtherAttributes()) {
                        g.setOtherAttrsMap((Map)JsonUtils.jsonToObject((String)g.getOtherAttributes(), Map.class));
                    }
                    this.groupCache.put(g.getName(), g);
                }
                retrievedCount = this.groupCache.size();
            }
            LOG.info("PolicyMgrUserGroupBuilder.buildGroupList(): No. of groups retrieved from ranger admin {}", (Object)retrievedCount);
        }
        LOG.debug("<== PolicyMgrUserGroupBuilder.buildGroupList()");
    }

    private void buildUserList() throws Throwable {
        LOG.debug("==> PolicyMgrUserGroupBuilder.buildUserList()");
        int totalCount = 100;
        int retrievedCount = 0;
        while (retrievedCount < totalCount) {
            String response = null;
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("pageSize", this.recordsToPullPerCall);
            queryParams.put("startIndex", String.valueOf(retrievedCount));
            if (this.isRangerCookieEnabled) {
                response = this.cookieBasedGetEntity(PM_USER_LIST_URI, retrievedCount);
            } else {
                try {
                    ClientResponse clientResp = this.ldapUgSyncClient.get(PM_USER_LIST_URI, queryParams);
                    if (clientResp != null) {
                        response = (String)clientResp.getEntity(String.class);
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to get users from Ranger admin, Error is : {}", (Object)e.getMessage());
                    throw e;
                }
            }
            LOG.debug("REST response from {} : {}", (Object)PM_USER_LIST_URI, (Object)response);
            GetXUserListResponse userList = (GetXUserListResponse)JsonUtils.jsonToObject((String)response, GetXUserListResponse.class);
            totalCount = userList.getTotalCount();
            if (userList.getXuserInfoList() != null) {
                for (XUserInfo u : userList.getXuserInfoList()) {
                    LOG.debug("USER: Id: {}, Name: {}, Description: {}", new Object[]{u.getId(), u.getName(), u.getDescription()});
                    if (null != u.getOtherAttributes()) {
                        u.setOtherAttrsMap((Map)JsonUtils.jsonToObject((String)u.getOtherAttributes(), Map.class));
                    }
                    this.userCache.put(u.getName(), u);
                }
                retrievedCount = this.userCache.size();
            }
            LOG.info("PolicyMgrUserGroupBuilder.buildUserList(): No. of users retrieved from ranger admin = {}", (Object)retrievedCount);
        }
        LOG.debug("<== PolicyMgrUserGroupBuilder.buildUserList()");
    }

    private void buildGroupUserLinkList() throws Throwable {
        LOG.debug("==> PolicyMgrUserGroupBuilder.buildGroupUserLinkList()");
        String response = null;
        if (this.isRangerCookieEnabled) {
            response = this.cookieBasedGetEntity("/service/xusers/ugsync/groupusers", 0);
        } else {
            try {
                ClientResponse clientResp = this.ldapUgSyncClient.get("/service/xusers/ugsync/groupusers", null);
                if (clientResp != null) {
                    response = (String)clientResp.getEntity(String.class);
                }
            }
            catch (Exception e) {
                LOG.error("Failed to get response, group user mappings from Ranger admin. Error is : {}", (Object)e.getMessage());
                throw e;
            }
        }
        LOG.debug("REST response from {} : {}", (Object)"/service/xusers/ugsync/groupusers", (Object)response);
        this.groupUsersCache = (Map)JsonUtils.jsonToObject((String)response, Map.class);
        if (MapUtils.isEmpty(this.groupUsersCache)) {
            this.groupUsersCache = new HashMap<String, Set<String>>();
        }
        LOG.debug("Group User List : {}", this.groupUsersCache.values());
        LOG.debug("<== PolicyMgrUserGroupBuilder.buildGroupUserLinkList()");
    }

    private void addOrUpdateUsers(Map<String, Map<String, String>> sourceUsers) throws Throwable {
        this.computeUserDelta(sourceUsers);
        if (MapUtils.isNotEmpty(this.deltaUsers) && this.addOrUpdateDeltaUsers() == 0) {
            String msg = "Failed to addorUpdate users to ranger admin";
            LOG.error(msg);
            throw new Exception(msg);
        }
    }

    private void addOrUpdateGroups(Map<String, Map<String, String>> sourceGroups) throws Throwable {
        this.computeGroupDelta(sourceGroups);
        if (MapUtils.isNotEmpty(this.deltaGroups) && this.addOrUpdateDeltaGroups() == 0) {
            String msg = "Failed to addorUpdate groups to ranger admin";
            LOG.error(msg);
            throw new Exception(msg);
        }
    }

    private void addOrUpdateGroupUsers(Map<String, Set<String>> sourceGroupUsers) throws Throwable {
        List<GroupUserInfo> groupUserInfoList = this.computeGroupUsersDelta(sourceGroupUsers);
        if (CollectionUtils.isNotEmpty(groupUserInfoList)) {
            this.noOfModifiedGroups += groupUserInfoList.size();
            if (this.addOrUpdateDeltaGroupUsers(groupUserInfoList) == 0) {
                String msg = "Failed to addorUpdate group memberships to ranger admin";
                LOG.error(msg);
                throw new Exception(msg);
            }
        }
    }

    private void updateUserRoles() throws Throwable {
        UsersGroupRoleAssignments ugRoleAssignments = new UsersGroupRoleAssignments();
        ArrayList<String> allUsers = new ArrayList<String>(this.computeRolesForUsers);
        ugRoleAssignments.setUsers(allUsers);
        ugRoleAssignments.setGroupRoleAssignments(this.groupMap);
        ugRoleAssignments.setUserRoleAssignments(this.userMap);
        ugRoleAssignments.setWhiteListUserRoleAssignments(this.whiteListUserMap);
        ugRoleAssignments.setWhiteListGroupRoleAssignments(this.whiteListGroupMap);
        ugRoleAssignments.setReset(this.isStartupFlag);
        String updatedUsers = this.updateRoles(ugRoleAssignments);
        if (updatedUsers == null) {
            String msg = "Unable to update roles for " + allUsers;
            LOG.error(msg);
            throw new Exception(msg);
        }
    }

    private <T> T setOtherAttributes(T uginfo, String syncSource, Map<String, String> otherAttrsMap, String otherAttributes) {
        if (uginfo instanceof XUserInfo) {
            XUserInfo xUserInfo = (XUserInfo)uginfo;
            xUserInfo.setSyncSource(syncSource);
            xUserInfo.setOtherAttrsMap(otherAttrsMap);
            xUserInfo.setOtherAttributes(otherAttributes);
            return (T)xUserInfo;
        }
        if (uginfo instanceof XGroupInfo) {
            XGroupInfo xGroupInfo = (XGroupInfo)uginfo;
            xGroupInfo.setSyncSource(syncSource);
            xGroupInfo.setOtherAttrsMap(otherAttrsMap);
            xGroupInfo.setOtherAttributes(otherAttributes);
            return (T)xGroupInfo;
        }
        return null;
    }

    private void computeGroupDelta(Map<String, Map<String, String>> sourceGroups) {
        LOG.debug("PolicyMgrUserGroupBuilder.computeGroupDelta({})", sourceGroups.keySet());
        this.deltaGroups = new HashMap<String, XGroupInfo>();
        for (String groupDN : sourceGroups.keySet()) {
            Map<String, String> newGroupAttrs = sourceGroups.get(groupDN);
            String newGroupAttrsStr = JsonUtils.objectToJson(newGroupAttrs);
            String groupName = this.groupNameMap.get(groupDN);
            if (StringUtils.isEmpty((String)groupName)) {
                groupName = this.groupNameTransform(newGroupAttrs.get("original_name").trim());
            }
            if (!this.isValidString(groupName)) {
                LOG.warn("Ignoring invalid group {} Full name = {}", (Object)groupName, (Object)groupDN);
                continue;
            }
            if (!this.groupCache.containsKey(groupName)) {
                XGroupInfo newGroup = this.addXGroupInfo(groupName, newGroupAttrs, newGroupAttrsStr);
                this.deltaGroups.put(groupName, newGroup);
                ++this.noOfNewGroups;
                this.groupNameMap.put(groupDN, groupName);
                continue;
            }
            XGroupInfo curGroup = this.groupCache.get(groupName);
            String curSyncSource = curGroup.getSyncSource();
            String curGroupAttrsStr = curGroup.getOtherAttributes();
            Map curGroupAttrs = curGroup.getOtherAttrsMap();
            String curGroupDN = MapUtils.isEmpty((Map)curGroupAttrs) ? groupName : (String)curGroupAttrs.get("full_name");
            String newSyncSource = newGroupAttrs.get("sync_source");
            if (this.isStartupFlag && !this.isSyncSourceValidationEnabled && !StringUtils.equalsIgnoreCase((String)curSyncSource, (String)newSyncSource)) {
                LOG.debug("[{}]: SyncSource updated to {}, previous value: {}", new Object[]{groupName, newSyncSource, curSyncSource});
                curGroup = this.setOtherAttributes(curGroup, newSyncSource, newGroupAttrs, newGroupAttrsStr);
                this.deltaGroups.put(groupName, curGroup);
                ++this.noOfModifiedGroups;
                this.groupNameMap.put(groupDN, groupName);
                continue;
            }
            if (MapUtils.isNotEmpty((Map)curGroupAttrs) && !StringUtils.equalsIgnoreCase((String)groupDN, (String)curGroupDN)) {
                LOG.debug("[{}]: SyncSource update skipped, current group DN = {} new user DN  = {}", new Object[]{groupName, curGroupDN, groupDN});
                if (!StringUtils.equalsIgnoreCase((String)curGroupAttrsStr, (String)newGroupAttrsStr)) continue;
                this.groupNameMap.put(groupDN, groupName);
                continue;
            }
            if (StringUtils.isEmpty((String)curSyncSource) || !StringUtils.equalsIgnoreCase((String)curGroupAttrsStr, (String)newGroupAttrsStr) && StringUtils.equalsIgnoreCase((String)curSyncSource, (String)newSyncSource)) {
                if (StringUtils.isEmpty((String)curSyncSource)) {
                    LOG.debug("[{}]: SyncSource updated to {}, previously empty", (Object)groupName, (Object)newSyncSource);
                } else {
                    LOG.debug("[{}]: Other Attributes updated!", (Object)groupName);
                }
                curGroup = this.setOtherAttributes(curGroup, newSyncSource, newGroupAttrs, newGroupAttrsStr);
                this.deltaGroups.put(groupName, curGroup);
                ++this.noOfModifiedGroups;
                this.groupNameMap.put(groupDN, groupName);
            } else if (!StringUtils.equalsIgnoreCase((String)curSyncSource, (String)newSyncSource)) {
                LOG.debug("[{}]: Different sync source exists, update skipped!", (Object)groupName);
            } else {
                LOG.debug("[{}]: No change, update skipped!", (Object)groupName);
            }
            if (!StringUtils.equalsIgnoreCase((String)curGroupAttrsStr, (String)newGroupAttrsStr)) continue;
            this.groupNameMap.put(groupDN, groupName);
        }
        LOG.debug("<== PolicyMgrUserGroupBuilder.computeGroupDelta({})", this.deltaGroups.keySet());
    }

    private void computeUserDelta(Map<String, Map<String, String>> sourceUsers) {
        LOG.debug("==> PolicyMgrUserGroupBuilder.computeUserDelta({})", sourceUsers.keySet());
        this.deltaUsers = new HashMap<String, XUserInfo>();
        for (Map.Entry<String, Map<String, String>> sourceUser : sourceUsers.entrySet()) {
            String userDN = sourceUser.getKey();
            Map<String, String> newUserAttrs = sourceUser.getValue();
            String newUserAttrsStr = JsonUtils.objectToJson(newUserAttrs);
            String userName = this.userNameMap.get(userDN);
            if (StringUtils.isEmpty((String)userName)) {
                userName = this.userNameTransform(newUserAttrs.get("original_name").trim());
            }
            if (!this.isValidString(userName)) {
                LOG.warn("Ignoring invalid user {} Full name = {}", (Object)userName, (Object)userDN);
                continue;
            }
            if (!this.userCache.containsKey(userName)) {
                XUserInfo newUser = this.addXUserInfo(userName, newUserAttrs, newUserAttrsStr);
                this.deltaUsers.put(userName, newUser);
                ++this.noOfNewUsers;
                this.userNameMap.put(userDN, userName);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)this.policyMgrUserName, (String)userName) || StringUtils.equalsIgnoreCase((String)"admin", (String)userName)) {
                LOG.debug("[{}]: SyncSource update skipped!", (Object)userName);
                continue;
            }
            XUserInfo curUser = this.userCache.get(userName);
            String curSyncSource = curUser.getSyncSource();
            String curUserAttrsStr = curUser.getOtherAttributes();
            Map curUserAttrs = curUser.getOtherAttrsMap();
            String curUserDN = MapUtils.isEmpty((Map)curUserAttrs) ? userName : (String)curUserAttrs.get("full_name");
            String newSyncSource = newUserAttrs.get("sync_source");
            if (this.isStartupFlag && !this.isSyncSourceValidationEnabled && !StringUtils.equalsIgnoreCase((String)curSyncSource, (String)newSyncSource)) {
                LOG.debug("[{}]: SyncSource updated to {}, previous value: {}", new Object[]{userName, newSyncSource, curSyncSource});
                curUser = this.setOtherAttributes(curUser, newSyncSource, newUserAttrs, newUserAttrsStr);
                curUser.setUserSource("1");
                this.deltaUsers.put(userName, curUser);
                ++this.noOfModifiedGroups;
                this.userNameMap.put(userDN, userName);
                continue;
            }
            if (MapUtils.isNotEmpty((Map)curUserAttrs) && !StringUtils.equalsIgnoreCase((String)userDN, (String)curUserDN)) {
                LOG.debug("[{}]: SyncSource update skipped, current user DN = {} new user DN  = {}", new Object[]{userName, curUserDN, userDN});
                if (!StringUtils.equalsIgnoreCase((String)curUserAttrsStr, (String)newUserAttrsStr)) continue;
                this.userNameMap.put(userDN, userName);
                continue;
            }
            if (StringUtils.isEmpty((String)curSyncSource) || !StringUtils.equalsIgnoreCase((String)curUserAttrsStr, (String)newUserAttrsStr) && StringUtils.equalsIgnoreCase((String)curSyncSource, (String)newSyncSource)) {
                if (StringUtils.isEmpty((String)curSyncSource)) {
                    LOG.debug("[{}]: SyncSource updated to {}, previously empty", (Object)userName, (Object)newSyncSource);
                } else {
                    LOG.debug("[{}]: Other Attributes updated!", (Object)userName);
                }
                curUser = this.setOtherAttributes(curUser, newSyncSource, newUserAttrs, newUserAttrsStr);
                curUser.setUserSource("1");
                this.deltaUsers.put(userName, curUser);
                ++this.noOfModifiedUsers;
                this.userNameMap.put(userDN, userName);
            } else if (!StringUtils.equalsIgnoreCase((String)curSyncSource, (String)newSyncSource)) {
                LOG.debug("[{}]: Different sync source exists, update skipped!", (Object)userName);
            } else {
                LOG.debug("[{}]: No change, update skipped!", (Object)userName);
            }
            if (!StringUtils.equalsIgnoreCase((String)curUserAttrsStr, (String)newUserAttrsStr)) continue;
            this.userNameMap.put(userDN, userName);
        }
        LOG.debug("<== PolicyMgrUserGroupBuilder.computeUserDelta({})", this.deltaUsers.keySet());
    }

    private List<GroupUserInfo> computeGroupUsersDelta(Map<String, Set<String>> sourceGroupUsers) {
        LOG.debug("==> PolicyMgrUserGroupBuilder.computeGroupUsersDelta({})", sourceGroupUsers.keySet());
        this.deltaGroupUsers = new HashMap<String, Set<String>>();
        ArrayList<GroupUserInfo> deltaGroupUserInfoList = new ArrayList<GroupUserInfo>();
        for (String groupDN : sourceGroupUsers.keySet()) {
            String groupName = this.groupNameMap.get(groupDN);
            if (StringUtils.isEmpty((String)groupName)) {
                LOG.debug("Ignoring group membership update for {}", (Object)groupDN);
                continue;
            }
            HashSet oldUsers = new HashSet();
            HashSet<String> newUsers = new HashSet<String>();
            HashSet<String> addUsers = new HashSet<String>();
            HashSet<String> delUsers = new HashSet<String>();
            if (CollectionUtils.isNotEmpty((Collection)this.groupUsersCache.get(groupName))) {
                oldUsers = new HashSet(this.groupUsersCache.get(groupName));
            }
            for (String userDN : sourceGroupUsers.get(groupDN)) {
                String userName = this.userNameMap.get(userDN);
                if (StringUtils.isEmpty((String)userName)) continue;
                newUsers.add(userName);
                if (!CollectionUtils.isEmpty(oldUsers) && oldUsers.contains(userName)) continue;
                addUsers.add(userName);
            }
            if (CollectionUtils.isNotEmpty(oldUsers)) {
                for (String userName : oldUsers) {
                    if (!CollectionUtils.isEmpty(newUsers) && newUsers.contains(userName)) continue;
                    delUsers.add(userName);
                }
            }
            if (!CollectionUtils.isNotEmpty(addUsers) && !CollectionUtils.isNotEmpty(delUsers)) continue;
            GroupUserInfo groupUserInfo = new GroupUserInfo();
            groupUserInfo.setGroupName(groupName);
            if (CollectionUtils.isNotEmpty(addUsers)) {
                groupUserInfo.setAddUsers(addUsers);
                if (this.groupMap.containsKey(groupName) || this.whiteListGroupMap.containsKey(groupName)) {
                    this.computeRolesForUsers.addAll(addUsers);
                }
            }
            if (CollectionUtils.isNotEmpty(delUsers)) {
                groupUserInfo.setDelUsers(delUsers);
                if (this.groupMap.containsKey(groupName) || this.whiteListGroupMap.containsKey(groupName)) {
                    this.computeRolesForUsers.addAll(delUsers);
                }
            }
            deltaGroupUserInfoList.add(groupUserInfo);
            this.deltaGroupUsers.put(groupName, newUsers);
        }
        if (CollectionUtils.isNotEmpty(deltaGroupUserInfoList)) {
            LOG.debug("<== PolicyMgrUserGroupBuilder.computeGroupUsersDelta({})", deltaGroupUserInfoList);
        } else {
            LOG.debug("<== PolicyMgrUserGroupBuilder.computeGroupUsersDelta(0)");
        }
        return deltaGroupUserInfoList;
    }

    private XUserInfo addXUserInfo(String aUserName, Map<String, String> otherAttrsMap, String otherAttributes) {
        XUserInfo xuserInfo = new XUserInfo();
        xuserInfo.setName(aUserName);
        xuserInfo.setFirstName(aUserName);
        xuserInfo.setDescription(aUserName + " - add from Unix box");
        xuserInfo.setUserSource("1");
        xuserInfo.setStatus("1");
        xuserInfo.setIsVisible("1");
        ArrayList<String> roleList = new ArrayList<String>();
        roleList.add(this.userMap.getOrDefault(aUserName, "ROLE_USER"));
        xuserInfo.setUserRoleList(roleList);
        xuserInfo.setOtherAttributes(otherAttributes);
        xuserInfo.setSyncSource(otherAttrsMap.get("sync_source"));
        xuserInfo.setOtherAttrsMap(otherAttrsMap);
        return xuserInfo;
    }

    private XGroupInfo addXGroupInfo(String aGroupName, Map<String, String> otherAttrsMap, String otherAttributes) {
        XGroupInfo addGroup = new XGroupInfo();
        addGroup.setName(aGroupName);
        addGroup.setDescription(aGroupName + " - add from Unix box");
        addGroup.setGroupType("1");
        addGroup.setIsVisible("1");
        addGroup.setGroupSource("1");
        addGroup.setOtherAttributes(otherAttributes);
        addGroup.setSyncSource(otherAttrsMap.get("sync_source"));
        addGroup.setOtherAttrsMap(otherAttrsMap);
        return addGroup;
    }

    private int addOrUpdateDeltaUsers() throws Throwable {
        int ret;
        LOG.debug("PolicyMgrUserGroupBuilder.addOrUpdateDeltaUsers({})", this.deltaUsers.keySet());
        GetXUserListResponse xUserList = new GetXUserListResponse();
        xUserList.setTotalCount(this.deltaUsers.size());
        xUserList.setXuserInfoList(new ArrayList<XUserInfo>(this.deltaUsers.values()));
        if (AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab)) {
            try {
                Subject sub = SecureClientLogin.loginUserFromKeytab((String)this.principal, (String)this.keytab, (String)this.nameRules);
                GetXUserListResponse xUserListFinal = xUserList;
                ret = Subject.doAs(sub, () -> {
                    try {
                        return this.getUsers(xUserListFinal);
                    }
                    catch (Throwable e) {
                        LOG.error("Failed to add or update Users : ", e);
                        return 0;
                    }
                });
            }
            catch (Exception e) {
                LOG.error("Failed to add or update Users : ", (Throwable)e);
                throw e;
            }
        } else {
            ret = this.getUsers(xUserList);
        }
        LOG.debug("PolicyMgrUserGroupBuilder.addOrUpdateDeltaUsers({})", this.deltaUsers.keySet());
        return ret;
    }

    private int getUsers(GetXUserListResponse xUserList) throws Throwable {
        LOG.debug("==> PolicyMgrUserGroupBuilder.getUsers()");
        int ret = 0;
        int totalCount = xUserList.getTotalCount();
        int uploadedCount = 0;
        int pageSize = Integer.parseInt(this.recordsToPullPerCall);
        while (uploadedCount < totalCount) {
            this.checkStatus();
            GetXUserListResponse pagedXUserList = new GetXUserListResponse();
            int pagedXUserListLen = uploadedCount + pageSize;
            pagedXUserList.setXuserInfoList(xUserList.getXuserInfoList().subList(uploadedCount, pagedXUserListLen > totalCount ? totalCount : pagedXUserListLen));
            pagedXUserList.setTotalCount(pageSize);
            if (pagedXUserList.getXuserInfoList().isEmpty()) {
                LOG.info("PolicyMgrUserGroupBuilder.getUsers() done updating users");
                return 1;
            }
            String response = this.getDataFromLdap(PM_ADD_USERS_URI, pagedXUserList);
            if (StringUtils.isNotEmpty((String)response)) {
                try {
                    ret = Integer.parseInt(response);
                }
                catch (NumberFormatException e) {
                    LOG.error("Failed to addOrUpdateUsers {}", (Object)uploadedCount, (Object)e);
                    throw e;
                }
            } else {
                LOG.error("Failed to addOrUpdateUsers {}", (Object)uploadedCount);
                throw new Exception("Failed to addOrUpdateUsers" + uploadedCount);
            }
            LOG.info("API returned: {}, No. of users uploaded to ranger admin = {}", (Object)ret, (Object)((uploadedCount += pageSize) > totalCount ? totalCount : uploadedCount));
        }
        LOG.debug("<== PolicyMgrUserGroupBuilder.getUsers()");
        return ret;
    }

    private String getDataFromLdap(String uri, Object pagedList) throws Exception {
        String response = null;
        if (this.isRangerCookieEnabled) {
            response = this.cookieBasedUploadEntity(pagedList, uri);
        } else {
            try {
                ClientResponse clientRes = this.ldapUgSyncClient.post(uri, null, pagedList);
                if (clientRes != null) {
                    response = (String)clientRes.getEntity(String.class);
                }
            }
            catch (Throwable t) {
                LOG.error("Failed to get response, Error is : ", t);
                throw t;
            }
        }
        LOG.debug("REST response from {} : {}", (Object)uri, (Object)response);
        return response;
    }

    private int addOrUpdateDeltaGroups() throws Throwable {
        int ret;
        LOG.debug("PolicyMgrUserGroupBuilder.addOrUpdateDeltaGroups({})", this.deltaGroups.keySet());
        GetXGroupListResponse xGroupList = new GetXGroupListResponse();
        xGroupList.setTotalCount(this.deltaGroups.size());
        xGroupList.setXgroupInfoList(new ArrayList<XGroupInfo>(this.deltaGroups.values()));
        if (AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab)) {
            try {
                Subject sub = SecureClientLogin.loginUserFromKeytab((String)this.principal, (String)this.keytab, (String)this.nameRules);
                GetXGroupListResponse xGroupListFinal = xGroupList;
                ret = Subject.doAs(sub, () -> {
                    try {
                        return this.getGroups(xGroupListFinal);
                    }
                    catch (Throwable e) {
                        LOG.error("Failed to add or update groups : ", e);
                        return 0;
                    }
                });
            }
            catch (Exception e) {
                LOG.error("Failed to add or update groups : ", (Throwable)e);
                throw e;
            }
        } else {
            ret = this.getGroups(xGroupList);
        }
        LOG.debug("PolicyMgrUserGroupBuilder.addOrUpdateDeltaGroups({})", this.deltaGroups.keySet());
        return ret;
    }

    private int getGroups(GetXGroupListResponse xGroupList) throws Throwable {
        LOG.debug("==> PolicyMgrUserGroupBuilder.getGroups()");
        int ret = 0;
        int totalCount = xGroupList.getTotalCount();
        int uploadedCount = 0;
        int pageSize = Integer.parseInt(this.recordsToPullPerCall);
        while (uploadedCount < totalCount) {
            this.checkStatus();
            GetXGroupListResponse pagedXGroupList = new GetXGroupListResponse();
            int pagedXGroupListLen = uploadedCount + pageSize;
            pagedXGroupList.setXgroupInfoList(xGroupList.getXgroupInfoList().subList(uploadedCount, pagedXGroupListLen > totalCount ? totalCount : pagedXGroupListLen));
            pagedXGroupList.setTotalCount(pageSize);
            String response = this.getDataFromLdap(PM_ADD_GROUPS_URI, pagedXGroupList);
            if (StringUtils.isNotEmpty((String)response)) {
                try {
                    ret = Integer.parseInt(response);
                }
                catch (NumberFormatException e) {
                    LOG.error("Failed to addOrUpdateGroups {}", (Object)uploadedCount, (Object)e);
                    throw e;
                }
            } else {
                LOG.error("Failed to addOrUpdateGroups {}", (Object)uploadedCount);
                throw new Exception("Failed to addOrUpdateGroups " + uploadedCount);
            }
            LOG.info("API returned: {}, No. of groups uploaded to ranger admin = {}", (Object)ret, (Object)((uploadedCount += pageSize) > totalCount ? totalCount : uploadedCount));
        }
        LOG.debug("<== PolicyMgrUserGroupBuilder.getGroups()");
        return ret;
    }

    private int addOrUpdateDeltaGroupUsers(List<GroupUserInfo> groupUserInfoList) throws Throwable {
        int ret;
        LOG.debug("==> PolicyMgrUserGroupBuilder.addOrUpdateDeltaGroupUsers({})", groupUserInfoList);
        if (AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab)) {
            try {
                Subject sub = SecureClientLogin.loginUserFromKeytab((String)this.principal, (String)this.keytab, (String)this.nameRules);
                List<GroupUserInfo> groupUserInfoListFinal = groupUserInfoList;
                ret = Subject.doAs(sub, () -> {
                    try {
                        return this.getGroupUsers(groupUserInfoListFinal);
                    }
                    catch (Throwable e) {
                        LOG.error("Failed to add or update group memberships : ", e);
                        return 0;
                    }
                });
            }
            catch (Exception e) {
                LOG.error("Failed to add or update group memberships : ", (Throwable)e);
                throw e;
            }
        } else {
            ret = this.getGroupUsers(groupUserInfoList);
        }
        LOG.debug("<== PolicyMgrUserGroupBuilder.addOrUpdateDeltaGroupUsers({})", groupUserInfoList);
        return ret;
    }

    private int getGroupUsers(List<GroupUserInfo> groupUserInfoList) throws Throwable {
        LOG.debug("==> PolicyMgrUserGroupBuilder.getGroupUsers()");
        int ret = 0;
        int totalCount = groupUserInfoList.size();
        int uploadedCount = 0;
        int pageSize = Integer.parseInt(this.recordsToPullPerCall);
        while (uploadedCount < totalCount) {
            this.checkStatus();
            int pagedGroupUserInfoListLen = uploadedCount + pageSize;
            List<GroupUserInfo> pagedGroupUserInfoList = groupUserInfoList.subList(uploadedCount, pagedGroupUserInfoListLen > totalCount ? totalCount : pagedGroupUserInfoListLen);
            String response = this.getDataFromLdap("/service/xusers/ugsync/groupusers", pagedGroupUserInfoList);
            if (StringUtils.isNotEmpty((String)response)) {
                try {
                    ret = Integer.parseInt(response);
                }
                catch (NumberFormatException e) {
                    LOG.error("Failed to addOrUpdateGroupUsers {}", (Object)uploadedCount, (Object)e);
                    throw e;
                }
            } else {
                LOG.error("Failed to addOrUpdateGroupUsers {}", (Object)uploadedCount);
                throw new Exception("Failed to addOrUpdateGroupUsers " + uploadedCount);
            }
            LOG.info("API returned: {}, No. of group memberships uploaded to ranger admin = {}", (Object)ret, (Object)((uploadedCount += pageSize) > totalCount ? totalCount : uploadedCount));
        }
        LOG.debug("<== PolicyMgrUserGroupBuilder.getGroupUsers()");
        return ret;
    }

    private String updateRoles(UsersGroupRoleAssignments ugRoleAssignments) {
        LOG.debug("==> PolicyMgrUserGroupBuilder.updateUserRole({})", (Object)ugRoleAssignments.getUsers());
        if (AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab)) {
            try {
                Subject sub = SecureClientLogin.loginUserFromKeytab((String)this.principal, (String)this.keytab, (String)this.nameRules);
                UsersGroupRoleAssignments result = ugRoleAssignments;
                return Subject.doAs(sub, () -> {
                    try {
                        return this.updateUsersRoles(result);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to add User Group Info: ", (Throwable)e);
                        return null;
                    }
                });
            }
            catch (Exception e) {
                LOG.error("Failed to Authenticate Using given Principal and Keytab : ", (Throwable)e);
                return null;
            }
        }
        return this.updateUsersRoles(ugRoleAssignments);
    }

    private String updateUsersRoles(UsersGroupRoleAssignments ugRoleAssignments) {
        LOG.debug("==> PolicyMgrUserGroupBuilder.updateUserRoles({})", (Object)ugRoleAssignments.getUsers());
        String response = null;
        try {
            int totalCount = ugRoleAssignments.getUsers().size();
            int pageSize = Integer.parseInt(this.recordsToPullPerCall);
            for (int uploadedCount = 0; uploadedCount < totalCount; uploadedCount += pageSize) {
                this.checkStatus();
                int pagedUgRoleAssignmentsListLen = uploadedCount + pageSize;
                UsersGroupRoleAssignments pagedUgRoleAssignmentsList = new UsersGroupRoleAssignments();
                pagedUgRoleAssignmentsList.setUsers(ugRoleAssignments.getUsers().subList(uploadedCount, pagedUgRoleAssignmentsListLen > totalCount ? totalCount : pagedUgRoleAssignmentsListLen));
                pagedUgRoleAssignmentsList.setGroupRoleAssignments(ugRoleAssignments.getGroupRoleAssignments());
                pagedUgRoleAssignmentsList.setUserRoleAssignments(ugRoleAssignments.getUserRoleAssignments());
                pagedUgRoleAssignmentsList.setWhiteListGroupRoleAssignments(ugRoleAssignments.getWhiteListGroupRoleAssignments());
                pagedUgRoleAssignmentsList.setWhiteListUserRoleAssignments(ugRoleAssignments.getWhiteListUserRoleAssignments());
                pagedUgRoleAssignmentsList.setReset(ugRoleAssignments.isReset());
                if (uploadedCount + pageSize >= totalCount) {
                    pagedUgRoleAssignmentsList.setLastPage(true);
                }
                String url = PM_UPDATE_USERS_ROLES_URI;
                String jsonString = JsonUtils.objectToJson((Object)pagedUgRoleAssignmentsList);
                LOG.debug("Paged RoleAssignments Request to {}: {}", (Object)url, (Object)jsonString);
                if (this.isRangerCookieEnabled) {
                    response = this.cookieBasedUploadEntity(pagedUgRoleAssignmentsList, url);
                } else {
                    try {
                        ClientResponse clientRes = this.ldapUgSyncClient.post(url, null, ugRoleAssignments);
                        if (clientRes != null) {
                            response = (String)clientRes.getEntity(String.class);
                        }
                    }
                    catch (Throwable t) {
                        LOG.error("Failed to get response: ", t);
                    }
                }
                LOG.debug("REST response from {} : {}", (Object)url, (Object)response);
                if (response != null) continue;
                throw new RuntimeException("Failed to get a REST response!");
            }
        }
        catch (Exception e) {
            LOG.error("Unable to update roles for: {}", (Object)ugRoleAssignments.getUsers(), (Object)e);
            response = null;
        }
        LOG.debug("<== PolicyMgrUserGroupBuilder.updateUserRoles({})", response);
        return response;
    }

    private void addUserGroupAuditInfo(UgsyncAuditInfo auditInfo) {
        LOG.debug("==> PolicyMgrUserGroupBuilder.addUserGroupAuditInfo({}, {}, {}, {}, {})", new Object[]{auditInfo.getNoOfNewUsers(), auditInfo.getNoOfNewGroups(), auditInfo.getNoOfModifiedUsers(), auditInfo.getNoOfModifiedGroups(), auditInfo.getSyncSource()});
        if (AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab)) {
            try {
                Subject sub = SecureClientLogin.loginUserFromKeytab((String)this.principal, (String)this.keytab, (String)this.nameRules);
                UgsyncAuditInfo auditInfoFinal = auditInfo;
                Subject.doAs(sub, () -> {
                    try {
                        this.getUserGroupAuditInfo(auditInfoFinal);
                    }
                    catch (Throwable e) {
                        LOG.error("Failed to add User : ", e);
                    }
                    return null;
                });
            }
            catch (Exception e) {
                LOG.error("Failed to Authenticate Using given Principal and Keytab : ", (Throwable)e);
            }
        } else {
            this.getUserGroupAuditInfo(auditInfo);
        }
    }

    private void getUserGroupAuditInfo(UgsyncAuditInfo userInfo) {
        LOG.debug("==> PolicyMgrUserGroupBuilder.getUserGroupAuditInfo()");
        this.checkStatus();
        String response = null;
        if (this.isRangerCookieEnabled) {
            response = this.cookieBasedUploadEntity(userInfo, PM_AUDIT_INFO_URI);
        } else {
            try {
                ClientResponse clientRes = this.ldapUgSyncClient.post(PM_AUDIT_INFO_URI, null, userInfo);
                if (clientRes != null) {
                    response = (String)clientRes.getEntity(String.class);
                }
            }
            catch (Throwable t) {
                LOG.error("Failed to get response, Error is : ", t);
            }
        }
        LOG.debug("REST response from {} : {}", (Object)PM_AUDIT_INFO_URI, (Object)response);
        JsonUtils.jsonToObject((String)response, UgsyncAuditInfo.class);
        LOG.debug("AuditInfo Creation successful ");
        LOG.debug("<== PolicyMgrUserGroupBuilder.getUserGroupAuditInfo()");
    }

    private String cookieBasedUploadEntity(Object obj, String apiURL) {
        LOG.debug("==> PolicyMgrUserGroupBuilder.cookieBasedUploadEntity()");
        String response = this.sessionId != null && this.isValidRangerCookie ? this.tryUploadEntityWithCookie(obj, apiURL) : this.tryUploadEntityWithCred(obj, apiURL);
        LOG.debug("<== PolicyMgrUserGroupBuilder.cookieBasedUploadEntity()");
        return response;
    }

    private String cookieBasedGetEntity(String apiURL, int retrievedCount) {
        LOG.debug("==> PolicyMgrUserGroupBuilder.cookieBasedGetEntity()");
        String response = this.sessionId != null && this.isValidRangerCookie ? this.tryGetEntityWithCookie(apiURL, retrievedCount) : this.tryGetEntityWithCred(apiURL, retrievedCount);
        LOG.debug("<== PolicyMgrUserGroupBuilder.cookieBasedGetEntity()");
        return response;
    }

    private String tryUploadEntityWithCookie(Object obj, String apiURL) {
        LOG.debug("==> PolicyMgrUserGroupBuilder.tryUploadEntityWithCookie()");
        String response = null;
        ClientResponse clientResp = null;
        try {
            clientResp = this.ldapUgSyncClient.post(apiURL, null, obj, this.sessionId);
        }
        catch (Throwable t) {
            LOG.error("Failed to get response, Error is : ", t);
        }
        if (clientResp != null) {
            if (!clientResp.toString().contains(apiURL)) {
                clientResp.setStatus(404);
                this.sessionId = null;
                this.isValidRangerCookie = false;
            } else if (clientResp.getStatus() == 401) {
                this.sessionId = null;
                this.isValidRangerCookie = false;
            } else if (clientResp.getStatus() == 204 || clientResp.getStatus() == 200) {
                List respCookieList = clientResp.getCookies();
                for (NewCookie cookie : respCookieList) {
                    if (!cookie.getName().equalsIgnoreCase(this.rangerCookieName)) continue;
                    if (!this.sessionId.getValue().equalsIgnoreCase(cookie.toCookie().getValue())) {
                        this.sessionId = cookie.toCookie();
                    }
                    this.isValidRangerCookie = true;
                    break;
                }
            }
            if (clientResp.getStatus() != 200 && clientResp.getStatus() != 204 && clientResp.getStatus() != 400) {
                this.sessionId = null;
                this.isValidRangerCookie = false;
            }
            clientResp.bufferEntity();
            response = (String)clientResp.getEntity(String.class);
        }
        LOG.debug("<== PolicyMgrUserGroupBuilder.tryUploadEntityWithCookie()");
        return response;
    }

    private String tryUploadEntityWithCred(Object obj, String apiURL) {
        LOG.debug("==> PolicyMgrUserGroupBuilder.tryUploadEntityInfoWithCred()");
        String response = null;
        ClientResponse clientResp = null;
        String jsonString = JsonUtils.objectToJson((Object)obj);
        LOG.debug("User Group Mapping: {}", (Object)jsonString);
        try {
            clientResp = this.ldapUgSyncClient.post(apiURL, null, obj);
        }
        catch (Throwable t) {
            LOG.error("Failed to get response, Error is : ", t);
        }
        if (clientResp != null) {
            if (!clientResp.toString().contains(apiURL)) {
                clientResp.setStatus(404);
            } else if (clientResp.getStatus() == 401) {
                LOG.warn("Credentials response from ranger is 401.");
            } else if (clientResp.getStatus() == 200 || clientResp.getStatus() == 204) {
                this.cookieList = clientResp.getCookies();
                for (NewCookie cookie : this.cookieList) {
                    if (!cookie.getName().equalsIgnoreCase(this.rangerCookieName)) continue;
                    this.sessionId = cookie.toCookie();
                    this.isValidRangerCookie = true;
                    LOG.info("valid cookie saved ");
                    break;
                }
            }
            if (clientResp.getStatus() != 200 && clientResp.getStatus() != 204 && clientResp.getStatus() != 400) {
                this.sessionId = null;
                this.isValidRangerCookie = false;
            }
            clientResp.bufferEntity();
            response = (String)clientResp.getEntity(String.class);
        }
        LOG.debug("<== PolicyMgrUserGroupBuilder.tryUploadEntityInfoWithCred()");
        return response;
    }

    private String tryGetEntityWithCred(String apiURL, int retrievedCount) {
        LOG.debug("==> PolicyMgrUserGroupBuilder.tryGetEntityWithCred()");
        String response = null;
        ClientResponse clientResp = null;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("pageSize", this.recordsToPullPerCall);
        queryParams.put("startIndex", String.valueOf(retrievedCount));
        try {
            clientResp = this.ldapUgSyncClient.get(apiURL, queryParams);
        }
        catch (Throwable t) {
            LOG.error("Failed to get response, Error is : ", t);
        }
        if (clientResp != null) {
            if (!clientResp.toString().contains(apiURL)) {
                clientResp.setStatus(404);
            } else if (clientResp.getStatus() == 401) {
                LOG.warn("Credentials response from ranger is 401.");
            } else if (clientResp.getStatus() == 200 || clientResp.getStatus() == 204) {
                this.cookieList = clientResp.getCookies();
                for (NewCookie cookie : this.cookieList) {
                    if (!cookie.getName().equalsIgnoreCase(this.rangerCookieName)) continue;
                    this.sessionId = cookie.toCookie();
                    this.isValidRangerCookie = true;
                    LOG.info("valid cookie saved ");
                    break;
                }
            }
            if (clientResp.getStatus() != 200 && clientResp.getStatus() != 204 && clientResp.getStatus() != 400) {
                this.sessionId = null;
                this.isValidRangerCookie = false;
            }
            clientResp.bufferEntity();
            response = (String)clientResp.getEntity(String.class);
        }
        LOG.debug("<== PolicyMgrUserGroupBuilder.tryGetEntityWithCred()");
        return response;
    }

    private String tryGetEntityWithCookie(String apiURL, int retrievedCount) {
        LOG.debug("==> PolicyMgrUserGroupBuilder.tryGetEntityWithCookie()");
        String response = null;
        ClientResponse clientResp = null;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("pageSize", this.recordsToPullPerCall);
        queryParams.put("startIndex", String.valueOf(retrievedCount));
        try {
            clientResp = this.ldapUgSyncClient.get(apiURL, queryParams, this.sessionId);
        }
        catch (Throwable t) {
            LOG.error("Failed to get response, Error is : ", t);
        }
        if (clientResp != null) {
            if (!clientResp.toString().contains(apiURL)) {
                clientResp.setStatus(404);
                this.sessionId = null;
                this.isValidRangerCookie = false;
            } else if (clientResp.getStatus() == 401) {
                this.sessionId = null;
                this.isValidRangerCookie = false;
            } else if (clientResp.getStatus() == 204 || clientResp.getStatus() == 200) {
                List respCookieList = clientResp.getCookies();
                for (NewCookie cookie : respCookieList) {
                    if (!cookie.getName().equalsIgnoreCase(this.rangerCookieName)) continue;
                    if (!this.sessionId.getValue().equalsIgnoreCase(cookie.toCookie().getValue())) {
                        this.sessionId = cookie.toCookie();
                    }
                    this.isValidRangerCookie = true;
                    break;
                }
            }
            if (clientResp.getStatus() != 200 && clientResp.getStatus() != 204 && clientResp.getStatus() != 400) {
                this.sessionId = null;
                this.isValidRangerCookie = false;
            }
            clientResp.bufferEntity();
            response = (String)clientResp.getEntity(String.class);
        }
        LOG.debug("<== PolicyMgrUserGroupBuilder.tryGetEntityWithCookie()");
        return response;
    }

    private void getRoleForUserGroups(String userGroupRolesData, Map<String, String> userMap, Map<String, String> groupMap) {
        LOG.debug("==>> getRoleForUserGroups({})", (Object)userGroupRolesData);
        LinkedHashMap<String, String> reverseGroupMap = new LinkedHashMap<String, String>();
        String roleDelimiter = this.config.getRoleDelimiter();
        String userGroupDelimiter = this.config.getUserGroupDelimiter();
        String userNameDelimiter = this.config.getUserGroupNameDelimiter();
        roleDelimiter = StringUtils.isEmpty((String)roleDelimiter) ? "&" : roleDelimiter;
        userGroupDelimiter = StringUtils.isEmpty((String)userGroupDelimiter) ? ":" : userGroupDelimiter;
        userNameDelimiter = StringUtils.isEmpty((String)userNameDelimiter) ? "," : userNameDelimiter;
        StringTokenizer str = new StringTokenizer(userGroupRolesData, roleDelimiter);
        String userGroupCheck = null;
        String roleName = null;
        while (str.hasMoreTokens()) {
            StringTokenizer userGroupRoles;
            int flag = 0;
            String tokens = str.nextToken();
            if (!StringUtils.isNotEmpty((String)tokens) || (userGroupRoles = new StringTokenizer(tokens, userGroupDelimiter)) == null) continue;
            block6: while (userGroupRoles.hasMoreElements()) {
                String userGroupRolesTokens = userGroupRoles.nextToken();
                if (!StringUtils.isNotEmpty((String)userGroupRolesTokens)) continue;
                switch (++flag) {
                    case 1: {
                        roleName = userGroupRolesTokens;
                        continue block6;
                    }
                    case 2: {
                        userGroupCheck = userGroupRolesTokens;
                        continue block6;
                    }
                    case 3: {
                        StringTokenizer userGroupNames = new StringTokenizer(userGroupRolesTokens, userNameDelimiter);
                        if (userGroupNames == null) continue block6;
                        while (userGroupNames.hasMoreElements()) {
                            String userGroup = userGroupNames.nextToken();
                            if (!StringUtils.isNotEmpty((String)userGroup)) continue;
                            if (userGroupCheck.trim().equalsIgnoreCase("u")) {
                                userMap.put(userGroup.trim(), roleName.trim());
                                continue;
                            }
                            if (!userGroupCheck.trim().equalsIgnoreCase("g")) continue;
                            reverseGroupMap.put(userGroup.trim(), roleName.trim());
                        }
                        continue block6;
                    }
                }
                userMap.clear();
                reverseGroupMap.clear();
            }
        }
        if (MapUtils.isNotEmpty(reverseGroupMap)) {
            ArrayList groupNames = new ArrayList(reverseGroupMap.keySet());
            Collections.reverse(groupNames);
            groupNames.forEach(group -> groupMap.put((String)group, (String)reverseGroupMap.get(group)));
        }
    }

    private void updateDeletedGroups(Map<String, Map<String, String>> sourceGroups) throws Throwable {
        this.computeDeletedGroups(sourceGroups);
        if (MapUtils.isNotEmpty(this.deletedGroups) && this.updateDeletedGroups() == 0) {
            String msg = "Failed to update deleted groups to ranger admin";
            LOG.error(msg);
            throw new Exception(msg);
        }
        LOG.info("No. of groups marked for delete = {}", (Object)this.deletedGroups.size());
        this.noOfDeletedGroups += this.deletedGroups.size();
    }

    private void computeDeletedGroups(Map<String, Map<String, String>> sourceGroups) {
        LOG.debug("PolicyMgrUserGroupBuilder.computeDeletedGroups({})", sourceGroups.keySet());
        this.deletedGroups = new HashMap<String, XGroupInfo>();
        for (XGroupInfo groupInfo : this.groupCache.values()) {
            Map groupOtherAttrs = groupInfo.getOtherAttrsMap();
            String groupDN = groupOtherAttrs != null ? (String)groupOtherAttrs.get("full_name") : null;
            if (!StringUtils.isNotEmpty((String)groupDN) || sourceGroups.containsKey(groupDN) || !StringUtils.equalsIgnoreCase((String)((String)groupOtherAttrs.get("sync_source")), (String)this.currentSyncSource) || !StringUtils.equalsIgnoreCase((String)((String)groupOtherAttrs.get("ldap_url")), (String)this.ldapUrl)) continue;
            if (ISHIDDEN.equals(groupInfo.getIsVisible())) {
                groupInfo.setIsVisible(ISHIDDEN);
                this.deletedGroups.put(groupInfo.getName(), groupInfo);
                continue;
            }
            LOG.info("group {} already marked for delete", (Object)groupInfo.getName());
        }
        LOG.debug("<== PolicyMgrUserGroupBuilder.computeDeletedGroups({})", this.deletedGroups);
    }

    private int updateDeletedGroups() throws Throwable {
        int ret;
        LOG.debug("==> PolicyMgrUserGroupBuilder.updateDeletedGroups({})", this.deletedGroups);
        if (AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab)) {
            try {
                Subject sub = SecureClientLogin.loginUserFromKeytab((String)this.principal, (String)this.keytab, (String)this.nameRules);
                ret = Subject.doAs(sub, () -> {
                    try {
                        return this.getDeletedGroups();
                    }
                    catch (Throwable e) {
                        LOG.error("Failed to add or update deleted groups : ", e);
                        return 0;
                    }
                });
            }
            catch (Exception e) {
                LOG.error("Failed to add or update deleted groups : ", (Throwable)e);
                throw e;
            }
        } else {
            ret = this.getDeletedGroups();
        }
        LOG.debug("<== PolicyMgrUserGroupBuilder.updateDeletedGroups({})", this.deletedGroups);
        return ret;
    }

    private int getDeletedGroups() throws Throwable {
        int ret;
        LOG.debug("==> PolicyMgrUserGroupBuilder.getDeletedGroups()");
        this.checkStatus();
        String response = null;
        if (this.isRangerCookieEnabled) {
            response = this.cookieBasedUploadEntity(this.deletedGroups.keySet(), PM_UPDATE_DELETED_GROUPS_URI);
        } else {
            try {
                ClientResponse clientRes = this.ldapUgSyncClient.post(PM_UPDATE_DELETED_GROUPS_URI, null, this.deletedGroups.keySet());
                if (clientRes != null) {
                    response = (String)clientRes.getEntity(String.class);
                }
            }
            catch (Throwable t) {
                LOG.error("Failed to get response, Error is : ", t);
            }
        }
        LOG.debug("REST response from {} : {}", (Object)PM_UPDATE_DELETED_GROUPS_URI, (Object)response);
        if (response != null) {
            try {
                ret = Integer.parseInt(response);
            }
            catch (NumberFormatException e) {
                LOG.error("Failed to update deleted groups", (Throwable)e);
                throw e;
            }
        } else {
            LOG.error("Failed to update deleted groups ");
            throw new Exception("Failed to update deleted groups ");
        }
        LOG.debug("<== PolicyMgrUserGroupBuilder.getDeletedGroups({})", (Object)ret);
        return ret;
    }

    private void updateDeletedUsers(Map<String, Map<String, String>> sourceUsers) throws Throwable {
        this.computeDeletedUsers(sourceUsers);
        if (MapUtils.isNotEmpty(this.deletedUsers) && this.updateDeletedUsers() == 0) {
            String msg = "Failed to update deleted users to ranger admin";
            LOG.error(msg);
            throw new Exception(msg);
        }
        LOG.info("No. of users marked for delete = {}", (Object)this.deletedUsers.size());
        this.noOfDeletedUsers += this.deletedUsers.size();
    }

    private void computeDeletedUsers(Map<String, Map<String, String>> sourceUsers) {
        LOG.debug("PolicyMgrUserGroupBuilder.computeDeletedUsers({})", sourceUsers.keySet());
        this.deletedUsers = new HashMap<String, XUserInfo>();
        for (XUserInfo userInfo : this.userCache.values()) {
            Map userOtherAttrs = userInfo.getOtherAttrsMap();
            String userDN = userOtherAttrs != null ? (String)userOtherAttrs.get("full_name") : null;
            if (!StringUtils.isNotEmpty((String)userDN) || sourceUsers.containsKey(userDN) || !StringUtils.equalsIgnoreCase((String)((String)userOtherAttrs.get("sync_source")), (String)this.currentSyncSource) || !StringUtils.equalsIgnoreCase((String)((String)userOtherAttrs.get("ldap_url")), (String)this.ldapUrl)) continue;
            if (!ISHIDDEN.equals(userInfo.getIsVisible())) {
                userInfo.setIsVisible(ISHIDDEN);
                this.deletedUsers.put(userInfo.getName(), userInfo);
                continue;
            }
            LOG.info("user {} already marked for delete", (Object)userInfo.getName());
        }
        LOG.debug("<== PolicyMgrUserGroupBuilder.computeDeletedUsers({})", this.deletedUsers);
    }

    private int updateDeletedUsers() throws Throwable {
        int ret;
        LOG.debug("==> PolicyMgrUserGroupBuilder.updateDeletedUsers({})", this.deletedUsers);
        if (AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab)) {
            try {
                Subject sub = SecureClientLogin.loginUserFromKeytab((String)this.principal, (String)this.keytab, (String)this.nameRules);
                ret = Subject.doAs(sub, () -> {
                    try {
                        return this.getDeletedUsers();
                    }
                    catch (Throwable e) {
                        LOG.error("Failed to add or update deleted users : ", e);
                        return 0;
                    }
                });
            }
            catch (Exception e) {
                LOG.error("Failed to add or update deleted users : ", (Throwable)e);
                throw e;
            }
        } else {
            ret = this.getDeletedUsers();
        }
        LOG.debug("<== PolicyMgrUserGroupBuilder.updateDeletedUsers({})", this.deletedUsers);
        return ret;
    }

    private int getDeletedUsers() throws Throwable {
        int ret;
        LOG.debug("==> PolicyMgrUserGroupBuilder.getDeletedUsers()");
        this.checkStatus();
        String response = null;
        if (this.isRangerCookieEnabled) {
            response = this.cookieBasedUploadEntity(this.deletedUsers.keySet(), PM_UPDATE_DELETED_USERS_URI);
        } else {
            try {
                ClientResponse clientRes = this.ldapUgSyncClient.post(PM_UPDATE_DELETED_USERS_URI, null, this.deletedUsers.keySet());
                if (clientRes != null) {
                    response = (String)clientRes.getEntity(String.class);
                }
            }
            catch (Throwable t) {
                LOG.error("Failed to get response, Error is : ", t);
            }
        }
        LOG.debug("REST response from {} : {}", (Object)PM_UPDATE_DELETED_USERS_URI, (Object)response);
        if (response != null) {
            try {
                ret = Integer.parseInt(response);
            }
            catch (NumberFormatException e) {
                LOG.error("Failed to update deleted users", (Throwable)e);
                throw e;
            }
        } else {
            LOG.error("Failed to update deleted users ");
            throw new Exception("Failed to update deleted users ");
        }
        LOG.debug("<== PolicyMgrUserGroupBuilder.getDeletedUsers({})", (Object)ret);
        return ret;
    }

    private void checkStatus() {
        if (!UserGroupSyncConfig.isUgsyncServiceActive()) {
            LOG.error(ERR_MSG_FOR_INACTIVE_SERVER);
            throw new RuntimeException(ERR_MSG_FOR_INACTIVE_SERVER);
        }
    }

    static {
        try {
            localHostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            localHostname = "unknown";
        }
    }
}

