/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.unixusersync.ha;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.RangerHAInitializer;
import org.apache.ranger.ha.ActiveInstanceElectorService;
import org.apache.ranger.ha.ActiveStateChangeHandler;
import org.apache.ranger.ha.ServiceState;
import org.apache.ranger.ha.service.HARangerService;
import org.apache.ranger.ha.service.ServiceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSyncHAInitializerImpl
extends RangerHAInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(UserSyncHAInitializerImpl.class);
    private static UserSyncHAInitializerImpl theInstance;
    ActiveInstanceElectorService activeInstanceElectorService;
    ActiveStateChangeHandler activeStateChangeHandler;
    List<HARangerService> haRangerService;
    ServiceManager serviceManager;

    private UserSyncHAInitializerImpl(Configuration configuration) {
        LOG.debug("==> UserSyncHAInitializerImpl.UserSyncHAInitializerImpl()");
        try {
            LOG.info("Ranger UserSync server is HA enabled : {}", (Object)configuration.getBoolean("ranger-ugsync.server.ha.enabled", false));
            this.init(configuration);
        }
        catch (Exception e) {
            LOG.error("UserSyncHAInitializerImpl initialization failed {}", (Object)e.getMessage());
        }
        LOG.info("<== UserSyncHAInitializerImpl.UserSyncHAInitializerImpl()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UserSyncHAInitializerImpl getInstance(Configuration configuration) {
        UserSyncHAInitializerImpl me = theInstance;
        if (me != null) return me;
        Class<UserSyncHAInitializerImpl> clazz = UserSyncHAInitializerImpl.class;
        synchronized (UserSyncHAInitializerImpl.class) {
            me = theInstance;
            if (me != null) return me;
            theInstance = me = new UserSyncHAInitializerImpl(configuration);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return me;
        }
    }

    public void init(Configuration configuration) throws Exception {
        super.init(configuration);
        LOG.info("==> UserSyncHAInitializerImpl.init() initialization started ");
        HashSet activeStateChangeHandlerProviders = new HashSet();
        this.activeInstanceElectorService = new ActiveInstanceElectorService(activeStateChangeHandlerProviders, this.curatorFactory, this.activeInstanceState, this.serviceState, configuration);
        this.haRangerService = new ArrayList<HARangerService>();
        this.haRangerService.add((HARangerService)this.activeInstanceElectorService);
        this.serviceManager = new ServiceManager(this.haRangerService);
        LOG.info("<== UserSyncHAInitializerImpl.init() initialization completed.");
    }

    public void stop() {
        LOG.debug("==> UserSyncHAInitializerImpl.stop()");
        if (this.serviceManager != null) {
            this.serviceManager.stop();
        }
        if (this.curatorFactory != null) {
            this.curatorFactory.close();
        }
        LOG.debug("<== UserSyncHAInitializerImpl.stop()");
    }

    public boolean isActive() {
        try {
            Thread.sleep(0L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.serviceState.getState().equals((Object)ServiceState.ServiceStateValue.ACTIVE);
    }
}

