/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.ldapusersync.process;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.Rdn;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.HashBasedTable;
import org.apache.hadoop.thirdparty.com.google.common.collect.Table;
import org.apache.ranger.ldapusersync.process.CustomSSLSocketFactory;
import org.apache.ranger.ugsyncutil.model.LdapSyncSourceInfo;
import org.apache.ranger.ugsyncutil.model.UgsyncAuditInfo;
import org.apache.ranger.unixusersync.config.UserGroupSyncConfig;
import org.apache.ranger.usergroupsync.UserGroupSink;
import org.apache.ranger.usergroupsync.UserGroupSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapUserGroupBuilder
implements UserGroupSource {
    private static final Logger LOG = LoggerFactory.getLogger(LdapUserGroupBuilder.class);
    private static final String DATA_TYPE_BYTEARRAY = "byte[]";
    private static final String DATE_FORMAT = "yyyyMMddHHmmss";
    private static final String MEMBER_OF_ATTR = "memberof=";
    private static final String GROUP_NAME_ATTRIBUTE = "cn=";
    private static final int PAGE_SIZE = 500;
    private static long deltaSyncUserTime;
    private static long deltaSyncGroupTime;
    private final UserGroupSyncConfig config = UserGroupSyncConfig.getInstance();
    private boolean pagedResultsEnabled = true;
    private boolean groupSearchFirstEnabled = true;
    private boolean userSearchEnabled = true;
    private boolean groupSearchEnabled = true;
    private int pagedResultsSize = 500;
    private int groupHierarchyLevels;
    private int deleteCycles;
    private int userSearchScope;
    private int groupSearchScope;
    private String deltaSyncUserTimeStamp;
    private String deltaSyncGroupTimeStamp;
    private String ldapUrl;
    private String ldapBindDn;
    private String ldapBindPassword;
    private String ldapAuthenticationMechanism;
    private String ldapReferral;
    private String searchBase;
    private String userNameAttribute;
    private String userCloudIdAttribute;
    private String userObjectClass;
    private String userSearchFilter;
    private String extendedUserSearchFilter;
    private String groupObjectClass;
    private String groupSearchFilter;
    private String extendedGroupSearchFilter;
    private String extendedAllGroupsSearchFilter;
    private String groupMemberAttributeName;
    private String groupNameAttribute;
    private String groupCloudIdAttribute;
    private String currentSyncSource;
    private String[] userSearchBase;
    private String[] groupSearchBase;
    private Set<String> groupNameSet;
    private Set<String> userGroupNameAttributeSet;
    private Set<String> otherUserAttributes;
    private Set<String> otherGroupAttributes;
    private LdapContext ldapContext;
    private SearchControls userSearchControls;
    private SearchControls groupSearchControls;
    private Table<String, String, String> groupUserTable;
    private Map<String, Map<String, String>> sourceUsers;
    private Map<String, Map<String, String>> sourceGroups;
    private Map<String, Set<String>> sourceGroupUsers;
    StartTlsResponse tls;
    UgsyncAuditInfo ugsyncAuditInfo;
    LdapSyncSourceInfo ldapSyncSourceInfo;

    public static void main(String[] args) throws Throwable {
        LdapUserGroupBuilder ugBuilder = new LdapUserGroupBuilder();
        ugBuilder.init();
    }

    @Override
    public void init() throws Throwable {
        deltaSyncUserTime = 0L;
        deltaSyncGroupTime = 0L;
        this.deleteCycles = 1;
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        this.deltaSyncUserTimeStamp = dateFormat.format(new Date(0L));
        this.deltaSyncGroupTimeStamp = dateFormat.format(new Date(0L));
        this.setConfig();
        this.ugsyncAuditInfo = new UgsyncAuditInfo();
        this.ldapSyncSourceInfo = new LdapSyncSourceInfo();
        this.ldapSyncSourceInfo.setLdapUrl(this.ldapUrl);
        this.ldapSyncSourceInfo.setIncrementalSycn(Boolean.toString(this.config.isDeltaSyncEnabled()));
        this.ldapSyncSourceInfo.setUserSearchEnabled(Boolean.toString(this.userSearchEnabled));
        this.ldapSyncSourceInfo.setGroupSearchEnabled(Boolean.toString(this.groupSearchEnabled));
        this.ldapSyncSourceInfo.setGroupSearchFirstEnabled(Boolean.toString(this.groupSearchFirstEnabled));
        this.ldapSyncSourceInfo.setGroupHierarchyLevel(Integer.toString(this.groupHierarchyLevels));
        this.ugsyncAuditInfo.setSyncSource(this.currentSyncSource);
        this.ugsyncAuditInfo.setLdapSyncSourceInfo(this.ldapSyncSourceInfo);
    }

    @Override
    public boolean isChanged() {
        return true;
    }

    @Override
    public void updateSink(UserGroupSink sink) throws Throwable {
        LOG.info("LdapUserGroupBuilder updateSink started");
        boolean computeDeletes = false;
        this.groupUserTable = HashBasedTable.create();
        this.sourceGroups = new HashMap<String, Map<String, String>>();
        this.sourceUsers = new HashMap<String, Map<String, String>>();
        this.sourceGroupUsers = new HashMap<String, Set<String>>();
        long highestdeltaSyncUserTime = 0L;
        long highestdeltaSyncGroupTime = 0L;
        if (this.config.isUserSyncDeletesEnabled() && (long)this.deleteCycles >= this.config.getUserSyncDeletesFrequency()) {
            this.deleteCycles = 1;
            computeDeletes = true;
            LOG.debug("Compute deleted users/groups is enabled for this sync cycle");
        }
        if (this.config.isUserSyncDeletesEnabled()) {
            ++this.deleteCycles;
        }
        if (this.groupSearchEnabled) {
            highestdeltaSyncGroupTime = this.getGroups(computeDeletes);
        }
        if (this.userSearchEnabled) {
            LOG.info("Performing user search to retrieve users from AD/LDAP");
            highestdeltaSyncUserTime = this.getUsers(computeDeletes);
        }
        if (this.groupHierarchyLevels > 0) {
            LOG.info("Going through group hierarchy for nested group evaluation");
            Set<String> groupFullNames = this.sourceGroups.keySet();
            Iterator iterator = groupFullNames.iterator();
            while (iterator.hasNext()) {
                String group = (String)iterator.next();
                Set<String> nextLevelGroups = this.groupUserTable.column((Object)group).keySet();
                this.goUpGroupHierarchy(nextLevelGroups, this.groupHierarchyLevels - 1, group);
            }
            LOG.info("Completed group hierarchy computation");
        }
        for (String groupName : this.groupUserTable.rowKeySet()) {
            Map groupUsersMap = this.groupUserTable.row((Object)groupName);
            HashSet<String> userSet = new HashSet<String>();
            for (Map.Entry entry : groupUsersMap.entrySet()) {
                if (!this.sourceUsers.containsKey(entry.getValue())) continue;
                userSet.add((String)entry.getValue());
            }
            this.sourceGroupUsers.put(groupName, userSet);
        }
        LOG.debug("Users = {}", this.sourceUsers.keySet());
        LOG.debug("Groups = {}", this.sourceGroups.keySet());
        LOG.debug("GroupUsers = {}", this.sourceGroupUsers.keySet());
        try {
            sink.addOrUpdateUsersGroups(this.sourceGroups, this.sourceUsers, this.sourceGroupUsers, computeDeletes);
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
            LOG.info("deltaSyncUserTime = {} and highestDeltaSyncUserTime = {}", (Object)deltaSyncUserTime, (Object)highestdeltaSyncUserTime);
            if (deltaSyncUserTime < highestdeltaSyncUserTime) {
                deltaSyncUserTime = highestdeltaSyncUserTime + 1L;
                this.deltaSyncUserTimeStamp = dateFormat.format(new Date(highestdeltaSyncUserTime + 60L));
            }
            LOG.info("deltaSyncGroupTime = {} and highestDeltaSyncGroupTime = {} ", (Object)deltaSyncGroupTime, (Object)highestdeltaSyncGroupTime);
            if (deltaSyncGroupTime < highestdeltaSyncGroupTime) {
                deltaSyncGroupTime = highestdeltaSyncGroupTime + 1L;
                this.deltaSyncGroupTimeStamp = dateFormat.format(new Date(highestdeltaSyncGroupTime + 60L));
            }
        }
        catch (Throwable t) {
            LOG.error("Failed to update ranger admin. Will retry in next sync cycle!!", t);
        }
        this.ldapSyncSourceInfo.setUserSearchFilter(this.extendedUserSearchFilter);
        this.ldapSyncSourceInfo.setGroupSearchFilter(this.extendedAllGroupsSearchFilter);
        try {
            sink.postUserGroupAuditInfo(this.ugsyncAuditInfo);
        }
        catch (Throwable t) {
            LOG.error("sink.postUserGroupAuditInfo failed with exception: {}", (Object)t.getMessage());
        }
    }

    private void createLdapContext() throws Throwable {
        String attrType;
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.ldapUrl);
        if (this.ldapUrl.startsWith("ldaps") && this.config.getSSLTrustStorePath() != null && !this.config.getSSLTrustStorePath().trim().isEmpty()) {
            env.put("java.naming.ldap.factory.socket", "org.apache.ranger.ldapusersync.process.CustomSSLSocketFactory");
        }
        if (StringUtils.isNotEmpty((String)this.userCloudIdAttribute) && this.config.getUserCloudIdAttributeDataType().equals(DATA_TYPE_BYTEARRAY)) {
            env.put("java.naming.ldap.attributes.binary", this.userCloudIdAttribute);
        }
        if (StringUtils.isNotEmpty((String)this.groupCloudIdAttribute) && this.config.getGroupCloudIdAttributeDataType().equals(DATA_TYPE_BYTEARRAY)) {
            env.put("java.naming.ldap.attributes.binary", this.groupCloudIdAttribute);
        }
        for (String otherUserAttribute : this.otherUserAttributes) {
            attrType = this.config.getOtherUserAttributeDataType(otherUserAttribute);
            if (!attrType.equals(DATA_TYPE_BYTEARRAY)) continue;
            env.put("java.naming.ldap.attributes.binary", otherUserAttribute);
        }
        for (String otherGroupAttribute : this.otherGroupAttributes) {
            attrType = this.config.getOtherGroupAttributeDataType(otherGroupAttribute);
            if (!attrType.equals(DATA_TYPE_BYTEARRAY)) continue;
            env.put("java.naming.ldap.attributes.binary", otherGroupAttribute);
        }
        this.ldapContext = new InitialLdapContext(env, null);
        if (!this.ldapUrl.startsWith("ldaps") && this.config.isStartTlsEnabled()) {
            this.tls = (StartTlsResponse)this.ldapContext.extendedOperation(new StartTlsRequest());
            if (this.config.getSSLTrustStorePath() != null && !this.config.getSSLTrustStorePath().trim().isEmpty()) {
                this.tls.negotiate(CustomSSLSocketFactory.getDefault());
            } else {
                this.tls.negotiate();
            }
            LOG.info("Starting TLS session...");
        }
        this.ldapContext.addToEnvironment("java.naming.security.principal", this.ldapBindDn);
        this.ldapContext.addToEnvironment("java.naming.security.credentials", this.ldapBindPassword);
        this.ldapContext.addToEnvironment("java.naming.security.authentication", this.ldapAuthenticationMechanism);
        this.ldapContext.addToEnvironment("java.naming.referral", this.ldapReferral);
    }

    private void setConfig() throws Throwable {
        LOG.info("LdapUserGroupBuilder initialization started");
        this.groupSearchFirstEnabled = true;
        this.currentSyncSource = this.config.getCurrentSyncSource();
        this.userSearchEnabled = this.config.isUserSearchEnabled();
        this.groupSearchEnabled = this.config.isGroupSearchEnabled();
        this.ldapUrl = this.config.getLdapUrl();
        this.ldapBindDn = this.config.getLdapBindDn();
        this.ldapBindPassword = this.config.getLdapBindPassword();
        this.ldapAuthenticationMechanism = this.config.getLdapAuthenticationMechanism();
        this.ldapReferral = this.config.getContextReferral();
        this.searchBase = this.config.getSearchBase();
        this.userSearchBase = this.config.getUserSearchBase().split(";");
        this.userSearchScope = this.config.getUserSearchScope();
        this.userObjectClass = this.config.getUserObjectClass();
        this.userSearchFilter = this.config.getUserSearchFilter();
        this.userNameAttribute = this.config.getUserNameAttribute();
        this.userCloudIdAttribute = this.config.getUserCloudIdAttribute();
        this.userGroupNameAttributeSet = this.config.getUserGroupNameAttributeSet();
        this.otherUserAttributes = this.config.getOtherUserAttributes();
        HashSet<String> userSearchAttributes = new HashSet<String>();
        userSearchAttributes.add(this.userNameAttribute);
        userSearchAttributes.addAll(this.userGroupNameAttributeSet);
        userSearchAttributes.add(this.userCloudIdAttribute);
        userSearchAttributes.addAll(this.otherUserAttributes);
        userSearchAttributes.add("uSNChanged");
        userSearchAttributes.add("modifytimestamp");
        this.userSearchControls = new SearchControls();
        this.userSearchControls.setSearchScope(this.userSearchScope);
        this.userSearchControls.setReturningAttributes(userSearchAttributes.toArray(new String[userSearchAttributes.size()]));
        this.pagedResultsEnabled = this.config.isPagedResultsEnabled();
        this.pagedResultsSize = this.config.getPagedResultsSize();
        this.groupSearchBase = this.config.getGroupSearchBase().split(";");
        this.groupSearchScope = this.config.getGroupSearchScope();
        this.groupObjectClass = this.config.getGroupObjectClass();
        this.groupSearchFilter = this.config.getGroupSearchFilter();
        this.groupMemberAttributeName = this.config.getUserGroupMemberAttributeName();
        this.groupNameAttribute = this.config.getGroupNameAttribute();
        this.groupCloudIdAttribute = this.config.getGroupCloudIdAttribute();
        this.groupHierarchyLevels = this.config.getGroupHierarchyLevels();
        this.extendedGroupSearchFilter = "(&" + this.extendedGroupSearchFilter + "(|(" + this.groupMemberAttributeName + "={0})(" + this.groupMemberAttributeName + "={1})))";
        this.groupSearchControls = new SearchControls();
        this.groupSearchControls.setSearchScope(this.groupSearchScope);
        HashSet<String> groupSearchAttributes = new HashSet<String>();
        groupSearchAttributes.add(this.groupNameAttribute);
        groupSearchAttributes.add(this.groupCloudIdAttribute);
        groupSearchAttributes.add(this.groupMemberAttributeName);
        groupSearchAttributes.add("uSNChanged");
        groupSearchAttributes.add("modifytimestamp");
        this.otherGroupAttributes = this.config.getOtherGroupAttributes();
        groupSearchAttributes.addAll(this.otherGroupAttributes);
        this.groupSearchControls.setReturningAttributes(groupSearchAttributes.toArray(new String[groupSearchAttributes.size()]));
        if (StringUtils.isEmpty((String)this.userSearchFilter)) {
            this.groupNameSet = this.config.getGroupNameSet();
            String computedSearchFilter = "";
            for (String groupName : this.groupNameSet) {
                LOG.debug("groupName = {}", (Object)groupName);
                if (!groupName.startsWith(MEMBER_OF_ATTR) && !groupName.startsWith(GROUP_NAME_ATTRIBUTE)) {
                    LOG.info("Ignoring unsupported format for {}", (Object)groupName);
                    continue;
                }
                String searchFilter = groupName;
                if (groupName.startsWith(MEMBER_OF_ATTR)) {
                    searchFilter = groupName.substring(MEMBER_OF_ATTR.length());
                }
                searchFilter = this.getFirstRDN(searchFilter);
                computedSearchFilter = computedSearchFilter + this.getDNForMemberOf(searchFilter);
            }
            if (StringUtils.isNotEmpty((String)computedSearchFilter)) {
                computedSearchFilter = "(|" + computedSearchFilter + ")";
            }
            LOG.info("Final computedSearchFilter = {}", (Object)computedSearchFilter);
            this.userSearchFilter = computedSearchFilter;
        }
        LOG.info("LdapUserGroupBuilder initialization completed with --  ldapUrl: {},  ldapBindDn: {},  ldapBindPassword: ***** ,  ldapAuthenticationMechanism: {},  searchBase: {},  userSearchBase: {},  userSearchScope: {},  userObjectClass: {},  userSearchFilter: {},  extendedUserSearchFilter: {},  userNameAttribute: {},  userSearchAttributes: {},  userGroupNameAttributeSet: {},  otherUserAttributes: {},  pagedResultsEnabled: {},  pagedResultsSize: {},  groupSearchEnabled: {},  groupSearchBase: {},  groupSearchScope: {},  groupObjectClass: {},  groupSearchFilter: {},  extendedGroupSearchFilter: {},  extendedAllGroupsSearchFilter: {},  groupMemberAttributeName: {},  groupNameAttribute: {},  groupSearchAttributes: {},  groupSearchFirstEnabled: {},  userSearchEnabled: {},  ldapReferral: {}", new Object[]{this.ldapUrl, this.ldapBindDn, this.ldapAuthenticationMechanism, this.searchBase, Arrays.toString(this.userSearchBase), this.userSearchScope, this.userObjectClass, this.userSearchFilter, this.extendedUserSearchFilter, this.userNameAttribute, userSearchAttributes, this.userGroupNameAttributeSet, this.otherUserAttributes, this.pagedResultsEnabled, this.pagedResultsSize, this.groupSearchEnabled, Arrays.toString(this.groupSearchBase), this.groupSearchScope, this.groupObjectClass, this.groupSearchFilter, this.extendedGroupSearchFilter, this.extendedAllGroupsSearchFilter, this.groupMemberAttributeName, this.groupNameAttribute, groupSearchAttributes, this.groupSearchFirstEnabled, this.userSearchEnabled, this.ldapReferral});
    }

    private void closeLdapContext() throws Throwable {
        if (this.tls != null) {
            this.tls.close();
        }
        if (this.ldapContext != null) {
            this.ldapContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getUsers(boolean computeDeletes) throws Throwable {
        long highestdeltaSyncUserTime;
        NamingEnumeration<SearchResult> userSearchResultEnum = null;
        NamingEnumeration groupSearchResultEnum = null;
        try {
            this.createLdapContext();
            if (this.pagedResultsEnabled) {
                this.ldapContext.setRequestControls(new Control[]{new PagedResultsControl(this.pagedResultsSize, false)});
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
            if (!this.groupUserTable.rowKeySet().isEmpty() || !this.config.isDeltaSyncEnabled() || computeDeletes) {
                deltaSyncUserTime = 0L;
                this.deltaSyncUserTimeStamp = dateFormat.format(new Date(0L));
            }
            this.extendedUserSearchFilter = "(objectclass=" + this.userObjectClass + ")(|(uSNChanged>=" + deltaSyncUserTime + ")(modifyTimestamp>=" + this.deltaSyncUserTimeStamp + "Z))";
            if (this.userSearchFilter != null && !this.userSearchFilter.trim().isEmpty()) {
                String customFilter = this.userSearchFilter.trim();
                if (!customFilter.startsWith("(")) {
                    customFilter = "(" + customFilter + ")";
                }
                this.extendedUserSearchFilter = "(&" + this.extendedUserSearchFilter + customFilter + ")";
            } else {
                this.extendedUserSearchFilter = "(&" + this.extendedUserSearchFilter + ")";
            }
            LOG.info("extendedUserSearchFilter = {}", (Object)this.extendedUserSearchFilter);
            highestdeltaSyncUserTime = deltaSyncUserTime;
            for (String s : this.userSearchBase) {
                byte[] cookie = null;
                int counter = 0;
                try {
                    int paged = 0;
                    do {
                        userSearchResultEnum = this.ldapContext.search(s, this.extendedUserSearchFilter, this.userSearchControls);
                        while (userSearchResultEnum.hasMore()) {
                            SearchResult userEntry = userSearchResultEnum.next();
                            if (userEntry == null) {
                                LOG.info("userEntry null, skipping sync for the entry");
                                continue;
                            }
                            Attributes attributes = userEntry.getAttributes();
                            if (attributes == null) {
                                LOG.info("attributes  missing for entry {}, skipping sync", (Object)userEntry.getNameInNamespace());
                                continue;
                            }
                            Attribute userNameAttr = attributes.get(this.userNameAttribute);
                            if (userNameAttr == null) {
                                LOG.info("{} missing for entry {}, skipping sync", (Object)this.userNameAttribute, (Object)userEntry.getNameInNamespace());
                                continue;
                            }
                            String userFullName = userEntry.getNameInNamespace();
                            String userName = (String)userNameAttr.get();
                            if (userName == null || userName.trim().isEmpty()) {
                                LOG.info("{} empty for entry {}, skipping sync", (Object)this.userNameAttribute, (Object)userEntry.getNameInNamespace());
                                continue;
                            }
                            Attribute timeStampAttr = attributes.get("uSNChanged");
                            if (timeStampAttr != null) {
                                String uSNChangedVal = (String)timeStampAttr.get();
                                long currentDeltaSyncTime = Long.parseLong(uSNChangedVal);
                                LOG.info("uSNChangedVal = {} and currentDeltaSyncTime = {}", (Object)uSNChangedVal, (Object)currentDeltaSyncTime);
                                if (currentDeltaSyncTime > highestdeltaSyncUserTime) {
                                    highestdeltaSyncUserTime = currentDeltaSyncTime;
                                }
                            } else {
                                timeStampAttr = attributes.get("modifytimestamp");
                                if (timeStampAttr != null) {
                                    String timeStampVal = (String)timeStampAttr.get();
                                    Date parseDate = dateFormat.parse(timeStampVal);
                                    long currentDeltaSyncTime = parseDate.getTime();
                                    LOG.info("timeStampVal = {} and currentDeltaSyncTime = {}", (Object)timeStampVal, (Object)currentDeltaSyncTime);
                                    if (currentDeltaSyncTime > highestdeltaSyncUserTime) {
                                        highestdeltaSyncUserTime = currentDeltaSyncTime;
                                        this.deltaSyncUserTimeStamp = timeStampVal;
                                    }
                                }
                            }
                            if (!this.groupSearchEnabled) {
                                for (String useGroupNameAttribute : this.userGroupNameAttributeSet) {
                                    Attribute userGroupfAttribute = userEntry.getAttributes().get(useGroupNameAttribute);
                                    if (userGroupfAttribute == null) continue;
                                    NamingEnumeration<?> groupEnum = userGroupfAttribute.getAll();
                                    while (groupEnum.hasMore()) {
                                        String groupDN = (String)groupEnum.next();
                                        LOG.debug("Adding {} to {}", (Object)groupDN, (Object)userName);
                                        HashMap<String, String> groupAttrMap = new HashMap<String, String>();
                                        String groupName = LdapUserGroupBuilder.getShortName(groupDN);
                                        groupAttrMap.put("original_name", groupName);
                                        groupAttrMap.put("full_name", groupDN);
                                        groupAttrMap.put("sync_source", this.currentSyncSource);
                                        groupAttrMap.put("ldap_url", this.config.getLdapUrl());
                                        this.sourceGroups.put(groupDN, groupAttrMap);
                                        LOG.debug("As groupsearch is disabled, adding group {} from user memberof attribute for user {}", (Object)groupName, (Object)userName);
                                        this.groupUserTable.put((Object)groupDN, (Object)userFullName, (Object)userFullName);
                                    }
                                }
                            }
                            HashMap<String, String> userAttrMap = new HashMap<String, String>();
                            userAttrMap.put("original_name", userName);
                            userAttrMap.put("full_name", userFullName);
                            userAttrMap.put("sync_source", this.currentSyncSource);
                            userAttrMap.put("ldap_url", this.config.getLdapUrl());
                            Attribute userCloudIdAttr = attributes.get(this.userCloudIdAttribute);
                            if (userCloudIdAttr != null) {
                                this.addToAttrMap(userAttrMap, "cloud_id", userCloudIdAttr, this.config.getUserCloudIdAttributeDataType());
                            }
                            for (String otherUserAttribute : this.otherUserAttributes) {
                                if (attributes.get(otherUserAttribute) == null) continue;
                                String attrType = this.config.getOtherUserAttributeDataType(otherUserAttribute);
                                this.addToAttrMap(userAttrMap, otherUserAttribute, attributes.get(otherUserAttribute), attrType);
                            }
                            this.sourceUsers.put(userFullName, userAttrMap);
                            if (this.groupUserTable.containsColumn((Object)userFullName) || this.groupUserTable.containsColumn((Object)userName)) {
                                Map userMap = this.groupUserTable.column((Object)userFullName);
                                if (MapUtils.isEmpty((Map)userMap)) {
                                    userMap = this.groupUserTable.column((Object)userName);
                                }
                                for (Map.Entry entry : userMap.entrySet()) {
                                    LOG.debug("Updating groupUserTable {} with: {} for {}", new Object[]{entry.getValue(), userName, entry.getKey()});
                                    this.groupUserTable.put((Object)((String)entry.getKey()), (Object)userFullName, (Object)userFullName);
                                }
                            }
                            if (++counter <= 2000) {
                                LOG.info("Updating user count: {}, userName: {}", (Object)counter, (Object)userName);
                                if (counter != 2000) continue;
                                LOG.info("===> 2000 user records have been synchronized so far. From now on, only a summary progress log will be written for every 100 users. To continue to see detailed log for every user, please enable Trace level logging. <===");
                                continue;
                            }
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Updating user count: {}, userName: {}", (Object)counter, (Object)userName);
                                continue;
                            }
                            if (counter % 100 != 0) continue;
                            LOG.info("Synced {} users till now", (Object)counter);
                        }
                        Control[] controls = this.ldapContext.getResponseControls();
                        if (controls != null) {
                            for (Control control : controls) {
                                if (!(control instanceof PagedResultsResponseControl)) continue;
                                PagedResultsResponseControl prrc = (PagedResultsResponseControl)control;
                                int total = prrc.getResultSize();
                                if (total != 0) {
                                    LOG.debug("END-OF-PAGE total : {}", (Object)total);
                                } else {
                                    LOG.debug("END-OF-PAGE total : unknown");
                                }
                                cookie = prrc.getCookie();
                            }
                        } else {
                            LOG.debug("No controls were sent from the server");
                        }
                        if (!this.pagedResultsEnabled) continue;
                        LOG.debug("Fetched paged results round: {}", (Object)(++paged));
                        this.ldapContext.setRequestControls(new Control[]{new PagedResultsControl(this.pagedResultsSize, cookie, true)});
                    } while (cookie != null);
                    LOG.info("LdapUserGroupBuilder.getUsers() completed with user count: {}", (Object)counter);
                }
                catch (Exception t) {
                    LOG.error("LdapUserGroupBuilder.getUsers() failed with exception: ", (Throwable)t);
                    LOG.info("LdapUserGroupBuilder.getUsers() user count: {}", (Object)counter);
                }
            }
        }
        finally {
            if (userSearchResultEnum != null) {
                userSearchResultEnum.close();
            }
            if (groupSearchResultEnum != null) {
                groupSearchResultEnum.close();
            }
            this.closeLdapContext();
        }
        LOG.debug("highestDeltaSyncUserTime = {}", (Object)highestdeltaSyncUserTime);
        return highestdeltaSyncUserTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getGroups(boolean computeDeletes) throws Throwable {
        NamingEnumeration<SearchResult> groupSearchResultEnum = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        long highestdeltaSyncGroupTime = deltaSyncGroupTime;
        try {
            this.createLdapContext();
            if (this.pagedResultsEnabled) {
                this.ldapContext.setRequestControls(new Control[]{new PagedResultsControl(this.pagedResultsSize, false)});
            }
            this.extendedGroupSearchFilter = "(objectclass=" + this.groupObjectClass + ")";
            if (this.groupSearchFilter != null && !this.groupSearchFilter.trim().isEmpty()) {
                String customFilter = this.groupSearchFilter.trim();
                if (!customFilter.startsWith("(")) {
                    customFilter = "(" + customFilter + ")";
                }
                this.extendedGroupSearchFilter = this.extendedGroupSearchFilter + customFilter;
            }
            if (!this.config.isDeltaSyncEnabled() || computeDeletes) {
                deltaSyncGroupTime = 0L;
                this.deltaSyncGroupTimeStamp = dateFormat.format(new Date(0L));
            }
            this.extendedAllGroupsSearchFilter = "(&" + this.extendedGroupSearchFilter + "(|(uSNChanged>=" + deltaSyncGroupTime + ")(modifyTimestamp>=" + this.deltaSyncGroupTimeStamp + "Z)))";
            LOG.info("extendedAllGroupsSearchFilter = {}", (Object)this.extendedAllGroupsSearchFilter);
            for (String s : this.groupSearchBase) {
                byte[] cookie = null;
                int counter = 0;
                try {
                    int paged = 0;
                    do {
                        groupSearchResultEnum = this.ldapContext.search(s, this.extendedAllGroupsSearchFilter, this.groupSearchControls);
                        while (groupSearchResultEnum.hasMore()) {
                            SearchResult groupEntry = groupSearchResultEnum.next();
                            if (groupEntry == null) {
                                LOG.info("groupEntry null, skipping sync for the entry");
                                continue;
                            }
                            ++counter;
                            Attributes attributes = groupEntry.getAttributes();
                            Attribute groupNameAttr = attributes.get(this.groupNameAttribute);
                            if (groupNameAttr == null) {
                                LOG.info("{} empty for entry {}, skipping sync", (Object)this.groupNameAttribute, (Object)groupEntry.getNameInNamespace());
                                continue;
                            }
                            String groupFullName = groupEntry.getNameInNamespace();
                            String gName = (String)groupNameAttr.get();
                            HashMap<String, String> groupAttrMap = new HashMap<String, String>();
                            groupAttrMap.put("original_name", gName);
                            groupAttrMap.put("full_name", groupFullName);
                            groupAttrMap.put("sync_source", this.currentSyncSource);
                            groupAttrMap.put("ldap_url", this.config.getLdapUrl());
                            Attribute groupCloudIdAttr = attributes.get(this.groupCloudIdAttribute);
                            if (groupCloudIdAttr != null) {
                                this.addToAttrMap(groupAttrMap, "cloud_id", groupCloudIdAttr, this.config.getGroupCloudIdAttributeDataType());
                            }
                            for (String otherGroupAttribute : this.otherGroupAttributes) {
                                if (attributes.get(otherGroupAttribute) == null) continue;
                                String attrType = this.config.getOtherGroupAttributeDataType(otherGroupAttribute);
                                this.addToAttrMap(groupAttrMap, otherGroupAttribute, attributes.get(otherGroupAttribute), attrType);
                            }
                            this.sourceGroups.put(groupFullName, groupAttrMap);
                            Attribute timeStampAttr = attributes.get("uSNChanged");
                            if (timeStampAttr != null) {
                                String uSNChangedVal = (String)timeStampAttr.get();
                                long currentDeltaSyncTime = Long.parseLong(uSNChangedVal);
                                if (currentDeltaSyncTime > highestdeltaSyncGroupTime) {
                                    highestdeltaSyncGroupTime = currentDeltaSyncTime;
                                }
                            } else {
                                timeStampAttr = attributes.get("modifytimestamp");
                                if (timeStampAttr != null) {
                                    String timeStampVal = (String)timeStampAttr.get();
                                    Date parseDate = dateFormat.parse(timeStampVal);
                                    long currentDeltaSyncTime = parseDate.getTime();
                                    LOG.info("timeStampVal = {} and currentDeltaSyncTime = {}", (Object)timeStampVal, (Object)currentDeltaSyncTime);
                                    if (currentDeltaSyncTime > highestdeltaSyncGroupTime) {
                                        highestdeltaSyncGroupTime = currentDeltaSyncTime;
                                        this.deltaSyncGroupTimeStamp = timeStampVal;
                                    }
                                }
                            }
                            Attribute groupMemberAttr = attributes.get(this.groupMemberAttributeName);
                            int userCount = 0;
                            if (groupMemberAttr == null || groupMemberAttr.size() <= 0) {
                                try {
                                    LOG.info("No members available for {}", (Object)gName);
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                                this.sourceGroupUsers.put(groupFullName, new HashSet());
                                continue;
                            }
                            NamingEnumeration<?> userEnum = groupMemberAttr.getAll();
                            while (userEnum.hasMore()) {
                                String originalUserFullName = (String)userEnum.next();
                                if (originalUserFullName == null || originalUserFullName.trim().isEmpty()) {
                                    this.sourceGroupUsers.put(groupFullName, new HashSet());
                                    continue;
                                }
                                ++userCount;
                                if (!this.userSearchEnabled) {
                                    HashMap<String, String> userAttrMap = new HashMap<String, String>();
                                    String userName = LdapUserGroupBuilder.getShortName(originalUserFullName);
                                    userAttrMap.put("original_name", userName);
                                    userAttrMap.put("full_name", originalUserFullName);
                                    userAttrMap.put("sync_source", this.currentSyncSource);
                                    userAttrMap.put("ldap_url", this.config.getLdapUrl());
                                    this.sourceUsers.put(originalUserFullName, userAttrMap);
                                    LOG.debug("As usersearch is disabled, adding user {} from group member attribute for group {}", (Object)userName, (Object)gName);
                                }
                                this.groupUserTable.put((Object)groupFullName, (Object)originalUserFullName, (Object)originalUserFullName);
                            }
                            LOG.info("No. of members in the group {} = {}", (Object)gName, (Object)userCount);
                        }
                        Control[] controls = this.ldapContext.getResponseControls();
                        if (controls != null) {
                            for (Control control : controls) {
                                if (!(control instanceof PagedResultsResponseControl)) continue;
                                PagedResultsResponseControl prrc = (PagedResultsResponseControl)control;
                                int total = prrc.getResultSize();
                                if (total != 0) {
                                    LOG.debug("END-OF-PAGE total: {}", (Object)total);
                                } else {
                                    LOG.debug("END-OF-PAGE total: unknown");
                                }
                                cookie = prrc.getCookie();
                            }
                        } else {
                            LOG.debug("No controls were sent from the server");
                        }
                        if (!this.pagedResultsEnabled) continue;
                        LOG.debug("Fetched paged results round: {}", (Object)(++paged));
                        this.ldapContext.setRequestControls(new Control[]{new PagedResultsControl(this.pagedResultsSize, cookie, true)});
                    } while (cookie != null);
                    LOG.info("LdapUserGroupBuilder.getGroups() completed with group count: {}", (Object)counter);
                }
                catch (Exception t) {
                    LOG.error("LdapUserGroupBuilder.getGroups() failed with exception: ", (Throwable)t);
                    LOG.info("LdapUserGroupBuilder.getGroups() group count: {}", (Object)counter);
                }
            }
        }
        finally {
            if (groupSearchResultEnum != null) {
                groupSearchResultEnum.close();
            }
            this.closeLdapContext();
        }
        if (this.groupHierarchyLevels > 0) {
            LOG.debug("deltaSyncGroupTime = {}", (Object)deltaSyncGroupTime);
            if (deltaSyncGroupTime > 0L) {
                LOG.info("LdapUserGroupBuilder.getGroups(): Going through group hierarchy for nested group evaluation for deltasync");
                this.goUpGroupHierarchyLdap(this.sourceGroups.keySet(), this.groupHierarchyLevels - 1);
            }
        }
        LOG.debug("highestdeltaSyncGroupTime = {}", (Object)highestdeltaSyncGroupTime);
        return highestdeltaSyncGroupTime;
    }

    private void goUpGroupHierarchy(Set<String> groups, int groupHierarchyLevels, String groupSName) {
        if (groupHierarchyLevels <= 0 || groups.isEmpty()) {
            return;
        }
        LOG.info("nextLevelGroups = {} for group = {}", groups, (Object)groupSName);
        for (String group : groups) {
            Set allMembers = this.groupUserTable.row((Object)groupSName).keySet();
            LOG.info("members of {} = {}", (Object)groupSName, allMembers);
            for (String member : allMembers) {
                if (this.groupUserTable.containsRow((Object)member)) continue;
                LOG.info("Adding {} to {}", (Object)member, (Object)group);
                String userSName = (String)this.groupUserTable.get((Object)groupSName, (Object)member);
                LOG.info("Short name of {} = {}", (Object)member, (Object)userSName);
                if (userSName == null) continue;
                this.groupUserTable.put((Object)group, (Object)member, (Object)userSName);
            }
            Set<String> nextLevelGroups = this.groupUserTable.column((Object)group).keySet();
            this.goUpGroupHierarchy(nextLevelGroups, groupHierarchyLevels - 1, group);
        }
    }

    private void goUpGroupHierarchyLdap(Set<String> groupDNs, int groupHierarchyLevels) throws Throwable {
        if (groupHierarchyLevels <= 0 || groupDNs.isEmpty()) {
            return;
        }
        HashSet<String> nextLevelGroups = new HashSet<String>();
        NamingEnumeration<SearchResult> groupSearchResultEnum = null;
        try {
            this.createLdapContext();
            if (this.pagedResultsEnabled) {
                this.ldapContext.setRequestControls(new Control[]{new PagedResultsControl(this.pagedResultsSize, false)});
            }
            String groupFilter = "(&(objectclass=" + this.groupObjectClass + ")";
            if (this.groupSearchFilter != null && !this.groupSearchFilter.trim().isEmpty()) {
                String customFilter = this.groupSearchFilter.trim();
                if (!customFilter.startsWith("(")) {
                    customFilter = "(" + customFilter + ")";
                }
                groupFilter = groupFilter + customFilter + "(|";
            }
            StringBuilder filter = new StringBuilder();
            for (String groupDN : groupDNs) {
                filter.append("(").append(this.groupMemberAttributeName).append("=").append(groupDN).append(")");
            }
            filter.append("))");
            groupFilter = groupFilter + filter;
            LOG.info("extendedAllGroupsSearchFilter = {}", (Object)groupFilter);
            for (String s : this.groupSearchBase) {
                byte[] cookie = null;
                int counter = 0;
                try {
                    do {
                        groupSearchResultEnum = this.ldapContext.search(s, groupFilter, this.groupSearchControls);
                        while (groupSearchResultEnum.hasMore()) {
                            SearchResult groupEntry = groupSearchResultEnum.next();
                            if (groupEntry == null) {
                                LOG.info("groupEntry null, skipping sync for the entry");
                                continue;
                            }
                            ++counter;
                            Attribute groupNameAttr = groupEntry.getAttributes().get(this.groupNameAttribute);
                            if (groupNameAttr == null) {
                                LOG.info("{} empty for entry {}, skipping sync", (Object)this.groupNameAttribute, (Object)groupEntry.getNameInNamespace());
                                continue;
                            }
                            String groupFullName = groupEntry.getNameInNamespace();
                            nextLevelGroups.add(groupFullName);
                            String gName = (String)groupNameAttr.get();
                            Attribute groupMemberAttr = groupEntry.getAttributes().get(this.groupMemberAttributeName);
                            int userCount = 0;
                            if (groupMemberAttr == null || groupMemberAttr.size() <= 0) {
                                LOG.info("No members available for {}", (Object)gName);
                                continue;
                            }
                            HashMap<String, String> groupAttrMap = new HashMap<String, String>();
                            groupAttrMap.put("original_name", gName);
                            groupAttrMap.put("full_name", groupFullName);
                            groupAttrMap.put("sync_source", this.currentSyncSource);
                            groupAttrMap.put("ldap_url", this.config.getLdapUrl());
                            for (String otherGroupAttribute : this.otherGroupAttributes) {
                                Attribute otherGroupAttr = groupEntry.getAttributes().get(otherGroupAttribute);
                                if (otherGroupAttr == null) continue;
                                groupAttrMap.put(otherGroupAttribute, (String)otherGroupAttr.get());
                            }
                            this.sourceGroups.put(groupFullName, groupAttrMap);
                            NamingEnumeration<?> userEnum = groupMemberAttr.getAll();
                            while (userEnum.hasMore()) {
                                String originalUserFullName = (String)userEnum.next();
                                if (originalUserFullName == null || originalUserFullName.trim().isEmpty()) continue;
                                ++userCount;
                                if (!this.userSearchEnabled && !this.sourceGroups.containsKey(originalUserFullName)) {
                                    HashMap<String, String> userAttrMap = new HashMap<String, String>();
                                    String userName = LdapUserGroupBuilder.getShortName(originalUserFullName);
                                    userAttrMap.put("original_name", userName);
                                    userAttrMap.put("full_name", originalUserFullName);
                                    userAttrMap.put("sync_source", this.currentSyncSource);
                                    userAttrMap.put("ldap_url", this.config.getLdapUrl());
                                    this.sourceUsers.put(originalUserFullName, userAttrMap);
                                }
                                this.groupUserTable.put((Object)groupFullName, (Object)originalUserFullName, (Object)originalUserFullName);
                            }
                            LOG.info("No. of members in the group {} = {}", (Object)gName, (Object)userCount);
                        }
                        Control[] controls = this.ldapContext.getResponseControls();
                        if (controls != null) {
                            for (Control control : controls) {
                                if (!(control instanceof PagedResultsResponseControl)) continue;
                                PagedResultsResponseControl prrc = (PagedResultsResponseControl)control;
                                int total = prrc.getResultSize();
                                if (total != 0) {
                                    LOG.debug("END-OF-PAGE total : {}", (Object)total);
                                } else {
                                    LOG.debug("END-OF-PAGE total : unknown");
                                }
                                cookie = prrc.getCookie();
                            }
                        } else {
                            LOG.debug("No controls were sent from the server");
                        }
                        if (!this.pagedResultsEnabled) continue;
                        this.ldapContext.setRequestControls(new Control[]{new PagedResultsControl(this.pagedResultsSize, cookie, true)});
                    } while (cookie != null);
                    LOG.info("LdapUserGroupBuilder.goUpGroupHierarchyLdap() completed with group count: {}", (Object)counter);
                }
                catch (RuntimeException re) {
                    LOG.error("LdapUserGroupBuilder.goUpGroupHierarchyLdap() failed with runtime exception: ", (Throwable)re);
                    throw re;
                }
                catch (Exception t) {
                    LOG.error("LdapUserGroupBuilder.goUpGroupHierarchyLdap() failed with exception: ", (Throwable)t);
                    LOG.info("LdapUserGroupBuilder.goUpGroupHierarchyLdap() group count: {}", (Object)counter);
                }
            }
        }
        catch (RuntimeException re) {
            LOG.error("LdapUserGroupBuilder.goUpGroupHierarchyLdap() failed with exception: ", (Throwable)re);
            throw re;
        }
        finally {
            if (groupSearchResultEnum != null) {
                groupSearchResultEnum.close();
            }
            this.closeLdapContext();
        }
        this.goUpGroupHierarchyLdap(nextLevelGroups, groupHierarchyLevels - 1);
    }

    private void addToAttrMap(Map<String, String> userAttrMap, String attrName, Attribute attr, String attrType) throws Throwable {
        if (attrType.equals(DATA_TYPE_BYTEARRAY)) {
            try {
                byte[] otherUserAttrBytes = (byte[])attr.get();
                String attrVal = UUID.nameUUIDFromBytes(otherUserAttrBytes).toString();
                userAttrMap.put(attrName, attrVal);
            }
            catch (ClassCastException e) {
                LOG.error("{} type is not set properly {}", (Object)attrName, (Object)e.getMessage());
            }
        } else if (attrType.equals("String")) {
            userAttrMap.put(attrName, (String)attr.get());
        } else {
            LOG.warn("Attribute Type {} not supported for {}", (Object)attrType, (Object)attrName);
        }
    }

    private static String getShortName(String longName) {
        if (StringUtils.isEmpty((String)longName)) {
            return null;
        }
        String shortName = "";
        try {
            LdapName subjectDN = new LdapName(longName);
            List<Rdn> rdns = subjectDN.getRdns();
            for (int i = rdns.size() - 1; i >= 0 && !StringUtils.isNotEmpty((String)shortName); --i) {
                Rdn rdn = rdns.get(i);
                Attributes attributes = rdn.toAttributes();
                try {
                    Object value;
                    Attribute uid = attributes.get("uid");
                    if (uid != null) {
                        Object value2 = uid.get();
                        if (value2 == null) continue;
                        shortName = value2.toString();
                        continue;
                    }
                    Attribute cn = attributes.get("cn");
                    if (cn == null || (value = cn.get()) == null) continue;
                    shortName = value.toString();
                    continue;
                }
                catch (NoSuchElementException | NamingException ignore) {
                    shortName = longName;
                }
            }
        }
        catch (InvalidNameException ex) {
            shortName = longName;
        }
        LOG.info("longName: {}, userName: {}", (Object)longName, (Object)shortName);
        return shortName;
    }

    private String getFirstRDN(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        String shortName = "";
        try {
            LdapName subjectDN = new LdapName(name);
            List<Rdn> rdns = subjectDN.getRdns();
            for (int i = rdns.size() - 1; i >= 0 && !StringUtils.isNotEmpty((String)shortName); --i) {
                Rdn rdn = rdns.get(i);
                Attributes attributes = rdn.toAttributes();
                try {
                    Object value;
                    Attribute cn = attributes.get("cn");
                    if (cn == null || (value = cn.get()) == null) continue;
                    shortName = GROUP_NAME_ATTRIBUTE + value;
                    continue;
                }
                catch (NoSuchElementException ignore) {
                    LOG.warn("NoSuchElementException while retrieving first RDN for {}", (Object)name);
                    continue;
                }
                catch (NamingException ignore) {
                    LOG.warn("NamingException while retrieving first RDN for {}", (Object)name);
                }
            }
        }
        catch (InvalidNameException ex) {
            LOG.warn("InvalidNameException while retrieving first RDN for {}", (Object)name);
        }
        LOG.debug("Input group name: {}, first RDN: {}", (Object)name, (Object)shortName);
        return shortName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDNForMemberOf(String searchFilter) throws Throwable {
        NamingEnumeration<SearchResult> userSearchResultEnum = null;
        LOG.debug("getDNForMemberOf({})", (Object)searchFilter);
        String computedSearchFilter = "";
        try {
            this.createLdapContext();
            SearchControls searchControls = new SearchControls();
            HashSet<String> searchAttributes = new HashSet<String>();
            if (this.pagedResultsEnabled) {
                this.ldapContext.setRequestControls(new Control[]{new PagedResultsControl(this.pagedResultsSize, false)});
            }
            searchControls.setSearchScope(this.groupSearchScope);
            searchAttributes.add(this.groupNameAttribute);
            searchControls.setReturningAttributes(searchAttributes.toArray(new String[searchAttributes.size()]));
            for (String s : this.groupSearchBase) {
                byte[] cookie = null;
                int counter = 0;
                try {
                    int paged = 0;
                    do {
                        String filter = String.format("(&(objectclass=%s)(%s))", this.groupObjectClass, searchFilter);
                        userSearchResultEnum = this.ldapContext.search(s, filter, searchControls);
                        while (userSearchResultEnum.hasMore()) {
                            SearchResult userEntry = userSearchResultEnum.next();
                            if (userEntry == null) {
                                LOG.info("userEntry null, skipping sync for the entry");
                                continue;
                            }
                            Attributes attributes = userEntry.getAttributes();
                            if (attributes == null) {
                                LOG.info("attributes  missing for entry {}, skipping sync", (Object)userEntry.getNameInNamespace());
                                continue;
                            }
                            Attribute groupNameAttr = attributes.get(this.groupNameAttribute);
                            if (groupNameAttr == null) {
                                LOG.info("{} missing for entry {}, skipping sync", (Object)this.groupNameAttribute, (Object)userEntry.getNameInNamespace());
                                continue;
                            }
                            String groupFullName = userEntry.getNameInNamespace();
                            LOG.info("groupFullName = {}", (Object)groupFullName);
                            computedSearchFilter = computedSearchFilter + "(memberof=" + groupFullName + ")";
                            if (++counter <= 2000) {
                                LOG.info("Updating group count: {}, groupName: {}", (Object)counter, (Object)groupFullName);
                                if (counter != 2000) continue;
                                LOG.info("===> 2000 group records have been synchronized so far. From now on, only a summary progress log will be written for every 100 users. To continue to see detailed log for every user, please enable Trace level logging. <===");
                                continue;
                            }
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Updating group count: {}, groupName: {}", (Object)counter, (Object)groupFullName);
                                continue;
                            }
                            if (counter % 100 != 0) continue;
                            LOG.info("Synced {} groups till now", (Object)counter);
                        }
                        Control[] controls = this.ldapContext.getResponseControls();
                        if (controls != null) {
                            for (Control control : controls) {
                                if (!(control instanceof PagedResultsResponseControl)) continue;
                                PagedResultsResponseControl prrc = (PagedResultsResponseControl)control;
                                int total = prrc.getResultSize();
                                if (total != 0) {
                                    LOG.debug("END-OF-PAGE total : {}", (Object)total);
                                } else {
                                    LOG.debug("END-OF-PAGE total : unknown");
                                }
                                cookie = prrc.getCookie();
                            }
                        } else {
                            LOG.debug("No controls were sent from the server");
                        }
                        if (!this.pagedResultsEnabled) continue;
                        LOG.debug("Fetched paged results round: {}", (Object)(++paged));
                        this.ldapContext.setRequestControls(new Control[]{new PagedResultsControl(this.pagedResultsSize, cookie, true)});
                    } while (cookie != null);
                    LOG.info("LdapUserGroupBuilder.getDNForMemberOf() completed with group count: {}", (Object)counter);
                }
                catch (Exception t) {
                    LOG.error("LdapUserGroupBuilder.getDNForMemberOf() failed with exception: ", (Throwable)t);
                    LOG.info("LdapUserGroupBuilder.getDNForMemberOf() group count: {}", (Object)counter);
                }
            }
        }
        finally {
            if (userSearchResultEnum != null) {
                userSearchResultEnum.close();
            }
            this.closeLdapContext();
        }
        LOG.debug("computedSearchFilter = {}", (Object)computedSearchFilter);
        return computedSearchFilter;
    }
}

