/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authentication;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.authentication.PasswordValidator;
import org.apache.ranger.credentialapi.CredentialReader;
import org.apache.ranger.plugin.util.XMLUtils;
import org.apache.ranger.unixusersync.config.UserGroupSyncConfig;
import org.apache.ranger.unixusersync.ha.UserSyncHAInitializerImpl;
import org.apache.ranger.usergroupsync.UserGroupSync;
import org.apache.ranger.usergroupsync.UserSyncMetricsProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixAuthenticationService {
    private static final Logger LOG = LoggerFactory.getLogger(UnixAuthenticationService.class);
    private static final String serviceName = "UnixAuthenticationService";
    private static final String SSL_ALGORITHM = "TLSv1.2";
    private static final String REMOTE_LOGIN_AUTH_SERVICE_PORT_PARAM = "ranger.usersync.port";
    private static final String SSL_KEYSTORE_PATH_PARAM = "ranger.usersync.keystore.file";
    private static final String SSL_TRUSTSTORE_PATH_PARAM = "ranger.usersync.truststore.file";
    private static final String SSL_KEYSTORE_FILE_TYPE_PARAM = "ranger.keystore.file.type";
    private static final String SSL_TRUSTSTORE_FILE_TYPE_PARAM = "ranger.truststore.file.type";
    private static final String SSL_KEYSTORE_PATH_PASSWORD_ALIAS = "usersync.ssl.key.password";
    private static final String SSL_TRUSTSTORE_PATH_PASSWORD_ALIAS = "usersync.ssl.truststore.password";
    private static final String CRED_VALIDATOR_PROG = "ranger.usersync.passwordvalidator.path";
    private static final String ADMIN_USER_LIST_PARAM = "admin.users";
    private static final String ADMIN_ROLE_LIST_PARAM = "admin.roleNames";
    private static final String SSL_ENABLED_PARAM = "ranger.usersync.ssl";
    private static final String CREDSTORE_FILENAME_PARAM = "ranger.usersync.credstore.filename";
    private static final String[] UGSYNC_CONFIG_XML_FILES = new String[]{"ranger-ugsync-default.xml", "ranger-ugsync-site.xml"};
    private static boolean enableUnixAuth;
    private final List<String> adminUserList = new ArrayList<String>();
    private String adminRoleNames;
    private String keyStorePath;
    private String keyStorePathPassword;
    private String keyStoreType;
    private String trustStorePath;
    private String trustStorePathPassword;
    private String trustStoreType;
    private List<String> enabledProtocolsList;
    private List<String> enabledCipherSuiteList;
    private UserSyncHAInitializerImpl userSyncHAInitializerImpl;
    private int portNum;
    private boolean sslEnabled;

    public static void main(String[] args) {
        enableUnixAuth = Arrays.stream(args).anyMatch("-enableUnixAuth"::equalsIgnoreCase);
        UnixAuthenticationService service = new UnixAuthenticationService();
        service.userSyncHAInitializerImpl = UserSyncHAInitializerImpl.getInstance((Configuration)UserGroupSyncConfig.getInstance().getUserGroupConfig());
        service.run();
    }

    public void run() {
        try {
            LOG.info("Starting User Sync Service!");
            this.startUnixUserGroupSyncProcess();
            Thread.sleep(5000L);
            if (enableUnixAuth) {
                LOG.info("Enabling Unix Auth Service!");
                this.init();
                this.startService();
            } else {
                LOG.info("Unix Auth Service Disabled!");
            }
        }
        catch (Throwable t) {
            LOG.error("ERROR: Service: {}", (Object)serviceName, (Object)t);
        }
        finally {
            LOG.info("Service: {} - STOPPED", (Object)serviceName);
            if (this.userSyncHAInitializerImpl != null) {
                LOG.info("Stopping curator leader latch service as main thread is closing");
                this.userSyncHAInitializerImpl.stop();
            }
        }
    }

    public void startService() throws Throwable {
        SSLContext context = SSLContext.getInstance(SSL_ALGORITHM);
        KeyManager[] km = null;
        if (this.keyStorePath != null && !this.keyStorePath.isEmpty()) {
            KeyStore ks = KeyStore.getInstance(this.keyStoreType);
            try (InputStream in = this.getFileInputStream(this.keyStorePath);){
                if (this.keyStorePathPassword == null) {
                    this.keyStorePathPassword = "";
                }
                ks.load(in, this.keyStorePathPassword.toCharArray());
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, this.keyStorePathPassword.toCharArray());
            km = kmf.getKeyManagers();
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore trustStoreKeyStore = null;
        if (this.trustStorePath != null && !this.trustStorePath.isEmpty()) {
            trustStoreKeyStore = KeyStore.getInstance(this.trustStoreType);
            try (InputStream in = this.getFileInputStream(this.trustStorePath);){
                if (this.trustStorePathPassword == null) {
                    this.trustStorePathPassword = "";
                }
                trustStoreKeyStore.load(in, this.trustStorePathPassword.toCharArray());
            }
        }
        trustManagerFactory.init(trustStoreKeyStore);
        TrustManager[] tm = trustManagerFactory.getTrustManagers();
        SecureRandom random = new SecureRandom();
        context.init(km, tm, random);
        SSLServerSocketFactory sf = context.getServerSocketFactory();
        try (ServerSocket socket = this.sslEnabled ? sf.createServerSocket(this.portNum) : new ServerSocket(this.portNum);){
            if (this.sslEnabled) {
                SSLServerSocket secureSocket = (SSLServerSocket)socket;
                String[] protocols = secureSocket.getEnabledProtocols();
                HashSet<String> allowedProtocols = new HashSet<String>();
                for (String ep : protocols) {
                    if (this.enabledProtocolsList.contains(ep.toUpperCase())) {
                        LOG.info("Enabling Protocol: [{}]", (Object)ep);
                        allowedProtocols.add(ep);
                        continue;
                    }
                    LOG.info("Disabling Protocol: [{}]", (Object)ep);
                }
                if (!allowedProtocols.isEmpty()) {
                    secureSocket.setEnabledProtocols(allowedProtocols.toArray(new String[0]));
                }
                String[] enabledCipherSuites = secureSocket.getEnabledCipherSuites();
                HashSet<String> allowedCipherSuites = new HashSet<String>();
                for (String enabledCipherSuite : enabledCipherSuites) {
                    if (this.enabledCipherSuiteList.contains(enabledCipherSuite)) {
                        LOG.debug("Enabling CipherSuite : [{}]", (Object)enabledCipherSuite);
                        allowedCipherSuites.add(enabledCipherSuite);
                        continue;
                    }
                    LOG.debug("Disabling CipherSuite : [{}]", (Object)enabledCipherSuite);
                }
                if (!allowedCipherSuites.isEmpty()) {
                    secureSocket.setEnabledCipherSuites(allowedCipherSuites.toArray(new String[0]));
                }
            }
            try {
                Socket client;
                while ((client = socket.accept()) != null) {
                    Thread clientValidatorThread = new Thread(new PasswordValidator(client));
                    clientValidatorThread.start();
                }
            }
            catch (IOException e) {
                socket.close();
                throw e;
            }
        }
    }

    private void startUnixUserGroupSyncProcess() {
        LOG.info("Start : startUnixUserGroupSyncProcess ");
        UserGroupSync syncProc = new UserGroupSync();
        Thread newSyncProcThread = new Thread((Runnable)syncProc);
        newSyncProcThread.setName("UnixUserSyncThread");
        newSyncProcThread.setDaemon(false);
        newSyncProcThread.start();
        LOG.info("UnixUserSyncThread started");
        LOG.info("creating UserSyncMetricsProducer thread with default metrics location : {}", (Object)System.getProperty("logdir"));
        boolean isUserSyncMetricsEnabled = UserGroupSyncConfig.getInstance().isUserSyncMetricsEnabled();
        if (isUserSyncMetricsEnabled) {
            UserSyncMetricsProducer userSyncMetricsProducer = new UserSyncMetricsProducer();
            Thread userSyncMetricsProducerThread = new Thread((Runnable)userSyncMetricsProducer);
            userSyncMetricsProducerThread.setName("UserSyncMetricsProducerThread");
            userSyncMetricsProducerThread.setDaemon(false);
            userSyncMetricsProducerThread.start();
            LOG.info("UserSyncMetricsProducer started");
        } else {
            LOG.info(" Ranger userSync metrics is not enabled");
        }
    }

    private void init() {
        String sslEnabledProp;
        String adminUsers;
        Properties prop = new Properties();
        for (String fn : UGSYNC_CONFIG_XML_FILES) {
            XMLUtils.loadConfig((String)fn, (Map)prop);
        }
        String credStoreFileName = prop.getProperty(CREDSTORE_FILENAME_PARAM);
        this.keyStorePath = prop.getProperty(SSL_KEYSTORE_PATH_PARAM);
        this.trustStorePath = prop.getProperty(SSL_TRUSTSTORE_PATH_PARAM);
        this.keyStoreType = prop.getProperty(SSL_KEYSTORE_FILE_TYPE_PARAM, KeyStore.getDefaultType());
        this.trustStoreType = prop.getProperty(SSL_TRUSTSTORE_FILE_TYPE_PARAM, KeyStore.getDefaultType());
        if (credStoreFileName == null) {
            throw new RuntimeException("Credential file is not defined. param = [ranger.usersync.credstore.filename]");
        }
        File credFile = new File(credStoreFileName);
        if (!credFile.exists()) {
            throw new RuntimeException("Credential file [" + credStoreFileName + "]: does not exists.");
        }
        if (!credFile.canRead()) {
            throw new RuntimeException("Credential file [" + credStoreFileName + "]: can not be read.");
        }
        if ("bcfks".equalsIgnoreCase(this.keyStoreType)) {
            String crendentialProviderPrefixBcfks = "bcfks://file";
            credStoreFileName = crendentialProviderPrefixBcfks + credStoreFileName;
        }
        this.keyStorePathPassword = CredentialReader.getDecryptedString((String)credStoreFileName, (String)SSL_KEYSTORE_PATH_PASSWORD_ALIAS, (String)this.keyStoreType);
        this.trustStorePathPassword = CredentialReader.getDecryptedString((String)credStoreFileName, (String)SSL_TRUSTSTORE_PATH_PASSWORD_ALIAS, (String)this.trustStoreType);
        this.portNum = Integer.parseInt(prop.getProperty(REMOTE_LOGIN_AUTH_SERVICE_PORT_PARAM));
        String validatorProg = prop.getProperty(CRED_VALIDATOR_PROG);
        if (validatorProg != null) {
            PasswordValidator.setValidatorProgram(validatorProg);
        }
        if ((adminUsers = prop.getProperty(ADMIN_USER_LIST_PARAM)) != null && !adminUsers.trim().isEmpty()) {
            for (String u : adminUsers.split(",")) {
                LOG.info("Adding Admin User: {}", (Object)u.trim());
                this.adminUserList.add(u.trim());
            }
            PasswordValidator.setAdminUserList(this.adminUserList);
        }
        this.adminRoleNames = prop.getProperty(ADMIN_ROLE_LIST_PARAM);
        if (this.adminRoleNames != null) {
            LOG.info("Adding Admin Group: {}", (Object)this.adminRoleNames);
            PasswordValidator.setAdminRoleNames(this.adminRoleNames);
        }
        this.sslEnabled = (sslEnabledProp = prop.getProperty(SSL_ENABLED_PARAM)) != null && sslEnabledProp.equalsIgnoreCase("true");
        String defaultEnabledProtocols = SSL_ALGORITHM;
        String enabledProtocols = prop.getProperty("ranger.usersync.https.ssl.enabled.protocols", defaultEnabledProtocols);
        String enabledCipherSuites = prop.getProperty("ranger.usersync.https.ssl.enabled.cipher.suites", "");
        this.enabledProtocolsList = new ArrayList<String>(Arrays.asList(enabledProtocols.toUpperCase().trim().split("\\s*,\\s*")));
        this.enabledCipherSuiteList = new ArrayList<String>(Arrays.asList(enabledCipherSuites.toUpperCase().trim().split("\\s*,\\s*")));
    }

    private InputStream getFileInputStream(String path) throws FileNotFoundException {
        InputStream ret;
        File f = new File(path);
        if (f.exists()) {
            ret = new FileInputStream(f);
        } else {
            ret = this.getClass().getResourceAsStream(path);
            if (ret == null) {
                ret = this.getClass().getResourceAsStream(File.separator + path);
            }
        }
        return ret;
    }
}

