/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authentication;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordValidator
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordValidator.class);
    private static List<String> adminUserList;
    private static String adminRoleNames;
    private static String validatorProgram;
    private Socket client;

    public PasswordValidator(Socket client) {
        this.client = client;
    }

    public static String getValidatorProgram() {
        return validatorProgram;
    }

    public static void setValidatorProgram(String validatorProgram) {
        PasswordValidator.validatorProgram = validatorProgram;
    }

    public static List<String> getAdminUserList() {
        return adminUserList;
    }

    public static void setAdminUserList(List<String> adminUserList) {
        PasswordValidator.adminUserList = adminUserList;
    }

    public static String getAdminRoleNames() {
        return adminRoleNames;
    }

    public static void setAdminRoleNames(String adminRoleNames) {
        PasswordValidator.adminRoleNames = adminRoleNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        PrintWriter writer = null;
        String userName = null;
        try {
            String line;
            int passwordAt;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
            writer = new PrintWriter(new OutputStreamWriter(this.client.getOutputStream()));
            String request = reader.readLine();
            if (request.startsWith("LOGIN:") && (passwordAt = (line = request.substring(6).trim()).indexOf(32)) != -1) {
                userName = line.substring(0, passwordAt).trim();
            }
            if (validatorProgram == null) {
                String res = "FAILED: Unable to validate credentials.";
                writer.println(res);
                writer.flush();
                LOG.error("Response [{}] for user: {} as ValidatorProgram is not defined in configuration", (Object)res, userName);
                return;
            }
            Process p = null;
            try {
                p = Runtime.getRuntime().exec(validatorProgram);
                BufferedReader pReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                PrintWriter pWriter = new PrintWriter(new OutputStreamWriter(p.getOutputStream()));
                pWriter.println(request);
                pWriter.flush();
                String res = pReader.readLine();
                if (res != null && res.startsWith("OK") && adminRoleNames != null && adminUserList != null && adminUserList.contains(userName)) {
                    res = res + " " + adminRoleNames;
                }
                LOG.info("Response [{}] for user: {}", (Object)res, (Object)userName);
                writer.println(res);
                writer.flush();
                return;
            }
            finally {
                if (p != null) {
                    p.destroy();
                }
            }
        }
        catch (Throwable t) {
            if (userName == null) return;
            if (writer == null) return;
            String res = "FAILED: unable to validate due to error " + t.getMessage();
            writer.println(res);
            LOG.error("Response [{}] for user: {} message: {}", new Object[]{res, userName, t.getMessage()});
            return;
        }
        finally {
            try {
                if (this.client != null) {
                    this.client.close();
                }
            }
            catch (IOException ioe) {
                LOG.debug("Close socket failure. Detail: ", (Throwable)ioe);
            }
            finally {
                this.client = null;
            }
        }
    }
}

