/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.ugsyncutil.util;

public class UgsyncCommonConstants {
    public static final String ORIGINAL_NAME = "original_name";
    public static final String FULL_NAME = "full_name";
    public static final String SYNC_SOURCE = "sync_source";
    public static final String LDAP_URL = "ldap_url";
    public static final String UGSYNC_NONE_CASE_CONVERSION_VALUE = "none";
    public static final String UGSYNC_LOWER_CASE_CONVERSION_VALUE = "lower";
    public static final String UGSYNC_UPPER_CASE_CONVERSION_VALUE = "upper";
    public static final String UGSYNC_USERNAME_CASE_CONVERSION_PARAM = "ranger.usersync.ldap.username.caseconversion";
    public static final String DEFAULT_UGSYNC_USERNAME_CASE_CONVERSION_VALUE = "none";
    public static final String UGSYNC_GROUPNAME_CASE_CONVERSION_PARAM = "ranger.usersync.ldap.groupname.caseconversion";
    public static final String DEFAULT_UGSYNC_GROUPNAME_CASE_CONVERSION_VALUE = "none";
    public static final String SYNC_MAPPING_USERNAME = "ranger.usersync.mapping.username.regex";
    public static final String SYNC_MAPPING_GROUPNAME = "ranger.usersync.mapping.groupname.regex";
    public static final String SYNC_MAPPING_USERNAME_HANDLER = "ranger.usersync.mapping.username.handler";
    public static final String DEFAULT_SYNC_MAPPING_USERNAME_HANDLER = "org.apache.ranger.ugsyncutil.transform.RegEx";
    public static final String SYNC_MAPPING_GROUPNAME_HANDLER = "ranger.usersync.mapping.groupname.handler";
    public static final String DEFAULT_SYNC_MAPPING_GROUPNAME_HANDLER = "org.apache.ranger.ugsyncutil.transform.RegEx";
    public static final String SYNC_MAPPING_SEPARATOR = "ranger.usersync.mapping.regex.separator";
    public static final String DEFAULT_MAPPING_SEPARATOR = "/";

    private UgsyncCommonConstants() {
    }

    public static CaseConversion toCaseConversion(String value) {
        if (UGSYNC_LOWER_CASE_CONVERSION_VALUE.equalsIgnoreCase(value)) {
            return CaseConversion.TO_LOWER;
        }
        if (UGSYNC_UPPER_CASE_CONVERSION_VALUE.equalsIgnoreCase(value)) {
            return CaseConversion.TO_UPPER;
        }
        return CaseConversion.NONE;
    }

    public static enum CaseConversion {
        NONE,
        TO_LOWER,
        TO_UPPER;

    }
}

