/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.ugsyncutil.transform;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ranger.ugsyncutil.transform.AbstractMapper;

public class RegEx
extends AbstractMapper {
    private LinkedHashMap<String, String> replacementPattern;

    public LinkedHashMap<String, String> getReplacementPattern() {
        return this.replacementPattern;
    }

    @Override
    public void init(String baseProperty, List<String> regexPatterns, String regexSeparator) {
        logger.info("Initializing for {}", (Object)baseProperty);
        try {
            this.populateReplacementPatterns(baseProperty, regexPatterns, regexSeparator);
        }
        catch (Throwable t) {
            logger.error("Failed to initialize {}", (Object)baseProperty, (Object)t.fillInStackTrace());
        }
    }

    @Override
    public String transform(String attrValue) {
        String result = attrValue;
        try {
            if (this.replacementPattern != null && !this.replacementPattern.isEmpty()) {
                for (String matchPattern : this.replacementPattern.keySet()) {
                    String replacement = this.replacementPattern.get(matchPattern);
                    Pattern p = Pattern.compile(matchPattern);
                    Matcher m = p.matcher(result);
                    result = m.replaceAll(replacement);
                }
            }
        }
        catch (Throwable t) {
            logger.error("Failed to transform {}", (Object)attrValue, (Object)t.fillInStackTrace());
        }
        return result;
    }

    void populateReplacementPatterns(String baseProperty, List<String> regexPatterns, String regexSeparator) {
        this.replacementPattern = new LinkedHashMap();
        String regex = String.format("s%s([^%s]*)%s([^%s]*)%s(g)?", regexSeparator, regexSeparator, regexSeparator, regexSeparator, regexSeparator);
        Pattern p = Pattern.compile(regex);
        for (String regexPattern : regexPatterns) {
            Matcher m = p.matcher(regexPattern);
            if (!m.matches()) {
                logger.warn("Invalid RegEx {} and hence skipping this regex property", (Object)regexPattern);
            }
            m = m.reset();
            while (m.find()) {
                String matchPattern = m.group(1);
                String replacement = m.group(2);
                if (matchPattern == null || matchPattern.isEmpty() || replacement == null) continue;
                this.replacementPattern.put(matchPattern, replacement);
                logger.debug("{} match pattern = {} and replacement string = {}", new Object[]{baseProperty, matchPattern, replacement});
            }
        }
    }
}

