/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.yarn.client;

import java.util.List;
import java.util.Map;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.yarn.client.YarnClient;
import org.apache.ranger.services.yarn.client.YarnConnectionMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnResourceMgr {
    private static final Logger LOG = LoggerFactory.getLogger(YarnResourceMgr.class);
    private static final String YARNQUEUE = "queue";

    private YarnResourceMgr() {
    }

    public static Map<String, Object> validateConfig(String serviceName, Map<String, String> configs) {
        Map<String, Object> ret;
        LOG.debug("==> YarnResourceMgr.validateConfig ServiceName: {}Configs{}", (Object)serviceName, configs);
        try {
            ret = YarnClient.connectionTest(serviceName, configs);
        }
        catch (Exception e) {
            LOG.error("<== YarnResourceMgr.validateConfig Error: {}", (Object)String.valueOf(e));
            throw e;
        }
        LOG.debug("<== YarnResourceMgr.validateConfig Result : {}", ret);
        return ret;
    }

    public static List<String> getYarnResources(String serviceName, Map<String, String> configs, ResourceLookupContext context) {
        String yarnQueueName;
        String userInput = context.getUserInput();
        Map resourceMap = context.getResources();
        List<String> resultList = null;
        List yarnQueueList = null;
        if (resourceMap != null && !resourceMap.isEmpty() && resourceMap.get(YARNQUEUE) != null) {
            yarnQueueName = userInput;
            yarnQueueList = (List)resourceMap.get(YARNQUEUE);
        } else {
            yarnQueueName = userInput;
        }
        if (configs == null || configs.isEmpty()) {
            LOG.error("Connection Config is empty");
        } else {
            resultList = YarnResourceMgr.getYarnResource(serviceName, configs, yarnQueueName, yarnQueueList);
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getYarnResource(String serviceName, Map<String, String> configs, String yarnQueueName, List<String> yarnQueueList) {
        YarnClient yarnClient = YarnConnectionMgr.getYarnClient(serviceName, configs);
        List<String> topologyList = null;
        if (yarnClient != null) {
            YarnClient yarnClient2 = yarnClient;
            synchronized (yarnClient2) {
                topologyList = yarnClient.getQueueList(yarnQueueName, yarnQueueList);
            }
        }
        return topologyList;
    }
}

