/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.yarn.authorizer;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.security.AccessRequest;
import org.apache.hadoop.yarn.security.Permission;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.ranger.plugin.classloader.PluginClassLoaderActivator;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerYarnAuthorizer
extends YarnAuthorizationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RangerYarnAuthorizer.class);
    private static final String RANGER_PLUGIN_TYPE = "yarn";
    private static final String RANGER_YARN_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.yarn.authorizer.RangerYarnAuthorizer";
    private YarnAuthorizationProvider yarnAuthorizationProviderImpl;
    private RangerPluginClassLoader pluginClassLoader;

    public RangerYarnAuthorizer() {
        LOG.debug("==> RangerYarnAuthorizer.RangerYarnAuthorizer()");
        this.init();
        LOG.debug("<== RangerYarnAuthorizer.RangerYarnAuthorizer()");
    }

    public void init(Configuration conf) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "init");){
            this.yarnAuthorizationProviderImpl.init(conf);
        }
    }

    public boolean checkPermission(AccessRequest accessRequest) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkPermission");){
            boolean bl = this.yarnAuthorizationProviderImpl.checkPermission(accessRequest);
            return bl;
        }
    }

    public void setPermission(List<Permission> permissions, UserGroupInformation ugi) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "setPermission");){
            this.yarnAuthorizationProviderImpl.setPermission(permissions, ugi);
        }
    }

    public void setAdmins(AccessControlList acls, UserGroupInformation ugi) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "setAdmins");){
            this.yarnAuthorizationProviderImpl.setAdmins(acls, ugi);
        }
    }

    public boolean isAdmin(UserGroupInformation ugi) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "isAdmin");){
            boolean bl = this.yarnAuthorizationProviderImpl.isAdmin(ugi);
            return bl;
        }
    }

    private void init() {
        LOG.debug("==> RangerYarnAuthorizer.init()");
        try {
            this.pluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, ((Object)((Object)this)).getClass());
            Class<?> cls = Class.forName(RANGER_YARN_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)this.pluginClassLoader);
            try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "init");){
                this.yarnAuthorizationProviderImpl = (YarnAuthorizationProvider)cls.newInstance();
            }
        }
        catch (Exception e) {
            LOG.error("Error Enabling RangerYarnPlugin", (Throwable)e);
        }
        LOG.debug("<== RangerYarnAuthorizer.init()");
    }
}

