/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.trino.client;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.ranger.plugin.client.BaseClient;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.util.PasswordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrinoClient
extends BaseClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(TrinoClient.class);
    public static final String TRINO_USER_NAME_PROP = "user";
    public static final String TRINO_PASSWORD_PROP = "password";
    private static final String ERR_MSG = "You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.";
    private Connection con;

    public TrinoClient(String serviceName) {
        super(serviceName, null);
        this.init();
    }

    public TrinoClient(String serviceName, Map<String, String> properties) {
        super(serviceName, properties);
        this.init();
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> connectionProperties) {
        HashMap<String, Object> resp = new HashMap<String, Object>();
        boolean status = false;
        try (TrinoClient client = new TrinoClient(serviceName, connectionProperties);){
            List<String> testResult = client.getCatalogList("*", null);
            if (testResult != null && !testResult.isEmpty()) {
                status = true;
            }
            if (status) {
                String msg = "Connection test successful";
                TrinoClient.generateResponseDataMap((boolean)true, (String)msg, (String)msg, null, null, resp);
            }
        }
        return resp;
    }

    public List<String> getCatalogList(String needle, List<String> catalogs) throws HadoopException {
        String ndl = needle;
        return Subject.doAs(this.getLoginSubject(), () -> {
            List<String> ret;
            try {
                ret = this.getCatalogs(ndl, catalogs);
            }
            catch (HadoopException he) {
                LOG.error("<== TrinoClient.getCatalogList() :Unable to get the Database List", (Throwable)he);
                throw he;
            }
            return ret;
        });
    }

    public List<String> getSchemaList(String needle, List<String> catalogs, List<String> schemas) throws HadoopException {
        String ndl = needle;
        List<String> cats = catalogs;
        List<String> shms = schemas;
        return Subject.doAs(this.getLoginSubject(), () -> {
            List<String> ret = null;
            try {
                ret = this.getSchemas(ndl, cats, shms);
            }
            catch (HadoopException he) {
                LOG.error("<== TrinoClient.getSchemaList() :Unable to get the Schema List", (Throwable)he);
            }
            return ret;
        });
    }

    public List<String> getTableList(String needle, List<String> catalogs, List<String> schemas, List<String> tables) throws HadoopException {
        String ndl = needle;
        List<String> cats = catalogs;
        List<String> shms = schemas;
        List<String> tbls = tables;
        return Subject.doAs(this.getLoginSubject(), () -> {
            List<String> ret;
            try {
                ret = this.getTables(ndl, cats, shms, tbls);
            }
            catch (HadoopException he) {
                LOG.error("<== TrinoClient.getTableList() :Unable to get the Column List", (Throwable)he);
                throw he;
            }
            return ret;
        });
    }

    public List<String> getColumnList(String needle, List<String> catalogs, List<String> schemas, List<String> tables, List<String> columns) throws HadoopException {
        String ndl = needle;
        List<String> cats = catalogs;
        List<String> shms = schemas;
        List<String> tbls = tables;
        List<String> cols = columns;
        return Subject.doAs(this.getLoginSubject(), () -> {
            List<String> ret;
            try {
                ret = this.getColumns(ndl, cats, shms, tbls, cols);
            }
            catch (HadoopException he) {
                LOG.error("<== TrinoClient.getColumnList() :Unable to get the Column List", (Throwable)he);
                throw he;
            }
            return ret;
        });
    }

    @Override
    public void close() {
        Subject.doAs(this.getLoginSubject(), () -> {
            this.close(this.con);
            return null;
        });
    }

    public void close(Statement stat) {
        try {
            if (stat != null) {
                stat.close();
            }
        }
        catch (SQLException e) {
            LOG.error("Unable to close SQL statement", (Throwable)e);
        }
    }

    public void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            LOG.error("Unable to close ResultSet", (Throwable)e);
        }
    }

    private void init() {
        Subject.doAs(this.getLoginSubject(), () -> {
            this.initConnection();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnection() {
        Properties prop = this.getConfigHolder().getRangerSection();
        String driverClassName = prop.getProperty("jdbc.driverClassName");
        String url = prop.getProperty("jdbc.url");
        Properties trinoProperties = new Properties();
        String decryptedPwd = null;
        try {
            decryptedPwd = PasswordUtils.decryptPassword((String)this.getConfigHolder().getPassword());
        }
        catch (Exception ex) {
            LOG.info("Password decryption failed");
        }
        finally {
            if (decryptedPwd == null) {
                decryptedPwd = prop.getProperty(TRINO_PASSWORD_PROP);
            }
        }
        trinoProperties.put(TRINO_USER_NAME_PROP, prop.getProperty("username"));
        if (prop.getProperty(TRINO_PASSWORD_PROP) != null) {
            trinoProperties.put(TRINO_PASSWORD_PROP, decryptedPwd);
        }
        if (driverClassName != null) {
            try {
                Driver driver = (Driver)Class.forName(driverClassName).newInstance();
                DriverManager.registerDriver(driver);
            }
            catch (SQLException e) {
                String msgDesc = "initConnection: Caught SQLException while registering the Trino driver.";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)e);
                hdpException.generateResponseDataMap(false, TrinoClient.getMessage((Throwable)e), msgDesc + ERR_MSG, null, null);
                throw hdpException;
            }
            catch (IllegalAccessException ilae) {
                String msgDesc = "initConnection: Class or its nullary constructor might not accessible.";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)ilae);
                hdpException.generateResponseDataMap(false, TrinoClient.getMessage((Throwable)ilae), msgDesc + ERR_MSG, null, null);
                throw hdpException;
            }
            catch (InstantiationException ie) {
                String msgDesc = "initConnection: Class may not have its nullary constructor or may be the instantiation fails for some other reason.";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)ie);
                hdpException.generateResponseDataMap(false, TrinoClient.getMessage((Throwable)ie), msgDesc + ERR_MSG, null, null);
                throw hdpException;
            }
            catch (ExceptionInInitializerError eie) {
                String msgDesc = "initConnection: Got ExceptionInInitializerError, The initialization provoked by this method fails.";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)eie);
                hdpException.generateResponseDataMap(false, TrinoClient.getMessage((Throwable)eie), msgDesc + ERR_MSG, null, null);
                throw hdpException;
            }
            catch (SecurityException se) {
                String msgDesc = "initConnection: unable to initiate connection to Trino instance, The caller's class loader is not the same as or an ancestor of the class loader for the current class and invocation of s.checkPackageAccess() denies access to the package of this class.";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)se);
                hdpException.generateResponseDataMap(false, TrinoClient.getMessage((Throwable)se), msgDesc + ERR_MSG, null, null);
                throw hdpException;
            }
            catch (Throwable t) {
                String msgDesc = "initConnection: Unable to connect to Trino instance, please provide valid value of field : {jdbc.driverClassName}.";
                HadoopException hdpException = new HadoopException(msgDesc, t);
                hdpException.generateResponseDataMap(false, TrinoClient.getMessage((Throwable)t), msgDesc + ERR_MSG, null, null);
                throw hdpException;
            }
        }
        try {
            this.con = DriverManager.getConnection(url, trinoProperties);
        }
        catch (SecurityException | SQLException e) {
            String msgDesc = "Unable to connect to Trino instance.";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)e);
            hdpException.generateResponseDataMap(false, TrinoClient.getMessage((Throwable)e), msgDesc + ERR_MSG, null, null);
            throw hdpException;
        }
        catch (Throwable t) {
            String msgDesc = "initConnection: Unable to connect to Trino instance, ";
            HadoopException hdpException = new HadoopException(msgDesc, t);
            hdpException.generateResponseDataMap(false, TrinoClient.getMessage((Throwable)t), msgDesc + ERR_MSG, null, null);
            throw hdpException;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getCatalogs(String needle, List<String> catalogs) throws HadoopException {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.con == null) return ret;
        Statement stat = null;
        ResultSet rs = null;
        String sql = "SHOW CATALOGS";
        try {
            if (needle != null && !needle.isEmpty() && !needle.equals("*")) {
                sql = sql + " LIKE '" + StringEscapeUtils.escapeSql((String)needle) + "%'";
            }
            stat = this.con.createStatement();
            rs = stat.executeQuery(sql);
            while (true) {
                if (!rs.next()) {
                    this.close(rs);
                    this.close(stat);
                    return ret;
                }
                String catalogName = rs.getString(1);
                if (catalogs != null && catalogs.contains(catalogName)) continue;
                ret.add(catalogName);
            }
        }
        catch (SQLTimeoutException sqlt) {
            try {
                String msgDesc = "Time Out, Unable to execute SQL [" + sql + "].";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqlt);
                hdpException.generateResponseDataMap(false, TrinoClient.getMessage((Throwable)sqlt), msgDesc + ERR_MSG, null, null);
                throw hdpException;
                catch (SQLException se) {
                    String msg = "Unable to execute SQL [" + sql + "]. ";
                    HadoopException he = new HadoopException(msg, (Throwable)se);
                    he.generateResponseDataMap(false, TrinoClient.getMessage((Throwable)se), msg + ERR_MSG, null, null);
                    throw he;
                }
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(stat);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> getSchemas(String needle, List<String> catalogs, List<String> schemas) throws HadoopException {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.con == null) return ret;
        Statement stat = null;
        ResultSet rs = null;
        String sql = null;
        try {
            if (catalogs == null || catalogs.isEmpty()) return ret;
            for (String catalog : catalogs) {
                sql = "SHOW SCHEMAS FROM \"" + StringEscapeUtils.escapeSql((String)catalog) + "\"";
                try {
                    if (needle != null && !needle.isEmpty() && !needle.equals("*")) {
                        sql = sql + " LIKE '" + StringEscapeUtils.escapeSql((String)needle) + "%'";
                    }
                    stat = this.con.createStatement();
                    rs = stat.executeQuery(sql);
                    while (rs.next()) {
                        String schema = rs.getString(1);
                        if (schemas != null && schemas.contains(schema)) continue;
                        ret.add(schema);
                    }
                    this.close(rs);
                    this.close(stat);
                    rs = null;
                    stat = null;
                }
                catch (Throwable throwable) {
                    this.close(rs);
                    this.close(stat);
                    rs = null;
                    stat = null;
                    throw throwable;
                    return ret;
                }
            }
        }
        catch (SQLTimeoutException sqlt) {
            String msgDesc = "Time Out, Unable to execute SQL [" + sql + "].";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqlt);
            hdpException.generateResponseDataMap(false, TrinoClient.getMessage((Throwable)sqlt), msgDesc + ERR_MSG, null, null);
            if (!LOG.isDebugEnabled()) throw hdpException;
            LOG.debug("<== TrinoClient.getSchemas() Error : ", (Throwable)sqlt);
            throw hdpException;
        }
        catch (SQLException sqle) {
            String msgDesc = "Unable to execute SQL [" + sql + "].";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqle);
            hdpException.generateResponseDataMap(false, TrinoClient.getMessage((Throwable)sqle), msgDesc + ERR_MSG, null, null);
            if (!LOG.isDebugEnabled()) throw hdpException;
            LOG.debug("<== TrinoClient.getSchemas() Error : ", (Throwable)sqle);
            throw hdpException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> getTables(String needle, List<String> catalogs, List<String> schemas, List<String> tables) throws HadoopException {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.con == null) return ret;
        Statement stat = null;
        ResultSet rs = null;
        String sql = null;
        if (catalogs == null) return ret;
        if (catalogs.isEmpty() || schemas == null || schemas.isEmpty()) return ret;
        try {
            for (String catalog : catalogs) {
                for (String schema : schemas) {
                    sql = "SHOW tables FROM \"" + StringEscapeUtils.escapeSql((String)catalog) + "\".\"" + StringEscapeUtils.escapeSql((String)schema) + "\"";
                    try {
                        if (needle != null && !needle.isEmpty() && !needle.equals("*")) {
                            sql = sql + " LIKE '" + StringEscapeUtils.escapeSql((String)needle) + "%'";
                        }
                        stat = this.con.createStatement();
                        rs = stat.executeQuery(sql);
                        while (rs.next()) {
                            String table = rs.getString(1);
                            if (tables != null && tables.contains(table)) continue;
                            ret.add(table);
                        }
                        this.close(rs);
                        this.close(stat);
                        rs = null;
                        stat = null;
                    }
                    catch (Throwable throwable) {
                        this.close(rs);
                        this.close(stat);
                        rs = null;
                        stat = null;
                        throw throwable;
                    }
                }
                continue;
                return ret;
            }
        }
        catch (SQLTimeoutException sqlt) {
            String msgDesc = "Time Out, Unable to execute SQL [" + sql + "].";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqlt);
            hdpException.generateResponseDataMap(false, TrinoClient.getMessage((Throwable)sqlt), msgDesc + ERR_MSG, null, null);
            if (!LOG.isDebugEnabled()) throw hdpException;
            LOG.debug("<== TrinoClient.getTables() Error : ", (Throwable)sqlt);
            throw hdpException;
        }
        catch (SQLException sqle) {
            String msgDesc = "Unable to execute SQL [" + sql + "].";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqle);
            hdpException.generateResponseDataMap(false, TrinoClient.getMessage((Throwable)sqle), msgDesc + ERR_MSG, null, null);
            if (!LOG.isDebugEnabled()) throw hdpException;
            LOG.debug("<== TrinoClient.getTables() Error : ", (Throwable)sqle);
            throw hdpException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> getColumns(String needle, List<String> catalogs, List<String> schemas, List<String> tables, List<String> columns) throws HadoopException {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.con == null) return ret;
        String regex = null;
        ResultSet rs = null;
        String sql = null;
        Statement stat = null;
        if (needle != null && !needle.isEmpty()) {
            regex = needle;
        }
        if (catalogs == null || catalogs.isEmpty() || schemas == null || schemas.isEmpty() || tables == null || tables.isEmpty()) return ret;
        try {
            for (String catalog : catalogs) {
                for (String schema : schemas) {
                    for (String table : tables) {
                        sql = "SHOW COLUMNS FROM \"" + StringEscapeUtils.escapeSql((String)catalog) + "\".\"" + StringEscapeUtils.escapeSql((String)schema) + "\".\"" + StringEscapeUtils.escapeSql((String)table) + "\"";
                        try {
                            stat = this.con.createStatement();
                            rs = stat.executeQuery(sql);
                            while (rs.next()) {
                                String column = rs.getString(1);
                                if (columns != null && columns.contains(column)) continue;
                                if (regex == null) {
                                    ret.add(column);
                                    continue;
                                }
                                if (!FilenameUtils.wildcardMatch((String)column, (String)regex)) continue;
                                ret.add(column);
                            }
                            this.close(rs);
                            this.close(stat);
                            stat = null;
                            rs = null;
                        }
                        catch (Throwable throwable) {
                            this.close(rs);
                            this.close(stat);
                            stat = null;
                            rs = null;
                            throw throwable;
                        }
                    }
                }
                continue;
                return ret;
            }
        }
        catch (SQLTimeoutException sqlt) {
            String msgDesc = "Time Out, Unable to execute SQL [" + sql + "].";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqlt);
            hdpException.generateResponseDataMap(false, TrinoClient.getMessage((Throwable)sqlt), msgDesc + ERR_MSG, null, null);
            if (!LOG.isDebugEnabled()) throw hdpException;
            LOG.debug("<== TrinoClient.getColumns() Error : ", (Throwable)sqlt);
            throw hdpException;
        }
        catch (SQLException sqle) {
            String msgDesc = "Unable to execute SQL [" + sql + "].";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqle);
            hdpException.generateResponseDataMap(false, TrinoClient.getMessage((Throwable)sqle), msgDesc + ERR_MSG, null, null);
            if (!LOG.isDebugEnabled()) throw hdpException;
            LOG.debug("<== TrinoClient.getColumns() Error : ", (Throwable)sqle);
            throw hdpException;
        }
    }

    private void close(Connection con) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e) {
            LOG.error("Unable to close Trino SQL connection", (Throwable)e);
        }
    }
}

