/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.sizing;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.authorization.utils.JsonUtils;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.RangerUserStore;
import org.apache.ranger.plugin.util.ServiceGdsInfo;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.apache.ranger.plugin.util.ServiceTags;
import org.apache.ranger.sizing.PerfMemTimeTracker;
import org.apache.ranger.sizing.PerfRequestGenerator;

public class RangerMemSizing {
    private static final String OPT_MODE_SPACE = "space";
    private static final String OPT_MODEL_RETRIEVAL = "retrieval";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
    private static final TypeReference<List<RangerAccessRequest>> TYPE_LIST_REQUESTS = new TypeReference<List<RangerAccessRequest>>(){};
    private final String policyFile;
    private final String tagFile;
    private final String rolesFile;
    private final String userStoreFile;
    private final String genRequestsFile;
    private final Set<String> genResourceKeys;
    private final String evalRequestsFile;
    private final int evalClientsCount;
    private final String gdsInfoFile;
    private final boolean deDup;
    private final boolean deDupStrings;
    private final String optimizationMode;
    private final boolean reuseResourceMatchers;
    private final PrintStream out = System.out;

    public RangerMemSizing(CommandLine cmdLine) {
        this.policyFile = cmdLine.getOptionValue('p');
        this.tagFile = cmdLine.getOptionValue('t');
        this.rolesFile = cmdLine.getOptionValue('r');
        this.userStoreFile = cmdLine.getOptionValue('u');
        this.genRequestsFile = cmdLine.getOptionValue('q');
        this.genResourceKeys = this.csvToSet(cmdLine.getOptionValue('k'));
        this.evalRequestsFile = cmdLine.getOptionValue('e');
        this.evalClientsCount = cmdLine.hasOption('c') ? Integer.parseInt(cmdLine.getOptionValue('c')) : 1;
        this.gdsInfoFile = cmdLine.getOptionValue('g');
        this.deDupStrings = this.deDup = Boolean.parseBoolean(cmdLine.getOptionValue("d", "true"));
        this.optimizationMode = StringUtils.startsWithIgnoreCase((String)cmdLine.getOptionValue('o', OPT_MODE_SPACE), (String)"s") ? OPT_MODE_SPACE : OPT_MODEL_RETRIEVAL;
        this.reuseResourceMatchers = Boolean.parseBoolean(cmdLine.getOptionValue('m', "true"));
    }

    public static void main(String[] args) {
        CommandLine cmdLine = RangerMemSizing.parseArgs(args);
        if (cmdLine != null) {
            RangerMemSizing memSizing = new RangerMemSizing(cmdLine);
            memSizing.run();
        }
    }

    public void run() {
        PerfMemTimeTracker tracker = new PerfMemTimeTracker("RangerMemSizing");
        ServicePolicies policies = this.loadPolicies(this.policyFile, tracker);
        ServiceTags tags = this.loadTags(this.tagFile, tracker);
        RangerRoles roles = this.loadRoles(this.rolesFile, tracker);
        RangerUserStore userStore = this.loadUserStore(this.userStoreFile, tracker);
        ServiceGdsInfo gdsInfo = this.loadGdsInfo(this.gdsInfoFile, tracker);
        RangerBasePlugin plugin = this.createRangerPlugin(policies, tags, roles, userStore, gdsInfo, tracker);
        int genReqCount = 0;
        int evalReqCount = 0;
        int evalAvgTimeNs = 0;
        if (StringUtils.isNotBlank((String)this.genRequestsFile)) {
            genReqCount = this.generateRequestsFile(policies, tags, this.genRequestsFile, tracker);
        }
        if (StringUtils.isNotBlank((String)this.evalRequestsFile)) {
            int[] res = this.evaluateRequests(this.evalRequestsFile, plugin, tracker);
            evalReqCount = res[0];
            evalAvgTimeNs = res[1];
        }
        tracker.stop();
        this.out.println();
        this.out.println("Parameters:");
        if (policies != null) {
            this.out.println("  Policies:      file=" + this.policyFile + ", size=" + new File(this.policyFile).length() + ", " + RangerMemSizing.toSummaryStr(policies));
        }
        if (tags != null) {
            this.out.println("  Tags:          file=" + this.tagFile + ", size=" + new File(this.tagFile).length() + ", " + RangerMemSizing.toSummaryStr(tags));
        }
        if (roles != null) {
            this.out.println("  Roles:         file=" + this.rolesFile + ", size=" + new File(this.rolesFile).length() + ", " + RangerMemSizing.toSummaryStr(roles));
        }
        if (userStore != null) {
            this.out.println("  UserStore:     file=" + this.userStoreFile + ", size=" + new File(this.userStoreFile).length() + ", " + RangerMemSizing.toSummaryStr(userStore));
        }
        if (this.genRequestsFile != null) {
            this.out.println("  GenReq:        file=" + this.genRequestsFile + ", requestCount=" + genReqCount);
        }
        if (this.evalRequestsFile != null) {
            this.out.println("  EvalReq:       file=" + this.evalRequestsFile + ", requestCount=" + evalReqCount + ", avgTimeTaken=" + evalAvgTimeNs + "ns, clientCount=" + this.evalClientsCount);
        }
        this.out.println("  DeDup:         " + this.deDup);
        this.out.println("  OptMode:       " + this.optimizationMode);
        this.out.println("  ReuseMatchers: " + this.reuseResourceMatchers);
        this.out.println();
        this.out.println("Results:");
        this.out.println("*****************************");
        tracker.print(this.out, true);
        this.out.println("*****************************");
    }

    private ServicePolicies loadPolicies(String fileName, PerfMemTimeTracker parent) {
        if (fileName == null) {
            return null;
        }
        ServicePolicies ret = null;
        try {
            File file = new File(fileName);
            PerfMemTimeTracker loadTracker = new PerfMemTimeTracker("Load policies");
            this.log("loading policies(file=" + fileName + ")");
            PerfMemTimeTracker tracker = new PerfMemTimeTracker("Read policies");
            try (FileReader reader = new FileReader(file);){
                ret = (ServicePolicies)JsonUtils.jsonToObject((Reader)reader, ServicePolicies.class);
            }
            tracker.stop();
            loadTracker.addChild(tracker);
            if (this.deDupStrings) {
                tracker = new PerfMemTimeTracker("DeDupStrings");
                ret.dedupStrings();
                tracker.stop();
                loadTracker.addChild(tracker);
            }
            loadTracker.stop();
            parent.addChild(loadTracker);
            this.log("loaded policies(file=" + fileName + ", size=" + file.length() + "): " + RangerMemSizing.toSummaryStr(ret));
        }
        catch (FileNotFoundException excp) {
            this.log(fileName + ": file does not exist!");
        }
        catch (IOException excp) {
            this.log(fileName, excp);
        }
        return ret;
    }

    private ServiceTags loadTags(String fileName, PerfMemTimeTracker parent) {
        if (fileName == null) {
            return null;
        }
        ServiceTags ret = null;
        try {
            File file = new File(fileName);
            PerfMemTimeTracker loadTracker = new PerfMemTimeTracker("Load tags");
            this.log("loading tags(file=" + fileName + ")");
            PerfMemTimeTracker tracker = new PerfMemTimeTracker("Read tags");
            try (FileReader reader = new FileReader(file);){
                ret = (ServiceTags)JsonUtils.jsonToObject((Reader)reader, ServiceTags.class);
            }
            tracker.stop();
            loadTracker.addChild(tracker);
            if (this.deDup) {
                tracker = new PerfMemTimeTracker("DeDupTags");
                int countOfDuplicateTags = ret.dedupTags();
                tracker.stop();
                loadTracker.addChild(tracker);
                this.log("DeDupTags(): duplicateTagsCount=" + countOfDuplicateTags);
            }
            if (this.deDupStrings) {
                tracker = new PerfMemTimeTracker("DeDupStrings");
                ret.dedupStrings();
                tracker.stop();
                loadTracker.addChild(tracker);
            }
            loadTracker.stop();
            parent.addChild(loadTracker);
            this.log("loaded tags(file=" + fileName + ", size=" + file.length() + "): " + RangerMemSizing.toSummaryStr(ret));
        }
        catch (FileNotFoundException excp) {
            this.log(fileName + ": file does not exist!");
        }
        catch (IOException excp) {
            this.log(fileName, excp);
        }
        return ret;
    }

    private RangerRoles loadRoles(String fileName, PerfMemTimeTracker parent) {
        if (fileName == null) {
            return null;
        }
        RangerRoles ret = null;
        try {
            File file = new File(fileName);
            PerfMemTimeTracker loadTracker = new PerfMemTimeTracker("Load roles");
            this.log("loading roles(file=" + fileName + ")");
            try (FileReader reader = new FileReader(file);){
                ret = (RangerRoles)JsonUtils.jsonToObject((Reader)reader, RangerRoles.class);
            }
            loadTracker.stop();
            parent.addChild(loadTracker);
            this.log("loaded roles(file=" + fileName + ", size=" + file.length() + "): " + RangerMemSizing.toSummaryStr(ret));
        }
        catch (FileNotFoundException excp) {
            this.log(fileName + ": file does not exist!");
        }
        catch (IOException excp) {
            this.log(fileName, excp);
        }
        return ret;
    }

    private RangerUserStore loadUserStore(String fileName, PerfMemTimeTracker parent) {
        if (fileName == null) {
            return null;
        }
        RangerUserStore ret = null;
        try {
            File file = new File(fileName);
            PerfMemTimeTracker loadTracker = new PerfMemTimeTracker("Load userStore");
            this.log("loading userStore(file=" + fileName + ")");
            PerfMemTimeTracker tracker = new PerfMemTimeTracker("Read userStore");
            try (FileReader reader = new FileReader(file);){
                ret = (RangerUserStore)JsonUtils.jsonToObject((Reader)reader, RangerUserStore.class);
            }
            tracker.stop();
            loadTracker.addChild(tracker);
            if (this.deDupStrings) {
                tracker = new PerfMemTimeTracker("DeDupStrings");
                ret.dedupStrings();
                tracker.stop();
                loadTracker.addChild(tracker);
            }
            loadTracker.stop();
            parent.addChild(loadTracker);
            this.log("loaded userStore(file=" + fileName + ", size=" + file.length() + "): " + RangerMemSizing.toSummaryStr(ret) + ")");
        }
        catch (FileNotFoundException excp) {
            this.log(fileName + ": file does not exist!");
        }
        catch (IOException excp) {
            this.log(fileName, excp);
        }
        return ret;
    }

    private ServiceGdsInfo loadGdsInfo(String fileName, PerfMemTimeTracker parent) {
        if (fileName == null) {
            return null;
        }
        ServiceGdsInfo ret = null;
        try {
            File file = new File(fileName);
            PerfMemTimeTracker loadTracker = new PerfMemTimeTracker("Load gdsInfo");
            this.log("loading gdsInfo(file=" + fileName + ")");
            PerfMemTimeTracker tracker = new PerfMemTimeTracker("Read gdsInfo");
            try (FileReader reader = new FileReader(file);){
                ret = (ServiceGdsInfo)JsonUtils.jsonToObject((Reader)reader, ServiceGdsInfo.class);
            }
            tracker.stop();
            loadTracker.addChild(tracker);
            if (this.deDupStrings) {
                tracker = new PerfMemTimeTracker("DeDupStrings");
                ret.dedupStrings();
                tracker.stop();
                loadTracker.addChild(tracker);
            }
            loadTracker.stop();
            parent.addChild(loadTracker);
            this.log("loaded gdsInfo(file=" + fileName + ", size=" + file.length() + "): " + RangerMemSizing.toSummaryStr(ret) + ")");
        }
        catch (FileNotFoundException excp) {
            this.log(fileName + ": file does not exist!");
        }
        catch (IOException excp) {
            this.log(fileName, excp);
        }
        return ret;
    }

    private RangerBasePlugin createRangerPlugin(ServicePolicies policies, ServiceTags tags, RangerRoles roles, RangerUserStore userStore, ServiceGdsInfo gdsInfo, PerfMemTimeTracker parent) {
        RangerBasePlugin ret = null;
        if (policies != null) {
            String serviceType = policies.getServiceDef().getName();
            String serviceName = policies.getServiceName();
            RangerPluginConfig pluginConfig = new RangerPluginConfig(serviceType, serviceName, serviceType, null, null, this.getPolicyEngineOptions());
            PerfMemTimeTracker tracker = new PerfMemTimeTracker("RangerBasePlugin initialization");
            this.log("Initializing RangerBasePlugin...");
            ret = new RangerBasePlugin(pluginConfig, policies, tags, roles, userStore, gdsInfo);
            tracker.stop();
            parent.addChild(tracker);
            this.log("Initialized RangerBasePlugin.");
        }
        return ret;
    }

    private int generateRequestsFile(ServicePolicies policies, ServiceTags tags, String fileName, PerfMemTimeTracker parent) {
        ObjectMapper mapper = JsonUtils.getMapper();
        this.initMapper(mapper);
        PerfMemTimeTracker tracker = new PerfMemTimeTracker("generateRequests");
        Collection<RangerAccessRequest> requests = new PerfRequestGenerator(this.genResourceKeys).generate(policies, tags);
        this.log("generateRequestsFile(): saving " + requests.size() + " requests..");
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(fileName, new String[0]), new OpenOption[0]);){
            writer.write(91);
            boolean isFirst = true;
            for (RangerAccessRequest request : requests) {
                if (!isFirst) {
                    writer.write(44);
                } else {
                    isFirst = false;
                }
                writer.newLine();
                writer.write(mapper.writeValueAsString((Object)request));
            }
            writer.newLine();
            writer.write(93);
            this.log("generateRequestsFile(): saved " + requests.size() + " requests");
        }
        catch (IOException excp) {
            this.log("generateRequestsFile(): failed", excp);
        }
        tracker.stop();
        parent.addChild(tracker);
        return requests.size();
    }

    private int[] evaluateRequests(String evalRequestsFile, RangerBasePlugin plugin, PerfMemTimeTracker parent) {
        PerfMemTimeTracker tracker = new PerfMemTimeTracker("evaluateRequests");
        List<RangerAccessRequest> requests = this.readRequests(evalRequestsFile, tracker);
        Thread[] clients = new Thread[this.evalClientsCount];
        AtomicInteger idxNextRequest = new AtomicInteger();
        AtomicLong totalTimeTakenNs = new AtomicLong();
        for (int idxClient = 0; idxClient < this.evalClientsCount; ++idxClient) {
            clients[idxClient] = new Thread(() -> {
                int idxReq;
                while ((idxReq = idxNextRequest.getAndIncrement()) < requests.size()) {
                    RangerAccessRequest request = (RangerAccessRequest)requests.get(idxReq);
                    long startTime = System.nanoTime();
                    plugin.isAccessAllowed(request);
                    totalTimeTakenNs.getAndAdd(System.nanoTime() - startTime);
                    if ((idxReq + 1) % 1000 == 0) {
                        this.log("  evaluated requests: " + (idxReq + 1) + ", avgTimeTaken=" + totalTimeTakenNs.get() / (long)idxReq + "ns");
                    }
                    requests.set(idxReq, null);
                }
            });
        }
        this.log("evaluateRequests(): evaluating " + requests.size() + " requests in " + clients.length + " clients...");
        for (Thread client : clients) {
            client.start();
        }
        this.log("evaluateRequests(): waiting for " + clients.length + " clients to complete...");
        for (Thread client : clients) {
            try {
                client.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        tracker.stop();
        parent.addChild(tracker);
        int avgTimeTakenNs = (int)(totalTimeTakenNs.get() / (long)idxNextRequest.get());
        this.log("evaluateRequests(): evaluated " + idxNextRequest.get() + " requests, avgTimeTaken=" + avgTimeTakenNs + "ns");
        return new int[]{requests.size(), avgTimeTakenNs};
    }

    private List<RangerAccessRequest> readRequests(String fileName, PerfMemTimeTracker parent) {
        PerfMemTimeTracker tracker = new PerfMemTimeTracker("readRequests");
        List<RangerAccessRequest> ret = null;
        ObjectMapper mapper = JsonUtils.getMapper();
        this.initMapper(mapper);
        try (InputStream inStr = Files.newInputStream(Paths.get(this.evalRequestsFile, new String[0]), new OpenOption[0]);){
            ret = (List<RangerAccessRequest>)mapper.readValue(inStr, TYPE_LIST_REQUESTS);
        }
        catch (IOException excp) {
            this.log("readRequests(): failed to read file " + this.evalRequestsFile, excp);
        }
        if (ret == null) {
            ret = Collections.emptyList();
        }
        tracker.stop();
        parent.addChild(tracker);
        this.log("readRequests(file=" + fileName + ", size=" + new File(this.evalRequestsFile).length() + "): request count=" + ret.size());
        return ret;
    }

    private static CommandLine parseArgs(String[] args) {
        Option help = new Option("h", "help", false, "show help");
        Option deDup = new Option("d", "deDup", true, "deDup string, tags: true|false");
        Option policies = new Option("p", "policies", true, "policies file");
        Option tags = new Option("t", "tags", true, "tags file");
        Option roles = new Option("r", "roles", true, "roles file");
        Option userStore = new Option("u", "userStore", true, "userStore file");
        Option genRequests = new Option("q", "genRequests", true, "generate requests file");
        Option evalRequests = new Option("e", "evalRequests", true, "eval requests file");
        Option evalClients = new Option("c", "evalClients", true, "eval clients count");
        Option gdsInfo = new Option("g", "gdsInfo", true, "gdsInfo file");
        Option optimizeMode = new Option("o", "optMode", true, "optimization mode: space|retrieval");
        Option reuseResourceMatchers = new Option("m", "reuseResourceMatchers", true, "reuse resource matchers: true|false");
        Option genResourceKeys = new Option("k", "genResourceKeys", true, "list of resourceKeys (comma separated) to generate requests for");
        Options options = new Options();
        options.addOption(help);
        options.addOption(policies);
        options.addOption(tags);
        options.addOption(roles);
        options.addOption(userStore);
        options.addOption(genRequests);
        options.addOption(evalRequests);
        options.addOption(evalClients);
        options.addOption(gdsInfo);
        options.addOption(deDup);
        options.addOption(optimizeMode);
        options.addOption(reuseResourceMatchers);
        options.addOption(genResourceKeys);
        try {
            CommandLine cmdLine = new DefaultParser().parse(options, args);
            if (!cmdLine.hasOption("h")) {
                return cmdLine;
            }
            new HelpFormatter().printHelp("RangerMemSizing", options);
        }
        catch (ParseException excp) {
            System.out.println("Failed to parse arguments");
            excp.printStackTrace(System.out);
        }
        return null;
    }

    private void log(String msg) {
        this.out.println(DATE_FORMAT.format(new Date()) + ": " + msg);
    }

    private void log(String msg, Throwable excp) {
        this.out.println(DATE_FORMAT.format(new Date()) + ": " + msg);
        excp.printStackTrace(this.out);
    }

    private RangerPolicyEngineOptions getPolicyEngineOptions() {
        RangerPolicyEngineOptions ret = new RangerPolicyEngineOptions();
        ret.disablePolicyRefresher = true;
        ret.disableTagRetriever = true;
        ret.disableUserStoreRetriever = true;
        ret.disableGdsInfoRetriever = true;
        ret.optimizeTrieForSpace = this.optimizationMode.equals(OPT_MODE_SPACE);
        ret.optimizeTrieForRetrieval = !ret.optimizeTrieForSpace;
        ret.optimizeTagTrieForSpace = ret.optimizeTrieForSpace;
        ret.optimizeTagTrieForRetrieval = ret.optimizeTrieForRetrieval;
        ret.enableResourceMatcherReuse = this.reuseResourceMatchers;
        return ret;
    }

    private static String toSummaryStr(ServicePolicies policies) {
        int policyCount = 0;
        if (policies != null) {
            if (policies.getPolicies() != null) {
                policyCount += policies.getPolicies().size();
            }
            if (policies.getTagPolicies() != null && policies.getTagPolicies().getPolicies() != null) {
                policyCount += policies.getTagPolicies().getPolicies().size();
            }
            if (policies.getSecurityZones() != null) {
                for (ServicePolicies.SecurityZoneInfo zoneInfo : policies.getSecurityZones().values()) {
                    if (zoneInfo.getPolicies() == null) continue;
                    policyCount += zoneInfo.getPolicies().size();
                }
            }
        }
        return "policyCount=" + policyCount;
    }

    private static String toSummaryStr(ServiceTags tags) {
        int tagDefCount = 0;
        int tagCount = 0;
        int resourceCount = 0;
        if (tags != null) {
            if (tags.getTagDefinitions() != null) {
                tagDefCount = tags.getTagDefinitions().size();
            }
            if (tags.getTags() != null) {
                tagCount = tags.getTags().size();
            }
            if (tags.getServiceResources() != null) {
                resourceCount = tags.getServiceResources().size();
            }
        }
        return "tagDefCount=" + tagDefCount + ", tagCount=" + tagCount + ", resourceCount=" + resourceCount;
    }

    private static String toSummaryStr(RangerRoles roles) {
        int roleCount = 0;
        if (roles != null && roles.getRangerRoles() != null) {
            roleCount = roles.getRangerRoles().size();
        }
        return "roleCount=" + roleCount;
    }

    private static String toSummaryStr(RangerUserStore userStore) {
        int userCount = 0;
        int groupCount = 0;
        int userGroupCount = 0;
        if (userStore != null) {
            if (userStore.getUserAttrMapping() != null) {
                userCount = userStore.getUserAttrMapping().size();
            }
            if (userStore.getGroupAttrMapping() != null) {
                groupCount = userStore.getGroupAttrMapping().size();
            }
            if (userStore.getUserGroupMapping() != null) {
                for (Set userGroups : userStore.getUserGroupMapping().values()) {
                    userGroupCount += userGroups.size();
                }
            }
        }
        return "users=" + userCount + ", groups=" + groupCount + ", userGroupMappings=" + userGroupCount;
    }

    private static String toSummaryStr(ServiceGdsInfo gdsInfo) {
        int dataShareCount = 0;
        int resourcesCount = 0;
        int datasetCount = 0;
        int projectCount = 0;
        if (gdsInfo != null) {
            if (gdsInfo.getDataShares() != null) {
                dataShareCount = gdsInfo.getDataShares().size();
            }
            if (gdsInfo.getResources() != null) {
                resourcesCount = gdsInfo.getResources().size();
            }
            if (gdsInfo.getDatasets() != null) {
                datasetCount = gdsInfo.getDatasets().size();
            }
            if (gdsInfo.getProjects() != null) {
                projectCount = gdsInfo.getProjects().size();
            }
        }
        return "dataShares=" + dataShareCount + ", resources=" + resourcesCount + ", datasets=" + datasetCount + ", projects=" + projectCount;
    }

    private Set<String> csvToSet(String str) {
        return StringUtils.isBlank((String)str) ? Collections.emptySet() : new HashSet<String>(Arrays.asList(StringUtils.split((String)str, (char)',')));
    }

    private void initMapper(ObjectMapper mapper) {
        SimpleModule serDeModule = new SimpleModule("RangerMemSizing", new Version(1, 0, 0, null, null, null));
        serDeModule.addSerializer(RangerAccessResource.class, (JsonSerializer)new RangerAccessResourceSerializer());
        serDeModule.addSerializer(RangerAccessResourceImpl.class, (JsonSerializer)new RangerAccessResourceImplSerializer());
        serDeModule.addDeserializer(RangerAccessResource.class, (JsonDeserializer)new RangerAccessResourceDeserializer());
        serDeModule.addSerializer(RangerAccessRequest.class, (JsonSerializer)new RangerAccessRequestSerializer());
        serDeModule.addSerializer(RangerAccessRequestImpl.class, (JsonSerializer)new RangerAccessRequestImplSerializer());
        serDeModule.addDeserializer(RangerAccessRequest.class, (JsonDeserializer)new RangerAccessRequestDeserializer());
        mapper.registerModule((Module)serDeModule);
    }

    static class RangerAccessRequestDeserializer
    extends JsonDeserializer<RangerAccessRequest> {
        RangerAccessRequestDeserializer() {
        }

        public RangerAccessRequest deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            TestRangerAccessRequestImpl req = (TestRangerAccessRequestImpl)context.readValue(parser, TestRangerAccessRequestImpl.class);
            return new RangerAccessRequestImpl((RangerAccessResource)new RangerAccessResourceImpl(req.resource.getElements()), req.accessType, req.user, req.userGroups, null);
        }
    }

    static class RangerAccessRequestImplSerializer
    extends JsonSerializer<RangerAccessRequestImpl> {
        RangerAccessRequestImplSerializer() {
        }

        public void serialize(RangerAccessRequestImpl value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            JsonUtils.getMapper().writeValue(gen, (Object)new TestRangerAccessRequestImpl(value.getResource(), value.getAccessType(), value.getUser(), value.getUserGroups()));
        }
    }

    static class RangerAccessRequestSerializer
    extends JsonSerializer<RangerAccessRequest> {
        RangerAccessRequestSerializer() {
        }

        public void serialize(RangerAccessRequest value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            JsonUtils.getMapper().writeValue(gen, (Object)new TestRangerAccessRequestImpl(value.getResource(), value.getAccessType(), value.getUser(), value.getUserGroups()));
        }
    }

    static class RangerAccessResourceDeserializer
    extends JsonDeserializer<RangerAccessResource> {
        RangerAccessResourceDeserializer() {
        }

        public RangerAccessResource deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            TestRangerAccessResourceImpl resource = (TestRangerAccessResourceImpl)context.readValue(parser, TestRangerAccessResourceImpl.class);
            return new RangerAccessResourceImpl(resource.getElements());
        }
    }

    static class RangerAccessResourceImplSerializer
    extends JsonSerializer<RangerAccessResource> {
        RangerAccessResourceImplSerializer() {
        }

        public void serialize(RangerAccessResource value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            JsonUtils.getMapper().writeValue(gen, (Object)new TestRangerAccessResourceImpl(value.getAsMap()));
        }
    }

    static class RangerAccessResourceSerializer
    extends JsonSerializer<RangerAccessResource> {
        RangerAccessResourceSerializer() {
        }

        public void serialize(RangerAccessResource value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            JsonUtils.getMapper().writeValue(gen, (Object)new TestRangerAccessResourceImpl(value.getAsMap()));
        }
    }

    static class TestRangerAccessRequestImpl {
        private TestRangerAccessResourceImpl resource;
        private String accessType;
        private String user;
        private Set<String> userGroups;

        public TestRangerAccessRequestImpl() {
        }

        public TestRangerAccessRequestImpl(RangerAccessResource resource, String accessType, String user, Set<String> userGroups) {
            this.resource = new TestRangerAccessResourceImpl(resource.getAsMap());
            this.accessType = accessType;
            this.user = user;
            this.userGroups = userGroups;
        }

        public TestRangerAccessResourceImpl getResource() {
            return this.resource;
        }

        public String getAccessType() {
            return this.accessType;
        }

        public String getUser() {
            return this.user;
        }

        public Set<String> getUserGroups() {
            return this.userGroups;
        }
    }

    static class TestRangerAccessResourceImpl {
        private Map<String, Object> elements;

        public TestRangerAccessResourceImpl() {
        }

        public TestRangerAccessResourceImpl(Map<String, Object> elements) {
            this.elements = elements;
        }

        public Map<String, Object> getElements() {
            return this.elements;
        }
    }
}

