/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.policyengine;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.util.PerfDataRecorder;
import org.apache.ranger.policyengine.CommandLineParser;
import org.apache.ranger.policyengine.PerfTestClient;
import org.apache.ranger.policyengine.PerfTestConfiguration;
import org.apache.ranger.policyengine.PerfTestEngine;
import org.apache.ranger.policyengine.PerfTestOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerPolicyenginePerfTester {
    private static final Logger LOG = LoggerFactory.getLogger(RangerPolicyenginePerfTester.class);

    private RangerPolicyenginePerfTester() {
    }

    public static void main(String[] args) {
        LOG.debug("==> RangerPolicyenginePerfTester.main()");
        CommandLineParser commandLineParser = new CommandLineParser();
        PerfTestOptions perfTestOptions = commandLineParser.parse(args);
        if (perfTestOptions != null) {
            PerfTestClient perfTestClient;
            URL statCollectionFileURL = perfTestOptions.getStatCollectionFileURL();
            ArrayList perfModuleNames = statCollectionFileURL != null ? RangerPolicyenginePerfTester.buildPerfModuleNames(statCollectionFileURL) : new ArrayList();
            PerfDataRecorder.initialize(perfModuleNames);
            URL servicePoliciesFileURL = perfTestOptions.getServicePoliciesFileURL();
            RangerPolicyEngineOptions policyEngineOptions = new RangerPolicyEngineOptions();
            policyEngineOptions.disableTagPolicyEvaluation = false;
            policyEngineOptions.evaluatorType = "optimized";
            policyEngineOptions.cacheAuditResults = false;
            policyEngineOptions.disableTrieLookupPrefilter = perfTestOptions.getIsTrieLookupPrefixDisabled();
            policyEngineOptions.optimizeTrieForRetrieval = perfTestOptions.getIsOnDemandTriePostSetupDisabled();
            policyEngineOptions.optimizeTagTrieForSpace = perfTestOptions.getIsTagTrieOptimizedForSpace();
            policyEngineOptions.optimizeTrieForSpace = perfTestOptions.getIsPolicyTrieOptimizedForSpace();
            URL configurationFileURL = perfTestOptions.getPerfConfigurationFileURL();
            PerfTestConfiguration configuration = new PerfTestConfiguration(configurationFileURL);
            policyEngineOptions.optimizeTrieForSpace = configuration.getBoolean("ranger.policyengine.option.optimize.policy.trie.for.space", false);
            policyEngineOptions.optimizeTagTrieForSpace = configuration.getBoolean("ranger.policyengine.option.optimize.tag.trie.for.space", false);
            policyEngineOptions.optimizeTagTrieForRetrieval = configuration.getBoolean("ranger.policyengine.option.optimize.tag.trie.for.retrieval", false);
            PerfTestEngine perfTestEngine = new PerfTestEngine(servicePoliciesFileURL, policyEngineOptions, configurationFileURL);
            if (!perfTestEngine.init()) {
                LOG.error("Error initializing test data. Existing...");
                System.exit(1);
            }
            URL[] requestFileURLs = perfTestOptions.getRequestFileURLs();
            int requestFilesCount = requestFileURLs.length;
            LOG.error("Warming up..");
            try {
                for (URL requestFileURL : requestFileURLs) {
                    perfTestClient = new PerfTestClient(perfTestEngine, 0, requestFileURL, 1);
                    if (perfTestClient.init()) {
                        perfTestClient.start();
                        perfTestClient.join();
                        continue;
                    }
                    LOG.error("Error initializing warm-up PerfTestClient");
                }
            }
            catch (Throwable t) {
                LOG.error("Error during warmup", t);
            }
            LOG.error("Warmed up!");
            PerfDataRecorder.clearStatistics();
            int clientsCount = perfTestOptions.getConcurrentClientCount();
            ArrayList<PerfTestClient> perfTestClients = new ArrayList<PerfTestClient>(clientsCount);
            for (int i = 0; i < clientsCount; ++i) {
                URL requestFileURL;
                requestFileURL = requestFileURLs[i % requestFilesCount];
                perfTestClient = new PerfTestClient(perfTestEngine, i, requestFileURL, perfTestOptions.getIterationsCount());
                if (!perfTestClient.init()) {
                    LOG.error("Error initializing PerfTestClient: (id={})", (Object)i);
                    continue;
                }
                perfTestClients.add(perfTestClient);
            }
            LOG.debug("Number of perfTestClients={}", (Object)perfTestClients.size());
            Runtime runtime = Runtime.getRuntime();
            runtime.gc();
            long totalMemory = runtime.totalMemory();
            long freeMemory = runtime.freeMemory();
            LOG.info("Before performance-run start: Memory stats: max-available=:{}; in-use={}; free={}", new Object[]{runtime.maxMemory(), totalMemory - freeMemory, freeMemory});
            LOG.info("Starting {} clients..", (Object)perfTestClients.size());
            for (PerfTestClient client : perfTestClients) {
                try {
                    client.start();
                }
                catch (Throwable t) {
                    LOG.error("Error in starting client: {}", (Object)client.getName(), (Object)t);
                }
            }
            LOG.info("Started {} clients", (Object)perfTestClients.size());
            LOG.info("Waiting for {} clients to finish up", (Object)perfTestClients.size());
            for (PerfTestClient client : perfTestClients) {
                while (client.isAlive()) {
                    try {
                        client.join(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.error("PerfTestClient.join() was interrupted");
                    }
                }
            }
            LOG.debug("<== RangerPolicyenginePerfTester.main()");
            LOG.info("Completed performance-run");
            runtime.gc();
            totalMemory = runtime.totalMemory();
            freeMemory = runtime.freeMemory();
            LOG.info("After performance-run end: Memory stats: max-available=:{}; in-use={}; free={}", new Object[]{runtime.maxMemory(), totalMemory - freeMemory, freeMemory});
            perfTestEngine.cleanUp();
            PerfDataRecorder.printStatistics();
        }
        LOG.info("Exiting...");
    }

    private static List<String> buildPerfModuleNames(URL statCollectionFileURL) {
        ArrayList<String> perfModuleNames = new ArrayList<String>();
        try (InputStream inStream = statCollectionFileURL.openStream();
             InputStreamReader reader = new InputStreamReader(inStream, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(reader);){
            String line = br.readLine();
            while (line != null) {
                if (!(line = line.trim()).isEmpty() && !line.startsWith("#")) {
                    String[] moduleNames = line.split(" ");
                    perfModuleNames.addAll(Arrays.asList(moduleNames));
                }
                line = br.readLine();
            }
        }
        catch (IOException exception) {
            System.out.println("Error reading arguments:" + exception);
        }
        return perfModuleNames;
    }
}

