/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.policyengine;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.ranger.plugin.service.RangerBasePlugin;

public class RangerPluginPerfTester {
    private static String serviceType;
    private static String serviceName;
    private static String appId;
    private static String rangerHostName;
    private static int socketReadTimeout;
    private static int pollingInterval;
    private static String policyCacheDir;
    private static boolean useCachedPolicyEvaluator;
    private static final Options options;

    private RangerPluginPerfTester() {
    }

    public static void main(String[] args) {
        block5: {
            if (!RangerPluginPerfTester.parseArguments(args)) {
                System.err.println("Exiting.. ");
                System.exit(-1);
            }
            System.out.println("Arguments:");
            System.out.println("\t\tservice-type:\t\t\t" + serviceType);
            System.out.println("\t\tservice-name:\t\t\t" + serviceName);
            System.out.println("\t\tapp-id:\t\t\t\t" + appId);
            System.out.println("\t\tranger-host:\t\t\t" + rangerHostName);
            System.out.println("\t\tsocket-read-timeout:\t\t" + socketReadTimeout);
            System.out.println("\t\tpolling-interval:\t\t" + pollingInterval);
            System.out.println("\t\tpolicy-cache-dir:\t\t" + policyCacheDir);
            System.out.println("\t\tuse-cached-policy-evaluator:\t" + useCachedPolicyEvaluator);
            System.out.println("\n\n");
            Path filePath = RangerPluginPerfTester.buildConfigurationFile();
            if (filePath != null) {
                RangerBasePlugin plugin = new RangerBasePlugin(serviceType, appId);
                plugin.getConfig().addResource(filePath);
                Runtime runtime = Runtime.getRuntime();
                runtime.gc();
                long totalMemory = runtime.totalMemory();
                long freeMemory = runtime.freeMemory();
                System.out.println("Initial Memory Statistics:");
                System.out.println("\t\tMaximum Memory available for the process:\t" + runtime.maxMemory());
                System.out.println("\t\tInitial In-Use memory:\t\t\t\t" + (totalMemory - freeMemory));
                System.out.println("\t\tInitial Free memory:\t\t\t\t" + freeMemory);
                System.out.println("\n\n");
                plugin.init();
                while (true) {
                    runtime.gc();
                    freeMemory = runtime.freeMemory();
                    totalMemory = runtime.totalMemory();
                    System.out.println("Memory Statistics:");
                    System.out.println("\t\tCurrently In-Use memory:\t" + (totalMemory - freeMemory));
                    System.out.println("\t\tCurrently Free memory:\t\t" + freeMemory);
                    System.out.println("\n\n");
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException e) {
                        System.err.println("Main thread interrupted..., exiting...");
                        break block5;
                    }
                }
            }
            System.err.println("Failed to build configuration file");
        }
    }

    static Path buildConfigurationFile() {
        Path ret = null;
        String propertyPrefix = "ranger.plugin." + serviceType;
        String policyEvaluatorType = useCachedPolicyEvaluator ? "cached" : "optimized";
        try {
            File file = File.createTempFile("ranger-plugin-test-site", ".xml");
            file.deleteOnExit();
            String filePathStr = file.getAbsolutePath();
            Path filePath = new Path(filePathStr);
            FileSystem fs = filePath.getFileSystem(new Configuration());
            FSDataOutputStream outStream = fs.create(filePath, true);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outStream);){
                writer.write("<configuration>\n        <property>\n                <name>" + propertyPrefix + ".policy.pollIntervalMs</name>\n                <value>" + pollingInterval + "</value>\n        </property>\n        <property>\n                <name>" + propertyPrefix + ".policy.cache.dir</name>\n                <value>" + policyCacheDir + "</value>\n        </property>\n        <property>\n                <name>" + propertyPrefix + ".policy.rest.url</name>\n                <value>" + rangerHostName + ":6080</value>\n        </property>\n        <property>\n                <name>" + propertyPrefix + ".policy.source.impl</name>\n                <value>org.apache.ranger.admin.client.RangerAdminRESTClient</value>\n        </property>\n        <property>\n                <name>" + propertyPrefix + ".policy.rest.client.read.timeoutMs</name>\n                <value>" + socketReadTimeout + "</value>\n        </property>\n        <property>\n                <name>" + propertyPrefix + ".policyengine.option.evaluator.type</name>\n                <value>" + policyEvaluatorType + "</value>\n        </property>\n        <property>\n                <name>" + propertyPrefix + ".service.name</name>\n                <value>" + serviceName + "</value>\n        </property>\n        <property>\n                <name>xasecure.audit.is.enabled</name>\n                <value>false</value>\n        </property>\n</configuration>\n");
                ret = filePath;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    static boolean parseArguments(String[] args) {
        boolean ret = false;
        options.addOption("h", "help", false, "show help.");
        options.addOption("s", "service-type", true, "Service-Type");
        options.addOption("n", "service-name", true, "Ranger service-name ");
        options.addOption("a", "app-id", true, "Application-Id");
        options.addOption("r", "ranger-host", true, "Ranger host-name");
        options.addOption("t", "socket-read-timeout", true, "Read timeout on socket in milliseconds");
        options.addOption("p", "polling-interval", true, "Polling Interval in milliseconds");
        options.addOption("c", "policy-cache-dir", true, "Policy-Cache directory ");
        options.addOption("e", "policy-evaluator-type", true, "Policy-Evaluator-Type (Cached/Other");
        DefaultParser commandLineParser = new DefaultParser();
        try {
            CommandLine commandLine = commandLineParser.parse(options, args);
            if (commandLine.hasOption("h")) {
                RangerPluginPerfTester.showUsage();
                return false;
            }
            serviceType = commandLine.getOptionValue("s");
            serviceName = commandLine.getOptionValue("n");
            appId = commandLine.getOptionValue("a");
            rangerHostName = commandLine.getOptionValue("r");
            policyCacheDir = commandLine.getOptionValue("c");
            try {
                String pollingIntervalStr = commandLine.getOptionValue("p");
                pollingInterval = Integer.parseInt(pollingIntervalStr);
            }
            catch (NumberFormatException pollingIntervalStr) {
                // empty catch block
            }
            String useCachedPolicyEvaluatorStr = commandLine.getOptionValue("e");
            if (StringUtils.equalsIgnoreCase((String)useCachedPolicyEvaluatorStr, (String)"cache")) {
                useCachedPolicyEvaluator = true;
            }
            try {
                String socketReadTimeoutStr = commandLine.getOptionValue("t");
                socketReadTimeout = Integer.parseInt(socketReadTimeoutStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ret = true;
        }
        catch (ParseException exception) {
            System.err.println("Failed to parse arguments:" + (Object)((Object)exception));
        }
        return ret;
    }

    static void showUsage() {
        HelpFormatter formater = new HelpFormatter();
        formater.printHelp("plugin-tester", options);
    }

    static {
        socketReadTimeout = 30000;
        pollingInterval = 30000;
        options = new Options();
    }
}

