/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.policyengine;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngine;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineImpl;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfTestEngine {
    private static final Logger LOG = LoggerFactory.getLogger(PerfTestEngine.class);
    private final URL servicePoliciesFileURL;
    private final RangerPolicyEngineOptions policyEngineOptions;
    private final URL configFileURL;
    private RangerPolicyEngine policyEvaluationEngine;

    public PerfTestEngine(URL servicePoliciesFileURL, RangerPolicyEngineOptions policyEngineOptions, URL configFileURL) {
        this.servicePoliciesFileURL = servicePoliciesFileURL;
        this.policyEngineOptions = policyEngineOptions;
        this.configFileURL = configFileURL;
    }

    public boolean init() {
        LOG.debug("==> init()");
        boolean ret = false;
        Gson gsonBuilder = new GsonBuilder().setDateFormat("yyyyMMdd-HH:mm:ss.SSS-Z").setPrettyPrinting().create();
        try (InputStream in = this.servicePoliciesFileURL.openStream();
             InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
            ServicePolicies servicePolicies = (ServicePolicies)gsonBuilder.fromJson((Reader)reader, ServicePolicies.class);
            RangerServiceDef serviceDef = servicePolicies.getServiceDef();
            String serviceType = serviceDef != null ? serviceDef.getName() : "";
            RangerPluginContext rangerPluginContext = new RangerPluginContext(new RangerPluginConfig(serviceType, null, "perf-test", null, null, this.policyEngineOptions));
            rangerPluginContext.getConfig().addResource(this.configFileURL);
            this.policyEvaluationEngine = new RangerPolicyEngineImpl(servicePolicies, rangerPluginContext, null);
            ret = true;
        }
        catch (Exception excp) {
            LOG.error("Error opening service-policies file or loading service-policies from file, URL={}", (Object)this.servicePoliciesFileURL, (Object)excp);
        }
        LOG.debug("<== init() : {}", (Object)ret);
        return ret;
    }

    public RangerAccessResult execute(RangerAccessRequest request) {
        LOG.debug("==> execute({})", (Object)request);
        RangerAccessResult ret = null;
        if (this.policyEvaluationEngine != null) {
            ret = this.policyEvaluationEngine.evaluatePolicies(request, 0, null);
            LOG.debug("Executed request = {{}}, result={{}}", (Object)request, (Object)ret);
        } else {
            LOG.error("Error executing request: PolicyEngine is null!");
        }
        LOG.debug("<== execute({}) : {}", (Object)request, (Object)ret);
        return ret;
    }

    public void cleanUp() {
        if (this.policyEvaluationEngine != null) {
            ((RangerPolicyEngineImpl)this.policyEvaluationEngine).releaseResources(true);
            this.policyEvaluationEngine = null;
        }
    }
}

