/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.policyengine;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.policyengine.PerfTestOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineParser {
    private static final Logger LOG = LoggerFactory.getLogger(CommandLineParser.class);
    private String servicePoliciesFileName;
    private String[] requestFileNames;
    private String statCollectionFileName;
    private URL servicePoliciesFileURL;
    private URL[] requestFileURLs;
    private URL statCollectionFileURL;
    private int concurrentClientCount = 1;
    private int iterationsCount = 1;
    private boolean isTrieLookupPrefixDisabled = true;
    private boolean isLazyTriePostSetupDisabled = true;
    private String configurationFileName;
    private URL configurationFileURL;
    private final Options options = new Options();

    CommandLineParser() {
    }

    public static URL getInputFileURL(String name) {
        LOG.debug("==> getResourceFileURL({})", (Object)name);
        URL ret = null;
        InputStream in = null;
        if (StringUtils.isNotBlank((String)name)) {
            File f = new File(name);
            if (f.exists() && f.isFile() && f.canRead()) {
                try {
                    in = new FileInputStream(f);
                    ret = f.toURI().toURL();
                    LOG.debug("URL:{}", (Object)ret);
                }
                catch (FileNotFoundException exception) {
                    LOG.error("Error processing input file:{} or no privilege for reading file {}", new Object[]{name, name, exception});
                }
                catch (MalformedURLException malformedException) {
                    LOG.error("Error processing input file:{} cannot be converted to URL {}", new Object[]{name, name, malformedException});
                }
            } else {
                URL fileURL = CommandLineParser.class.getResource(name);
                if (fileURL == null && !name.startsWith("/")) {
                    fileURL = CommandLineParser.class.getResource("/" + name);
                }
                if (fileURL == null && (fileURL = ClassLoader.getSystemClassLoader().getResource(name)) == null && !name.startsWith("/")) {
                    fileURL = ClassLoader.getSystemClassLoader().getResource("/" + name);
                }
                if (fileURL != null) {
                    try {
                        in = fileURL.openStream();
                        ret = fileURL;
                    }
                    catch (Exception exception) {
                        LOG.error("{} cannot be opened:", (Object)name, (Object)exception);
                    }
                } else {
                    LOG.warn("Error processing input file: URL not found for {} or no privilege for reading file {}", (Object)name, (Object)name);
                }
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LOG.debug("<== getResourceFileURL({}, URL={})", (Object)name, ret);
        return ret;
    }

    final PerfTestOptions parse(String[] args) {
        PerfTestOptions ret = null;
        if (this.parseArguments(args) && this.validateInputFiles()) {
            ret = new PerfTestOptions(this.servicePoliciesFileURL, this.requestFileURLs, this.statCollectionFileURL, this.concurrentClientCount, this.iterationsCount, this.isTrieLookupPrefixDisabled, this.isLazyTriePostSetupDisabled, this.configurationFileURL);
        } else {
            this.showUsage();
        }
        return ret;
    }

    final boolean parseArguments(String[] args) {
        LOG.debug("==> parseArguments()");
        boolean ret = false;
        this.options.addOption("h", "help", false, "show help.");
        this.options.addOption("s", "service-policies", true, "Policies File Name");
        this.options.addOption("r", "requests", true, "Request Definition File Name");
        this.options.addOption("p", "statistics", true, "Modules for stat collection File Name");
        this.options.addOption("c", "clients", true, "Number of concurrent clients");
        this.options.addOption("n", "cycles", true, "Number of iterations");
        this.options.addOption("f", "configurations", true, "Configuration File Name");
        this.options.addOption("t", "trie-prefilter", false, "Enable trie-prefilter");
        this.options.addOption("d", "trie-lazy-setup", false, "Enable lazy trie-setup");
        DefaultParser commandLineParser = new DefaultParser();
        try {
            CommandLine commandLine = commandLineParser.parse(this.options, args);
            if (commandLine.hasOption("h")) {
                this.showUsage();
                return false;
            }
            String clientOptionValue = commandLine.getOptionValue("c");
            String iterationsOptionValue = commandLine.getOptionValue("n");
            this.servicePoliciesFileName = commandLine.getOptionValue("s");
            this.requestFileNames = commandLine.getOptionValues("r");
            this.statCollectionFileName = commandLine.getOptionValue("p");
            this.concurrentClientCount = clientOptionValue != null ? Integer.parseInt(clientOptionValue) : 1;
            this.iterationsCount = iterationsOptionValue != null ? Integer.parseInt(iterationsOptionValue) : 1;
            if (commandLine.hasOption("t")) {
                this.isTrieLookupPrefixDisabled = false;
            }
            if (commandLine.hasOption("d")) {
                this.isLazyTriePostSetupDisabled = false;
            }
            this.configurationFileName = commandLine.getOptionValue("f");
            if (LOG.isDebugEnabled()) {
                LOG.debug("servicePoliciesFileName={}, requestFileName={}", (Object)this.servicePoliciesFileName, (Object)Arrays.toString(this.requestFileNames));
                LOG.debug("concurrentClientCount={}, iterationsCount={}", (Object)this.concurrentClientCount, (Object)this.iterationsCount);
                LOG.debug("isTrieLookupPrefixDisabled={}", (Object)this.isTrieLookupPrefixDisabled);
                LOG.debug("isLazyTriePostSetupDisabled={}", (Object)this.isLazyTriePostSetupDisabled);
                LOG.debug("configurationFileName={}", (Object)this.configurationFileName);
            }
            ret = true;
        }
        catch (Exception exception) {
            LOG.error("Error processing command-line arguments: ", (Throwable)exception);
        }
        LOG.debug("<== parseArguments() : {}", (Object)ret);
        return ret;
    }

    final boolean validateInputFiles() {
        LOG.debug("==> validateInputFiles()");
        boolean ret = false;
        if (this.servicePoliciesFileName != null) {
            this.servicePoliciesFileURL = CommandLineParser.getInputFileURL(this.servicePoliciesFileName);
            if (this.servicePoliciesFileURL != null) {
                if (this.requestFileNames != null) {
                    if (this.validateRequestFiles()) {
                        ret = true;
                        if (this.statCollectionFileName != null) {
                            this.statCollectionFileURL = CommandLineParser.getInputFileURL(this.statCollectionFileName);
                            boolean bl = ret = this.statCollectionFileURL != null;
                        }
                        if (ret && this.configurationFileName != null) {
                            this.configurationFileURL = CommandLineParser.getInputFileURL(this.configurationFileName);
                            ret = this.configurationFileURL != null;
                        }
                    }
                } else {
                    LOG.error("Error processing requests file: No requests files provided.");
                }
            } else {
                LOG.error("Error processing service-policies file: unreadable service-policies file: {}", (Object)this.servicePoliciesFileName);
            }
        } else {
            LOG.error("Error processing service-policies file: null service-policies file");
        }
        LOG.debug("<== validateInputFiles(): {}", (Object)ret);
        return ret;
    }

    final boolean validateRequestFiles() {
        boolean ret;
        LOG.debug("==> validateRequestFiles()");
        boolean bl = ret = this.requestFileNames.length > 0;
        if (ret) {
            this.requestFileURLs = new URL[this.requestFileNames.length];
            for (int i = 0; ret && i < this.requestFileNames.length; ++i) {
                if (this.requestFileNames[i] != null) {
                    this.requestFileURLs[i] = CommandLineParser.getInputFileURL(this.requestFileNames[i]);
                    if (this.requestFileURLs[i] != null) continue;
                    LOG.error("Cannot read file: {}", (Object)this.requestFileNames[i]);
                    ret = false;
                    continue;
                }
                LOG.error("Error processing request-file: null input file-name for request-file");
                ret = false;
            }
        }
        LOG.debug("<== validateRequestFiles(): {}", (Object)ret);
        return ret;
    }

    void showUsage() {
        HelpFormatter formater = new HelpFormatter();
        formater.printHelp("perfTester", this.options);
    }
}

