/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.storm.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.storm.client.StormClient;
import org.apache.ranger.services.storm.client.StormConnectionMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormResourceMgr {
    private static final Logger LOG = LoggerFactory.getLogger(StormResourceMgr.class);
    private static final String TOPOLOGY = "topology";

    private StormResourceMgr() {
    }

    public static Map<String, Object> validateConfig(String serviceName, Map<String, String> configs) {
        Map<String, Object> ret;
        LOG.debug("==> StormResourceMgr.validateConfig ServiceName: {} Configs{}", (Object)serviceName, configs);
        try {
            ret = StormClient.connectionTest(serviceName, configs);
        }
        catch (Exception e) {
            LOG.error("<== StormResourceMgr.validateConfig Error: {}", (Object)String.valueOf(e));
            throw e;
        }
        LOG.debug("<== StormResourceMgr.validateConfig Result : {}", ret);
        return ret;
    }

    public static List<String> getStormResources(String serviceName, Map<String, String> configs, ResourceLookupContext context) {
        String stormTopologyName;
        String userInput = context.getUserInput();
        Map resourceMap = context.getResources();
        List<String> resultList = null;
        List stormTopologyList = null;
        if (resourceMap != null && !resourceMap.isEmpty() && resourceMap.get(TOPOLOGY) != null) {
            stormTopologyName = userInput;
            stormTopologyList = (List)resourceMap.get(TOPOLOGY);
        } else {
            stormTopologyName = userInput;
        }
        if (configs == null || configs.isEmpty()) {
            LOG.error("Connection Config is empty");
        } else {
            String url = configs.get("nimbus.url");
            String username = configs.get("username");
            String password = configs.get("password");
            String lookupPrincipal = configs.get("lookupprincipal");
            String lookupKeytab = configs.get("lookupkeytab");
            String nameRules = configs.get("namerules");
            resultList = StormResourceMgr.getStormResources(url, username, password, lookupPrincipal, lookupKeytab, nameRules, stormTopologyName, stormTopologyList);
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getStormResources(String url, String username, String password, String lookupPrincipal, String lookupKeytab, String nameRules, String topologyName, List<String> stormTopologyList) {
        List<String> topologyList;
        StormClient stormClient = StormConnectionMgr.getStormClient(url, username, password, lookupPrincipal, lookupKeytab, nameRules);
        if (stormClient == null) {
            LOG.error("Storm Client is null");
            return new ArrayList<String>();
        }
        StormClient stormClient2 = stormClient;
        synchronized (stormClient2) {
            topologyList = stormClient.getTopologyList(topologyName, stormTopologyList);
        }
        return topologyList;
    }
}

