/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.storm.authorizer;

import java.util.Map;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.apache.storm.security.auth.IAuthorizer;
import org.apache.storm.security.auth.ReqContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerStormAuthorizer
implements IAuthorizer {
    private static final Logger LOG = LoggerFactory.getLogger(RangerStormAuthorizer.class);
    private static final String RANGER_PLUGIN_TYPE = "storm";
    private static final String RANGER_STORM_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.storm.authorizer.RangerStormAuthorizer";
    private IAuthorizer rangerStormAuthorizerImpl;
    private RangerPluginClassLoader rangerPluginClassLoader;

    public RangerStormAuthorizer() {
        LOG.debug("==> RangerStormAuthorizer.RangerStormAuthorizer()");
        this.init();
        LOG.debug("<== RangerStormAuthorizer.RangerStormAuthorizer()");
    }

    public void prepare(Map stormConf) {
        LOG.debug("==> RangerStormAuthorizer.prepare()");
        try {
            this.activatePluginClassLoader();
            this.rangerStormAuthorizerImpl.prepare(stormConf);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        LOG.debug("<== RangerStormAuthorizer.prepare()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean permit(ReqContext context, String operation, Map topologyConf) {
        LOG.debug("==> RangerStormAuthorizer.permit()");
        try {
            this.activatePluginClassLoader();
            boolean bl = this.rangerStormAuthorizerImpl.permit(context, operation, topologyConf);
            return bl;
        }
        finally {
            this.deactivatePluginClassLoader();
            LOG.debug("<== RangerStormAuthorizer.permit()");
        }
    }

    private void init() {
        LOG.debug("==> RangerStormAuthorizer.init()");
        try {
            this.rangerPluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, this.getClass());
            Class<?> cls = Class.forName(RANGER_STORM_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)this.rangerPluginClassLoader);
            this.activatePluginClassLoader();
            this.rangerStormAuthorizerImpl = (IAuthorizer)cls.newInstance();
        }
        catch (Exception e) {
            LOG.error("Error Enabling RangerStormPlugin", (Throwable)e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        LOG.debug("<== RangerStormAuthorizer.init()");
    }

    private void activatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.deactivate();
        }
    }
}

