/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.storm.authorizer;

import java.util.Map;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.apache.storm.security.auth.IAuthorizer;
import org.apache.storm.security.auth.ReqContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerStormAuthorizer
implements IAuthorizer {
    private static final Logger LOG = LoggerFactory.getLogger(RangerStormAuthorizer.class);
    private static final String RANGER_PLUGIN_TYPE = "storm";
    private static final String RANGER_STORM_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.storm.authorizer.RangerStormAuthorizer";
    private IAuthorizer rangerStormAuthorizerImpl = null;
    private static RangerPluginClassLoader rangerPluginClassLoader = null;

    public RangerStormAuthorizer() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerStormAuthorizer.RangerStormAuthorizer()");
        }
        this.init();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerStormAuthorizer.RangerStormAuthorizer()");
        }
    }

    private void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerStormAuthorizer.init()");
        }
        try {
            rangerPluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, this.getClass());
            Class<?> cls = Class.forName(RANGER_STORM_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)rangerPluginClassLoader);
            this.activatePluginClassLoader();
            this.rangerStormAuthorizerImpl = (IAuthorizer)cls.newInstance();
        }
        catch (Exception e) {
            LOG.error("Error Enabling RangerStormPlugin", (Throwable)e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerStormAuthorizer.init()");
        }
    }

    public void prepare(Map storm_conf) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerStormAuthorizer.prepare()");
        }
        try {
            this.activatePluginClassLoader();
            this.rangerStormAuthorizerImpl.prepare(storm_conf);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerStormAuthorizer.prepare()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean permit(ReqContext context, String operation, Map topology_conf) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerStormAuthorizer.permit()");
        }
        boolean ret = false;
        try {
            this.activatePluginClassLoader();
            ret = this.rangerStormAuthorizerImpl.permit(context, operation, topology_conf);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerStormAuthorizer.permit()");
        }
        return ret;
    }

    private void activatePluginClassLoader() {
        if (rangerPluginClassLoader != null) {
            rangerPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (rangerPluginClassLoader != null) {
            rangerPluginClassLoader.deactivate();
        }
    }
}

