/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.sqoop.client;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.sqoop.client.SqoopClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqoopResourceMgr {
    private static final Logger LOG = LoggerFactory.getLogger(SqoopResourceMgr.class);
    public static final String CONNECTOR = "connector";
    public static final String LINK = "link";
    public static final String JOB = "job";

    private SqoopResourceMgr() {
    }

    public static Map<String, Object> validateConfig(String serviceName, Map<String, String> configs) {
        Map<String, Object> ret;
        LOG.debug("==> SqoopResourceMgr.validateConfig ServiceName: {} Configs {}", (Object)serviceName, configs);
        try {
            ret = SqoopClient.connectionTest(serviceName, configs);
        }
        catch (Exception e) {
            LOG.error("<== SqoopResourceMgr.validateConfig Error: ", (Throwable)e);
            throw e;
        }
        LOG.debug("<== SqoopResourceMgr.validateConfig Result: {}", ret);
        return ret;
    }

    public static List<String> getSqoopResources(String serviceName, Map<String, String> configs, ResourceLookupContext context) {
        SqoopClient sqoopClient;
        String userInput = context.getUserInput();
        String resource = context.getResourceName();
        Map resourceMap = context.getResources();
        LOG.debug("==> SqoopResourceMgr.getSqoopResources()  userInput: {}, resource: {}, resourceMap: {}", new Object[]{userInput, resource, resourceMap});
        if (MapUtils.isEmpty(configs)) {
            LOG.error("Connection Config is empty!");
            return null;
        }
        if (StringUtils.isEmpty((String)userInput)) {
            LOG.warn("User input is empty, set default value : *");
            userInput = "*";
        }
        if ((sqoopClient = SqoopClient.getSqoopClient(serviceName, configs)) == null) {
            LOG.error("Failed to getSqoopResources!");
            return null;
        }
        List<String> resultList = null;
        if (StringUtils.isNotEmpty((String)resource)) {
            switch (resource) {
                case "connector": {
                    List existingConnectors = (List)resourceMap.get(CONNECTOR);
                    resultList = sqoopClient.getConnectorList(userInput, existingConnectors);
                    break;
                }
                case "link": {
                    List existingLinks = (List)resourceMap.get(LINK);
                    resultList = sqoopClient.getLinkList(userInput, existingLinks);
                    break;
                }
                case "job": {
                    List existingJobs = (List)resourceMap.get(JOB);
                    resultList = sqoopClient.getJobList(userInput, existingJobs);
                    break;
                }
            }
        }
        LOG.debug("<== SqoopResourceMgr.getSqoopResources() result: {}", resultList);
        return resultList;
    }
}

