/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.sqoop.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.client.BaseClient;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.services.sqoop.client.json.model.SqoopConnectorResponse;
import org.apache.ranger.services.sqoop.client.json.model.SqoopConnectorsResponse;
import org.apache.ranger.services.sqoop.client.json.model.SqoopJobResponse;
import org.apache.ranger.services.sqoop.client.json.model.SqoopJobsResponse;
import org.apache.ranger.services.sqoop.client.json.model.SqoopLinkResponse;
import org.apache.ranger.services.sqoop.client.json.model.SqoopLinksResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqoopClient
extends BaseClient {
    private static final Logger LOG = LoggerFactory.getLogger(SqoopClient.class);
    private static final String EXPECTED_MIME_TYPE = "application/json";
    private static final String SQOOP_CONNECTOR_API_ENDPOINT = "/sqoop/v1/connector/all";
    private static final String SQOOP_LINK_API_ENDPOINT = "/sqoop/v1/link/all";
    private static final String SQOOP_JOB_API_ENDPOINT = "/sqoop/v1/job/all";
    private static final String ERROR_MESSAGE = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.";
    private final String sqoopUrl;
    private final String userName;

    public SqoopClient(String serviceName, Map<String, String> configs) {
        super(serviceName, configs, "sqoop-client");
        this.sqoopUrl = configs.get("sqoop.url");
        this.userName = configs.get("username");
        if (StringUtils.isEmpty((String)this.sqoopUrl)) {
            LOG.error("No value found for configuration 'sqoop.url'. Sqoop resource lookup will fail.");
        }
        if (StringUtils.isEmpty((String)this.userName)) {
            LOG.error("No value found for configuration 'username'. Sqoop resource lookup will fail.");
        }
        LOG.debug("Sqoop Client is build with url [{}], user: [{}].", (Object)this.sqoopUrl, (Object)this.userName);
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) {
        SqoopClient sqoopClient = SqoopClient.getSqoopClient(serviceName, configs);
        List<String> strList = sqoopClient.getConnectorList(null, null);
        boolean connectivityStatus = false;
        if (CollectionUtils.isNotEmpty(strList)) {
            LOG.debug("ConnectionTest list size {} sqoop connectors.", (Object)strList.size());
            connectivityStatus = true;
        }
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        if (connectivityStatus) {
            String successMsg = "ConnectionTest Successful.";
            BaseClient.generateResponseDataMap((boolean)true, (String)successMsg, (String)successMsg, null, null, responseData);
        } else {
            String failureMsg = "Unable to retrieve any sqoop connectors using given parameters.";
            BaseClient.generateResponseDataMap((boolean)false, (String)failureMsg, (String)(failureMsg + ERROR_MESSAGE), null, null, responseData);
        }
        return responseData;
    }

    public static SqoopClient getSqoopClient(String serviceName, Map<String, String> configs) {
        LOG.debug("Getting SqoopClient for datasource: {}", (Object)serviceName);
        if (MapUtils.isEmpty(configs)) {
            String msgDesc = "Could not connect sqoop as Connection ConfigMap is empty.";
            LOG.error(msgDesc);
            HadoopException hdpException = new HadoopException(msgDesc);
            hdpException.generateResponseDataMap(false, msgDesc, msgDesc + ERROR_MESSAGE, null, null);
            throw hdpException;
        }
        SqoopClient sqoopClient = new SqoopClient(serviceName, configs);
        return sqoopClient;
    }

    public List<String> getConnectorList(String connectorMatching, List<String> existingConnectors) {
        LOG.debug("Get sqoop connector list for connectorMatching: {}, existingConnectors: {}", (Object)connectorMatching, existingConnectors);
        Subject subj = this.getLoginSubject();
        if (subj == null) {
            return Collections.emptyList();
        }
        List ret = Subject.doAs(subj, () -> {
            ClientResponse response = SqoopClient.getClientResponse(this.sqoopUrl, SQOOP_CONNECTOR_API_ENDPOINT, this.userName);
            SqoopConnectorsResponse sqoopConnectorsResponse = this.getSqoopResourceResponse(response, SqoopConnectorsResponse.class);
            if (sqoopConnectorsResponse == null || CollectionUtils.isEmpty(sqoopConnectorsResponse.getConnectors())) {
                return Collections.emptyList();
            }
            ArrayList<String> connectorResponses = new ArrayList<String>();
            for (SqoopConnectorResponse sqoopConnectorResponse : sqoopConnectorsResponse.getConnectors()) {
                connectorResponses.add(sqoopConnectorResponse.getName());
            }
            List<String> connectors = null;
            if (CollectionUtils.isNotEmpty(connectorResponses)) {
                connectors = SqoopClient.filterResourceFromResponse(connectorMatching, existingConnectors, connectorResponses);
            }
            return connectors;
        });
        LOG.debug("Get sqoop connector list result: {}", (Object)ret);
        return ret;
    }

    public List<String> getLinkList(String linkMatching, List<String> existingLinks) {
        LOG.debug("Get sqoop link list for linkMatching: {}, existingLinks: {}", (Object)linkMatching, existingLinks);
        Subject subj = this.getLoginSubject();
        if (subj == null) {
            return Collections.emptyList();
        }
        List ret = Subject.doAs(subj, () -> {
            ClientResponse response = SqoopClient.getClientResponse(this.sqoopUrl, SQOOP_LINK_API_ENDPOINT, this.userName);
            SqoopLinksResponse sqoopLinksResponse = this.getSqoopResourceResponse(response, SqoopLinksResponse.class);
            if (sqoopLinksResponse == null || CollectionUtils.isEmpty(sqoopLinksResponse.getLinks())) {
                return Collections.emptyList();
            }
            ArrayList<String> linkResponses = new ArrayList<String>();
            for (SqoopLinkResponse sqoopLinkResponse : sqoopLinksResponse.getLinks()) {
                linkResponses.add(sqoopLinkResponse.getName());
            }
            List<String> links = null;
            if (CollectionUtils.isNotEmpty(linkResponses)) {
                links = SqoopClient.filterResourceFromResponse(linkMatching, existingLinks, linkResponses);
            }
            return links;
        });
        LOG.debug("Get sqoop link list result: {}", (Object)ret);
        return ret;
    }

    public List<String> getJobList(String jobMatching, List<String> existingJobs) {
        LOG.debug("Get sqoop job list for jobMatching: {}, existingJobs: {}", (Object)jobMatching, existingJobs);
        Subject subj = this.getLoginSubject();
        if (subj == null) {
            return Collections.emptyList();
        }
        List ret = Subject.doAs(subj, () -> {
            ClientResponse response = SqoopClient.getClientResponse(this.sqoopUrl, SQOOP_JOB_API_ENDPOINT, this.userName);
            SqoopJobsResponse sqoopJobsResponse = this.getSqoopResourceResponse(response, SqoopJobsResponse.class);
            if (sqoopJobsResponse == null || CollectionUtils.isEmpty(sqoopJobsResponse.getJobs())) {
                return Collections.emptyList();
            }
            ArrayList<String> jobResponses = new ArrayList<String>();
            for (SqoopJobResponse sqoopJobResponse : sqoopJobsResponse.getJobs()) {
                jobResponses.add(sqoopJobResponse.getName());
            }
            List<String> jobs = null;
            if (CollectionUtils.isNotEmpty(jobResponses)) {
                jobs = SqoopClient.filterResourceFromResponse(jobMatching, existingJobs, jobResponses);
            }
            return jobs;
        });
        LOG.debug("Get sqoop job list result: {}", (Object)ret);
        return ret;
    }

    private static ClientResponse getClientResponse(String sqoopUrl, String sqoopApi, String userName) {
        ClientResponse response = null;
        Object[] sqoopUrls = sqoopUrl.trim().split("[,;]");
        if (ArrayUtils.isEmpty((Object[])sqoopUrls)) {
            return null;
        }
        Client client = Client.create();
        for (Object currentUrl : sqoopUrls) {
            if (StringUtils.isBlank((String)currentUrl)) continue;
            String url = ((String)currentUrl).trim() + sqoopApi + "?" + "user.name" + "=" + userName;
            try {
                response = SqoopClient.getClientResponse(url, client);
                if (response == null) continue;
                if (response.getStatus() == 200) break;
                response.close();
            }
            catch (Throwable t) {
                String msgDesc = "Exception while getting sqoop response, sqoopUrl: " + url;
                LOG.error(msgDesc, t);
            }
        }
        client.destroy();
        return response;
    }

    private static ClientResponse getClientResponse(String url, Client client) {
        LOG.debug("getClientResponse():calling {}", (Object)url);
        WebResource webResource = client.resource(url);
        ClientResponse response = (ClientResponse)webResource.accept(new String[]{EXPECTED_MIME_TYPE}).get(ClientResponse.class);
        if (response != null) {
            LOG.debug("getClientResponse():response.getStatus()= {}", (Object)response.getStatus());
            if (response.getStatus() != 200) {
                LOG.warn("getClientResponse():response.getStatus()= {} for URL {}, failed to get sqoop resource list.", (Object)response.getStatus(), (Object)url);
                String jsonString = (String)response.getEntity(String.class);
                LOG.warn(jsonString);
            }
        }
        return response;
    }

    private <T> T getSqoopResourceResponse(ClientResponse response, Class<T> classOfT) {
        Object resource;
        block9: {
            try {
                if (response != null) {
                    if (response.getStatus() == 200) {
                        String jsonString = (String)response.getEntity(String.class);
                        Gson gson = new GsonBuilder().setPrettyPrinting().create();
                        resource = gson.fromJson(jsonString, classOfT);
                        break block9;
                    }
                    String msgDesc = "Unable to get a valid response for expected mime type : [application/json], sqoopUrl: " + this.sqoopUrl + " - got http response code " + response.getStatus();
                    LOG.error(msgDesc);
                    HadoopException hdpException = new HadoopException(msgDesc);
                    hdpException.generateResponseDataMap(false, msgDesc, msgDesc + ERROR_MESSAGE, null, null);
                    throw hdpException;
                }
                String msgDesc = "Unable to get a valid response for expected mime type : [application/json], sqoopUrl: " + this.sqoopUrl + " - got null response.";
                LOG.error(msgDesc);
                HadoopException hdpException = new HadoopException(msgDesc);
                hdpException.generateResponseDataMap(false, msgDesc, msgDesc + ERROR_MESSAGE, null, null);
                throw hdpException;
            }
            catch (HadoopException he) {
                throw he;
            }
            catch (Throwable t) {
                String msgDesc = "Exception while getting sqoop resource response, sqoopUrl: " + this.sqoopUrl;
                HadoopException hdpException = new HadoopException(msgDesc, t);
                LOG.error(msgDesc, t);
                hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)t), msgDesc + ERROR_MESSAGE, null, null);
                throw hdpException;
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        return (T)resource;
    }

    private static List<String> filterResourceFromResponse(String resourceMatching, List<String> existingResources, List<String> resourceResponses) {
        ArrayList<String> resources = new ArrayList<String>();
        for (String resourceResponse : resourceResponses) {
            if (CollectionUtils.isNotEmpty(existingResources) && existingResources.contains(resourceResponse) || !StringUtils.isEmpty((String)resourceMatching) && !resourceMatching.startsWith("*") && !resourceResponse.toLowerCase().startsWith(resourceMatching.toLowerCase())) continue;
            LOG.debug("filterResourceFromResponse(): Adding sqoop resource {}", (Object)resourceResponse);
            resources.add(resourceResponse);
        }
        return resources;
    }
}

