/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.sqoop;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.sqoop.client.SqoopResourceMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceSqoop
extends RangerBaseService {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceSqoop.class);

    public void init(RangerServiceDef serviceDef, RangerService service) {
        super.init(serviceDef, service);
    }

    public Map<String, Object> validateConfig() throws Exception {
        Map<String, Object> ret = new HashMap<String, Object>();
        String serviceName = this.getServiceName();
        LOG.debug("==> RangerServiceSqoop.validateConfig Service: ({} )", (Object)serviceName);
        if (this.configs != null) {
            try {
                ret = SqoopResourceMgr.validateConfig(serviceName, this.configs);
            }
            catch (Exception e) {
                LOG.error("<== RangerServiceSqoop.validateConfig Error: {}", (Object)String.valueOf(e));
                throw e;
            }
        }
        LOG.debug("<== RangerServiceSqoop.validateConfig Response : ({})", ret);
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) {
        List<String> ret = new ArrayList<String>();
        String serviceName = this.getServiceName();
        Map configs = this.getConfigs();
        LOG.debug("==> RangerServiceSqoop.lookupResource Context: ({})", (Object)context);
        if (context != null) {
            try {
                ret = SqoopResourceMgr.getSqoopResources(serviceName, configs, context);
            }
            catch (Exception e) {
                LOG.error("<==RangerServiceSqoop.lookupResource Error: {}", (Object)String.valueOf(e));
                throw e;
            }
        }
        LOG.debug("<== RangerServiceSqoop.lookupResource Response: ({})", ret);
        return ret;
    }
}

