/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.sqoop.authorizer;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.MPrincipal;
import org.apache.sqoop.model.MPrivilege;
import org.apache.sqoop.model.MResource;
import org.apache.sqoop.security.AuthorizationValidator;
import org.apache.sqoop.security.SecurityError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerSqoopAuthorizer
extends AuthorizationValidator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerSqoopAuthorizer.class);
    private static volatile RangerSqoopPlugin sqoopPlugin;
    private static String clientIPAddress;

    public RangerSqoopAuthorizer() {
        LOG.debug("==> RangerSqoopAuthorizer.RangerSqoopAuthorizer()");
        this.init();
        LOG.debug("<== RangerSqoopAuthorizer.RangerSqoopAuthorizer()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void init() {
        LOG.debug("==> RangerSqoopAuthorizer.init()");
        RangerSqoopPlugin plugin = sqoopPlugin;
        if (plugin == null) {
            Class<RangerSqoopAuthorizer> clazz = RangerSqoopAuthorizer.class;
            // MONITORENTER : org.apache.ranger.authorization.sqoop.authorizer.RangerSqoopAuthorizer.class
            plugin = sqoopPlugin;
            if (plugin == null) {
                plugin = new RangerSqoopPlugin();
                plugin.init();
                sqoopPlugin = plugin;
                clientIPAddress = this.getClientIPAddress();
            }
            // MONITOREXIT : clazz
        }
        LOG.debug("<== RangerSqoopAuthorizer.init()");
    }

    public void checkPrivileges(MPrincipal principal, List<MPrivilege> privileges) throws SqoopException {
        LOG.debug("==> RangerSqoopAuthorizer.checkPrivileges( principal={}, privileges={})", (Object)principal, privileges);
        if (CollectionUtils.isEmpty(privileges)) {
            LOG.debug("<== RangerSqoopAuthorizer.checkPrivileges() return because privileges is empty.");
            return;
        }
        RangerSqoopPlugin plugin = sqoopPlugin;
        if (plugin != null) {
            for (MPrivilege privilege : privileges) {
                RangerSqoopAccessRequest request = new RangerSqoopAccessRequest(principal, privilege, clientIPAddress);
                RangerAccessResult result = plugin.isAccessAllowed((RangerAccessRequest)request);
                if (result == null || result.getIsAllowed()) continue;
                throw new SqoopException((ErrorCode)SecurityError.AUTH_0014, "principal = " + principal + " does not have privileges for: " + privilege);
            }
        }
        LOG.debug("<== RangerSqoopAuthorizer.checkPrivileges() success without exception.");
    }

    private String getClientIPAddress() {
        InetAddress ip = null;
        try {
            ip = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOG.debug("Failed to get Client IP Address {}", (Object)String.valueOf(e));
        }
        String ret = null;
        if (ip != null) {
            ret = ip.getHostAddress();
        }
        return ret;
    }

    private static class RangerSqoopAccessRequest
    extends RangerAccessRequestImpl {
        public RangerSqoopAccessRequest(MPrincipal principal, MPrivilege privilege, String clientIPAddress) {
            super.setResource((RangerAccessResource)new RangerSqoopResource(privilege.getResource()));
            if (MPrincipal.TYPE.USER.name().equals(principal.getType())) {
                super.setUser(principal.getName());
            }
            if (MPrincipal.TYPE.GROUP.name().equals(principal.getType())) {
                super.setUserGroups((Set)Sets.newHashSet((Object[])new String[]{principal.getName()}));
            }
            String action = privilege.getAction();
            super.setAccessType(action);
            super.setAction(action);
            super.setAccessTime(new Date());
            super.setClientIPAddress(clientIPAddress);
        }
    }

    private static class RangerSqoopResource
    extends RangerAccessResourceImpl {
        public RangerSqoopResource(MResource resource) {
            if (MResource.TYPE.CONNECTOR.name().equals(resource.getType())) {
                this.setValue("connector", resource.getName());
            }
            if (MResource.TYPE.LINK.name().equals(resource.getType())) {
                this.setValue("link", resource.getName());
            }
            if (MResource.TYPE.JOB.name().equals(resource.getType())) {
                this.setValue("job", resource.getName());
            }
        }
    }

    private static class RangerSqoopPlugin
    extends RangerBasePlugin {
        public RangerSqoopPlugin() {
            super("sqoop", "sqoop");
        }

        public void init() {
            super.init();
            RangerDefaultAuditHandler auditHandler = new RangerDefaultAuditHandler((Configuration)this.getConfig());
            super.setResultProcessor((RangerAccessResultProcessor)auditHandler);
        }
    }
}

