/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.sqoop.authorizer;

import java.util.List;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.MPrincipal;
import org.apache.sqoop.model.MPrivilege;
import org.apache.sqoop.security.AuthorizationValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerSqoopAuthorizer
extends AuthorizationValidator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerSqoopAuthorizer.class);
    private static final String RANGER_PLUGIN_TYPE = "sqoop";
    private static final String RANGER_SQOOP_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.sqoop.authorizer.RangerSqoopAuthorizer";
    private AuthorizationValidator authorizationValidator;
    private RangerPluginClassLoader rangerPluginClassLoader;

    public RangerSqoopAuthorizer() {
        LOG.debug("==> RangerSqoopAuthorizer.RangerSqoopAuthorizer()");
        this.init();
        LOG.debug("<== RangerSqoopAuthorizer.RangerSqoopAuthorizer()");
    }

    public void init() {
        LOG.debug("==> RangerSqoopAuthorizer.init()");
        try {
            this.rangerPluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, ((Object)((Object)this)).getClass());
            Class<?> cls = Class.forName(RANGER_SQOOP_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)this.rangerPluginClassLoader);
            this.activatePluginClassLoader();
            this.authorizationValidator = (AuthorizationValidator)cls.newInstance();
        }
        catch (Exception e) {
            LOG.error("Error Enabling RangerSqoopAuthorizer", (Throwable)e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        LOG.debug("<== RangerSqoopAuthorizer.init()");
    }

    public void checkPrivileges(MPrincipal principal, List<MPrivilege> privileges) throws SqoopException {
        LOG.debug("==> RangerSqoopAuthorizer.checkPrivileges()");
        try {
            this.activatePluginClassLoader();
            this.authorizationValidator.checkPrivileges(principal, privileges);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        LOG.debug("<== RangerSqoopAuthorizer.checkPrivileges()");
    }

    private void activatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.deactivate();
        }
    }
}

