/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.solr.client;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.services.solr.client.ServiceSolrClient;

public class ServiceSolrConnectionMgr {
    private static final String SOLR_ZOOKEEPER_QUORUM = "solr.zookeeper.quorum";
    private static final String SOLR_URL = "solr.url";

    private ServiceSolrConnectionMgr() {
    }

    public static ServiceSolrClient getSolrClient(String serviceName, Map<String, String> configs) throws Exception {
        String solrUrl = configs.get(SOLR_URL);
        String zkUrl = configs.get(SOLR_ZOOKEEPER_QUORUM);
        if (solrUrl != null || zkUrl != null) {
            boolean isSolrCloud = StringUtils.isNotEmpty((String)zkUrl);
            String url = isSolrCloud ? zkUrl : solrUrl;
            return new ServiceSolrClient(serviceName, configs, url, isSolrCloud);
        }
        throw new Exception("Required properties are not set for " + serviceName + ". URL or Zookeeper information not provided.");
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) throws Exception {
        ServiceSolrClient serviceSolrClient = ServiceSolrConnectionMgr.getSolrClient(serviceName, configs);
        return serviceSolrClient.connectionTest();
    }
}

