/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.solr.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.SecureClientLogin;
import org.apache.ranger.plugin.client.BaseClient;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.plugin.util.PasswordUtils;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.solr.RangerSolrConstants;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.Krb5HttpClientBuilder;
import org.apache.solr.client.solrj.impl.SolrHttpClientBuilder;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.ConfigSetAdminRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceSolrClient {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceSolrClient.class);
    private final String url;
    private final String username;
    private final String password;
    private final String serviceName;
    private final String authType;
    private final boolean isKerberosAuth;
    private final boolean isSolrCloud;
    private Subject loginSubject;
    private SolrClient solrClient;

    public ServiceSolrClient(String serviceName, Map<String, String> configs, String url, boolean isSolrCloud) {
        this.username = configs.get("username");
        this.password = configs.get("password");
        this.authType = configs.get("authtype");
        this.isKerberosAuth = "kerberos".equalsIgnoreCase(this.authType);
        this.url = url;
        this.serviceName = serviceName;
        this.isSolrCloud = isSolrCloud;
        this.createSolrClientInstance();
        this.login(configs);
    }

    public Map<String, Object> connectionTest() {
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        if (this.isKerberosAuth) {
            Subject.doAs(this.loginSubject, () -> {
                this.testConnection(responseData);
                return null;
            });
        } else {
            this.testConnection(responseData);
        }
        return responseData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getResources(ResourceLookupContext context) {
        ArrayList<String> resultList;
        block36: {
            String userInput = context.getUserInput();
            String resource = context.getResourceName();
            Map resourceMap = context.getResources();
            resultList = null;
            List collectionList = null;
            List fieldList = null;
            List configList = null;
            List schemaList = null;
            RangerSolrConstants.ResourceType lookupResource = RangerSolrConstants.ResourceType.COLLECTION;
            LOG.debug("<== getResources() UserInput: \"{}\" resource : {} resourceMap: {}", new Object[]{userInput, resource, resourceMap});
            if (userInput != null && resource != null) {
                if (resourceMap != null && !resourceMap.isEmpty()) {
                    collectionList = (List)resourceMap.get("collection");
                    fieldList = (List)resourceMap.get("field");
                    configList = (List)resourceMap.get("config");
                    schemaList = (List)resourceMap.get("schema");
                }
                switch (resource.trim().toLowerCase()) {
                    case "collection": {
                        lookupResource = RangerSolrConstants.ResourceType.COLLECTION;
                        break;
                    }
                    case "field": {
                        lookupResource = RangerSolrConstants.ResourceType.FIELD;
                        break;
                    }
                    case "config": {
                        lookupResource = RangerSolrConstants.ResourceType.CONFIG;
                        break;
                    }
                    case "admin": {
                        lookupResource = RangerSolrConstants.ResourceType.ADMIN;
                        break;
                    }
                    case "schema": {
                        lookupResource = RangerSolrConstants.ResourceType.SCHEMA;
                        break;
                    }
                }
            }
            if (userInput != null) {
                try {
                    Callable<List> callableObj = null;
                    String userInputFinal = userInput;
                    List finalCollectionList = collectionList;
                    List finalFieldList = fieldList;
                    List finalConfigList = configList;
                    List finalSchemaList = schemaList;
                    if (lookupResource == RangerSolrConstants.ResourceType.COLLECTION) {
                        callableObj = () -> {
                            ArrayList<String> retList = new ArrayList<String>();
                            try {
                                List list = this.isKerberosAuth ? Subject.doAs(this.loginSubject, () -> {
                                    List<String> ret = null;
                                    try {
                                        ret = this.getCollectionList(finalCollectionList);
                                    }
                                    catch (Exception e) {
                                        LOG.error("Unable to get collections, Error : {}", (Object)e.getMessage(), (Object)new Throwable(e));
                                    }
                                    return ret;
                                }) : this.getCollectionList(finalCollectionList);
                                if (userInputFinal != null && !userInputFinal.isEmpty()) {
                                    for (String value : list) {
                                        if (!value.startsWith(userInputFinal)) continue;
                                        retList.add(value);
                                    }
                                } else {
                                    retList.addAll(list);
                                }
                            }
                            catch (Exception ex) {
                                LOG.error("Error getting collections.", (Throwable)ex);
                            }
                            return retList;
                        };
                    } else if (lookupResource == RangerSolrConstants.ResourceType.FIELD) {
                        callableObj = () -> {
                            ArrayList<String> retList = new ArrayList<String>();
                            try {
                                List list = this.isKerberosAuth ? Subject.doAs(this.loginSubject, () -> {
                                    List<Object> ret = new ArrayList();
                                    try {
                                        ret = this.getFieldList(finalCollectionList, (List<String>)finalFieldList);
                                    }
                                    catch (Exception e) {
                                        LOG.error("Unable to get field list, Error : {}", (Object)e.getMessage(), (Object)new Throwable(e));
                                    }
                                    return ret;
                                }) : this.getFieldList(finalCollectionList, (List<String>)finalFieldList);
                                if (userInputFinal != null && !userInputFinal.isEmpty()) {
                                    for (String value : list) {
                                        if (!value.startsWith(userInputFinal)) continue;
                                        retList.add(value);
                                    }
                                } else {
                                    retList.addAll(list);
                                }
                            }
                            catch (Exception ex) {
                                LOG.error("Error getting collections.", (Throwable)ex);
                            }
                            return retList;
                        };
                    } else if (lookupResource == RangerSolrConstants.ResourceType.CONFIG) {
                        callableObj = () -> {
                            ArrayList<String> retList = new ArrayList<String>();
                            try {
                                List list = this.isKerberosAuth ? Subject.doAs(this.loginSubject, () -> {
                                    List<String> ret = null;
                                    try {
                                        ret = this.getConfigList(finalConfigList);
                                    }
                                    catch (Exception e) {
                                        LOG.error("Unable to get Solr configs, Error : {}", (Object)e.getMessage(), (Object)new Throwable(e));
                                    }
                                    return ret;
                                }) : this.getConfigList(finalConfigList);
                                if (userInputFinal != null && !userInputFinal.isEmpty()) {
                                    for (String value : list) {
                                        if (!value.startsWith(userInputFinal)) continue;
                                        retList.add(value);
                                    }
                                } else {
                                    retList.addAll(list);
                                }
                            }
                            catch (Exception ex) {
                                LOG.error("Error getting Solr configs: ", (Throwable)ex);
                            }
                            return retList;
                        };
                    } else if (lookupResource == RangerSolrConstants.ResourceType.ADMIN) {
                        ArrayList<String> retList = new ArrayList<String>();
                        try {
                            List<String> list = RangerSolrConstants.AdminType.VALUE_LIST;
                            if (userInputFinal != null && !userInputFinal.isEmpty()) {
                                for (String value : list) {
                                    if (!value.startsWith(userInputFinal)) continue;
                                    retList.add(value);
                                }
                            } else {
                                retList.addAll(list);
                            }
                        }
                        catch (Exception ex) {
                            LOG.error("Error getting Solr admin resources.", (Throwable)ex);
                        }
                        resultList = retList;
                    } else if (lookupResource == RangerSolrConstants.ResourceType.SCHEMA) {
                        callableObj = () -> {
                            ArrayList<String> retList = new ArrayList<String>();
                            try {
                                List list = this.isKerberosAuth ? Subject.doAs(this.loginSubject, () -> {
                                    List<String> ret = null;
                                    try {
                                        ret = this.getSchemaList(finalSchemaList);
                                    }
                                    catch (Exception e) {
                                        LOG.error("Unable to get collections for schema listing, Error : {}", (Object)e.getMessage(), (Object)new Throwable(e));
                                    }
                                    return ret;
                                }) : this.getSchemaList(finalSchemaList);
                                if (userInputFinal != null && !userInputFinal.isEmpty()) {
                                    for (String value : list) {
                                        if (!value.startsWith(userInputFinal)) continue;
                                        retList.add(value);
                                    }
                                } else {
                                    retList.addAll(list);
                                }
                            }
                            catch (Exception ex) {
                                LOG.error("Error getting collections for schema listing.", (Throwable)ex);
                            }
                            return retList;
                        };
                    }
                    if (callableObj == null) break block36;
                    ServiceSolrClient serviceSolrClient = this;
                    synchronized (serviceSolrClient) {
                        resultList = (ArrayList<String>)TimedEventUtil.timedTask(callableObj, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                    }
                }
                catch (Exception e) {
                    LOG.error("Unable to get Solr resources.", (Throwable)e);
                }
            }
        }
        return resultList;
    }

    private void testConnection(Map<String, Object> responseData) {
        String successMsg = "ConnectionTest Successful";
        try {
            this.getCollectionList(null);
            BaseClient.generateResponseDataMap((boolean)true, (String)successMsg, (String)successMsg, null, null, responseData);
        }
        catch (Exception e) {
            LOG.error("Error connecting to Solr. solrClient={}", (Object)this.solrClient, (Object)e);
            String failureMsg = "Unable to connect to Solr instance." + e.getMessage();
            BaseClient.generateResponseDataMap((boolean)false, (String)failureMsg, (String)(failureMsg + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check server logs for more info."), null, null, responseData);
        }
    }

    private List<String> getSchemaList(List<String> ignoreSchemaList) throws Exception {
        return this.getCollectionList(ignoreSchemaList);
    }

    private List<String> getCollectionList(List<String> ignoreCollectionList) throws Exception {
        if (!this.isSolrCloud) {
            return this.getCoresList(ignoreCollectionList);
        }
        CollectionAdminRequest.List request = new CollectionAdminRequest.List();
        String decPassword = this.getDecryptedPassword();
        if (!this.isKerberosAuth && this.username != null && decPassword != null) {
            request.setBasicAuthCredentials(this.username, decPassword);
        }
        SolrResponse response = request.process(this.solrClient);
        ArrayList<String> list = new ArrayList<String>();
        ArrayList responseCollectionList = (ArrayList)response.getResponse().get("collections");
        if (CollectionUtils.isEmpty((Collection)responseCollectionList)) {
            return list;
        }
        for (String responseCollection : responseCollectionList) {
            if (ignoreCollectionList != null && ignoreCollectionList.contains(responseCollection)) continue;
            list.add(responseCollection);
        }
        return list;
    }

    private List<String> getCoresList(List<String> ignoreCollectionList) throws Exception {
        CoreAdminRequest request = new CoreAdminRequest();
        request.setAction(CoreAdminParams.CoreAdminAction.STATUS);
        String decPassword = this.getDecryptedPassword();
        if (!this.isKerberosAuth && this.username != null && decPassword != null) {
            request.setBasicAuthCredentials(this.username, decPassword);
        }
        CoreAdminResponse cores = (CoreAdminResponse)request.process(this.solrClient);
        ArrayList<String> coreList = new ArrayList<String>();
        for (int i = 0; i < cores.getCoreStatus().size(); ++i) {
            if (ignoreCollectionList != null && ignoreCollectionList.contains(cores.getCoreStatus().getName(i))) continue;
            coreList.add(cores.getCoreStatus().getName(i));
        }
        return coreList;
    }

    private List<String> getFieldList(String collection, List<String> ignoreFieldList) throws Exception {
        String queryStr = "";
        if (collection != null && !collection.isEmpty()) {
            queryStr = queryStr + "/" + collection;
        }
        queryStr = queryStr + "/schema/fields";
        SolrQuery query = new SolrQuery();
        query.setRequestHandler(queryStr);
        QueryRequest req = new QueryRequest((SolrParams)query);
        String decPassword = this.getDecryptedPassword();
        if (!this.isKerberosAuth && this.username != null && decPassword != null) {
            req.setBasicAuthCredentials(this.username, decPassword);
        }
        QueryResponse response = (QueryResponse)req.process(this.solrClient);
        ArrayList<String> fieldList = new ArrayList<String>();
        if (response != null && response.getStatus() == 0) {
            ArrayList fields = (ArrayList)response.getResponse().get("fields");
            for (SimpleOrderedMap fmap : fields) {
                String fieldName = (String)fmap.get("name");
                if (ignoreFieldList != null && ignoreFieldList.contains(fieldName)) continue;
                fieldList.add(fieldName);
            }
        } else {
            LOG.error("Error getting fields for collection={}, response={}", (Object)collection, (Object)response);
        }
        return fieldList;
    }

    private List<String> getFieldList(List<String> collectionList, List<String> ignoreFieldList) throws Exception {
        LinkedHashSet<String> fieldSet = new LinkedHashSet<String>();
        if (collectionList == null || collectionList.isEmpty()) {
            return this.getFieldList((String)null, ignoreFieldList);
        }
        for (String collection : collectionList) {
            try {
                fieldSet.addAll(this.getFieldList(collection, ignoreFieldList));
            }
            catch (Exception ex) {
                LOG.error("Error getting fields.", (Throwable)ex);
            }
        }
        return new ArrayList<String>(fieldSet);
    }

    private List<String> getConfigList(List<String> ignoreConfigList) throws Exception {
        ConfigSetAdminRequest.List request = new ConfigSetAdminRequest.List();
        String decPassword = this.getDecryptedPassword();
        if (!this.isKerberosAuth && this.username != null && decPassword != null) {
            request.setBasicAuthCredentials(this.username, decPassword);
        }
        SolrResponse response = request.process(this.solrClient);
        ArrayList<String> list = new ArrayList<String>();
        ArrayList responseConfigSetList = (ArrayList)response.getResponse().get("configSets");
        if (CollectionUtils.isEmpty((Collection)responseConfigSetList)) {
            return list;
        }
        for (String responseConfigSet : responseConfigSetList) {
            if (ignoreConfigList != null && ignoreConfigList.contains(responseConfigSet)) continue;
            list.add(responseConfigSet);
        }
        return list;
    }

    private String getDecryptedPassword() {
        String decryptedPwd = null;
        try {
            decryptedPwd = PasswordUtils.decryptPassword((String)this.password);
        }
        catch (Exception ex) {
            LOG.info("Password decryption failed; trying Solr connection with received password string");
        }
        finally {
            if (decryptedPwd == null) {
                decryptedPwd = this.password;
            }
        }
        return decryptedPwd;
    }

    private void createSolrClientInstance() {
        this.setHttpClientBuilderForKrb();
        if (this.isSolrCloud) {
            List<String> zookeeperHosts = Arrays.asList(this.url);
            this.solrClient = new CloudSolrClient.Builder(zookeeperHosts, Optional.empty()).build();
        } else {
            HttpSolrClient.Builder builder = new HttpSolrClient.Builder();
            builder.withBaseSolrUrl(this.url);
            this.solrClient = builder.build();
        }
    }

    private void setHttpClientBuilderForKrb() {
        if (this.isKerberosAuth) {
            try (Krb5HttpClientBuilder krbBuild = new Krb5HttpClientBuilder();){
                SolrHttpClientBuilder kb = krbBuild.getBuilder();
                HttpClientUtil.setHttpClientBuilder((SolrHttpClientBuilder)kb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void login(Map<String, String> configs) {
        try {
            String adminPrincipal = configs.get("rangerprincipal");
            String adminKeytab = configs.get("rangerkeytab");
            String nameRules = configs.get("namerules");
            if (StringUtils.isEmpty((String)nameRules)) {
                LOG.debug("Name Rule is empty. Setting Name Rule as 'DEFAULT'");
                nameRules = "DEFAULT";
            }
            String userName = this.username;
            if (StringUtils.isEmpty((String)adminPrincipal) || StringUtils.isEmpty((String)adminKeytab)) {
                if (userName == null) {
                    throw this.createException("Unable to find login username for hadoop environment, [" + this.serviceName + "]", null);
                }
                String keyTabFile = configs.get("rangerkeytab");
                if (keyTabFile != null) {
                    if (this.isKerberosAuth) {
                        LOG.info("Init Login: security enabled, using username/keytab");
                        this.loginSubject = SecureClientLogin.loginUserFromKeytab((String)userName, (String)keyTabFile, (String)nameRules);
                    } else {
                        LOG.info("Init Login: using username");
                        this.loginSubject = SecureClientLogin.login((String)userName);
                    }
                } else {
                    String encryptedPwd = this.password;
                    String password = null;
                    if (encryptedPwd != null) {
                        try {
                            password = PasswordUtils.decryptPassword((String)encryptedPwd);
                        }
                        catch (Exception ex) {
                            LOG.info("Password decryption failed; trying connection with received password string");
                        }
                        finally {
                            if (password == null) {
                                password = encryptedPwd;
                            }
                        }
                    } else {
                        LOG.info("Password decryption failed: no password was configured");
                    }
                    if (this.isKerberosAuth) {
                        LOG.info("Init Login: using username/password");
                        this.loginSubject = SecureClientLogin.loginUserWithPassword((String)userName, (String)password);
                    } else {
                        LOG.info("Init Login: security not enabled, using username");
                        this.loginSubject = SecureClientLogin.login((String)userName);
                    }
                }
            } else if (this.isKerberosAuth) {
                LOG.info("Init Lookup Login: security enabled, using lookupPrincipal/lookupKeytab");
                this.loginSubject = SecureClientLogin.loginUserFromKeytab((String)adminPrincipal, (String)adminKeytab, (String)nameRules);
            } else {
                LOG.info("Init Login: security not enabled, using username");
                this.loginSubject = SecureClientLogin.login((String)userName);
            }
        }
        catch (IOException | SecurityException ioe) {
            throw this.createException("Unable to login to Hadoop environment [" + this.serviceName + "]", ioe);
        }
    }

    private HadoopException createException(String msgDesc, Exception exp) {
        HadoopException hdpException = new HadoopException(msgDesc, (Throwable)exp);
        String fullDescription = exp != null ? BaseClient.getMessage((Throwable)exp) : msgDesc;
        hdpException.generateResponseDataMap(false, fullDescription + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check server logs for more info.", msgDesc + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check server logs for more info.", null, null);
        return hdpException;
    }
}

