/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.solr;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.solr.RangerSolrConstants;
import org.apache.ranger.services.solr.client.ServiceSolrClient;
import org.apache.ranger.services.solr.client.ServiceSolrConnectionMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceSolr
extends RangerBaseService {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceSolr.class);
    public static final String ACCESS_TYPE_QUERY = RangerSolrConstants.AccessType.QUERY.toString();

    public void init(RangerServiceDef serviceDef, RangerService service) {
        super.init(serviceDef, service);
    }

    public Map<String, Object> validateConfig() throws Exception {
        Map<String, Object> ret = new HashMap<String, Object>();
        String serviceName = this.getServiceName();
        LOG.debug("==> RangerServiceSolr.validateConfig Service: ({} )", (Object)serviceName);
        if (this.configs != null) {
            try {
                ret = ServiceSolrConnectionMgr.connectionTest(serviceName, this.configs);
            }
            catch (Exception e) {
                LOG.error("<== RangerServiceSolr.validateConfig Error:", (Throwable)e);
                throw e;
            }
        }
        LOG.debug("<== RangerServiceSolr.validateConfig Response : ({} )", ret);
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        ServiceSolrClient serviceSolrClient = ServiceSolrConnectionMgr.getSolrClient(this.serviceName, this.configs);
        return serviceSolrClient.getResources(context);
    }

    public List<RangerPolicy> getDefaultRangerPolicies() throws Exception {
        LOG.debug("==> RangerServiceSolr.getDefaultRangerPolicies()");
        List ret = super.getDefaultRangerPolicies();
        for (RangerPolicy defaultPolicy : ret) {
            if (!defaultPolicy.getName().contains("all") || !StringUtils.isNotBlank((String)this.lookUpUser)) continue;
            RangerPolicy.RangerPolicyItem policyItemForLookupUser = new RangerPolicy.RangerPolicyItem();
            policyItemForLookupUser.setUsers(Collections.singletonList(this.lookUpUser));
            policyItemForLookupUser.setAccesses(Collections.singletonList(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_QUERY)));
            policyItemForLookupUser.setDelegateAdmin(Boolean.valueOf(false));
            defaultPolicy.addPolicyItem(policyItemForLookupUser);
        }
        LOG.debug("<== RangerServiceSolr.getDefaultRangerPolicies()");
        return ret;
    }
}

