/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.solr.authorizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ranger.services.solr.RangerSolrConstants;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.handler.admin.ConfigSetsHandler;
import org.apache.solr.security.AuthorizationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SolrAuthzUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SolrAuthzUtil.class);

    private SolrAuthzUtil() {
    }

    static List<String> getConfigAuthorizables(AuthorizationContext ctx) {
        ArrayList<String> result = new ArrayList<String>(1);
        if (ctx.getHandler() instanceof ConfigSetsHandler) {
            String name = ctx.getParams().get("name");
            if (name != null) {
                result.add(name);
            }
        } else {
            for (AuthorizationContext.CollectionRequest r : ctx.getCollectionRequests()) {
                result.add(r.collectionName);
            }
        }
        if (result.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Missing collection name for the config operation with authorization context {}. Using * permissions for authorization check", (Object)SolrAuthzUtil.toString(ctx));
            }
            result.add("*");
        }
        return result;
    }

    static List<String> getSchemaAuthorizables(AuthorizationContext ctx) {
        ArrayList<String> result = new ArrayList<String>(1);
        for (AuthorizationContext.CollectionRequest r : ctx.getCollectionRequests()) {
            result.add(r.collectionName);
        }
        if (result.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Missing collection name for the schema operation with authorization context {}. Using * permissions for authorization check", (Object)SolrAuthzUtil.toString(ctx));
            }
            result.add("*");
        }
        return result;
    }

    static Map<String, RangerSolrConstants.AccessType> getCollectionsForAdminOp(AuthorizationContext ctx) {
        String actionName = ctx.getParams().get("action");
        CollectionParams.CollectionAction action = CollectionParams.CollectionAction.get((String)actionName);
        if (action != null) {
            switch (action) {
                case LISTSNAPSHOTS: 
                case BACKUP: {
                    String name = ctx.getParams().get("collection");
                    return name != null ? Collections.singletonMap(name, RangerSolrConstants.AccessType.QUERY) : Collections.emptyMap();
                }
                case MIGRATE: {
                    HashMap<String, RangerSolrConstants.AccessType> result = new HashMap<String, RangerSolrConstants.AccessType>();
                    String source = ctx.getParams().get("collection");
                    String target = ctx.getParams().get("target.collection");
                    if (source != null) {
                        result.put(source, RangerSolrConstants.AccessType.QUERY);
                    }
                    if (target != null) {
                        result.put(source, RangerSolrConstants.AccessType.UPDATE);
                    }
                    return result;
                }
                case DELETE: 
                case CREATEALIAS: 
                case DELETEALIAS: 
                case CREATESHARD: 
                case DELETESHARD: 
                case SPLITSHARD: 
                case RELOAD: 
                case CREATE: {
                    String name = ctx.getParams().get("name");
                    return name != null ? Collections.singletonMap(name, RangerSolrConstants.AccessType.UPDATE) : Collections.emptyMap();
                }
                case DELETESNAPSHOT: 
                case CREATESNAPSHOT: 
                case SYNCSHARD: 
                case MOVEREPLICA: 
                case RESTORE: 
                case MIGRATESTATEFORMAT: 
                case FORCELEADER: 
                case REBALANCELEADERS: 
                case BALANCESHARDUNIQUE: 
                case ADDREPLICAPROP: 
                case DELETEREPLICAPROP: 
                case ADDREPLICA: 
                case DELETEREPLICA: 
                case MODIFYCOLLECTION: {
                    String name = ctx.getParams().get("collection");
                    return name != null ? Collections.singletonMap(name, RangerSolrConstants.AccessType.UPDATE) : Collections.emptyMap();
                }
                case MOCK_COLL_TASK: 
                case MOCK_REPLICA_TASK: 
                case MOCK_SHARD_TASK: 
                case REPLACENODE: 
                case DELETENODE: 
                case ADDROLE: 
                case REMOVEROLE: 
                case REQUESTSTATUS: 
                case DELETESTATUS: 
                case LIST: 
                case LISTALIASES: 
                case CLUSTERPROP: 
                case OVERSEERSTATUS: 
                case CLUSTERSTATUS: {
                    return Collections.emptyMap();
                }
            }
        }
        return Collections.emptyMap();
    }

    static Map<String, RangerSolrConstants.AccessType> getCoresForAdminOp(AuthorizationContext ctx) {
        String actionName = ctx.getParams().get("action");
        CoreAdminParams.CoreAdminAction action = CoreAdminParams.CoreAdminAction.get((String)actionName);
        if (action != null) {
            switch (action) {
                case REQUESTBUFFERUPDATES: 
                case REQUESTAPPLYUPDATES: 
                case CREATE: {
                    String coreName = ctx.getParams().get("name");
                    return coreName != null ? Collections.singletonMap(coreName, RangerSolrConstants.AccessType.UPDATE) : Collections.emptyMap();
                }
                case REQUESTSTATUS: 
                case OVERSEEROP: 
                case INVOKE: 
                case DELETEALIAS: {
                    return Collections.emptyMap();
                }
                case REQUESTSYNCSHARD: 
                case REJOINLEADERELECTION: 
                case PREPRECOVERY: 
                case FORCEPREPAREFORLEADERSHIP: 
                case CREATESNAPSHOT: 
                case DELETESNAPSHOT: 
                case RESTORECORE: 
                case REQUESTRECOVERY: 
                case SPLIT: 
                case MERGEINDEXES: 
                case UNLOAD: 
                case RENAME: 
                case RELOAD: {
                    String coreName = ctx.getParams().get("core");
                    return coreName != null ? Collections.singletonMap(coreName, RangerSolrConstants.AccessType.UPDATE) : Collections.emptyMap();
                }
                case LISTSNAPSHOTS: 
                case BACKUPCORE: 
                case STATUS: {
                    String coreName = ctx.getParams().get("core");
                    return coreName != null ? Collections.singletonMap(coreName, RangerSolrConstants.AccessType.QUERY) : Collections.emptyMap();
                }
                case SWAP: {
                    HashMap<String, RangerSolrConstants.AccessType> result = new HashMap<String, RangerSolrConstants.AccessType>();
                    String core1 = ctx.getParams().get("core");
                    String core2 = ctx.getParams().get("other");
                    if (core1 != null) {
                        result.put(core1, RangerSolrConstants.AccessType.UPDATE);
                    }
                    if (core2 != null) {
                        result.put(core2, RangerSolrConstants.AccessType.UPDATE);
                    }
                    return result;
                }
            }
        }
        return Collections.emptyMap();
    }

    static String toString(AuthorizationContext ctx) {
        StringBuilder builder = new StringBuilder();
        builder.append("AuthorizationContext {");
        builder.append("userPrincipal : ");
        builder.append(ctx.getUserPrincipal().getName());
        builder.append(", collections : ");
        builder.append(ctx.getCollectionRequests());
        builder.append(", handler : ");
        builder.append(ctx.getHandler());
        builder.append(", HTTP method : ");
        builder.append(ctx.getHttpMethod());
        builder.append("}");
        return builder.toString();
    }
}

