/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.solr.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.apache.ranger.plugin.client.BaseClient;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.plugin.util.PasswordUtils;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.SimpleOrderedMap;

public class ServiceSolrClient {
    private static final Logger LOG = Logger.getLogger(ServiceSolrClient.class);
    private static final String errMessage = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check server logs for more info.";
    private static final String COLLECTION_KEY = "collection";
    private static final String FIELD_KEY = "field";
    private static final long LOOKUP_TIMEOUT_SEC = 5L;
    private String username;
    private String password;
    private SolrClient solrClient = null;
    private boolean isSolrCloud = true;

    public ServiceSolrClient(SolrClient solrClient, boolean isSolrCloud, Map<String, String> configs) {
        this.solrClient = solrClient;
        this.isSolrCloud = isSolrCloud;
        this.username = configs.get("username");
        this.password = configs.get("password");
    }

    public Map<String, Object> connectionTest() throws Exception {
        String errMsg = errMessage;
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        try {
            this.getCollectionList(null);
            String successMsg = "ConnectionTest Successful";
            BaseClient.generateResponseDataMap((boolean)true, (String)successMsg, (String)successMsg, null, null, responseData);
        }
        catch (IOException e) {
            LOG.error((Object)("Error connecting to Solr. solrClient=" + this.solrClient), (Throwable)e);
            String failureMsg = "Unable to connect to Solr instance." + e.getMessage();
            BaseClient.generateResponseDataMap((boolean)false, (String)failureMsg, (String)(failureMsg + errMsg), null, null, responseData);
        }
        return responseData;
    }

    public List<String> getCollectionList(List<String> ignoreCollectionList) throws Exception {
        if (!this.isSolrCloud) {
            return this.getCoresList(ignoreCollectionList);
        }
        CollectionAdminRequest.List request = new CollectionAdminRequest.List();
        String decPassword = this.getDecryptedPassword();
        if (this.username != null && decPassword != null) {
            request.setBasicAuthCredentials(this.username, decPassword);
        }
        SolrResponse response = request.process(this.solrClient);
        ArrayList<String> list = new ArrayList<String>();
        ArrayList responseCollectionList = (ArrayList)response.getResponse().get("collections");
        if (CollectionUtils.isEmpty((Collection)responseCollectionList)) {
            return list;
        }
        for (String responseCollection : responseCollectionList) {
            if (ignoreCollectionList != null && ignoreCollectionList.contains(responseCollection)) continue;
            list.add(responseCollection);
        }
        return list;
    }

    public List<String> getCoresList(List<String> ignoreCollectionList) throws Exception {
        CoreAdminRequest request = new CoreAdminRequest();
        request.setAction(CoreAdminParams.CoreAdminAction.STATUS);
        String decPassword = this.getDecryptedPassword();
        if (this.username != null && decPassword != null) {
            request.setBasicAuthCredentials(this.username, decPassword);
        }
        CoreAdminResponse cores = (CoreAdminResponse)request.process(this.solrClient);
        ArrayList<String> coreList = new ArrayList<String>();
        for (int i = 0; i < cores.getCoreStatus().size(); ++i) {
            if (ignoreCollectionList != null && ignoreCollectionList.contains(cores.getCoreStatus().getName(i))) continue;
            coreList.add(cores.getCoreStatus().getName(i));
        }
        return coreList;
    }

    public List<String> getFieldList(String collection, List<String> ignoreFieldList) throws Exception {
        String queryStr = "";
        if (collection != null && !collection.isEmpty()) {
            queryStr = queryStr + "/" + collection;
        }
        queryStr = queryStr + "/schema/fields";
        SolrQuery query = new SolrQuery();
        query.setRequestHandler(queryStr);
        QueryRequest req = new QueryRequest((SolrParams)query);
        String decPassword = this.getDecryptedPassword();
        if (this.username != null && decPassword != null) {
            req.setBasicAuthCredentials(this.username, decPassword);
        }
        QueryResponse response = (QueryResponse)req.process(this.solrClient);
        ArrayList<String> fieldList = new ArrayList<String>();
        if (response != null && response.getStatus() == 0) {
            ArrayList fields = (ArrayList)response.getResponse().get("fields");
            for (SimpleOrderedMap fmap : fields) {
                String fieldName = (String)fmap.get("name");
                if (ignoreFieldList != null && ignoreFieldList.contains(fieldName)) continue;
                fieldList.add(fieldName);
            }
        } else {
            LOG.error((Object)("Error getting fields for collection=" + collection + ", response=" + response));
        }
        return fieldList;
    }

    public List<String> getFieldList(List<String> collectionList, List<String> ignoreFieldList) throws Exception {
        LinkedHashSet<String> fieldSet = new LinkedHashSet<String>();
        if (collectionList == null || collectionList.size() == 0) {
            return this.getFieldList((String)null, ignoreFieldList);
        }
        for (String collection : collectionList) {
            try {
                fieldSet.addAll(this.getFieldList(collection, ignoreFieldList));
            }
            catch (Exception ex) {
                LOG.error((Object)"Error getting fields.", (Throwable)ex);
            }
        }
        return new ArrayList<String>(fieldSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getResources(ResourceLookupContext context) {
        List resultList;
        block20: {
            String userInput = context.getUserInput();
            String resource = context.getResourceName();
            Map resourceMap = context.getResources();
            resultList = null;
            List collectionList = null;
            List fieldList = null;
            RESOURCE_TYPE lookupResource = RESOURCE_TYPE.COLLECTION;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<== getResources() UserInput: \"" + userInput + "\" resource : " + resource + " resourceMap: " + resourceMap));
            }
            if (userInput != null && resource != null) {
                if (resourceMap != null && !resourceMap.isEmpty()) {
                    collectionList = (List)resourceMap.get(COLLECTION_KEY);
                    fieldList = (List)resourceMap.get(FIELD_KEY);
                }
                switch (resource.trim().toLowerCase()) {
                    case "collection": {
                        lookupResource = RESOURCE_TYPE.COLLECTION;
                        break;
                    }
                    case "field": {
                        lookupResource = RESOURCE_TYPE.FIELD;
                        break;
                    }
                }
            }
            if (userInput != null) {
                try {
                    Callable<List<String>> callableObj = null;
                    final String userInputFinal = userInput;
                    final List finalCollectionList = collectionList;
                    final List finalFieldList = fieldList;
                    if (lookupResource == RESOURCE_TYPE.COLLECTION) {
                        callableObj = new Callable<List<String>>(){

                            @Override
                            public List<String> call() {
                                ArrayList<String> retList = new ArrayList<String>();
                                try {
                                    List<String> list = ServiceSolrClient.this.getCollectionList(finalCollectionList);
                                    if (userInputFinal != null && !userInputFinal.isEmpty()) {
                                        for (String value : list) {
                                            if (!value.startsWith(userInputFinal)) continue;
                                            retList.add(value);
                                        }
                                    } else {
                                        retList.addAll(list);
                                    }
                                }
                                catch (Exception ex) {
                                    LOG.error((Object)"Error getting collection.", (Throwable)ex);
                                }
                                return retList;
                            }
                        };
                    } else if (lookupResource == RESOURCE_TYPE.FIELD) {
                        callableObj = new Callable<List<String>>(){

                            @Override
                            public List<String> call() {
                                ArrayList<String> retList = new ArrayList<String>();
                                try {
                                    List<String> list = ServiceSolrClient.this.getFieldList(finalCollectionList, (List<String>)finalFieldList);
                                    if (userInputFinal != null && !userInputFinal.isEmpty()) {
                                        for (String value : list) {
                                            if (!value.startsWith(userInputFinal)) continue;
                                            retList.add(value);
                                        }
                                    } else {
                                        retList.addAll(list);
                                    }
                                }
                                catch (Exception ex) {
                                    LOG.error((Object)"Error getting collection.", (Throwable)ex);
                                }
                                return retList;
                            }
                        };
                    }
                    if (callableObj == null) break block20;
                    ServiceSolrClient serviceSolrClient = this;
                    synchronized (serviceSolrClient) {
                        resultList = (List)TimedEventUtil.timedTask((Callable)callableObj, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Unable to get hive resources.", (Throwable)e);
                }
            }
        }
        return resultList;
    }

    private String getDecryptedPassword() {
        String decryptedPwd = null;
        try {
            decryptedPwd = PasswordUtils.decryptPassword((String)this.password);
        }
        catch (Exception ex) {
            LOG.info((Object)"Password decryption failed; trying Solr connection with received password string");
            decryptedPwd = null;
        }
        finally {
            if (decryptedPwd == null) {
                decryptedPwd = this.password;
            }
        }
        return decryptedPwd;
    }

    static enum RESOURCE_TYPE {
        COLLECTION,
        FIELD;

    }
}

