/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.solr;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.solr.client.ServiceSolrClient;
import org.apache.ranger.services.solr.client.ServiceSolrConnectionMgr;

public class RangerServiceSolr
extends RangerBaseService {
    private static final Log LOG = LogFactory.getLog(RangerServiceSolr.class);

    public void init(RangerServiceDef serviceDef, RangerService service) {
        super.init(serviceDef, service);
    }

    public Map<String, Object> validateConfig() throws Exception {
        Map<String, Object> ret = new HashMap<String, Object>();
        String serviceName = this.getServiceName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerServiceSolr.validateConfig Service: (" + serviceName + " )"));
        }
        if (this.configs != null) {
            try {
                ret = ServiceSolrConnectionMgr.connectionTest(serviceName, this.configs);
            }
            catch (Exception e) {
                LOG.error((Object)"<== RangerServiceSolr.validateConfig Error:", (Throwable)e);
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerServiceSolr.validateConfig Response : (" + ret + " )"));
        }
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        ServiceSolrClient serviceSolrClient = ServiceSolrConnectionMgr.getSolrClient(this.serviceName, this.configs);
        return serviceSolrClient.getResources(context);
    }
}

