/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.solr.authorizer;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.audit.RangerMultiResourceAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.AuthorizationPlugin;
import org.apache.solr.security.AuthorizationResponse;

public class RangerSolrAuthorizer
implements AuthorizationPlugin {
    private static final Log logger = LogFactory.getLog(RangerSolrAuthorizer.class);
    private static final Log PERF_SOLRAUTH_REQUEST_LOG = RangerPerfTracer.getPerfLogger((String)"solrauth.request");
    public static final String PROP_USE_PROXY_IP = "xasecure.solr.use_proxy_ip";
    public static final String PROP_PROXY_IP_HEADER = "xasecure.solr.proxy_ip_header";
    public static final String PROP_SOLR_APP_NAME = "xasecure.solr.app.name";
    public static final String KEY_COLLECTION = "collection";
    public static final String ACCESS_TYPE_CREATE = "create";
    public static final String ACCESS_TYPE_UPDATE = "update";
    public static final String ACCESS_TYPE_QUERY = "query";
    public static final String ACCESS_TYPE_OTHERS = "others";
    public static final String ACCESS_TYPE_ADMIN = "solr_admin";
    private static volatile RangerBasePlugin solrPlugin = null;
    boolean useProxyIP = false;
    String proxyIPHeader = "HTTP_X_FORWARDED_FOR";
    String solrAppName = "Client";

    public RangerSolrAuthorizer() {
        logger.info((Object)"RangerSolrAuthorizer()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void init(Map<String, Object> initInfo) {
        logger.info((Object)"init()");
        try {
            this.useProxyIP = RangerConfiguration.getInstance().getBoolean(PROP_USE_PROXY_IP, this.useProxyIP);
            this.proxyIPHeader = RangerConfiguration.getInstance().get(PROP_PROXY_IP_HEADER, this.proxyIPHeader);
            this.solrAppName = System.getProperty("solr.kerberos.jaas.appname", this.solrAppName);
            this.solrAppName = RangerConfiguration.getInstance().get(PROP_SOLR_APP_NAME, this.solrAppName);
            logger.info((Object)("init(): useProxyIP=" + this.useProxyIP));
            logger.info((Object)("init(): proxyIPHeader=" + this.proxyIPHeader));
            logger.info((Object)("init(): solrAppName=" + this.solrAppName));
            logger.info((Object)("init(): KerberosName.rules=" + MiscUtil.getKerberosNamesRules()));
            this.authToJAASFile();
        }
        catch (Throwable t) {
            logger.fatal((Object)"Error init", t);
        }
        try {
            RangerBasePlugin me = solrPlugin;
            if (me == null) {
                Class<RangerSolrAuthorizer> clazz = RangerSolrAuthorizer.class;
                // MONITORENTER : org.apache.ranger.authorization.solr.authorizer.RangerSolrAuthorizer.class
                me = solrPlugin;
                logger.info((Object)"RangerSolrAuthorizer(): init called");
                if (me == null) {
                    me = solrPlugin = new RangerBasePlugin("solr", "solr");
                }
                // MONITOREXIT : clazz
            }
            solrPlugin.init();
            return;
        }
        catch (Throwable t) {
            logger.fatal((Object)"Error creating and initializing RangerBasePlugin()");
        }
    }

    private void authToJAASFile() {
        try {
            MiscUtil.setUGIFromJAASConfig((String)this.solrAppName);
            logger.info((Object)("LoginUser=" + MiscUtil.getUGILoginUser()));
        }
        catch (Throwable t) {
            logger.error((Object)("Error authenticating for appName=" + this.solrAppName), t);
        }
    }

    public void close() throws IOException {
        logger.info((Object)"close() called");
        try {
            solrPlugin.cleanup();
            if (solrPlugin.getAuditProviderFactory() != null) {
                solrPlugin.getAuditProviderFactory().shutdown();
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Error cleaning up Ranger plugin. Ignoring error", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationResponse authorize(AuthorizationContext context) {
        boolean isDenied = false;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"==> RangerSolrAuthorizer.authorize()");
                this.logAuthorizationConext(context);
            }
            RangerMultiResourceAuditHandler auditHandler = new RangerMultiResourceAuditHandler();
            RangerPerfTracer perf = null;
            if (RangerPerfTracer.isPerfTraceEnabled((Log)PERF_SOLRAUTH_REQUEST_LOG)) {
                perf = RangerPerfTracer.getPerfTracer((Log)PERF_SOLRAUTH_REQUEST_LOG, (String)"RangerSolrAuthorizer.authorize()");
            }
            String userName = this.getUserName(context);
            Set<String> userGroups = this.getGroupsForUser(userName);
            String ip = null;
            Date eventTime = new Date();
            if (this.useProxyIP) {
                ip = context.getHttpHeader(this.proxyIPHeader);
            }
            if (ip == null) {
                ip = context.getHttpHeader("REMOTE_ADDR");
            }
            if (ip == null) {
                ip = context.getRemoteAddr();
            }
            ArrayList<RangerAccessRequestImpl> rangerRequests = new ArrayList<RangerAccessRequestImpl>();
            List collectionRequests = context.getCollectionRequests();
            if (CollectionUtils.isEmpty((Collection)collectionRequests)) {
                RangerAccessRequestImpl requestForCollection = this.createRequest(userName, userGroups, ip, eventTime, context, null);
                if (requestForCollection != null) {
                    rangerRequests.add(requestForCollection);
                }
            } else {
                for (AuthorizationContext.CollectionRequest collectionRequest : context.getCollectionRequests()) {
                    RangerAccessRequestImpl requestForCollection = this.createRequest(userName, userGroups, ip, eventTime, context, collectionRequest);
                    if (requestForCollection == null) continue;
                    rangerRequests.add(requestForCollection);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("rangerRequests.size()=" + rangerRequests.size()));
            }
            try {
                for (RangerAccessRequestImpl rangerRequest : rangerRequests) {
                    RangerAccessResult result = solrPlugin.isAccessAllowed((RangerAccessRequest)rangerRequest, (RangerAccessResultProcessor)auditHandler);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("rangerRequest=" + result));
                    }
                    if (result != null && result.getIsAllowed()) continue;
                    isDenied = true;
                    break;
                }
            }
            finally {
                auditHandler.flushAudit();
                RangerPerfTracer.log((RangerPerfTracer)perf);
            }
        }
        catch (Throwable t) {
            isDenied = true;
            MiscUtil.logErrorMessageByInterval((Log)logger, (String)t.getMessage(), (Throwable)t);
        }
        AuthorizationResponse response = null;
        response = isDenied ? new AuthorizationResponse(403) : new AuthorizationResponse(200);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("<== RangerSolrAuthorizer.authorize() result: " + isDenied + "Response : " + response.getMessage()));
        }
        return response;
    }

    private void logAuthorizationConext(AuthorizationContext context) {
        try {
            String collections = "";
            int i = -1;
            for (AuthorizationContext.CollectionRequest collectionRequest : context.getCollectionRequests()) {
                if (++i > 0) {
                    collections = collections + ",";
                }
                collections = collections + collectionRequest.collectionName;
            }
            String headers = "";
            i = -1;
            Enumeration eList = context.getHeaderNames();
            while (eList.hasMoreElements()) {
                if (++i > 0) {
                    headers = headers + ",";
                }
                String header = (String)eList.nextElement();
                String value = context.getHttpHeader(header);
                headers = headers + header + "=" + value;
            }
            String ipAddress = context.getHttpHeader("HTTP_X_FORWARDED_FOR");
            if (ipAddress == null) {
                ipAddress = context.getHttpHeader("REMOTE_HOST");
            }
            if (ipAddress == null) {
                ipAddress = context.getHttpHeader("REMOTE_ADDR");
            }
            if (ipAddress == null) {
                ipAddress = context.getRemoteAddr();
            }
            String userName = this.getUserName(context);
            Set<String> groups = this.getGroupsForUser(userName);
            String resource = context.getResource();
            String solrParams = "";
            try {
                solrParams = context.getParams().toQueryString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            AuthorizationContext.RequestType requestType = context.getRequestType();
            String accessType = this.mapToRangerAccessType(context);
            Principal principal = context.getUserPrincipal();
            String contextString = new String("AuthorizationContext: ");
            contextString = contextString + "context.getResource()= " + (resource != null ? resource : "");
            contextString = contextString + ", solarParams= " + (solrParams != null ? solrParams : "");
            contextString = contextString + ", requestType= " + (requestType != null ? requestType : "");
            contextString = contextString + ", ranger.requestType= " + (accessType != null ? accessType : "");
            contextString = contextString + ", userPrincipal= " + (principal != null ? principal : "");
            contextString = contextString + ", userName= " + userName;
            contextString = contextString + ", groups= " + groups;
            contextString = contextString + ", ipAddress= " + ipAddress;
            contextString = contextString + ", collections= " + collections;
            contextString = contextString + ", headers= " + headers;
            logger.debug((Object)contextString);
        }
        catch (Throwable t) {
            logger.error((Object)"Error getting request context!!!", t);
        }
    }

    private RangerAccessRequestImpl createRequest(String userName, Set<String> userGroups, String ip, Date eventTime, AuthorizationContext context, AuthorizationContext.CollectionRequest collectionRequest) {
        String accessType;
        String action = accessType = this.mapToRangerAccessType(context);
        RangerAccessRequestImpl rangerRequest = this.createBaseRequest(userName, userGroups, ip, eventTime);
        RangerAccessResourceImpl rangerResource = new RangerAccessResourceImpl();
        if (collectionRequest == null) {
            rangerResource.setValue(KEY_COLLECTION, (Object)"*");
        } else {
            rangerResource.setValue(KEY_COLLECTION, (Object)collectionRequest.collectionName);
        }
        rangerRequest.setResource((RangerAccessResource)rangerResource);
        rangerRequest.setAccessType(accessType);
        rangerRequest.setAction(action);
        return rangerRequest;
    }

    private RangerAccessRequestImpl createBaseRequest(String userName, Set<String> userGroups, String ip, Date eventTime) {
        RangerAccessRequestImpl rangerRequest = new RangerAccessRequestImpl();
        if (userName != null && !userName.isEmpty()) {
            rangerRequest.setUser(userName);
        }
        if (userGroups != null && userGroups.size() > 0) {
            rangerRequest.setUserGroups(userGroups);
        }
        if (ip != null && !ip.isEmpty()) {
            rangerRequest.setClientIPAddress(ip);
        }
        rangerRequest.setAccessTime(eventTime);
        return rangerRequest;
    }

    private String getUserName(AuthorizationContext context) {
        Principal principal = context.getUserPrincipal();
        if (principal != null) {
            return MiscUtil.getShortNameFromPrincipalName((String)principal.getName());
        }
        return null;
    }

    private Set<String> getGroupsForUser(String name) {
        return MiscUtil.getGroupsForRequestUser((String)name);
    }

    String mapToRangerAccessType(AuthorizationContext context) {
        String accessType = ACCESS_TYPE_OTHERS;
        AuthorizationContext.RequestType requestType = context.getRequestType();
        if (AuthorizationContext.RequestType.ADMIN.equals((Object)requestType)) {
            accessType = ACCESS_TYPE_ADMIN;
        } else if (AuthorizationContext.RequestType.READ.equals((Object)requestType)) {
            accessType = ACCESS_TYPE_QUERY;
        } else if (AuthorizationContext.RequestType.WRITE.equals((Object)requestType)) {
            accessType = ACCESS_TYPE_UPDATE;
        } else if (AuthorizationContext.RequestType.UNKNOWN.equals((Object)requestType)) {
            logger.info((Object)("UNKNOWN request type. Mapping it to " + accessType + ". Resource=" + context.getResource()));
            accessType = ACCESS_TYPE_OTHERS;
        } else {
            logger.info((Object)("Request type is not supported. requestType=" + requestType + ". Mapping it to " + accessType + ". Resource=" + context.getResource()));
        }
        return accessType;
    }
}

