/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.solr.authorizer;

import java.io.IOException;
import java.util.Map;
import org.apache.ranger.plugin.classloader.PluginClassLoaderActivator;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.AuthorizationPlugin;
import org.apache.solr.security.AuthorizationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerSolrAuthorizer
extends SearchComponent
implements AuthorizationPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(RangerSolrAuthorizer.class);
    private static final String RANGER_PLUGIN_TYPE = "solr";
    private static final String RANGER_SOLR_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.solr.authorizer.RangerSolrAuthorizer";
    private AuthorizationPlugin rangerSolrAuthorizerImpl;
    private SearchComponent rangerSearchComponentImpl;
    private RangerPluginClassLoader pluginClassLoader;

    public RangerSolrAuthorizer() {
        LOG.debug("==> RangerSolrAuthorizer.RangerSolrAuthorizer()");
        this.init0();
        LOG.debug("<== RangerSolrAuthorizer.RangerSolrAuthorizer()");
    }

    public void close() throws IOException {
        LOG.debug("==> RangerSolrAuthorizer.close(Resource)");
        boolean isAuthorizer = StringUtils.equals((String)super.getName(), (String)RANGER_SOLR_AUTHORIZER_IMPL_CLASSNAME);
        if (isAuthorizer) {
            try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "close");){
                this.rangerSolrAuthorizerImpl.close();
            }
        } else {
            LOG.debug("RangerSolrAuthorizer.close(): not forwarding for instance '{}'", (Object)super.getName());
        }
    }

    public AuthorizationResponse authorize(AuthorizationContext context) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "authorize");){
            AuthorizationResponse authorizationResponse = this.rangerSolrAuthorizerImpl.authorize(context);
            return authorizationResponse;
        }
    }

    public void init(Map<String, Object> initInfo) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "init");){
            this.rangerSolrAuthorizerImpl.init(initInfo);
        }
    }

    public void prepare(ResponseBuilder responseBuilder) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "prepare");){
            this.rangerSearchComponentImpl.prepare(responseBuilder);
        }
    }

    public void process(ResponseBuilder responseBuilder) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "process");){
            this.rangerSearchComponentImpl.process(responseBuilder);
        }
    }

    public void init(NamedList args) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "init");){
            this.rangerSearchComponentImpl.init(args);
        }
    }

    public String getDescription() {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "getDescription");){
            String string = this.rangerSearchComponentImpl.getDescription();
            return string;
        }
    }

    private void init0() {
        LOG.debug("==> RangerSolrAuthorizer.init0()");
        try {
            this.pluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, ((Object)((Object)this)).getClass());
            Class<?> cls = Class.forName(RANGER_SOLR_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)this.pluginClassLoader);
            try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "init0");){
                AuthorizationPlugin impl;
                this.rangerSolrAuthorizerImpl = impl = (AuthorizationPlugin)cls.newInstance();
                this.rangerSearchComponentImpl = (SearchComponent)impl;
            }
        }
        catch (Exception e) {
            LOG.error("Error Enabling RangerSolrPlugin", (Throwable)e);
        }
        LOG.debug("<== RangerSolrAuthorizer.init0()");
    }
}

