/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.schema.registry.client.connection;

import com.hortonworks.registries.auth.Login;
import com.hortonworks.registries.schemaregistry.client.LoadBalancedFailoverUrlSelector;
import com.hortonworks.registries.schemaregistry.client.SchemaRegistryClient;
import com.hortonworks.registries.schemaregistry.client.UrlSelector;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.ranger.services.schema.registry.client.connection.ISchemaRegistryClient;
import org.apache.ranger.services.schema.registry.client.connection.util.SecurityUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSchemaRegistryClient
implements ISchemaRegistryClient {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSchemaRegistryClient.class);
    private static final String SCHEMA_REGISTRY_PATH = "/api/v1/schemaregistry";
    private static final String SCHEMAS_PATH = "/api/v1/schemaregistry/schemas/";
    private static final String SCHEMA_REGISTRY_VERSION_PATH = "/api/v1/schemaregistry/version";
    private static final String SSL_ALGORITHM = "TLSv1.2";
    private final Client client;
    private final Login login;
    private final UrlSelector urlSelector;
    private final Map<String, SchemaRegistryTargets> urlWithTargets;
    private final SchemaRegistryClient.Configuration configuration;

    public DefaultSchemaRegistryClient(Map<String, ?> conf) {
        this.configuration = new SchemaRegistryClient.Configuration(conf);
        this.login = SecurityUtils.initializeSecurityContext(conf);
        ClientConfig config = this.createClientConfig(conf);
        boolean sslEnabled = SecurityUtils.isHttpsConnection(conf);
        ClientBuilder clientBuilder = (ClientBuilder)JerseyClientBuilder.newBuilder().withConfig((Configuration)config).property("jersey.config.client.followRedirects", (Object)Boolean.TRUE);
        if (sslEnabled) {
            SSLContext ctx;
            try {
                ctx = SecurityUtils.createSSLContext(conf, SSL_ALGORITHM);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            clientBuilder.sslContext(ctx);
        }
        this.client = clientBuilder.build();
        this.urlSelector = this.createUrlSelector();
        this.urlWithTargets = new ConcurrentHashMap<String, SchemaRegistryTargets>();
    }

    @Override
    public List<String> getSchemaGroups() {
        LOG.debug("==> DefaultSchemaRegistryClient.getSchemaGroups()");
        ArrayList<String> res = new ArrayList<String>();
        WebTarget webResource = this.currentSchemaRegistryTargets().schemasTarget;
        try {
            Response response = (Response)this.login.doAction(() -> (Response)webResource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(Response.class));
            LOG.debug("DefaultSchemaRegistryClient.getSchemaGroups(): response statusCode = {}", (Object)response.getStatus());
            JSONArray mDataList = new JSONObject((String)response.readEntity(String.class)).getJSONArray("entities");
            int len = mDataList.length();
            for (int i = 0; i < len; ++i) {
                JSONObject entity = mDataList.getJSONObject(i);
                JSONObject schemaMetadata = (JSONObject)entity.get("schemaMetadata");
                String group = (String)schemaMetadata.get("schemaGroup");
                res.add(group);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LOG.debug("<== DefaultSchemaRegistryClient.getSchemaGroups(): {} schemaGroups found", (Object)res.size());
        return res;
    }

    @Override
    public List<String> getSchemaNames(List<String> schemaGroups) {
        LOG.debug("==> DefaultSchemaRegistryClient.getSchemaNames( {} )", schemaGroups);
        ArrayList<String> res = new ArrayList<String>();
        WebTarget webTarget = this.currentSchemaRegistryTargets().schemasTarget;
        try {
            Response response = (Response)this.login.doAction(() -> (Response)webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(Response.class));
            LOG.debug("DefaultSchemaRegistryClient.getSchemaNames(): response statusCode = {}", (Object)response.getStatus());
            JSONArray mDataList = new JSONObject((String)response.readEntity(String.class)).getJSONArray("entities");
            int len = mDataList.length();
            for (int i = 0; i < len; ++i) {
                JSONObject entity = mDataList.getJSONObject(i);
                JSONObject schemaMetadata = (JSONObject)entity.get("schemaMetadata");
                String group = (String)schemaMetadata.get("schemaGroup");
                for (String schemaGroup : schemaGroups) {
                    if (!group.matches(schemaGroup)) continue;
                    String name = (String)schemaMetadata.get("name");
                    res.add(name);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LOG.debug("<== DefaultSchemaRegistryClient.getSchemaNames( {} ): {} schemaNames found", schemaGroups, (Object)res.size());
        return res;
    }

    @Override
    public List<String> getSchemaBranches(String schemaMetadataName) {
        LOG.debug("==> DefaultSchemaRegistryClient.getSchemaBranches( {} )", (Object)schemaMetadataName);
        ArrayList<String> res = new ArrayList<String>();
        WebTarget target = this.currentSchemaRegistryTargets().schemasTarget.path(DefaultSchemaRegistryClient.encode(schemaMetadataName) + "/branches");
        try {
            Response response = (Response)this.login.doAction(() -> (Response)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(Response.class));
            LOG.debug("DefaultSchemaRegistryClient.getSchemaBranches(): response statusCode = {}", (Object)response.getStatus());
            JSONArray mDataList = new JSONObject((String)response.readEntity(String.class)).getJSONArray("entities");
            int len = mDataList.length();
            for (int i = 0; i < len; ++i) {
                JSONObject branchInfo = mDataList.getJSONObject(i);
                String smName = (String)branchInfo.get("schemaMetadataName");
                if (!smName.matches(schemaMetadataName)) continue;
                String bName = (String)branchInfo.get("name");
                res.add(bName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LOG.debug("<== DefaultSchemaRegistryClient.getSchemaBranches( {} ): {} branches found.", (Object)schemaMetadataName, (Object)res.size());
        return res;
    }

    @Override
    public void checkConnection() throws Exception {
        LOG.debug("==> DefaultSchemaRegistryClient.checkConnection(): trying to connect to the SR server... ");
        WebTarget webTarget = this.currentSchemaRegistryTargets().schemaRegistryVersion;
        Response response = (Response)this.login.doAction(() -> (Response)webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(Response.class));
        LOG.debug("DefaultSchemaRegistryClient.checkConnection(): response statusCode = {}", (Object)response.getStatus());
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            LOG.error("DefaultSchemaRegistryClient.checkConnection(): Connection failed. Response StatusCode = {}", (Object)response.getStatus());
            throw new Exception("Connection failed. StatusCode = " + response.getStatus());
        }
        String respStr = (String)response.readEntity(String.class);
        if (!respStr.contains("version") || !respStr.contains("revision")) {
            LOG.error("DefaultSchemaRegistryClient.checkConnection(): Connection failed. Bad response body.");
            throw new Exception("Connection failed. Bad response body.");
        }
        LOG.debug("<== DefaultSchemaRegistryClient.checkConnection(): connection test successful ");
    }

    private ClientConfig createClientConfig(Map<String, ?> conf) {
        ClientConfig config = new ClientConfig();
        config.property("jersey.config.client.connectTimeout", (Object)30000);
        config.property("jersey.config.client.readTimeout", (Object)30000);
        config.property("jersey.config.client.followRedirects", (Object)true);
        for (Map.Entry<String, ?> entry : conf.entrySet()) {
            config.property(entry.getKey(), entry.getValue());
        }
        return config;
    }

    private UrlSelector createUrlSelector() {
        LoadBalancedFailoverUrlSelector urlSelector;
        String rootCatalogURL = (String)this.configuration.getValue(SchemaRegistryClient.Configuration.SCHEMA_REGISTRY_URL.name());
        String urlSelectorClass = (String)this.configuration.getValue(SchemaRegistryClient.Configuration.URL_SELECTOR_CLASS.name());
        if (urlSelectorClass == null) {
            urlSelector = new LoadBalancedFailoverUrlSelector(rootCatalogURL);
        } else {
            try {
                urlSelector = (UrlSelector)Class.forName(urlSelectorClass).getConstructor(String.class).newInstance(rootCatalogURL);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        urlSelector.init(this.configuration.getConfig());
        return urlSelector;
    }

    private SchemaRegistryTargets currentSchemaRegistryTargets() {
        String url = this.urlSelector.select();
        this.urlWithTargets.computeIfAbsent(url, s -> new SchemaRegistryTargets(this.client.target(s)));
        return this.urlWithTargets.get(url);
    }

    private static String encode(String schemaName) {
        try {
            return URLEncoder.encode(schemaName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static class SchemaRegistryTargets {
        private final WebTarget schemaRegistryVersion;
        private final WebTarget schemasTarget;

        SchemaRegistryTargets(WebTarget rootResource) {
            this.schemaRegistryVersion = rootResource.path(DefaultSchemaRegistryClient.SCHEMA_REGISTRY_VERSION_PATH);
            this.schemasTarget = rootResource.path(DefaultSchemaRegistryClient.SCHEMAS_PATH);
        }
    }
}

